/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphgenerator.random;

import bridge.algorithms.GraphUtility;
import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import java.util.ArrayList;
import java.util.Random;
import mascoptLib.graphgenerator.actions.ActionOnGraph;
import mascoptLib.graphgenerator.actions.ChanceGenerator;
import mascoptLib.graphgenerator.criterium.FitnessCriterion;
import mascoptLib.graphgenerator.random.Strategy;
import mascoptLib.graphgenerator.random.SumListFitnessComputator;

public abstract class AbstractRandomGraphGenerator<V, L extends Link<V>> {
    private final Random random_ = new Random();
    protected Strategy strategy_ = Strategy.ADD;
    protected int maxActionsForStep_ = -1;
    protected SumListFitnessComputator<V, L> fitnessComputator_ = new SumListFitnessComputator();
    private SumListFitnessComputator<V, L> barrerComputator_ = new SumListFitnessComputator();
    private Graph<V, L> graph_;
    protected int limit_ = 100;
    protected int limitImprovement_ = 100;

    protected abstract Graph<V, L> copyGraph(Graph<V, L> var1);

    public Graph<V, L> getGraph() {
        return this.graph_;
    }

    protected void setStrategy(Strategy strategy, int maxActionsForStep) {
        assert (maxActionsForStep >= 1);
        this.strategy_ = strategy;
        this.maxActionsForStep_ = maxActionsForStep;
    }

    protected void setStrategy(Strategy strategy) {
        this.strategy_ = strategy;
    }

    public void addValuator(FitnessCriterion<V, L> computator, double heavy) {
        assert (heavy > 0.0);
        assert (computator != null);
        this.fitnessComputator_.addCriterion(computator, heavy);
    }

    public void addInvariant(FitnessCriterion<V, L> computator) {
        assert (computator != null);
        this.barrerComputator_.addCriterion(computator, 1.0);
    }

    public void setFailedIterationLimit(int limit) {
        this.limit_ = limit;
    }

    public void setImprovementLimit(int limit) {
        this.limitImprovement_ = limit;
    }

    public void setGraph(Graph<V, L> graph) {
        assert (graph != null);
        this.graph_ = this.copyGraph(graph);
    }

    public ComputationResult compute() throws Unsatisfiednvariant {
        assert (this.graph_ != null);
        if (GraphUtility.checkProprieties(this.graph_, GraphUtility.Propriety.EMPTY_GRAPH)) {
            throw new IllegalArgumentException("The graph must be not empty");
        }
        if (GraphUtility.checkProprieties(this.graph_, GraphUtility.Propriety.MULTI_GRAPH)) {
            throw new IllegalArgumentException("The graph must be not multi graph");
        }
        if (GraphUtility.checkProprieties(this.graph_, GraphUtility.Propriety.HAVE_LOOP_LINKS)) {
            throw new IllegalArgumentException("The graph must be without loop");
        }
        FitnessCriterion<V, L> computator = this.barrerComputator_.getFirstNonZero(this.graph_);
        if (computator != null) {
            throw new Unsatisfiednvariant(computator);
        }
        if (this.maxActionsForStep_ == 1) {
            return this.caseOneAction();
        }
        return this.caseManyAction();
    }

    private ComputationResult caseOneAction() {
        ChanceGenerator<V, L> chanceGenerator = this.strategy_.generateTheChances(this.graph_);
        double actualFitness = this.fitnessComputator_.computeMin(this.graph_, Double.POSITIVE_INFINITY);
        if (actualFitness == 0.0 || actualFitness < Double.MIN_VALUE) {
            return ComputationResult.PERFECT_RESULT;
        }
        int tryesNo = 0;
        int improvementNo = 0;
        while (tryesNo <= this.limit_ && improvementNo <= this.limitImprovement_) {
            double newFitness;
            ActionOnGraph<V, L> action = chanceGenerator.getNext();
            if (action == null) {
                tryesNo = this.limit_ + 1;
                break;
            }
            action.apply(this.graph_);
            if (this.barrerComputator_.getFirstNonZero(this.graph_) == null && (newFitness = this.fitnessComputator_.computeMin(this.graph_, actualFitness)) < actualFitness) {
                actualFitness = newFitness;
                if (actualFitness == 0.0 || actualFitness < Double.MIN_VALUE) {
                    return ComputationResult.PERFECT_RESULT;
                }
                this.strategy_.onConfirmedAction(chanceGenerator, action);
                tryesNo = 0;
                ++improvementNo;
                chanceGenerator.repeatChoices();
                continue;
            }
            action.unApply(this.graph_);
            ++tryesNo;
        }
        if (tryesNo > this.limit_) {
            return ComputationResult.FAILED_ITERATION_LIMIT_REACHED;
        }
        return ComputationResult.IMPROVEMENT_LIMIT_REACHED;
    }

    /*
     * Could not resolve type clashes
     */
    private ComputationResult caseManyAction() {
        ChanceGenerator<V, L> chanceGenerator = this.strategy_.generateTheChances(this.graph_);
        double actualFitness = this.fitnessComputator_.computeMin(this.graph_, Double.POSITIVE_INFINITY);
        if (actualFitness == 0.0 || actualFitness < Double.MIN_VALUE) {
            return ComputationResult.PERFECT_RESULT;
        }
        int tryesNo = 0;
        int improvementNo = 0;
        while (tryesNo <= this.limit_ && improvementNo <= this.limitImprovement_) {
            double newFitness;
            int actionsNo = this.getActionNo();
            ArrayList<ActionOnGraph<V, L>> actualSet = new ArrayList<ActionOnGraph<V, L>>(actionsNo);
            ActionOnGraph<V, L> action = chanceGenerator.getNext();
            while (actionsNo > 0 && action != null) {
                actualSet.add(action);
                --actionsNo;
                action = chanceGenerator.getNext();
            }
            for (ActionOnGraph actualAction : actualSet) {
                actualAction.apply(this.graph_);
            }
            if (this.barrerComputator_.getFirstNonZero(this.graph_) == null && (newFitness = this.fitnessComputator_.computeMin(this.graph_, Double.POSITIVE_INFINITY)) < actualFitness) {
                for (ActionOnGraph actualAction : actualSet) {
                    this.strategy_.onConfirmedAction(chanceGenerator, actualAction);
                }
                actualFitness = newFitness;
                if (actualFitness == 0.0 || actualFitness < Double.MIN_VALUE) {
                    return ComputationResult.PERFECT_RESULT;
                }
                tryesNo = 0;
                ++improvementNo;
                chanceGenerator.repeatChoices();
                continue;
            }
            for (ActionOnGraph actualAction : actualSet) {
                actualAction.unApply(this.graph_);
            }
            ++tryesNo;
            chanceGenerator.repeatChoices();
        }
        if (tryesNo > this.limit_) {
            return ComputationResult.FAILED_ITERATION_LIMIT_REACHED;
        }
        return ComputationResult.IMPROVEMENT_LIMIT_REACHED;
    }

    private int getActionNo() {
        if (this.maxActionsForStep_ > 0) {
            return this.maxActionsForStep_;
        }
        double restricted = this.random_.nextDouble() * (double)this.graph_.vertexSet().size();
        return (int)Math.ceil(Math.pow(restricted, 2.0));
    }

    public static enum ComputationResult {
        PERFECT_RESULT,
        IMPROVEMENT_LIMIT_REACHED,
        FAILED_ITERATION_LIMIT_REACHED;

    }

    public static class Unsatisfiednvariant
    extends Exception {
        private static final long serialVersionUID = -5308284874616479413L;
        FitnessCriterion computator_;

        Unsatisfiednvariant(FitnessCriterion computator) {
            super("The criterion " + computator.toString() + " is not sadified by the starting graph.");
            this.computator_ = computator;
        }
    }
}

