/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.graphgenerator.random;

import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import java.util.ArrayList;
import java.util.List;
import mascoptLib.graphgenerator.criterium.FitnessCriterion;

class SumListFitnessComputator<V, L extends Link<V>> {
    private List<CriterionHeavy> list_ = new ArrayList<CriterionHeavy>();

    public void addCriterion(FitnessCriterion<V, L> criterion, double heavy) {
        this.list_.add(new CriterionHeavy(criterion, heavy));
    }

    public double computeMin(Graph<V, L> graph, double otherValue) {
        double result = 0.0;
        for (CriterionHeavy fitnessComputator : this.list_) {
            double tempResult = fitnessComputator.criterion.compute(graph);
            assert (tempResult >= 0.0);
            if (tempResult == 0.0 || !((result += (Math.pow(tempResult + 1.0, (tempResult + 1.0) * 2.5) - 1.0) * fitnessComputator.heavy) > otherValue)) continue;
            return otherValue;
        }
        return result;
    }

    public FitnessCriterion<V, L> getFirstNonZero(Graph<V, L> graph) {
        for (CriterionHeavy fitnessComputator : this.list_) {
            double tempResult = fitnessComputator.criterion.compute(graph);
            assert (tempResult >= 0.0);
            if (tempResult == 0.0) continue;
            return fitnessComputator.criterion;
        }
        return null;
    }

    private class CriterionHeavy {
        FitnessCriterion<V, L> criterion;
        double heavy;

        public CriterionHeavy(FitnessCriterion<V, L> criterion, double heavy) {
            this.criterion = criterion;
            this.heavy = heavy;
        }
    }
}

