/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui;

import bridge.algorithms.StepAlgo;
import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;

public class AutoArrangeGraphs
extends StepAlgo<MascoptVertex, MascoptAbstractLink> {
    private MascoptAbstractGraph<?> graph_;
    private double l = 100.0;
    private double m = 2.0;
    private int maxStep_ = 50;
    private double shift_ = 10000.0;
    private double variation_ = 1000.0;
    private int step_ = 0;
    private HashMap<MascoptVertex, MyVector> D;

    public AutoArrangeGraphs(MascoptAbstractGraph<?> g) {
        super(true);
        this.graph_ = g;
        this.D = new HashMap();
        for (MascoptVertex currentVertex : this.graph_.vertexSet()) {
            this.D.put(currentVertex, new MyVector());
        }
    }

    @Override
    public void run() {
        MyVector currentFa = new MyVector();
        MyVector currentFr = new MyVector();
        MascoptVertexSet vertexSet = this.graph_.vertexSet();
        while (this.variation_ > 1.0E-4 && this.step_ < this.maxStep_) {
            ++this.step_;
            this.variation_ = 0.0;
            for (MascoptVertex node : vertexSet) {
                double nodeX = node.getX();
                double nodeY = node.getY();
                currentFa.reset();
                for (MascoptVertex theNeighb : this.graph_.neighborhood(node)) {
                    if (node == theNeighb) continue;
                    currentFa.add(-1.0 / (this.l * this.l * this.l) * (nodeX - theNeighb.getX()), -1.0 / (this.l * this.l * this.l) * (nodeY - theNeighb.getY()));
                }
                currentFr.reset();
                for (MascoptVertex nodeTmp : vertexSet) {
                    if (nodeTmp == node) continue;
                    double dist = this.distance(node, nodeTmp);
                    if (dist == 0.0) {
                        nodeTmp.setX(nodeTmp.getX() + 1.0);
                        nodeTmp.setY(nodeTmp.getY() + 1.0);
                        dist = this.distance(node, nodeTmp);
                    }
                    double distCube = dist * dist * dist;
                    currentFr.add((nodeX - nodeTmp.getX()) / distCube, (nodeY - nodeTmp.getY()) / distCube);
                }
                MyVector dV = this.D.get(node);
                dV.x_ = dV.x_ / this.m + (currentFr.x_ + currentFa.x_) * this.shift_;
                dV.y_ = dV.y_ / this.m + (currentFr.y_ + currentFa.y_) * this.shift_;
                this.variation_ += dV.norme();
            }
            for (MascoptVertex node : vertexSet) {
                MyVector dV = this.D.get(node);
                double x = node.getX();
                double y = node.getY();
                node.setX(x += dV.x_);
                node.setY(y += dV.y_);
            }
        }
        this.ends();
    }

    public void mixVertices() {
        Iterator it = this.graph_.vertexSet().iterator();
        double scale = 500.0;
        double stepX = 50.0;
        double stepY = 50.0;
        while (it.hasNext()) {
            MascoptVertex node = (MascoptVertex)it.next();
            node.setX(Math.random() * scale + stepX);
            node.setY(Math.random() * scale + stepY);
        }
    }

    private double distance(MascoptVertex vertex1, MascoptVertex vertex2) {
        return Math.sqrt((vertex1.getX() - vertex2.getX()) * (vertex1.getX() - vertex2.getX()) + (vertex1.getY() - vertex2.getY()) * (vertex1.getY() - vertex2.getY()));
    }

    private class MyVector {
        double x_;
        double y_;

        public MyVector() {
            this(0.0, 0.0);
        }

        public MyVector(double x, double y) {
            this.x_ = x;
            this.y_ = y;
        }

        public void reset() {
            this.x_ = 0.0;
            this.y_ = 0.0;
        }

        public void add(double x, double y) {
            this.x_ += x;
            this.y_ += y;
        }

        public double norme() {
            return Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_);
        }
    }
}

