/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.flows.MascoptMultiFlow;
import mascoptLib.gui.layerManager.GEdge;
import mascoptLib.gui.layerManager.GLayer;
import mascoptLib.gui.layerManager.GObject;
import mascoptLib.gui.layerManager.GVertex;
import mascoptLib.gui.layerManager.GView;
import mascoptLib.gui.layerManager.LayerManager;
import mascoptLib.gui.layerManager.Link;

public class DefaultEventListener
extends MouseAdapter
implements MouseMotionListener,
MouseWheelListener,
KeyListener {
    private GObject currentDragged_ = null;
    private Point draggOrigin = null;
    private Cursor oldCursor = null;
    private Cursor moveCursor = new Cursor(13);
    private LayerManager layerManager;
    private GEdge movingDraggedEdge_ = null;
    private MascoptVertex startNode = null;
    private GObject endNode = null;
    private Link linkTmp = null;
    private GObject gNode;

    void setLayerManager(LayerManager lm) {
        this.layerManager = lm;
    }

    protected LayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object source = e.getSource();
        if (source instanceof GObject) {
            this.currentDragged_ = (GObject)source;
            this.draggOrigin = e.getPoint();
            this.oldCursor = this.currentDragged_.getCursor();
            this.currentDragged_.setCursor(this.moveCursor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.currentDragged_ != null) {
            if (this.currentDragged_ instanceof GEdge && this.movingDraggedEdge_ != null) {
                GLayer layer = this.movingDraggedEdge_.getGGraph().getLayer();
                if (this.movingDraggedEdge_ != null) {
                    this.movingDraggedEdge_.getGGraph().setEdgeShift((GEdge)this.currentDragged_, this.movingDraggedEdge_.getShift());
                    ((GEdge)this.currentDragged_).updateBounds();
                    this.movingDraggedEdge_.getGGraph().getLayer().remove(this.movingDraggedEdge_);
                    this.movingDraggedEdge_ = null;
                }
                layer.repaint();
            } else {
                this.currentDragged_.repaint();
                if (this.oldCursor != null) {
                    this.currentDragged_.setCursor(this.oldCursor);
                }
            }
            this.currentDragged_ = null;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Object source = e.getSource();
        if (source instanceof GView) {
            GView view = (GView)source;
            if (this.startNode != null) {
                this.endNode.setLocation(view.getReal((Point)e.getPoint()).x - 2, view.getReal((Point)e.getPoint()).y - 2);
                view.repaint();
            }
        } else {
            GObject go = (GObject)source;
            if (this.startNode != null) {
                Point locObj = go.getLocation();
                locObj.translate(e.getPoint().x, e.getPoint().y);
                this.endNode.setLocation(locObj);
                this.linkTmp.repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.currentDragged_ == null) {
            return;
        }
        if (this.currentDragged_ instanceof GView) {
            GView view = (GView)this.currentDragged_;
            Point realDraggOrigin = view.getReal(this.draggOrigin);
            Point realMousePoint = view.getReal(e.getPoint());
            int transX = realDraggOrigin.x - realMousePoint.x;
            int transY = realDraggOrigin.y - realMousePoint.y;
            this.currentDragged_.translate(transX, transY);
            this.draggOrigin = e.getPoint();
        } else if (this.currentDragged_ instanceof GEdge) {
            if (this.movingDraggedEdge_ == null) {
                this.movingDraggedEdge_ = new GEdge((GVertex)((GEdge)this.currentDragged_).getSource(), (GVertex)((GEdge)this.currentDragged_).getTarget(), Color.black, ((GEdge)this.currentDragged_).getShift());
                this.movingDraggedEdge_.setVisibleArrow(false);
                ((GEdge)this.currentDragged_).getGGraph().getLayer().add(this.movingDraggedEdge_);
            }
            ((GEdge)this.currentDragged_).getGGraph().changeEdgeShift((GEdge)this.currentDragged_, this.movingDraggedEdge_, e.getX(), e.getY());
        } else {
            this.currentDragged_.translate(e.getX() - this.draggOrigin.x, e.getY() - this.draggOrigin.y);
            this.currentDragged_.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Object source = e.getSource();
        if (source instanceof GView) {
            GView view = (GView)e.getSource();
            double speed = 1.0 - (double)e.getWheelRotation() * 0.1;
            view.updateZoom(speed);
            view.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected final MascoptObject getMascoptObjectFromMouseEvent(MouseEvent event) {
        Component source = (Component)event.getSource();
        if (source instanceof GVertex) {
            return ((GVertex)source).getVertex();
        }
        if (source instanceof GEdge) {
            return ((GEdge)source).getAbstractEdge();
        }
        if (source instanceof GView) {
            return null;
        }
        return null;
    }

    protected final GLayer getLayer(MouseEvent event) {
        Component source = (Component)event.getSource();
        if (source instanceof GVertex) {
            return ((GVertex)source).getGGraph().getLayer();
        }
        if (source instanceof GEdge) {
            return ((GEdge)source).getGGraph().getLayer();
        }
        return null;
    }

    protected final MascoptObject getGraph(MouseEvent event) {
        Component source = (Component)event.getSource();
        if (source instanceof GVertex) {
            return ((GVertex)source).getGGraph().getGraph();
        }
        if (source instanceof GEdge) {
            return ((GEdge)source).getGGraph().getGraph();
        }
        return null;
    }

    protected final Point getRealPoint(MouseEvent event, GView view) {
        return view.getReal(event.getPoint());
    }

    protected final void beginLinkCreation(MascoptVertex origin, MascoptObject graph, GLayer layer) {
        this.startNode = origin;
        if (graph instanceof MascoptAbstractGraph) {
            this.gNode = layer.getObject(graph).getGObject(origin);
        } else if (graph instanceof MascoptAbstractPath) {
            this.gNode = ((MascoptAbstractPath)graph).length() == 0 ? new GObject((int)origin.getX(), (int)origin.getY(), 1, 1) : layer.getObject(graph).getGObject(origin);
        } else {
            if (graph instanceof MascoptMultiFlow) {
                return;
            }
            throw new RuntimeException("The type " + graph.getClass() + " of the currently displayed object is unknow");
        }
        this.endNode = new GObject(this.gNode.getLocation().x, this.gNode.getLocation().y, 1, 1);
        this.linkTmp = new Link(this.gNode, this.endNode, Color.black);
        this.linkTmp.addMouseMotionListener(this);
        this.linkTmp.addMouseListener(this);
        layer.add(this.linkTmp);
    }

    protected final MascoptAbstractLink finalizeLinkCreation(MascoptVertex target, MascoptObject graph, GLayer layer, boolean cont) {
        Object result;
        if (this.startNode == null) {
            return null;
        }
        if (graph instanceof MascoptAbstractGraph) {
            result = ((MascoptAbstractGraph)graph).getFactory().getGraphFactory().newLink(this.startNode, target);
        } else if (graph instanceof MascoptAbstractPath) {
            result = ((MascoptAbstractPath)graph).getFactory().getGraphFactory().newLink(this.startNode, target);
        } else {
            if (graph instanceof MascoptMultiFlow) {
                throw new IllegalStateException("Link creation in Flow can't begin ...");
            }
            throw new RuntimeException("The type " + graph.getClass() + " of the currently displayed object is unknow");
        }
        this.stopLinkCreation(layer);
        if (cont) {
            this.beginLinkCreation(target, graph, layer);
        }
        return result;
    }

    protected final void stopLinkCreation(GLayer layer) {
        this.startNode = null;
        if (!(this.gNode instanceof GVertex)) {
            layer.remove(this.gNode);
            this.gNode = null;
        }
        if (this.endNode != null) {
            layer.remove(this.endNode);
            this.endNode = null;
        }
        if (this.linkTmp != null) {
            layer.remove(this.linkTmp);
            this.linkTmp = null;
            layer.repaint();
        }
    }
}

