/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.io.IOException;
import java.util.Iterator;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.flows.MascoptMultiFlow;
import mascoptLib.core.interfaces.MascoptObserver;
import mascoptLib.gui.layerManager.GDispatch;
import mascoptLib.gui.layerManager.GLayer;
import mascoptLib.gui.layerManager.LayerManager;

class GFlow
extends GDispatch<MascoptArc>
implements MascoptObserver {
    private MascoptMultiFlow flow;
    private MascoptVertexSet vertexSet = new MascoptVertexSet();

    @Override
    protected MascoptObject getGraph() {
        return this.flow;
    }

    public GFlow(MascoptMultiFlow flow, LayerManager lm, GLayer gl) {
        super(lm, gl);
        this.flow = flow;
        flow.addAddObserver(this);
        Iterator<MascoptArc> edgeIt = flow.edgeWithFlowIterator();
        while (edgeIt.hasNext()) {
            MascoptVertex[] vertices = edgeIt.next().getVertices();
            this.vertexSet.add(vertices[0]);
            this.vertexSet.add(vertices[1]);
        }
        Iterator vertexIt = this.vertexSet.iterator();
        while (vertexIt.hasNext()) {
            this.addGraphicVertex((MascoptVertex)vertexIt.next());
        }
        edgeIt = flow.edgeWithFlowIterator();
        while (vertexIt.hasNext()) {
            this.addGraphicEdge(edgeIt.next());
        }
    }

    @Override
    void addingUpdate(Object[] objs) throws IOException {
        this.addGraphicVertex((MascoptVertex)objs[0]);
        super.addingUpdate(objs);
    }

    @Override
    void removeUpdate(Object[] objs) {
        throw new IllegalStateException("Can't modify a flow");
    }

    @Override
    void changeValueUpdate(Object[] objs) {
    }

    @Override
    Iterator<MascoptArc> edgeIterator() {
        return this.flow.edgeWithFlowIterator();
    }

    @Override
    Iterator<MascoptVertex> getMascoptVertexIterator() {
        return this.vertexSet.iterator();
    }

    @Override
    void loadImagesOfVertices() throws IOException {
        MascoptMap imagesMap = this.getVerticesImagesMap();
        String imagesName = this.getVerticesImagesName();
        MascoptObject imagesContext = this.getVerticesImagesContext();
        Iterator<MascoptVertex> vertexIt = this.getMascoptVertexIterator();
        while (vertexIt.hasNext()) {
            MascoptVertex current = vertexIt.next();
            this.setImageFromMap(current, imagesMap, imagesName, imagesContext);
        }
    }

    @Override
    void loadImagesOfEdges() throws IOException {
        MascoptMap imagesMap = this.getEdgesImagesMap();
        String imagesName = this.getEdgesImagesName();
        MascoptObject imagesContext = this.getEdgesImagesContext();
        Iterator<MascoptArc> edgeIt = this.edgeIterator();
        while (edgeIt.hasNext()) {
            MascoptAbstractLink current = edgeIt.next();
            this.setImageFromMap(current, imagesMap, imagesName, imagesContext);
        }
    }
}

