/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import mascoptLib.gui.layerManager.GEdge;
import mascoptLib.gui.layerManager.GObject;

class GLabel
extends GObject {
    private static final long serialVersionUID = 2L;
    private LabelListener labelListener_ = new LabelListener();
    private GObject source_;
    private String[] lines_;
    private Color color_ = Color.black;
    private Color colorBack_ = Color.black;
    private boolean transparent_ = false;
    private Font font_ = null;
    private int ascent_ = 0;

    public GLabel(GObject source, String[] lines) {
        this(source, lines, Color.black);
    }

    public GLabel(GObject source, String[] lines, Color color) {
        this(source, lines, color, new Color(230, 240, 240), false, 10);
    }

    public GLabel(GObject source, String[] lines, Color color, Color back, boolean transparent, int fontSize) {
        this.source_ = source;
        this.lines_ = lines;
        this.color_ = color;
        this.colorBack_ = back;
        this.transparent_ = transparent;
        this.font_ = new Font("Monospaced", 0, fontSize);
        source.addComponentListener(this.labelListener_);
        this.updateBounds();
    }

    private String getMaxLine() {
        FontMetrics fm = this.source_.getFontMetrics(this.font_);
        String maxLine = "";
        int i = 0;
        while (i < this.lines_.length) {
            if (fm.stringWidth(this.lines_[i]) >= fm.stringWidth(maxLine)) {
                maxLine = this.lines_[i];
            }
            ++i;
        }
        return maxLine;
    }

    protected void updateBounds() {
        int startY;
        int startX;
        int sourceWidth = this.source_.getWidth();
        int sourceHeight = this.source_.getHeight();
        FontMetrics fm = this.source_.getFontMetrics(this.font_);
        int h = fm.getAscent() * this.lines_.length + fm.getDescent();
        if (this.source_ instanceof GEdge) {
            GEdge link = (GEdge)this.source_;
            if (link.getSource() == link.getTarget()) {
                Point sourceLocation = this.source_.getLocation();
                startX = sourceLocation.x + sourceWidth - fm.stringWidth(String.valueOf(this.getMaxLine()) + "X");
                startY = sourceLocation.y + (int)Math.round(0.5 * (double)sourceHeight) - h;
            } else {
                Point controlPoint = link.getControlPoint();
                startX = controlPoint.x;
                startY = controlPoint.y;
            }
        } else {
            Point sourceLocation = this.source_.getLocation();
            startX = sourceLocation.x;
            startY = sourceLocation.y + (int)Math.round(-0.5 * (double)sourceHeight) - h;
        }
        Rectangle bounds = new Rectangle(startX, startY, fm.stringWidth(String.valueOf(this.getMaxLine()) + "X"), h);
        this.ascent_ = fm.getAscent();
        this.setBounds(bounds);
        this.repaint();
    }

    public Color getColor() {
        return this.color_;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.transparent_) {
            g.setColor(this.colorBack_);
            Rectangle bg = this.getBounds();
            g.fill3DRect(1, 1, bg.width - 1, bg.height - 1, true);
        }
        g.setColor(this.color_);
        g.setFont(this.font_);
        int i = 0;
        while (i < this.lines_.length) {
            g.drawString(this.lines_[i], 2, this.ascent_ * (i + 1));
            ++i;
        }
    }

    @Override
    public String toString() {
        String result = "";
        int i = 0;
        while (i < this.lines_.length) {
            result = String.valueOf(result) + this.lines_[i];
            ++i;
        }
        return result;
    }

    class LabelListener
    extends ComponentAdapter {
        LabelListener() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            GLabel.this.updateBounds();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            GLabel.this.updateBounds();
        }
    }
}

