/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Color;
import java.io.IOException;
import java.util.Iterator;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.interfaces.MascoptObserver;
import mascoptLib.gui.layerManager.GDispatch;
import mascoptLib.gui.layerManager.GEdge;
import mascoptLib.gui.layerManager.GLayer;
import mascoptLib.gui.layerManager.GVertex;
import mascoptLib.gui.layerManager.LayerManager;

class GPath<E extends MascoptAbstractLink>
extends GDispatch<E>
implements MascoptObserver {
    private MascoptAbstractPath<E> path;

    @Override
    protected MascoptAbstractPath<E> getGraph() {
        return this.path;
    }

    public GPath(MascoptAbstractPath<E> path, LayerManager lm, GLayer gl) {
        super(lm, gl);
        this.path = path;
        path.addAddObserver(this);
        path.addRemoveObserver(this);
        Iterator<MascoptVertex> it = path.vertexIterator(path.isDirected() ? path.getFirstVertex() : path.getEnds()[0]);
        while (it.hasNext()) {
            this.addGraphicVertex(it.next());
        }
        it = path.edgeIterator(path.isDirected() ? path.getFirstVertex() : path.getEnds()[0]);
        while (it.hasNext()) {
            this.addGraphicEdge((MascoptAbstractLink)((Object)it.next()));
        }
    }

    @Override
    void remove() {
        Iterator<MascoptVertex> it = this.path.vertexIterator(this.path.isDirected() ? this.path.getFirstVertex() : this.path.getEnds()[0]);
        while (it.hasNext()) {
            this.removeGraphicVertex(it.next());
        }
        it = this.path.edgeIterator(this.path.isDirected() ? this.path.getFirstVertex() : this.path.getEnds()[0]);
        while (it.hasNext()) {
            this.removeGraphicEdge((MascoptAbstractLink)((Object)it.next()));
        }
        this.getGObjectMapping().clear();
        this.path.deleteAddObserver(this);
        this.path.deleteRemoveObserver(this);
        this.path = null;
        super.remove();
    }

    @Override
    void addingUpdate(Object[] objs) throws IOException {
        if (objs[0] instanceof MascoptVertex) {
            this.addGraphicVertex((MascoptVertex)objs[0]);
            this.getLayer().addLabel((MascoptObject)objs[0], this.path);
        } else if (objs[0] instanceof MascoptAbstractLink) {
            this.addGraphicEdge((MascoptAbstractLink)objs[0]);
            this.getLayer().addLabel((MascoptObject)objs[0], this.path);
        }
        super.addingUpdate(objs);
        this.getLayer().repaint();
    }

    @Override
    void removeUpdate(Object[] objs) {
        if (objs[0] instanceof MascoptVertex) {
            this.removeGraphicVertex((MascoptVertex)objs[0]);
        } else if (objs[0] instanceof MascoptAbstractLink) {
            this.removeGraphicEdge((MascoptAbstractLink)objs[0]);
        }
        this.getLayer().repaint();
    }

    @Override
    void changeValueUpdate(Object[] objs) {
        String value = (String)objs[1];
        if (objs[0] instanceof MascoptVertex) {
            MascoptVertex vertex = (MascoptVertex)objs[0];
            if (!((MascoptAbstractPath)this.getGraph()).contains(vertex)) {
                return;
            }
            GVertex graphicVertex = (GVertex)this.getGObject(vertex);
            assert (graphicVertex != null);
            if (value.equals("x") || value.equals("y")) {
                graphicVertex.setLocation((int)Math.round(vertex.getX()), (int)Math.round(vertex.getY()));
                this.getLayer().repaint();
            }
            if (value.equals("name")) {
                this.getLayer().refreshObjectLabels(vertex, this.path);
                this.getLayer().repaint();
                return;
            }
            if (value.equals("color")) {
                int colValue = vertex.getColor();
                if (colValue != -1) {
                    graphicVertex.setColor(new Color(colValue));
                } else {
                    graphicVertex.setColor(this.vertexColor_);
                }
                this.getLayer().repaint();
                return;
            }
            this.getLayerManager().updateLabelOfObject(vertex, this.path, this.getLayer(), value);
        } else if (objs[0] instanceof MascoptAbstractLink) {
            MascoptAbstractLink edge = (MascoptAbstractLink)objs[0];
            if (!((MascoptAbstractPath)this.getGraph()).contains(edge)) {
                return;
            }
            GEdge graphicEdge = (GEdge)this.getGObject(edge);
            assert (graphicEdge != null);
            if (value.equals("name")) {
                this.getLayer().refreshObjectLabels(edge, this.path);
                this.getLayer().repaint();
                return;
            }
            if (value.equals("color")) {
                int colValue = edge.getColor();
                if (colValue != -1) {
                    graphicEdge.setColor(new Color(colValue));
                } else {
                    graphicEdge.setColor(this.linkColor_);
                }
                this.getLayer().repaint();
                return;
            }
            this.getLayerManager().updateLabelOfObject(edge, this.path, this.getLayer(), value);
        }
    }

    @Override
    Iterator<E> edgeIterator() {
        return this.path.edgeIterator(this.path.isDirected() ? this.path.getFirstVertex() : this.path.getEnds()[0]);
    }

    @Override
    Iterator<MascoptVertex> getMascoptVertexIterator() {
        return this.path.vertexIterator(this.path.isDirected() ? this.path.getFirstVertex() : this.path.getEnds()[0]);
    }

    @Override
    void setLinkWidth(int width) {
        super.setLinkWidth(width);
        MascoptObject thisPath = this.getGraph();
        Iterator edgesIt = ((MascoptAbstractPath)thisPath).edgeIterator(((MascoptAbstractPath)thisPath).isDirected() ? ((MascoptAbstractPath)thisPath).getFirstVertex() : ((MascoptAbstractPath)thisPath).getEnds()[0]);
        while (edgesIt.hasNext()) {
            GEdge current = (GEdge)this.getGObject((MascoptObject)edgesIt.next());
            current.setLinkWidth(width);
        }
    }

    @Override
    void loadImagesOfVertices() throws IOException {
        MascoptMap imagesMap = this.getVerticesImagesMap();
        String imagesName = this.getVerticesImagesName();
        MascoptObject imagesContext = this.getVerticesImagesContext();
        Iterator<MascoptVertex> vertexIt = this.getMascoptVertexIterator();
        while (vertexIt.hasNext()) {
            MascoptVertex current = vertexIt.next();
            this.setImageFromMap(current, imagesMap, imagesName, imagesContext);
        }
    }

    @Override
    void loadImagesOfEdges() throws IOException {
        MascoptMap imagesMap = this.getEdgesImagesMap();
        String imagesName = this.getEdgesImagesName();
        MascoptObject imagesContext = this.getEdgesImagesContext();
        Iterator<E> edgeIt = this.edgeIterator();
        while (edgeIt.hasNext()) {
            MascoptAbstractLink current = (MascoptAbstractLink)edgeIt.next();
            this.setImageFromMap(current, imagesMap, imagesName, imagesContext);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

