/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.QuadCurve2D;
import java.awt.image.BufferedImage;
import mascoptLib.gui.layerManager.GObject;

class Link
extends GObject {
    private static final long serialVersionUID = 2L;
    private LinkListener linkListener_ = new LinkListener();
    private GObject source_;
    private GObject target_;
    private int offSetSourceX_;
    private int offSetSourceY_;
    private int offSetTargetX_;
    private int offSetTargetY_;
    private int shift_;
    private Point sourceRealCoordinates_;
    private Point targetRealCoordinates_;
    private double distance_;
    private int xPicture_;
    private int yPicture_;
    private QuadCurve2D.Double curve_;
    private QuadCurve2D.Double insideCurve_;
    private Ellipse2D.Double loop_;
    private Ellipse2D.Double insideLoop_;
    private Color color_ = Color.green;
    private int width_ = 1;
    protected int MARGIN = 2;
    private BufferedImage picture_ = null;
    private int radius_ = 10;
    private int dx_ = 0;
    private int dy_ = 0;

    public Link(GObject source, GObject target, Color color) {
        this(source, target, color, 0);
    }

    public Link(GObject source, GObject target, Color color, int shift) {
        this(source, target, source.getWidth() / 2, source.getHeight() / 2, target.getWidth() / 2, target.getHeight() / 2, color, shift);
    }

    public Link(GObject source, GObject target, int offSetSourceX, int offSetSourceY, int offSetTargetX, int offSetTargetY, Color color) {
        this(source, target, offSetSourceX, offSetSourceY, offSetTargetX, offSetTargetY, color, 0);
    }

    public Link(GObject source, GObject target, int offSetSourceX, int offSetSourceY, int offSetTargetX, int offSetTargetY, Color color, int shift) {
        this.source_ = source;
        this.target_ = target;
        this.offSetSourceX_ = offSetSourceX;
        this.offSetSourceY_ = offSetSourceY;
        this.offSetTargetX_ = offSetTargetX;
        this.offSetTargetY_ = offSetTargetY;
        this.color_ = color;
        this.shift_ = shift;
        source.addComponentListener(this.linkListener_);
        target.addComponentListener(this.linkListener_);
        if (source != target) {
            this.curve_ = new QuadCurve2D.Double();
            this.insideCurve_ = new QuadCurve2D.Double();
        } else {
            this.loop_ = new Ellipse2D.Double();
            this.insideLoop_ = new Ellipse2D.Double();
        }
        this.updateBounds();
    }

    protected int getDx() {
        return this.dx_;
    }

    protected int getDy() {
        return this.dy_;
    }

    Point getControlPoint() {
        Point sourceLocation = this.source_.getLocation();
        Point targetLocation = this.target_.getLocation();
        sourceLocation.translate(this.offSetSourceX_, this.offSetSourceY_);
        targetLocation.translate(this.offSetTargetX_, this.offSetTargetY_);
        double X = targetLocation.x - sourceLocation.x;
        double Y = targetLocation.y - sourceLocation.y;
        long controlPointX = (long)(sourceLocation.x + this.dx_) + Math.round(X / 2.0);
        long controlPointY = (long)(sourceLocation.y + this.dy_) + Math.round(Y / 2.0);
        return new Point((int)controlPointX, (int)controlPointY);
    }

    private void fillCurve(Point sourceLocation, Point targetLocation, double shiftScale, QuadCurve2D.Double curve) {
        this.sourceRealCoordinates_ = sourceLocation;
        this.targetRealCoordinates_ = targetLocation;
        Point controlPoint = this.computeControlPoint(sourceLocation, targetLocation, shiftScale);
        curve.setCurve(this.sourceRealCoordinates_.x, this.sourceRealCoordinates_.y, controlPoint.getX(), controlPoint.getY(), this.targetRealCoordinates_.x, this.targetRealCoordinates_.y);
    }

    private void fillLoop(Point sourceLocation, Point targetLocation, double loopRadius, Ellipse2D.Double loop) {
        this.sourceRealCoordinates_ = sourceLocation;
        this.targetRealCoordinates_ = targetLocation;
        loop.setFrame(this.sourceRealCoordinates_.x, (double)this.sourceRealCoordinates_.y - (loopRadius + (double)this.dx_) / 2.0, 2.0 * (loopRadius + (double)this.dx_), 2.0 * (loopRadius + (double)this.dy_));
    }

    private Point computeControlPoint(Point sourceLocation, Point targetLocation, double shiftScale) {
        if (this.source_ == this.target_) {
            throw new IllegalStateException("Loop doesn't have control point");
        }
        double X = targetLocation.x - sourceLocation.x;
        double Y = targetLocation.y - sourceLocation.y;
        long controlPointX = (long)(this.sourceRealCoordinates_.x + this.dx_ * 2) + Math.round(X / shiftScale);
        long controlPointY = (long)(this.sourceRealCoordinates_.y + this.dy_ * 2) + Math.round(Y / shiftScale);
        return new Point((int)controlPointX, (int)controlPointY);
    }

    protected void updateBounds() {
        Point sourceLocation = this.source_.getLocation();
        Point targetLocation = this.target_.getLocation();
        sourceLocation.translate(this.offSetSourceX_, this.offSetSourceY_);
        targetLocation.translate(this.offSetTargetX_, this.offSetTargetY_);
        double X = targetLocation.x - sourceLocation.x;
        double Y = targetLocation.y - sourceLocation.y;
        this.distance_ = Math.sqrt(X * X + Y * Y);
        if (this.distance_ != 0.0) {
            this.dx_ = -((int)Math.floor((double)this.shift_ * Y / this.distance_));
            this.dy_ = (int)Math.floor((double)this.shift_ * X / this.distance_);
        }
        if (this.source_ != this.target_) {
            QuadCurve2D.Double tmp = new QuadCurve2D.Double();
            this.fillCurve(sourceLocation, targetLocation, 2.0, tmp);
            this.setBounds(tmp.getBounds());
            Point location = this.getLocation();
            sourceLocation.translate(-location.x, -location.y);
            targetLocation.translate(-location.x, -location.y);
            this.fillCurve(sourceLocation, targetLocation, 2.0, this.curve_);
            this.fillCurve(sourceLocation, targetLocation, 1.9, this.insideCurve_);
            if (this.picture_ != null) {
                this.xPicture_ = (int)((long)(this.sourceRealCoordinates_.x + this.dx_) + Math.round(X / 3.0));
                this.yPicture_ = (int)((long)(this.sourceRealCoordinates_.y + this.dy_) + Math.round(Y / 3.0));
            }
        } else {
            Ellipse2D.Double tmpLoop = new Ellipse2D.Double();
            this.fillLoop(sourceLocation, targetLocation, this.getBaseRadiusOfLoop(), tmpLoop);
            this.setBounds(tmpLoop.getBounds());
            this.dx_ = this.shift_;
            this.dy_ = this.shift_ / 2;
            Point location = this.getLocation();
            sourceLocation.translate(-location.x, -location.y);
            targetLocation.translate(-location.x, -location.y);
            this.fillLoop(sourceLocation, targetLocation, this.getBaseRadiusOfLoop(), this.loop_);
            this.fillLoop(sourceLocation, targetLocation, this.getBaseRadiusOfLoop() - 1, this.insideLoop_);
            if (this.picture_ != null) {
                this.xPicture_ = this.sourceRealCoordinates_.x + 2 * (this.getBaseRadiusOfLoop() + this.dx_);
                this.yPicture_ = this.sourceRealCoordinates_.y - (this.getBaseRadiusOfLoop() + this.dx_) / 2;
            }
        }
    }

    int getBaseRadiusOfLoop() {
        return this.radius_;
    }

    public void setPicture(BufferedImage picture) {
        if (picture != null) {
            this.picture_ = picture.getSubimage(0, 0, picture.getWidth() < 15 ? picture.getWidth() : 15, picture.getHeight() < 15 ? picture.getHeight() : 15);
            if (this.target_ != this.source_) {
                this.xPicture_ = (int)((double)(10 * (this.sourceRealCoordinates_.x - this.targetRealCoordinates_.x)) / this.distance_ + (double)this.targetRealCoordinates_.x);
                if (this.sourceRealCoordinates_.x < this.targetRealCoordinates_.x) {
                    this.xPicture_ -= picture.getWidth() / 2;
                }
                this.yPicture_ = (int)((double)(10 * (this.sourceRealCoordinates_.y - this.targetRealCoordinates_.y)) / this.distance_ + (double)this.targetRealCoordinates_.y);
                if (this.sourceRealCoordinates_.y < this.targetRealCoordinates_.y) {
                    this.yPicture_ -= picture.getHeight() / 2;
                }
            }
        } else {
            this.picture_ = null;
        }
    }

    public GObject getSource() {
        return this.source_;
    }

    public Point getSourceRealCoordinates() {
        return this.sourceRealCoordinates_;
    }

    public GObject getTarget() {
        return this.target_;
    }

    public Point getTargetRealCoordinates() {
        return this.targetRealCoordinates_;
    }

    @Override
    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        if (this.source_ != this.target_) {
            return this.curve_.contains(x, y) && !this.insideCurve_.contains(x, y) || this.curve_.contains((double)x + 1.0, y) && !this.insideCurve_.contains((double)x + 1.0, y) || this.curve_.contains((double)x - 1.0, y) && !this.insideCurve_.contains((double)x - 1.0, y) || this.curve_.contains(x, (double)y + 1.0) && !this.insideCurve_.contains(x, (double)y + 1.0) || this.curve_.contains(x, (double)y - 1.0) && !this.insideCurve_.contains(x, (double)y - 1.0);
        }
        return this.loop_.contains(x, y) && !this.insideLoop_.contains(x, y) || this.loop_.contains((double)x + 1.0, y) && !this.insideLoop_.contains((double)x + 1.0, y) || this.loop_.contains((double)x - 1.0, y) && !this.insideLoop_.contains((double)x - 1.0, y) || this.loop_.contains(x, (double)y + 2.0) && !this.insideLoop_.contains(x, (double)y + 2.0) || this.loop_.contains(x, (double)y + 1.0) && !this.insideLoop_.contains(x, (double)y + 1.0);
    }

    public void setColor(Color c) {
        this.color_ = c;
    }

    public void setLinkWidth(int width) {
        this.width_ = width;
        this.repaint();
    }

    protected int getLinkWidth() {
        return this.width_;
    }

    public Color getColor() {
        return this.color_;
    }

    public double getDistance() {
        return this.distance_;
    }

    int getOffsetSourceX() {
        return this.offSetSourceX_;
    }

    int getOffsetSourceY() {
        return this.offSetSourceY_;
    }

    int getOffsetTargetX() {
        return this.offSetTargetX_;
    }

    int getOffsetTargetY() {
        return this.offSetTargetY_;
    }

    public int getShift() {
        return this.shift_;
    }

    void setShift(int shift) {
        this.shift_ = shift;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.color_);
        BasicStroke render = new BasicStroke(this.width_);
        ((Graphics2D)g).setStroke(render);
        if (this.source_ != this.target_) {
            ((Graphics2D)g).draw(this.curve_);
        } else {
            ((Graphics2D)g).draw(this.loop_);
        }
        if (this.picture_ != null) {
            g.drawImage(this.picture_, this.xPicture_, this.yPicture_, this.picture_.getWidth(), this.picture_.getHeight(), this);
        }
    }

    class LinkListener
    extends ComponentAdapter {
        LinkListener() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            Link.this.updateBounds();
        }
    }
}

