/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.layerManager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.Vector;
import mascoptLib.gui.layerManager.GObject;
import mascoptLib.gui.layerManager.Layer;
import mascoptLib.gui.layerManager.LayerInfo;

class View
extends GObject {
    private static final long serialVersionUID = 2L;
    private Point viewCenter;
    private Point realCenter;
    private double zoomFactor;
    private Vector<LayerInfo> layersInfo;
    private String displayMessage = null;
    public Dimension preferredSize = new Dimension(400, 400);
    private Component currentMouseOn = null;
    private Component oldMouseOn = null;
    private Component currentDragged = null;

    public View(int x, int y, double zoomFactor) {
        this.zoomFactor = zoomFactor;
        this.realCenter = new Point(x, y);
        this.viewCenter = new Point();
        this.layersInfo = new Vector();
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    @Override
    public void setLocation(Point p) {
        super.setLocation(p);
    }

    public void addLayer(Layer layer) {
        this.layersInfo.add(new LayerInfo(layer, true));
        layer.addView(this);
    }

    public void removeLayer(Layer layer) {
        int noL = this.findLayerInfo(layer);
        if (noL != -1) {
            this.layersInfo.remove(noL);
            layer.removeView(this);
        }
    }

    public void insertLayer(int index, Layer layer) {
        this.insertLayerInfo(index, new LayerInfo(layer, true));
    }

    public void insertLayerInfo(int index, LayerInfo li) {
        this.layersInfo.add(index, li);
        li.getLayer().addView(this);
    }

    public int getLayerCount() {
        return this.layersInfo.size();
    }

    public int getLayerIndex(Layer l) {
        int nbLayers = this.getLayerCount();
        int i = 0;
        while (i < nbLayers) {
            LayerInfo li = this.layersInfo.elementAt(i);
            if (li.getLayer() == l) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean contains(Layer l) {
        return this.getLayerIndex(l) != -1;
    }

    public LayerInfo getLayerInfo(Layer l) {
        int nbLayers = this.getLayerCount();
        int i = 0;
        while (i < nbLayers) {
            LayerInfo li = this.layersInfo.elementAt(i);
            if (li.getLayer() == l) {
                return li;
            }
            ++i;
        }
        return null;
    }

    public void setVisibleLayer(Layer layer, boolean visible) {
        int noL = this.findLayerInfo(layer);
        if (noL != -1) {
            this.layersInfo.elementAt(noL).setVisible(visible);
        }
    }

    private int findLayerInfo(Layer l) {
        int nbLayer = this.layersInfo.size();
        int i = 0;
        while (i < nbLayer) {
            LayerInfo li = this.layersInfo.elementAt(i);
            if (li.getLayer() == l) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Point getRealCenter() {
        return this.realCenter;
    }

    public void setRealCenter(Point p) {
        this.realCenter = p;
    }

    @Override
    public void translate(int realX, int realY) {
        this.realCenter.translate(realX, realY);
        this.repaint();
    }

    public void translate(Point realPoint) {
        this.translate(realPoint.x, realPoint.y);
    }

    public double getZoom() {
        return this.zoomFactor;
    }

    public void setZoom(double newZoom) {
        this.zoomFactor = newZoom;
        this.repaint();
    }

    public void updateZoom(double newZoom) {
        this.zoomFactor *= newZoom;
        this.repaint();
    }

    public Point getReal(Point p) {
        return new Point((int)Math.floor(this.realCenter.getX() + (p.getX() - this.viewCenter.getX()) / this.zoomFactor), (int)Math.floor(this.realCenter.getY() + (p.getY() - this.viewCenter.getY()) / this.zoomFactor));
    }

    public Dimension getReal(Dimension dim) {
        return new Dimension((int)Math.floor(dim.getWidth() / this.zoomFactor), (int)Math.floor(dim.getHeight() / this.zoomFactor));
    }

    public Rectangle getReal(Rectangle r) {
        return new Rectangle(this.getReal(r.getLocation()), this.getReal(r.getSize()));
    }

    public Point getView(Point p) {
        return new Point((int)Math.floor(this.viewCenter.getX() + (p.getX() - this.realCenter.getX()) * this.zoomFactor), (int)Math.floor(this.viewCenter.getY() + (p.getY() - this.realCenter.getY()) * this.zoomFactor));
    }

    public Dimension getView(Dimension dim) {
        return new Dimension((int)Math.floor(dim.getWidth() * this.zoomFactor), (int)Math.floor(dim.getHeight() * this.zoomFactor));
    }

    public Rectangle getView(Rectangle r) {
        return new Rectangle(this.getView(r.getLocation()), this.getView(r.getSize()));
    }

    @Override
    public void repaint() {
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    public void setDisplayMessage(String s) {
        this.displayMessage = s;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(int x, int y) {
        this.setPreferredSize(new Dimension(x, y));
    }

    @Override
    public void setPreferredSize(Dimension dim) {
        this.preferredSize = dim;
    }

    @Override
    public void paint(Graphics g) {
        int cx = (int)Math.floor((double)this.getWidth() / 2.0);
        int cy = (int)Math.floor((double)this.getHeight() / 2.0);
        this.viewCenter = new Point(cx, cy);
        double tx = this.viewCenter.getX() / this.zoomFactor - this.realCenter.getX();
        double ty = this.viewCenter.getY() / this.zoomFactor - this.realCenter.getY();
        ((Graphics2D)g).scale(this.zoomFactor, this.zoomFactor);
        ((Graphics2D)g).translate(tx, ty);
        Rectangle bounds = this.getBounds();
        bounds.translate(-this.getLocation().x, -this.getLocation().y);
        Rectangle realView = this.getReal(bounds);
        int nbLayers = this.layersInfo.size();
        int i = 0;
        while (i < nbLayers) {
            LayerInfo layerInfo = this.layersInfo.elementAt(i);
            if (layerInfo.isVisible()) {
                Layer layer = layerInfo.getLayer();
                layer.paint(g, realView);
            }
            ++i;
        }
        if (this.displayMessage != null) {
            ((Graphics2D)g).translate(-tx, -ty);
            ((Graphics2D)g).scale(1.0 / this.zoomFactor, 1.0 / this.zoomFactor);
            g.setColor(Color.black);
            g.drawString(this.displayMessage, cx, cy);
        }
    }

    public Component getFirstComponentAt(Point p) {
        int nbLayers = this.layersInfo.size();
        int i = 0;
        while (i < nbLayers) {
            Component c;
            LayerInfo layerInfo = this.layersInfo.elementAt(i);
            if (layerInfo.isVisible() && (c = layerInfo.getLayer().getComponentAt(p)) != null) {
                return c;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        Point realPoint = this.getReal(e.getPoint());
        this.currentMouseOn = this.getFirstComponentAt(realPoint);
        if (this.currentMouseOn != null) {
            e.translatePoint(-e.getX() + realPoint.x, -e.getY() + realPoint.y);
            this.forwardEvent(e, e.getID(), this.currentMouseOn);
        } else {
            super.processMouseEvent(e);
            this.currentMouseOn = this;
        }
        if (e.getID() == 501) {
            this.currentDragged = this.currentMouseOn;
        } else if (e.getID() == 502) {
            this.currentDragged = null;
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        Point realPoint = this.getReal(e.getPoint());
        this.currentMouseOn = this.getFirstComponentAt(realPoint);
        if (e.getID() == 506) {
            if (this.currentDragged == this) {
                super.processMouseMotionEvent(e);
            } else if (this.currentDragged != null) {
                e.translatePoint(-e.getX() + realPoint.x, -e.getY() + realPoint.y);
                this.forwardEvent(e, e.getID(), this.currentDragged);
            }
        } else if (e.getID() == 503) {
            if (this.currentMouseOn != null && this.currentMouseOn != this.oldMouseOn) {
                this.forwardEvent(e, 504, this.currentMouseOn);
            }
            if (this.oldMouseOn != null && this.currentMouseOn != this.oldMouseOn) {
                this.forwardEvent(e, 505, this.oldMouseOn);
            }
            if (this.currentMouseOn != null) {
                e.translatePoint(-e.getX() + realPoint.x, -e.getY() + realPoint.y);
                this.forwardEvent(e, e.getID(), this.currentMouseOn);
            } else {
                super.processMouseMotionEvent(e);
            }
            this.oldMouseOn = this.currentMouseOn;
        }
    }

    private void forwardEvent(MouseEvent e, int type, Component source) {
        Point realComponentLocation = source.getLocation();
        Point newP = e.getPoint();
        newP.translate(-realComponentLocation.x, -realComponentLocation.y);
        MouseEvent newEvent = new MouseEvent(source, type, e.getWhen(), e.getModifiers(), newP.x, newP.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(newEvent);
    }
}

