/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.mapEditor;

import bridge.abstractClasses.AbstractScalar;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptSet;

public class MapEditor
extends JFrame {
    private static final long serialVersionUID = 2L;
    private static final ClassLoader loader_ = ClassLoader.getSystemClassLoader();
    private static final int OBJECT_CONTEXT_NAME = 0;
    private static final int OBJECT_NAME_CONTEXT = 1;
    private static final int NAME_OBJECT_CONTEXT = 2;
    private JPanel mapEditorPanel_ = null;
    private JComboBox displayTypeComboBox_ = null;
    private JScrollPane jScrollPane_ = null;
    private JTree jTree_ = null;
    private TextField displayTypeLabel_ = null;
    private MascoptObject valueChangeKey_;
    private MascoptObject valueChangeContext_;
    private String valueChangeName_;
    private DefaultMutableTreeNode root_ = null;
    private int displayType_ = 0;
    private MascoptMap editedMap_ = null;
    private HashSet<String> namesSet_ = new HashSet();
    private JFrame valueChangeFrame_ = null;
    private JPanel valueChangePanel_ = null;
    private JLabel keyLabel_ = null;
    private JLabel keyNameLabel_ = null;
    private JLabel contextLabel_ = null;
    private JLabel contextNameLabel_ = null;
    private JLabel typeLabel_ = null;
    private JComboBox typeComboBox_ = null;
    private JLabel nameLabel_ = null;
    private JTextField nameEntry_ = null;
    private JLabel valueLabel_ = null;
    private JTextField valueEntry_ = null;
    private JButton okButton_ = null;
    private JButton cancelButton_ = null;
    static String[] mascoptTypeName = new String[]{"MascoptInteger", "MascoptDouble", "MascoptMPInteger", "MascoptMPDecimal", "String"};

    public MapEditor() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(395, 300);
        this.setContentPane(this.getMapEditorPanel());
        this.setTitle("Map Editor");
        this.setVisible(true);
    }

    private JPanel getMapEditorPanel() {
        if (this.mapEditorPanel_ == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.weightx = 1.0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.weightx = 1.0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.ipadx = 0;
            gridBagConstraints1.ipady = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.anchor = 12;
            gridBagConstraints1.gridheight = 1;
            gridBagConstraints1.gridwidth = 1;
            gridBagConstraints1.gridx = 1;
            this.mapEditorPanel_ = new JPanel();
            this.mapEditorPanel_.setLayout(new GridBagLayout());
            this.mapEditorPanel_.add((Component)this.getDisplayTypeLabel(), gridBagConstraints3);
            this.mapEditorPanel_.add((Component)this.getDisplayTypeComboBox(), gridBagConstraints1);
            this.mapEditorPanel_.add((Component)this.getJScrollPane(), gridBagConstraints11);
        }
        return this.mapEditorPanel_;
    }

    private JComboBox getDisplayTypeComboBox() {
        if (this.displayTypeComboBox_ == null) {
            this.displayTypeComboBox_ = new JComboBox();
            this.displayTypeComboBox_.setName("jComboBox");
            this.displayTypeComboBox_.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (MapEditor.this.displayType_ != MapEditor.this.displayTypeComboBox_.getSelectedIndex()) {
                        MapEditor.this.displayType_ = MapEditor.this.displayTypeComboBox_.getSelectedIndex();
                        MapEditor.this.fillTree();
                    }
                }
            });
        }
        return this.displayTypeComboBox_;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane_ == null) {
            this.jScrollPane_ = new JScrollPane();
            this.jScrollPane_.setViewportView(this.getJTree());
            this.jScrollPane_.setName("jScrollPane");
            this.jScrollPane_.setViewportView(this.getJTree());
        }
        return this.jScrollPane_;
    }

    private JTree getJTree() {
        if (this.jTree_ == null) {
            this.jTree_ = new JTree();
            this.jTree_.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MapEditor.this.mouseClickOnTree(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            this.jTree_.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    MapEditor.this.keyPressedOnTree(e);
                }
            });
        }
        return this.jTree_;
    }

    private TextField getDisplayTypeLabel() {
        if (this.displayTypeLabel_ == null) {
            this.displayTypeLabel_ = new TextField();
            this.displayTypeLabel_.setEditable(false);
            this.displayTypeLabel_.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.displayTypeLabel_.setText("Choose display type");
        }
        return this.displayTypeLabel_;
    }

    public void fillComboBox() {
        JComboBox displayType = this.getDisplayTypeComboBox();
        displayType.addItem("Key/Context/Name");
        displayType.addItem("Key/Name/Context");
        displayType.addItem("Name/Key/Context");
    }

    private void fillTree() {
        if (this.editedMap_ == null) {
            return;
        }
        if (this.root_ == null) {
            this.root_ = new DefaultMutableTreeNode(this.editedMap_.getName());
        } else {
            this.root_.removeAllChildren();
        }
        switch (this.displayType_) {
            case 0: {
                this.fillTreeWithObjectContextName();
                break;
            }
            case 1: {
                this.fillTreeWithObjectNameContext();
                break;
            }
            case 2: {
                this.fillTreeWithNameObjectContext();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Unexepted display type index");
            }
        }
        DefaultTreeModel model = new DefaultTreeModel(this.root_);
        JTree tree = this.getJTree();
        tree.setModel(model);
    }

    private DefaultMutableTreeNode getValueTreeNode(MascoptObject key, String valueName, MascoptObject context) {
        return new DefaultMutableTreeNode(String.valueOf(this.editedMap_.getDataType(key, valueName, context).equals("String") ? this.editedMap_.getString(key, valueName, context) : this.editedMap_.getValue(key, valueName, context).toString()) + "(" + this.editedMap_.getDataType(key, valueName, context) + ")");
    }

    private void fillTreeWithObjectContextName() {
        Iterator<? extends MascoptObject> keyIt = this.editedMap_.keysIterator();
        while (keyIt.hasNext()) {
            MascoptObject currentObj = keyIt.next();
            DefaultMutableTreeNode objNode = new DefaultMutableTreeNode(currentObj);
            this.root_.add(objNode);
            Iterator<? extends MascoptObject> contextIt = this.editedMap_.contextsIterator(currentObj);
            while (contextIt.hasNext()) {
                MascoptObject currentCont = contextIt.next();
                DefaultMutableTreeNode contNode = new DefaultMutableTreeNode(currentCont);
                objNode.add(contNode);
                Iterator<String> namesIt = this.editedMap_.namesIterator(currentObj, currentCont);
                while (namesIt.hasNext()) {
                    String currentName = namesIt.next();
                    this.namesSet_.add(currentName.intern());
                    DefaultMutableTreeNode nameNode = new DefaultMutableTreeNode(currentName);
                    contNode.add(nameNode);
                    DefaultMutableTreeNode valueNode = this.getValueTreeNode(currentObj, currentName, currentCont);
                    nameNode.add(valueNode);
                }
            }
        }
    }

    private void fillTreeWithObjectNameContext() {
        Iterator<? extends MascoptObject> keyIt = this.editedMap_.keysIterator();
        while (keyIt.hasNext()) {
            MascoptObject currentObj = keyIt.next();
            DefaultMutableTreeNode objNode = new DefaultMutableTreeNode(currentObj);
            this.root_.add(objNode);
            for (String currentName : this.namesSet_) {
                DefaultMutableTreeNode nameNode = new DefaultMutableTreeNode(currentName);
                Iterator<? extends MascoptObject> contextIt = this.editedMap_.contextsIterator(currentObj, currentName);
                while (contextIt.hasNext()) {
                    objNode.add(nameNode);
                    MascoptObject currentCont = contextIt.next();
                    DefaultMutableTreeNode contNode = new DefaultMutableTreeNode(currentCont);
                    nameNode.add(contNode);
                    DefaultMutableTreeNode valueNode = this.getValueTreeNode(currentObj, currentName, currentCont);
                    contNode.add(valueNode);
                }
            }
        }
    }

    private void fillTreeWithNameObjectContext() {
        for (String currentName : this.namesSet_) {
            DefaultMutableTreeNode nameNode = new DefaultMutableTreeNode(currentName);
            this.root_.add(nameNode);
            Iterator<? extends MascoptObject> keyIt = this.editedMap_.keysIterator();
            while (keyIt.hasNext()) {
                MascoptObject currentObj = keyIt.next();
                DefaultMutableTreeNode objNode = new DefaultMutableTreeNode(currentObj);
                Iterator<? extends MascoptObject> contextIt = this.editedMap_.contextsIterator(currentObj, currentName);
                while (contextIt.hasNext()) {
                    nameNode.add(objNode);
                    MascoptObject currentCont = contextIt.next();
                    DefaultMutableTreeNode contNode = new DefaultMutableTreeNode(currentCont);
                    objNode.add(contNode);
                    DefaultMutableTreeNode valueNode = this.getValueTreeNode(currentObj, currentName, currentCont);
                    contNode.add(valueNode);
                }
            }
        }
    }

    public void setEditedMap(MascoptMap map) {
        this.editedMap_ = map;
        this.fillTree();
    }

    private JFrame getValueChangeFrame() {
        if (this.valueChangeFrame_ == null) {
            this.valueChangeFrame_ = new JFrame();
            this.valueChangeFrame_.setTitle("Value Change");
            this.valueChangeFrame_.setSize(new Dimension(315, 363));
            this.valueChangeFrame_.setResizable(false);
            this.valueChangeFrame_.setDefaultCloseOperation(2);
            this.valueChangeFrame_.setContentPane(this.getValueChangePanel());
            this.valueChangeFrame_.setVisible(false);
        }
        return this.valueChangeFrame_;
    }

    private JPanel getValueChangePanel() {
        if (this.valueChangePanel_ == null) {
            this.valueLabel_ = new JLabel();
            this.valueLabel_.setText("Value");
            this.valueLabel_.setHorizontalAlignment(0);
            this.valueLabel_.setBounds(new Rectangle(32, 241, 53, 27));
            this.nameLabel_ = new JLabel();
            this.nameLabel_.setText("Name");
            this.nameLabel_.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.nameLabel_.setHorizontalTextPosition(0);
            this.nameLabel_.setHorizontalAlignment(0);
            this.nameLabel_.setBounds(new Rectangle(32, 128, 53, 27));
            this.typeLabel_ = new JLabel();
            this.typeLabel_.setText("Type");
            this.typeLabel_.setHorizontalAlignment(0);
            this.typeLabel_.setBounds(new Rectangle(32, 178, 53, 27));
            this.contextLabel_ = new JLabel();
            this.contextLabel_.setText("Context");
            this.contextLabel_.setHorizontalTextPosition(0);
            this.contextLabel_.setHorizontalAlignment(0);
            this.contextLabel_.setBounds(new Rectangle(32, 66, 53, 27));
            this.keyLabel_ = new JLabel();
            this.keyLabel_.setText("Key");
            this.keyLabel_.setBounds(new Rectangle(32, 12, 53, 27));
            this.keyLabel_.setHorizontalTextPosition(0);
            this.keyLabel_.setHorizontalAlignment(0);
            this.keyLabel_.setToolTipText("The name of the key");
            this.valueChangePanel_ = new JPanel();
            this.valueChangePanel_.setLayout(null);
            this.valueChangePanel_.add((Component)this.keyLabel_, null);
            this.valueChangePanel_.add((Component)this.getKeyNameLabel(), null);
            this.valueChangePanel_.add((Component)this.contextLabel_, null);
            this.valueChangePanel_.add((Component)this.getContextNameLabel(), null);
            this.valueChangePanel_.add((Component)this.nameLabel_, null);
            this.valueChangePanel_.add((Component)this.getNameEntry(), null);
            this.valueChangePanel_.add((Component)this.typeLabel_, null);
            this.valueChangePanel_.add((Component)this.getTypeComboBox(), null);
            this.valueChangePanel_.add((Component)this.valueLabel_, null);
            this.valueChangePanel_.add((Component)this.getValueEntry(), null);
            this.valueChangePanel_.add((Component)this.getOkButton(), null);
            this.valueChangePanel_.add((Component)this.getCancelButton(), null);
        }
        return this.valueChangePanel_;
    }

    private JLabel getKeyNameLabel() {
        if (this.keyNameLabel_ == null) {
            this.keyNameLabel_ = new JLabel();
            this.keyNameLabel_.setText("JLabel");
            this.keyNameLabel_.setHorizontalAlignment(0);
            this.keyNameLabel_.setBounds(new Rectangle(155, 12, 144, 27));
        }
        return this.keyNameLabel_;
    }

    private JLabel getContextNameLabel() {
        if (this.contextNameLabel_ == null) {
            this.contextNameLabel_ = new JLabel();
            this.contextNameLabel_.setText("JLabel");
            this.contextNameLabel_.setHorizontalAlignment(0);
            this.contextNameLabel_.setBounds(new Rectangle(155, 66, 144, 27));
        }
        return this.contextNameLabel_;
    }

    private JComboBox getTypeComboBox() {
        if (this.typeComboBox_ == null) {
            this.typeComboBox_ = new JComboBox();
            this.typeComboBox_.setBounds(new Rectangle(155, 178, 144, 27));
            int i = 0;
            while (i < mascoptTypeName.length) {
                this.typeComboBox_.addItem(mascoptTypeName[i]);
                ++i;
            }
        }
        return this.typeComboBox_;
    }

    private JTextField getNameEntry() {
        if (this.nameEntry_ == null) {
            this.nameEntry_ = new JTextField();
            this.nameEntry_.setBounds(new Rectangle(155, 128, 144, 27));
        }
        return this.nameEntry_;
    }

    private JTextField getValueEntry() {
        if (this.valueEntry_ == null) {
            this.valueEntry_ = new JTextField();
            this.valueEntry_.setBounds(new Rectangle(155, 241, 144, 27));
        }
        return this.valueEntry_;
    }

    private JButton getOkButton() {
        if (this.okButton_ == null) {
            this.okButton_ = new JButton();
            this.okButton_.setText("OK");
            this.okButton_.setBounds(new Rectangle(42, 299, 84, 25));
            this.okButton_.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    MapEditor.this.updateEditedMapFromValueChange();
                }
            });
            this.okButton_.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        MapEditor.this.updateEditedMapFromValueChange();
                    }
                }
            });
        }
        return this.okButton_;
    }

    private JButton getCancelButton() {
        if (this.cancelButton_ == null) {
            this.cancelButton_ = new JButton();
            this.cancelButton_.setText("Cancel");
            this.cancelButton_.setBounds(new Rectangle(206, 299, 84, 25));
            this.cancelButton_.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MapEditor.this.getValueChangeFrame().dispose();
                }
            });
        }
        return this.cancelButton_;
    }

    void updateEditedMapFromValueChange() {
        String name = this.getNameEntry().getText();
        int dataType = this.typeComboBox_.getSelectedIndex();
        String valueString = this.getValueEntry().getText();
        assert (dataType < mascoptTypeName.length);
        if (mascoptTypeName[dataType].equalsIgnoreCase("String")) {
            this.editedMap_.putString(this.valueChangeKey_, name, this.valueChangeContext_, valueString);
        } else {
            Constructor<?> numberConstructor;
            Class<?> numberType;
            try {
                numberType = loader_.loadClass("mascoptLib.numeric." + mascoptTypeName[dataType]);
            }
            catch (ClassNotFoundException e1) {
                Object[] errorMessage = new Object[]{"loadClass : " + e1};
                JOptionPane.showMessageDialog(null, errorMessage, "Set value error", 0);
                return;
            }
            try {
                numberConstructor = numberType.getConstructor("".getClass());
            }
            catch (NoSuchMethodException e1) {
                Object[] errorMessage = new Object[]{"loadClass : " + e1};
                JOptionPane.showMessageDialog(null, errorMessage, "Set value error", 0);
                return;
            }
            AbstractScalar value = null;
            try {
                value = (AbstractScalar)numberConstructor.newInstance(valueString);
            }
            catch (IllegalAccessError e) {
                Object[] errorMessage = new Object[]{"loadClass : " + e};
                JOptionPane.showMessageDialog(null, errorMessage, "Set value error", 0);
                return;
            }
            catch (IllegalArgumentException e) {
                Object[] errorMessage = new Object[]{"loadClass : " + e};
                JOptionPane.showMessageDialog(null, errorMessage, "Set value error", 0);
                return;
            }
            catch (InstantiationException e) {
                Object[] errorMessage = new Object[]{"loadClass : " + e};
                JOptionPane.showMessageDialog(null, errorMessage, "Set value error", 0);
                return;
            }
            catch (IllegalAccessException e) {
                Object[] errorMessage = new Object[]{"loadClass : " + e};
                JOptionPane.showMessageDialog(null, errorMessage, "Set value error", 0);
                return;
            }
            catch (InvocationTargetException e) {
                Object[] errorMessage = new Object[]{"loadClass : " + e};
                JOptionPane.showMessageDialog(null, errorMessage, "Set value error", 0);
                return;
            }
            this.editedMap_.putValue(this.valueChangeKey_, name, this.valueChangeContext_, value);
        }
        if (!name.equals(this.valueChangeName_)) {
            this.editedMap_.remove(this.valueChangeKey_, this.valueChangeName_, this.valueChangeContext_);
        }
        this.getValueChangeFrame().dispose();
        this.fillTree();
    }

    private MascoptObject getObjectValueFromTreePath(TreePath path) {
        Object[] nodes = path.getPath();
        switch (this.displayType_) {
            case 0: 
            case 1: {
                if (nodes.length > 1) {
                    return (MascoptObject)((DefaultMutableTreeNode)nodes[1]).getUserObject();
                }
                return null;
            }
            case 2: {
                if (nodes.length > 2) {
                    return (MascoptObject)((DefaultMutableTreeNode)nodes[2]).getUserObject();
                }
                return null;
            }
        }
        throw new IndexOutOfBoundsException("Unexepted display type index");
    }

    private MascoptObject getContextValueFromTreePath(TreePath path) {
        Object[] nodes = path.getPath();
        switch (this.displayType_) {
            case 0: {
                if (nodes.length > 2) {
                    return (MascoptObject)((DefaultMutableTreeNode)nodes[2]).getUserObject();
                }
                return null;
            }
            case 1: 
            case 2: {
                if (nodes.length > 3) {
                    return (MascoptObject)((DefaultMutableTreeNode)nodes[3]).getUserObject();
                }
                return null;
            }
        }
        throw new IndexOutOfBoundsException("Unexepted display type index");
    }

    private String getValueNameFromTreePath(TreePath path) {
        Object[] nodes = path.getPath();
        switch (this.displayType_) {
            case 0: {
                if (nodes.length > 3) {
                    return (String)((DefaultMutableTreeNode)nodes[3]).getUserObject();
                }
                return null;
            }
            case 1: {
                if (nodes.length > 2) {
                    return (String)((DefaultMutableTreeNode)nodes[2]).getUserObject();
                }
                return null;
            }
            case 2: {
                if (nodes.length > 1) {
                    return (String)((DefaultMutableTreeNode)nodes[1]).getUserObject();
                }
                return null;
            }
        }
        throw new IndexOutOfBoundsException("Unexepted display type");
    }

    private void mouseClickOnTree(MouseEvent e) {
        if (e.getClickCount() > 1 && this.jTree_.getPathForLocation(e.getX(), e.getY()) != null && ((DefaultMutableTreeNode)this.jTree_.getPathForLocation(e.getX(), e.getY()).getLastPathComponent()).isLeaf()) {
            TreePath p = this.jTree_.getPathForLocation(e.getX(), e.getY());
            this.getValueChangeFrame().setVisible(true);
            this.valueChangeKey_ = this.getObjectValueFromTreePath(p);
            this.valueChangeContext_ = this.getContextValueFromTreePath(p);
            this.valueChangeName_ = this.getValueNameFromTreePath(p);
            String dataType = this.editedMap_.getDataType(this.valueChangeKey_, this.valueChangeName_, this.valueChangeContext_);
            this.getTypeComboBox().setSelectedItem(dataType);
            Object value = dataType.equalsIgnoreCase("String") ? this.editedMap_.getString(this.valueChangeKey_, this.valueChangeName_, this.valueChangeContext_) : this.editedMap_.getValue(this.valueChangeKey_, this.valueChangeName_, this.valueChangeContext_);
            this.getKeyNameLabel().setText(this.valueChangeKey_.toString());
            this.getContextNameLabel().setText(this.valueChangeContext_.toString());
            this.getNameEntry().setText(this.valueChangeName_);
            this.getValueEntry().setText(value.toString());
        }
    }

    private void keyPressedOnTree(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            TreePath selectedPath = this.jTree_.getSelectionPath();
            if (selectedPath == null) {
                return;
            }
            switch (this.displayType_) {
                case 0: {
                    MascoptObject o = this.getObjectValueFromTreePath(selectedPath);
                    if (o == null) break;
                    MascoptObject c = this.getContextValueFromTreePath(selectedPath);
                    if (c != null) {
                        String name = this.getValueNameFromTreePath(selectedPath);
                        if (name == null) {
                            this.editedMap_.removeAll(o, c);
                            break;
                        }
                        this.editedMap_.remove(o, name, c);
                        break;
                    }
                    this.editedMap_.removeAll(o);
                    break;
                }
                case 1: {
                    MascoptObject o = this.getObjectValueFromTreePath(selectedPath);
                    if (o == null) break;
                    String name = this.getValueNameFromTreePath(selectedPath);
                    if (name != null) {
                        MascoptObject c = this.getContextValueFromTreePath(selectedPath);
                        if (c != null) {
                            this.editedMap_.remove(o, name, c);
                            break;
                        }
                        Iterator<? extends MascoptObject> contextIt = this.editedMap_.contextsIterator(o, name);
                        while (contextIt.hasNext()) {
                            contextIt.next();
                            contextIt.remove();
                        }
                        break;
                    }
                    this.editedMap_.removeAll(o);
                    break;
                }
                case 2: {
                    String name = this.getValueNameFromTreePath(selectedPath);
                    if (name == null) break;
                    MascoptObject o = this.getObjectValueFromTreePath(selectedPath);
                    if (o != null) {
                        MascoptObject c = this.getContextValueFromTreePath(selectedPath);
                        if (c != null) {
                            this.editedMap_.remove(o, name, c);
                            break;
                        }
                        Iterator<? extends MascoptObject> contextIt = this.editedMap_.contextsIterator(o, name);
                        while (contextIt.hasNext()) {
                            contextIt.next();
                            contextIt.remove();
                        }
                    } else {
                        this.namesSet_.remove(name.intern());
                        MascoptSet<MascoptObject> objectSet = new MascoptSet<MascoptObject>();
                        Iterator<? extends MascoptObject> it = this.editedMap_.keysIterator();
                        while (it.hasNext()) {
                            objectSet.add(it.next());
                        }
                        Iterator itSet = objectSet.iterator();
                        while (itSet.hasNext()) {
                            Iterator<? extends MascoptObject> contIt = this.editedMap_.contextsIterator(itSet.next(), name);
                            while (contIt.hasNext()) {
                                contIt.next();
                                contIt.remove();
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException("Unexepted display type");
                }
            }
            this.fillTree();
        }
    }
}

