/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.stepAlgoGui;

import bridge.algorithms.StepAlgo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptObservableObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.Notification;
import mascoptLib.core.interfaces.MascoptObserver;
import mascoptLib.gui.layerManager.GLayer;
import mascoptLib.gui.layerManager.GView;
import mascoptLib.gui.layerManager.LayerManager;
import mascoptLib.gui.stepAlgoGui.StepAlgoGuiEventListener;
import tools.SystemAbstraction;

public class StepAlgoGui
implements ActionListener,
MascoptObserver,
Observer {
    private MascoptAbstractGraph<?> firstGraph_;
    private final StepAlgo<?, ?> algo_;
    private Vector<WindowsConfiguration> configurations_;
    private MascoptMap verticesAndEdgesMapValues_;
    private MascoptObject verticesAndEdgesContextValues_;
    private String[] verticesLabels_ = null;
    private String[] edgesLabels_ = null;
    private String algoName_ = "Demonstration";
    private String layerName_ = "Layer I";
    private int edgeWidth_ = 1;
    private JButton start_;
    private JButton prev_;
    private JButton step_;
    private JButton stopResume_;
    private LayerManager layerManager_;
    private int realStep_ = 0;
    private String prefix_;
    private int currentDisplayedStep_ = 0;
    private Thread algoThread = null;

    private WindowsConfiguration getConfigurationFromGraph(MascoptAbstractGraph<?> g) {
        for (WindowsConfiguration current : this.configurations_) {
            if (current.getGraph() != g) continue;
            return current;
        }
        return null;
    }

    private void loadImage(int index) {
        int i = 0;
        while (i < this.configurations_.size()) {
            WindowsConfiguration conf = this.configurations_.get(i);
            String fileName = String.valueOf(this.prefix_) + index + "-" + i + ".png";
            this.layerManager_.removeLayerInView(conf.getLayer(), conf.getView());
            File file = new File(fileName);
            try {
                BufferedImage image = ImageIO.read(file);
                this.layerManager_.setBackGroundOfView(conf.getView(), (Image)null);
                this.layerManager_.setBackGroundOfView(conf.getView(), image);
            }
            catch (IOException e) {
                System.err.println(e);
            }
            ++i;
        }
    }

    private void displayGraph() {
        int i = 0;
        while (i < this.configurations_.size()) {
            WindowsConfiguration conf = this.configurations_.get(i);
            this.layerManager_.setBackGroundOfView(conf.getView(), (Image)null);
            this.layerManager_.addLayerInView(conf.getLayer(), conf.getView());
            ++i;
        }
    }

    private void saveWindowsToImage() {
        int i = 0;
        while (i < this.configurations_.size()) {
            WindowsConfiguration conf = this.configurations_.get(i);
            GView v = conf.getView();
            String fileName = this.prefix_;
            try {
                BufferedImage bufferedImage = new BufferedImage(v.getWidth(), v.getHeight(), 1);
                Graphics2D g2d = bufferedImage.createGraphics();
                g2d.setColor(v.getBackground());
                g2d.fillRect(0, 0, v.getWidth(), v.getHeight());
                v.paint(g2d);
                g2d.dispose();
                fileName = String.valueOf(fileName) + this.realStep_;
                fileName = String.valueOf(fileName) + "-" + i;
                fileName = String.valueOf(fileName) + ".png";
                File file = new File(fileName);
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void createViewFrame(GView v, int xLocation, int yLocation) {
        JFrame jfView = new JFrame(v.getName());
        jfView.setDefaultCloseOperation(0);
        jfView.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StepAlgoGui.this.killGui();
                System.exit(0);
            }
        });
        JPanel jpM = new JPanel();
        jpM.setLayout(new BorderLayout());
        JPanel jp = new JPanel();
        this.start_ = new JButton("start");
        this.prev_ = new JButton("previous");
        this.prev_.setEnabled(false);
        this.step_ = new JButton("step");
        this.step_.setEnabled(false);
        this.stopResume_ = new JButton("Resume");
        this.stopResume_.setEnabled(false);
        this.start_.addActionListener(this);
        this.prev_.addActionListener(this);
        this.step_.addActionListener(this);
        this.stopResume_.addActionListener(this);
        jp.add(new JLabel(this.algoName_));
        jp.add(this.start_);
        jp.add(this.prev_);
        jp.add(this.step_);
        jp.add(this.stopResume_);
        jpM.add((Component)v, "Center");
        jpM.add((Component)jp, "North");
        jfView.getContentPane().add(jpM);
        jfView.pack();
        jfView.setLocation(xLocation, yLocation);
        jfView.setVisible(true);
    }

    public StepAlgoGui(StepAlgo<?, ?> algo) {
        this.algo_ = algo;
        this.prefix_ = SystemAbstraction.getTempDirectory();
        this.prefix_ = String.valueOf(this.prefix_) + "/demo";
        algo.addObserver(this);
        this.configurations_ = new Vector();
    }

    private Point computeMiddle(MascoptAbstractGraph<?> graph) {
        int x = 0;
        int y = 0;
        int nbVertex = 0;
        if (graph == null) {
            return new Point(0, 0);
        }
        for (MascoptVertex v : graph.vertexSet()) {
            x = (int)((double)x + v.getX());
            y = (int)((double)y + v.getY());
            ++nbVertex;
        }
        return new Point(x / (nbVertex == 0 ? 1 : nbVertex), y / (nbVertex == 0 ? 1 : nbVertex));
    }

    public void initGUI() {
        StepAlgoGuiEventListener eventListener = new StepAlgoGuiEventListener(this);
        this.layerManager_ = new LayerManager(eventListener);
        Point center = this.computeMiddle(this.firstGraph_);
        GView newView = this.layerManager_.newView("", center.x, center.y, 1.0);
        GLayer layer = this.layerManager_.newLayer(this.layerName_);
        this.configurations_.add(new WindowsConfiguration(this.firstGraph_, newView, layer));
        this.layerManager_.addGraph(this.firstGraph_);
        try {
            this.layerManager_.setVisibleGraphInLayer(this.firstGraph_, layer, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.layerManager_.setGraphLayerMapValues(this.firstGraph_, layer, this.verticesAndEdgesMapValues_);
        this.layerManager_.setGraphLayerContextValues(this.firstGraph_, layer, this.verticesAndEdgesContextValues_);
        if (this.verticesLabels_ != null) {
            this.layerManager_.setVertexLabelGraphInLayer(this.firstGraph_, layer, this.verticesLabels_);
        }
        if (this.edgesLabels_ != null) {
            this.layerManager_.setEdgeLabelGraphInLayer(this.firstGraph_, layer, this.edgesLabels_);
        }
        this.layerManager_.setGraphLinkWidth(this.firstGraph_, layer, this.edgeWidth_);
        this.layerManager_.setLayerVisibleLabels(layer, true);
        this.layerManager_.setLayerUpdateLabelsWhenValuesChange(layer, true);
        this.layerManager_.addLayerInView(layer, newView);
        this.createViewFrame(newView, 0, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            JButton button = (JButton)source;
            if (button.getText().equalsIgnoreCase("start")) {
                if (this.preRun()) {
                    this.algoThread = this.algo_.start();
                    button.setEnabled(false);
                    this.step_.setEnabled(true);
                    this.stopResume_.setEnabled(true);
                }
            } else if (button.getText().equalsIgnoreCase("previous")) {
                this.step_.setEnabled(true);
                --this.currentDisplayedStep_;
                this.loadImage(this.currentDisplayedStep_);
                if (this.currentDisplayedStep_ == 0) {
                    this.prev_.setEnabled(false);
                }
            } else if (button.getText().equalsIgnoreCase("step")) {
                this.prev_.setEnabled(true);
                if (this.currentDisplayedStep_ < this.realStep_) {
                    ++this.currentDisplayedStep_;
                    if (this.currentDisplayedStep_ == this.realStep_) {
                        this.displayGraph();
                    } else {
                        this.loadImage(this.currentDisplayedStep_);
                    }
                } else if (!this.algo_.isEnded()) {
                    this.algo_.nextStep();
                } else {
                    button.setEnabled(false);
                }
            } else {
                if (!this.algoThread.isAlive()) {
                    this.stopResume_.setEnabled(false);
                    this.step_.setEnabled(false);
                    this.prev_.setEnabled(false);
                    return;
                }
                if (this.algo_.getStepMode()) {
                    if (this.currentDisplayedStep_ != this.realStep_) {
                        this.currentDisplayedStep_ = this.realStep_;
                        this.displayGraph();
                    }
                    this.prev_.setEnabled(false);
                    this.step_.setEnabled(false);
                    button.setText("Stop");
                    this.algo_.setPauseMode(false);
                    this.algo_.nextStep();
                } else {
                    this.prev_.setEnabled(true);
                    this.step_.setEnabled(true);
                    this.algo_.setPauseMode(true);
                    button.setText("Resume");
                }
            }
        }
    }

    protected void clickVertex(MascoptVertex v) {
    }

    protected void clickEdge(MascoptAbstractLink e) {
    }

    protected boolean preRun() {
        return true;
    }

    public void setGraphToDisplay(MascoptAbstractGraph<?> g) {
        this.firstGraph_ = g;
    }

    public void setAlgoName(String algoName) {
        this.algoName_ = algoName;
    }

    public void setVerticesLabel(String labels) {
        if (this.verticesLabels_ == null) {
            this.verticesLabels_ = labels.split(System.getProperty("line.separator"));
        }
    }

    public void setEdgesLabel(String labels) {
        if (this.edgesLabels_ == null) {
            this.edgesLabels_ = labels.split(System.getProperty("line.separator"));
        }
    }

    public void setEdgeWidth(int width) {
        this.edgeWidth_ = width;
    }

    public void setLayerName(String name) {
        this.layerName_ = name;
    }

    public void setVerticesAndEdgesMapValues(MascoptMap m) {
        this.verticesAndEdgesMapValues_ = m;
    }

    public void setVerticesAndEdgesContextValues(MascoptObject context) {
        this.verticesAndEdgesContextValues_ = context;
    }

    public void setMapToListen(MascoptMap map) {
        map.addValueObserver(this);
    }

    @Override
    public void update(MascoptObservableObject o, Notification nr) {
        String valueName;
        Object[] objs = nr.getObjects();
        MascoptObservableObject.MascoptEventType message = nr.getEventType();
        if (message == MascoptObservableObject.MascoptEventType.VALUE_CHANGE && (valueName = (String)objs[1]).equalsIgnoreCase("color")) {
            MascoptObject toColor = (MascoptObject)objs[0];
            String color = ((MascoptMap)o).getString(toColor, (String)objs[1], (MascoptObject)objs[0]);
            int colorValue = Integer.parseInt(color);
            if (toColor instanceof MascoptAbstractLink || toColor instanceof MascoptVertex) {
                toColor.setColor(colorValue);
            } else if (toColor instanceof MascoptAbstractPath) {
                MascoptAbstractPath p;
                Iterator edgeIt = p.edgeIterator((p = (MascoptAbstractPath)toColor).isDirected() ? p.getFirstVertex() : p.getEnds()[0]);
                while (edgeIt.hasNext()) {
                    MascoptAbstractLink currentEdge = (MascoptAbstractLink)edgeIt.next();
                    currentEdge.setColor(colorValue);
                }
            }
        }
    }

    @Override
    public void update(Observable o, Object m) {
        if (m instanceof StepAlgo.StepAlgoMessage) {
            StepAlgo.StepAlgoMessage message = (StepAlgo.StepAlgoMessage)m;
            switch (message.getType()) {
                case PAUSE_NOTIFICATION: {
                    this.saveWindowsToImage();
                    ++this.realStep_;
                    this.currentDisplayedStep_ = this.realStep_;
                    break;
                }
                case END_NOTIFICATION: {
                    this.stopResume_.setEnabled(false);
                    this.step_.setEnabled(false);
                    this.prev_.setEnabled(true);
                    break;
                }
                case DISPLAY_GRAPH_NEW_WINDOW: {
                    MascoptAbstractGraph graphToDisplay = (MascoptAbstractGraph)message.getMessageArgs()[0];
                    Point center = this.computeMiddle(graphToDisplay);
                    GView newView = this.layerManager_.newView((String)message.getMessageArgs()[1], center.x, center.y, 1.0);
                    GLayer newLayer = this.layerManager_.newLayer("");
                    this.configurations_.add(new WindowsConfiguration(graphToDisplay, newView, newLayer));
                    this.layerManager_.addLayerInView(newLayer, newView);
                    this.layerManager_.addGraph(graphToDisplay);
                    try {
                        this.layerManager_.setVisibleGraphInLayer(graphToDisplay, newLayer, true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.layerManager_.setGraphLinkWidth(graphToDisplay, newLayer, this.edgeWidth_);
                    JFrame jfView = new JFrame(newView.getName());
                    JPanel jpM = new JPanel();
                    jpM.setLayout(new BorderLayout());
                    jpM.add((Component)newView, "Center");
                    jfView.getContentPane().add(jpM);
                    jfView.pack();
                    jfView.setLocation(0, 0);
                    jfView.setVisible(true);
                    break;
                }
                case EDGES_LABEL: {
                    WindowsConfiguration conf = this.getConfigurationFromGraph((MascoptAbstractGraph)message.getMessageArgs()[0]);
                    if (conf == null) {
                        System.err.println("Warning : Receive a graphic request on an unknow graph");
                        return;
                    }
                    GLayer layer = conf.getLayer();
                    this.layerManager_.setGraphLayerMapValues((MascoptObject)message.getMessageArgs()[0], layer, (MascoptMap)message.getMessageArgs()[1]);
                    this.layerManager_.setGraphLayerContextValues((MascoptObject)message.getMessageArgs()[0], layer, (MascoptObject)message.getMessageArgs()[2]);
                    this.layerManager_.setEdgeLabelGraphInLayer((MascoptObject)message.getMessageArgs()[0], layer, (String[])message.getMessageArgs()[3]);
                    this.layerManager_.setLayerUpdateLabelsWhenValuesChange(layer, true);
                    break;
                }
                case VERTICES_LABEL: {
                    WindowsConfiguration conf = this.getConfigurationFromGraph((MascoptAbstractGraph)message.getMessageArgs()[0]);
                    if (conf == null) {
                        System.err.println("Warning : Receive a graphic request on an unknow graph");
                        return;
                    }
                    GLayer layer = conf.getLayer();
                    this.layerManager_.setGraphLayerMapValues((MascoptObject)message.getMessageArgs()[0], layer, (MascoptMap)message.getMessageArgs()[1]);
                    this.layerManager_.setGraphLayerContextValues((MascoptObject)message.getMessageArgs()[0], layer, (MascoptObject)message.getMessageArgs()[2]);
                    this.layerManager_.setVertexLabelGraphInLayer((MascoptObject)message.getMessageArgs()[0], layer, (String[])message.getMessageArgs()[1]);
                    this.layerManager_.setLayerUpdateLabelsWhenValuesChange(layer, true);
                    break;
                }
                default: {
                    System.err.println("Warning : Receive an unknow notification message");
                }
            }
        }
    }

    void killGui() {
        int i = 0;
        while (i < this.realStep_) {
            int j = 0;
            while (j < this.configurations_.size()) {
                File current = new File(String.valueOf(this.prefix_) + i + "-" + j + ".png");
                current.delete();
                ++j;
            }
            ++i;
        }
    }

    private class WindowsConfiguration {
        private MascoptObject graph_;
        private GView view_;
        private GLayer layer_;

        public WindowsConfiguration(MascoptObject graph, GView view, GLayer layer) {
            this.graph_ = graph;
            this.view_ = view;
            this.layer_ = layer;
        }

        public MascoptObject getGraph() {
            return this.graph_;
        }

        public GView getView() {
            return this.view_;
        }

        public GLayer getLayer() {
            return this.layer_;
        }
    }
}

