/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.gui.valuesChooser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptSet;
import mascoptLib.core.MascoptVertex;

public class ValuesChooser
extends JPanel {
    private static final long serialVersionUID = -8733829638195574721L;
    private Vector<ValuesChooserEntry> entry = new Vector();
    private JButton cancelButton;
    private JButton okButton;
    private JFrame window = null;
    private boolean userChoose;
    private ReentrantLock lock = new ReentrantLock();
    private Condition condVar = this.lock.newCondition();
    private int nbLine = 1;

    public ValuesChooser(boolean createWindow) {
        if (createWindow) {
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.window = new JFrame("Values Chooser");
            this.window.getContentPane().setLayout(new GridBagLayout());
            c.fill = 1;
            c.gridwidth = 0;
            c.gridheight = 0;
            JPanel jpValuesChooser = new JPanel();
            jpValuesChooser.setLayout(new GridBagLayout());
            c.fill = 1;
            c.gridwidth = 0;
            c.gridheight = 0;
            jpValuesChooser.add((Component)this, c);
            this.window.getContentPane().add((Component)jpValuesChooser, c);
            this.window.setDefaultCloseOperation(3);
        }
    }

    public ValuesChooserEntry addEntry(String label, MascoptMap m, MascoptSet elements, ValuesChooserEntryType type) {
        ValuesChooserEntry newEntry = new ValuesChooserEntry(label, m, elements, type);
        this.entry.add(newEntry);
        return newEntry;
    }

    public boolean choose() {
        this.setLayout(new GridBagLayout());
        this.addFirstLabel();
        Iterator<ValuesChooserEntry> it = this.entry.iterator();
        while (it.hasNext()) {
            this.addEntryLine(it.next());
        }
        ++this.nbLine;
        this.addOkAndCancelButton();
        if (this.window != null) {
            this.window.pack();
            this.window.setLocationRelativeTo(this.window.getParent());
            this.window.setVisible(true);
        }
        this.lock.lock();
        try {
            try {
                this.condVar.await();
            }
            catch (InterruptedException e1) {
                this.lock.unlock();
                if (this.window != null) {
                    this.window.dispose();
                }
                return false;
            }
        }
        finally {
            this.lock.unlock();
            if (this.window != null) {
                this.window.dispose();
            }
        }
        return this.userChoose;
    }

    private void addFirstLabel() {
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.fill = 2;
        labelConstraints.gridx = 1;
        labelConstraints.gridy = 0;
        labelConstraints.weightx = 1.0;
        labelConstraints.gridwidth = 4;
        labelConstraints.insets = new Insets(5, 5, 5, 5);
        JLabel label = new JLabel();
        label.setText("Choose values");
        label.setHorizontalAlignment(0);
        this.add((Component)label, labelConstraints);
        GridBagConstraints separatorConstraints = new GridBagConstraints();
        separatorConstraints.fill = 2;
        separatorConstraints.gridx = 0;
        separatorConstraints.gridy = 1;
        separatorConstraints.weightx = 1.0;
        separatorConstraints.gridwidth = 6;
        separatorConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)new JSeparator(), separatorConstraints);
        GridBagConstraints contextConstraints = new GridBagConstraints();
        contextConstraints.fill = 2;
        contextConstraints.gridx = 2;
        contextConstraints.gridy = 2;
        contextConstraints.insets = new Insets(5, 5, 5, 5);
        contextConstraints.weightx = 1.0;
        contextConstraints.gridwidth = 2;
        this.add((Component)new JLabel("Context"), contextConstraints);
        GridBagConstraints nameConstraints = new GridBagConstraints();
        nameConstraints.fill = 2;
        nameConstraints.gridx = 4;
        nameConstraints.gridy = 2;
        nameConstraints.insets = new Insets(5, 5, 5, 5);
        nameConstraints.weightx = 1.0;
        nameConstraints.gridwidth = 2;
        this.add((Component)new JLabel("Name"), nameConstraints);
    }

    private void addEntryLine(ValuesChooserEntry e) {
        ++this.nbLine;
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.fill = 2;
        labelConstraints.gridx = 0;
        labelConstraints.gridy = this.nbLine + 1;
        labelConstraints.insets = new Insets(5, 5, 5, 5);
        labelConstraints.weightx = 1.0;
        labelConstraints.gridwidth = 2;
        JLabel label = new JLabel();
        label.setText(e.getLabel());
        this.add((Component)label, labelConstraints);
        GridBagConstraints contextConstraints = new GridBagConstraints();
        contextConstraints.fill = 2;
        contextConstraints.gridx = 2;
        contextConstraints.gridy = this.nbLine + 1;
        contextConstraints.insets = new Insets(5, 5, 5, 5);
        contextConstraints.weightx = 1.0;
        contextConstraints.gridwidth = 2;
        this.add((Component)e.getContextComboBoxEntry(), contextConstraints);
        GridBagConstraints nameConstraints = new GridBagConstraints();
        nameConstraints.fill = 2;
        nameConstraints.gridx = 4;
        nameConstraints.gridy = this.nbLine + 1;
        nameConstraints.insets = new Insets(5, 5, 5, 5);
        nameConstraints.weightx = 1.0;
        nameConstraints.gridwidth = 2;
        this.add((Component)e.getNamesComboBoxEntry(), nameConstraints);
    }

    private void addOkAndCancelButton() {
        GridBagConstraints okConstraints = new GridBagConstraints();
        okConstraints.fill = 0;
        okConstraints.gridx = 1;
        okConstraints.gridy = this.nbLine + 1;
        okConstraints.weightx = 1.0;
        okConstraints.gridwidth = 1;
        okConstraints.anchor = 15;
        this.okButton = new JButton();
        this.okButton.setText("Ok");
        this.okButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ValuesChooser.this.userChoose = true;
                ValuesChooser.this.lock.lock();
                ValuesChooser.this.condVar.signal();
                ValuesChooser.this.lock.unlock();
            }
        });
        this.add((Component)this.okButton, okConstraints);
        GridBagConstraints cancelConstraints = new GridBagConstraints();
        cancelConstraints.fill = 0;
        cancelConstraints.gridx = 4;
        cancelConstraints.gridy = this.nbLine + 1;
        cancelConstraints.weightx = 1.0;
        cancelConstraints.gridwidth = 1;
        cancelConstraints.anchor = 15;
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ValuesChooser.this.userChoose = false;
                ValuesChooser.this.lock.lock();
                ValuesChooser.this.condVar.signal();
                ValuesChooser.this.lock.unlock();
            }
        });
        this.add((Component)this.cancelButton, cancelConstraints);
    }

    public class ValuesChooserEntry {
        private String label_;
        private MascoptMap map_;
        private MascoptSet elements_;
        private MascoptObject context_;
        private String name_;
        private ValuesChooserEntryType type_;
        private HashMap<String, MascoptObject> idToContextMap_ = new HashMap();
        private HashMap<MascoptObject, HashSet<String>> contextToNamesSet_ = new HashMap();
        private JComboBox contextComboBox_ = null;
        private JComboBox namesComboBox_ = null;

        ValuesChooserEntry(String label, MascoptMap m, MascoptSet elements, ValuesChooserEntryType type) {
            this.label_ = label;
            this.map_ = m;
            this.elements_ = elements;
            this.type_ = type;
            this.fillContextAndNamesHashMap();
        }

        private String getLabel() {
            return this.label_;
        }

        public MascoptObject getContext() {
            return this.context_;
        }

        private void fillContextAndNamesHashMap() {
            Iterator<? extends MascoptObject> keyIt = this.map_.keysIterator();
            while (keyIt.hasNext()) {
                MascoptObject currentKey = keyIt.next();
                if (!this.elements_.contains(currentKey) || this.type_ != ValuesChooserEntryType.ANY_TYPE && (this.type_ == ValuesChooserEntryType.VERTEX_TYPE && !(currentKey instanceof MascoptVertex) || this.type_ == ValuesChooserEntryType.EDGES_TYPE && !(currentKey instanceof MascoptAbstractLink))) continue;
                Iterator<? extends MascoptObject> contextIt = this.map_.contextsIterator(currentKey);
                while (contextIt.hasNext()) {
                    MascoptObject currentContext = contextIt.next();
                    if (this.idToContextMap_.containsKey(currentContext.getId())) continue;
                    Iterator<String> namesIt = this.map_.namesIterator(currentKey, currentContext);
                    HashSet<String> currentNameSet = new HashSet<String>();
                    while (namesIt.hasNext()) {
                        String currentName = namesIt.next();
                        if (!MascoptMap.isDefined(this.map_, this.elements_, currentName, currentContext == currentKey ? null : currentContext)) continue;
                        this.idToContextMap_.put(currentKey != currentContext ? currentContext.getId() : "No Context", currentKey != currentContext ? currentContext : null);
                        this.contextToNamesSet_.put(currentContext == currentKey ? null : currentContext, currentNameSet);
                        currentNameSet.add(currentName);
                    }
                }
            }
        }

        private void updateSelection() {
            String selection = (String)this.getContextComboBoxEntry().getSelectedItem();
            if (selection == null) {
                return;
            }
            this.context_ = this.idToContextMap_.get(selection);
            this.getNamesComboBoxEntry().removeAllItems();
            Iterator<String> namesIt = this.contextToNamesSet_.get(this.context_).iterator();
            while (namesIt.hasNext()) {
                this.getNamesComboBoxEntry().addItem(namesIt.next());
            }
            this.getNamesComboBoxEntry().setSelectedIndex(0);
            this.name_ = (String)this.getNamesComboBoxEntry().getSelectedItem();
        }

        private JComboBox getContextComboBoxEntry() {
            if (this.contextComboBox_ == null) {
                this.contextComboBox_ = new JComboBox();
                Iterator<String> contextNameIt = this.idToContextMap_.keySet().iterator();
                while (contextNameIt.hasNext()) {
                    this.contextComboBox_.addItem(contextNameIt.next());
                }
                this.updateSelection();
                this.contextComboBox_.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ValuesChooserEntry.this.updateSelection();
                    }
                });
            }
            return this.contextComboBox_;
        }

        private JComboBox getNamesComboBoxEntry() {
            if (this.namesComboBox_ == null) {
                this.namesComboBox_ = new JComboBox();
                this.namesComboBox_.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String selection = (String)ValuesChooserEntry.this.namesComboBox_.getSelectedItem();
                        if (selection == null) {
                            return;
                        }
                        ValuesChooserEntry.this.name_ = (String)ValuesChooserEntry.this.namesComboBox_.getSelectedItem();
                    }
                });
            }
            return this.namesComboBox_;
        }

        public String getName() {
            return this.name_;
        }
    }

    public static enum ValuesChooserEntryType {
        ANY_TYPE,
        VERTEX_TYPE,
        EDGES_TYPE;

    }
}

