/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.reader.snd.natives;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import mascoptLib.core.MascoptAbstractCycle;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptAbstractPath;
import mascoptLib.core.MascoptArcSet;
import mascoptLib.core.MascoptEdgeSet;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;
import mascoptLib.core.flows.MascoptFlow;
import mascoptLib.io.interfaces.Reader;
import mascoptLib.numeric.MascoptAbstractScalar;
import mascoptLib.numeric.MascoptDouble;
import mascoptLib.numeric.MascoptInteger;

public class SNDNetworkNativeReader
implements Reader {
    public static final String PREINSTALLED_CAP = "PREINSTALLED_CAP";
    public static final String PREINSTALLED_COST = "PREINSTALLED_COST";
    public static final String ROUTING_COST = "ROUTING_COST";
    public static final String SETUP_COST = "SETUP_COST";
    public static final String CAPACITY_COST_LIST = "CAPACITY_COST_LIST";
    public static final String MAX_PATH_LENGTH = "MAX_PATH_LENGTH";
    private static final String UNLIMITED = "UNLIMITED";
    private static final String NODES_KEYWORD = "NODES";
    private static final String LINKS_KEYWORD = "LINKS";
    private static final String DEMANDS_KEYWORD = "DEMANDS";
    public static final int UNDIRECTED_LINK = 0;
    public static final int BIDIRECTED_LINK = 1;
    public static final int DIRECTED_LINK = 2;
    public static final int UNDIRECTED_DEMANDS = 0;
    public static final int DIRECTED_DEMANDS = 1;
    public static final int SYMETRIC_DEMANDS = 2;
    private Vector<MascoptVertex> vertices = new Vector();
    private Vector<MascoptAbstractLink> edges = new Vector();
    private Vector<MascoptVertexSet> vertexSets = new Vector();
    private Vector<MascoptAbstractLinkSet<? extends MascoptAbstractLink>> edgeSets = new Vector();
    private Vector<MascoptAbstractPath<? extends MascoptAbstractLink>> paths = new Vector();
    private Vector<MascoptAbstractGraph<? extends MascoptAbstractLink>> graphs = new Vector();
    private Vector<MascoptMap> maps = new Vector();
    private MascoptMap map = new MascoptMap();
    private HashMap<String, MascoptVertex> nameToVertex;
    private int numLine = 0;
    private BufferedReader reader;
    private final int linksType;
    private final int demandsType;

    public static void getCapacityCostVector(MascoptAbstractLink e, MascoptMap m, Vector<MascoptAbstractScalar> capacityVector, Vector<MascoptAbstractScalar> costVector) {
        String list = m.getString(e, CAPACITY_COST_LIST);
        if (list.trim().length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(list, " ");
        while (st.hasMoreTokens()) {
            String cap = st.nextToken();
            String cost = st.nextToken();
            if (cap.equalsIgnoreCase(UNLIMITED)) {
                capacityVector.add(new MascoptInteger(-1));
            } else {
                capacityVector.add(new MascoptInteger(cap));
            }
            costVector.add(new MascoptInteger(cost));
        }
    }

    public SNDNetworkNativeReader(String fileName, int linksType, int demandsType) throws FileNotFoundException, SecurityException {
        this.maps.add(this.map);
        this.nameToVertex = new HashMap();
        this.linksType = linksType;
        this.demandsType = demandsType;
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
    }

    public SNDNetworkNativeReader(String fileName) throws FileNotFoundException, SecurityException {
        this(fileName, 1, 1);
    }

    private void readNodes() throws IOException {
        String line;
        MascoptVertexSet newVertexSet = new MascoptVertexSet();
        this.vertexSets.add(newVertexSet);
        while ((line = this.reader.readLine()) != null) {
            if (line.trim().length() == 0) {
                ++this.numLine;
                continue;
            }
            if (line.trim().equals(")")) {
                return;
            }
            StringTokenizer st = new StringTokenizer(line, "() \t");
            String nodeName = st.nextToken();
            String xCoord = st.nextToken();
            String yCoord = st.nextToken();
            try {
                MascoptVertex newVertex = new MascoptVertex(Double.parseDouble(xCoord) * 10.0, Double.parseDouble(yCoord) * 10.0);
                newVertex.setName(nodeName);
                this.nameToVertex.put(nodeName, newVertex);
                newVertexSet.add(newVertex);
                this.vertices.add(newVertex);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(String.valueOf(e.getMessage()) + " at line " + this.numLine);
            }
            ++this.numLine;
        }
    }

    private void readLinks() throws IOException {
        String line;
        MascoptAbstractLinkSet newEdgeSet = this.linksType == 0 ? new MascoptEdgeSet(this.vertexSets.get(0)) : new MascoptArcSet(this.vertexSets.get(0));
        this.edgeSets.add(newEdgeSet);
        while ((line = this.reader.readLine()) != null) {
            if (line.trim().length() == 0) {
                ++this.numLine;
                continue;
            }
            if (line.trim().equals(")")) {
                return;
            }
            StringTokenizer st = new StringTokenizer(line, "() \t");
            String linkName = st.nextToken();
            String sourceName = st.nextToken().intern();
            String destinationName = st.nextToken().intern();
            String preCap = st.nextToken();
            String preCost = st.nextToken();
            String costList = "";
            while (st.hasMoreTokens()) {
                costList = String.valueOf(costList) + st.nextToken() + " ";
            }
            MascoptVertex source = this.nameToVertex.get(sourceName);
            MascoptVertex destination = this.nameToVertex.get(destinationName);
            Object newEdge = newEdgeSet.getFactory().getLinkSetFactory().newLink(source, destination);
            ((MascoptObject)newEdge).setName(linkName);
            newEdgeSet.add(newEdge);
            this.edges.add((MascoptAbstractLink)newEdge);
            this.map.putValue(newEdge, PREINSTALLED_CAP, new MascoptDouble(preCap));
            this.map.putValue(newEdge, PREINSTALLED_COST, new MascoptDouble(preCost));
            this.map.putString(newEdge, CAPACITY_COST_LIST, costList);
            if (this.linksType == 1) {
                newEdge = newEdgeSet.getFactory().getLinkSetFactory().newLink(destination, source);
                ((MascoptObject)newEdge).setName(linkName);
                newEdgeSet.add(newEdge);
                this.edges.add((MascoptAbstractLink)newEdge);
                this.map.putValue(newEdge, PREINSTALLED_CAP, new MascoptDouble(preCap));
                this.map.putValue(newEdge, PREINSTALLED_COST, new MascoptDouble(preCost));
                this.map.putString(newEdge, CAPACITY_COST_LIST, costList);
            }
            ++this.numLine;
        }
    }

    private <E extends MascoptAbstractLink> void readDemands() throws IOException {
        String line;
        MascoptAbstractLinkSet newEdgeSet = this.demandsType == 0 ? new MascoptEdgeSet(this.vertexSets.get(0)) : new MascoptArcSet(this.vertexSets.get(0));
        this.edgeSets.add(newEdgeSet);
        while ((line = this.reader.readLine()) != null) {
            if (line.trim().length() == 0) {
                ++this.numLine;
                continue;
            }
            if (line.trim().equals(")")) {
                return;
            }
            StringTokenizer st = new StringTokenizer(line, "() \t");
            String linkName = st.nextToken();
            String sourceName = st.nextToken().intern();
            MascoptVertex source = this.nameToVertex.get(sourceName);
            String destinationName = st.nextToken().intern();
            MascoptVertex destination = this.nameToVertex.get(destinationName);
            Object newEdge = newEdgeSet.getFactory().getLinkSetFactory().newLink(source, destination);
            ((MascoptObject)newEdge).setName(linkName);
            newEdgeSet.add(newEdge);
            String routingUnit = st.nextToken();
            this.map.putValue(newEdge, "Routing Unit", new MascoptDouble(routingUnit));
            String requestSize = st.nextToken();
            this.map.putValue(newEdge, "Request Size", new MascoptDouble(requestSize));
            String pathLength = st.nextToken();
            if (pathLength.equalsIgnoreCase(UNLIMITED)) {
                this.map.putValue(newEdge, MAX_PATH_LENGTH, new MascoptInteger(Integer.MAX_VALUE));
            } else {
                this.map.putValue(newEdge, MAX_PATH_LENGTH, new MascoptInteger(pathLength));
            }
            ++this.numLine;
        }
    }

    @Override
    public void parse() {
        try {
            String sectionName;
            StringTokenizer st;
            String line = this.reader.readLine();
            if (line != null && !line.trim().equals("?SNDlib native format; type: network; version: 1.0".trim())) {
                throw new IOException("SND network native file exepted");
            }
            ++this.numLine;
            while ((line = this.reader.readLine()) != null) {
                if (line.trim().length() == 0 || line.trim().startsWith("#")) {
                    ++this.numLine;
                    continue;
                }
                st = new StringTokenizer(line, "() \t");
                sectionName = st.nextToken();
                if (sectionName.equals(NODES_KEYWORD)) {
                    this.readNodes();
                    break;
                }
                throw new IOException("Syntax error NODES expected at line " + this.numLine);
            }
            while ((line = this.reader.readLine()) != null) {
                if (line.trim().length() == 0 || line.trim().startsWith("#")) {
                    ++this.numLine;
                    continue;
                }
                st = new StringTokenizer(line, "() \t");
                sectionName = st.nextToken();
                if (sectionName.equals(LINKS_KEYWORD)) {
                    this.readLinks();
                    break;
                }
                throw new IOException("Syntax error LINKS expected at line " + this.numLine);
            }
            MascoptAbstractGraph<? extends MascoptAbstractLink> newGraph = this.edgeSets.get(0).getFactory().getGraphFactory().newGraph(this.edgeSets.get(0));
            newGraph.setName("Graph Cable");
            this.graphs.add(newGraph);
            while ((line = this.reader.readLine()) != null) {
                if (line.trim().length() == 0 || line.trim().startsWith("#")) {
                    ++this.numLine;
                    continue;
                }
                StringTokenizer st2 = new StringTokenizer(line, "() \t");
                String sectionName2 = st2.nextToken();
                if (sectionName2.equals(DEMANDS_KEYWORD)) {
                    this.readDemands();
                    break;
                }
                throw new IOException("Syntax error LINKS expected at line " + this.numLine);
            }
            newGraph = this.edgeSets.get(1).getFactory().getGraphFactory().newGraph(this.edgeSets.get(1));
            newGraph.setName("Graph Request");
            this.graphs.add(newGraph);
        }
        catch (IOException e) {
            System.err.println(e);
            return;
        }
    }

    @Override
    public Iterator<MascoptAbstractPath<? extends MascoptAbstractLink>> getPaths() {
        return this.paths.iterator();
    }

    public Iterator<MascoptAbstractLink> getEdges() {
        return this.edges.iterator();
    }

    @Override
    public Iterator<MascoptAbstractLinkSet<? extends MascoptAbstractLink>> getEdgeSets() {
        return this.edgeSets.iterator();
    }

    @Override
    public Iterator<MascoptAbstractGraph<? extends MascoptAbstractLink>> getGraphs() {
        return this.graphs.iterator();
    }

    @Override
    public Iterator<MascoptVertex> getVertices() {
        return this.vertices.iterator();
    }

    @Override
    public Iterator<MascoptAbstractCycle<? extends MascoptAbstractLink>> getCycles() {
        return new Vector().iterator();
    }

    @Override
    public Iterator<MascoptVertexSet> getVertexSets() {
        return this.vertexSets.iterator();
    }

    @Override
    public Iterator<MascoptMap> getMaps() {
        return this.maps.iterator();
    }

    @Override
    public Iterator<MascoptFlow> getFlows() {
        return new Vector().iterator();
    }

    @Override
    public Iterator<MascoptObject> getAllObjects() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

