/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.writer.fig;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import mascoptLib.core.MascoptAbstractGraph;
import mascoptLib.core.MascoptAbstractLink;
import mascoptLib.core.MascoptAbstractLinkSet;
import mascoptLib.core.MascoptArc;
import mascoptLib.core.MascoptMap;
import mascoptLib.core.MascoptObject;
import mascoptLib.core.MascoptSet;
import mascoptLib.core.MascoptVertex;
import mascoptLib.core.MascoptVertexSet;

public class FigWriter {
    private static final Vector<String> COLORSNAME = new Vector();
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final int CENTER = 0;
    public static final int FLUSH_LEFT = 1;
    public static final int NATIVE_COLOR = 0;
    public static final int UNIFIED_COLOR = 1;
    public static final int StickArrowType = 0;
    public static final int ClosedTriangleArrowType = 1;
    public static final int IndentedButtArrowType = 2;
    public static final int ClosedWithPointedButtArrowType = 3;
    private String fileName_;
    private MascoptMap verticesLabelsMap_;
    private MascoptMap edgesLabelsMap_;
    private int userColorNumber_ = 32;
    private TreeMap<Integer, Integer> userColorMap_ = new TreeMap();
    private String orientation_ = "Landscape";
    private String justification_ = "Center";
    private float magnification_ = 100.0f;
    private int verticesRadiusLength_ = 40;
    private int verticesLineStyle_ = 0;
    private int verticesLineThickness_ = 1;
    private int verticesColorMode_ = 1;
    private int verticesUnifiedColor_ = 0;
    private int verticesFillType_ = 20;
    private int edgesLineStyle_ = 0;
    private int edgesLineThickness_ = 1;
    private int edgesColorMode_ = 1;
    private int edgesUnifiedColor_ = 0;
    private int shift_ = 20;
    private int arrowType_ = 3;
    private int arrowStyle_ = 1;
    private float arrowThickness_ = 0.5f;
    private float arrowWidth_ = 40.0f;
    private float arrowHeight_ = 80.0f;
    private String verticesLabels_ = null;
    private MascoptObject verticesLabelsContext_ = null;
    private String edgesLabels_ = null;
    private MascoptObject edgesLabelsContext_ = null;
    private int textJustification_ = 0;
    private int textColor_ = 0;
    private int textFont_ = 0;
    private float textSize_ = 16.0f;
    private int fontFlags_ = 0;
    private Vector<MascoptAbstractGraph<?>> graphsToGenerate_;

    static {
        String[] names = new String[]{"black", "blue", "green", "cyan", "red", "magenta", "yellow", "white"};
        int i = 0;
        while (i < names.length) {
            COLORSNAME.add(names[i]);
            ++i;
        }
    }

    public FigWriter(String name) {
        this.fileName_ = name;
        this.graphsToGenerate_ = new Vector();
    }

    public void add(MascoptAbstractGraph<?> graph) {
        this.graphsToGenerate_.add(graph);
    }

    private String resolveValues(MascoptObject mo, MascoptMap m, MascoptObject context, String code) {
        String resolved = "";
        String str = code;
        StringTokenizer st = new StringTokenizer(code, "$", false);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals(str)) {
                resolved = String.valueOf(resolved) + tok;
                continue;
            }
            if (tok.startsWith("(")) {
                int endIndex = tok.indexOf(41);
                if (endIndex == -1) {
                    resolved = String.valueOf(resolved) + tok;
                    continue;
                }
                String toResolve = tok.substring(1, endIndex);
                String value = null;
                if (toResolve.equals("name")) {
                    value = mo.getName();
                } else if (toResolve.equals("id")) {
                    value = mo.getId();
                } else if (m == null) {
                    value = "No Map";
                } else {
                    String type = m.getDataType(mo, toResolve, context == null ? mo : context);
                    if (type != null) {
                        if (type.equals("String")) {
                            value = "";
                            value = String.valueOf(value) + m.getString(mo, toResolve, context == null ? mo : context);
                        } else {
                            value = "";
                            value = String.valueOf(value) + m.getValue(mo, toResolve, context == null ? mo : context);
                        }
                    }
                }
                if (value == null) {
                    value = "??";
                }
                resolved = String.valueOf(resolved) + value;
                resolved = String.valueOf(resolved) + tok.substring(endIndex + 1);
                continue;
            }
            resolved = String.valueOf(resolved) + tok;
        }
        return resolved;
    }

    private void writeText(String label, int x, int y, MascoptObject mo, MascoptMap m, MascoptObject context, PrintStream output) {
        String labelText = this.resolveValues(mo, m, context, label);
        output.print("4 ");
        output.print(String.valueOf(this.textJustification_) + " ");
        output.print(String.valueOf(this.textColor_) + " ");
        output.print("50 ");
        output.print("-1 ");
        output.print(String.valueOf(this.textFont_) + " ");
        output.print(String.valueOf(this.textSize_) + " ");
        output.print("0.0 ");
        output.print(String.valueOf(this.fontFlags_) + " ");
        output.print(String.valueOf(this.textSize_) + " ");
        output.print(String.valueOf(this.textSize_ * (float)labelText.length()) + " ");
        output.print(String.valueOf(x) + " " + y + " ");
        output.print(labelText);
        output.println("\\001");
    }

    public void setOrientation(int orientation) {
        switch (orientation) {
            case 0: {
                this.orientation_ = "Portrait";
                break;
            }
            case 1: {
                this.orientation_ = "Landscape";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow orientation");
            }
        }
    }

    public void setJustification(int justification) {
        switch (justification) {
            case 0: {
                this.justification_ = "Center";
                break;
            }
            case 1: {
                this.justification_ = "Flush Left";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow justification");
            }
        }
    }

    public void setMagnification(float percentage) {
        this.magnification_ = percentage;
    }

    public void setVerticesColorMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Unknow mode");
        }
        this.verticesColorMode_ = mode;
    }

    public void setVerticesUnifiedColor(int color) {
        this.verticesUnifiedColor_ = this.createOrGetColor(color);
    }

    public void setVerticesUnifiedColor(String name) {
        if (COLORSNAME.indexOf(name.toLowerCase()) != -1) {
            this.verticesUnifiedColor_ = COLORSNAME.indexOf(name.toLowerCase());
        }
    }

    public void setVerticesFillMode(int fillMode) {
        if (fillMode < -1 || fillMode > 40) {
            throw new IllegalArgumentException("Value of fill mode is invalid");
        }
        this.verticesFillType_ = fillMode;
    }

    public void setVerticesLineThickness(int lineThickness) {
        if (lineThickness < 0) {
            throw new IllegalArgumentException("Line thickness must be positive");
        }
        this.verticesLineThickness_ = lineThickness;
    }

    public void setVerticesRadiusLength(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("vertices radius lenght must be positive");
        }
        this.verticesRadiusLength_ = length;
    }

    public void setEdgesColorMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Unknow mode");
        }
        this.edgesColorMode_ = mode;
    }

    public void setEdgesUnifiedColor(int color) {
        this.edgesUnifiedColor_ = this.createOrGetColor(color);
    }

    public void setEdgesUnifiedColor(String name) {
        if (COLORSNAME.indexOf(name.toLowerCase()) != -1) {
            this.edgesUnifiedColor_ = COLORSNAME.indexOf(name.toLowerCase());
        }
    }

    public void setEdgesLineThickness(int lineThickness) {
        if (lineThickness < 0) {
            throw new IllegalArgumentException("Line thickness must be positive");
        }
        this.edgesLineThickness_ = lineThickness;
    }

    public void setArrowType(int type) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("Unknow arrow type");
        }
        this.arrowType_ = type;
        if (this.arrowType_ == 0) {
            this.arrowStyle_ = 0;
        }
    }

    public void setArrowWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Width of arrows must be positive");
        }
        this.arrowWidth_ = width;
    }

    public void setArrowHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("Height of arrows must be positive");
        }
        this.arrowHeight_ = height;
    }

    public void setArrowFill(boolean filled) {
        this.arrowStyle_ = filled && this.arrowType_ != 0 ? 1 : 0;
    }

    public void setLabelFontSize(float size) {
        this.textSize_ = size;
    }

    public void setVerticesLabels(String label) {
        this.verticesLabels_ = label;
    }

    public void setEdgesLabels(String label) {
        this.edgesLabels_ = label;
    }

    public void setVerticesLabelsMap(MascoptMap m) {
        this.verticesLabelsMap_ = m;
    }

    public void setEdgesLabelsMap(MascoptMap m) {
        this.edgesLabelsMap_ = m;
    }

    public void setVerticesLabelsContext(MascoptObject context) {
        this.verticesLabelsContext_ = context;
    }

    public void setEdgesLabelsContext(MascoptObject context) {
        this.edgesLabelsContext_ = context;
    }

    public void setLabelsColor(int color) {
        this.textColor_ = this.createOrGetColor(color);
    }

    public void setLabelsColor(String color) {
        if (COLORSNAME.indexOf(color.toLowerCase()) != -1) {
            this.textColor_ = COLORSNAME.indexOf(color.toLowerCase());
            return;
        }
        System.err.println("FigWriter Warning : the color " + color + " is unknow");
    }

    private void writeEdgeSet(MascoptAbstractLinkSet<?> edgeSet, PrintStream output) {
        for (MascoptAbstractLink current : edgeSet) {
            int endPointY;
            int endPointX;
            int startPointY;
            int startPointX;
            output.print("3 2 ");
            output.print(String.valueOf(this.edgesLineStyle_) + " ");
            output.print(String.valueOf(this.edgesLineThickness_) + " ");
            if (this.edgesColorMode_ == 0) {
                output.print(String.valueOf(this.createOrGetColor(current.getColor())) + " ");
            } else {
                output.print(String.valueOf(this.edgesUnifiedColor_) + " ");
            }
            output.print("7 ");
            output.print("50 -1 -1 0.000 ");
            output.print("0 ");
            if (current instanceof MascoptArc) {
                output.println("1 0 3 ");
                output.print(String.valueOf(this.arrowType_) + " ");
                output.print(String.valueOf(this.arrowStyle_) + " ");
                output.print(String.valueOf(this.arrowThickness_) + " ");
                output.print(String.valueOf(this.arrowWidth_) + " ");
                output.println(String.valueOf(this.arrowHeight_) + " ");
            } else {
                output.println("0 0 3 ");
            }
            MascoptVertex[] ends = current.getVertices();
            double X = ends[1].getX() * 10.0 - ends[0].getX() * 10.0;
            double Y = ends[1].getY() * 10.0 - ends[0].getY() * 10.0;
            double distance = Math.sqrt(X * X + Y * Y);
            if (ends[0] == ends[1]) continue;
            if (current instanceof MascoptArc) {
                MascoptVertex tail = ((MascoptArc)current).getTail();
                MascoptVertex head = ((MascoptArc)current).getHead();
                startPointX = (int)tail.getX();
                startPointY = (int)tail.getY();
                endPointX = (int)head.getX();
                endPointY = (int)head.getY();
                endPointX *= 10;
                endPointY *= 10;
                startPointX *= 10;
                startPointY *= 10;
            } else {
                startPointX = (int)ends[0].getX();
                startPointY = (int)ends[0].getY();
                endPointX = (int)ends[1].getX();
                endPointY = (int)ends[1].getY();
                endPointX *= 10;
                endPointY *= 10;
                startPointX *= 10;
                startPointY *= 10;
            }
            if (startPointX < endPointX) {
                if (startPointY < endPointY) {
                    startPointY += this.verticesRadiusLength_;
                    endPointX -= this.verticesRadiusLength_;
                } else {
                    startPointX += this.verticesRadiusLength_;
                    endPointY += this.verticesRadiusLength_;
                }
            } else if (startPointY < endPointY) {
                startPointX -= this.verticesRadiusLength_;
                endPointY -= this.verticesRadiusLength_;
            } else {
                startPointY -= this.verticesRadiusLength_;
                endPointX += this.verticesRadiusLength_;
            }
            double dx = -((int)Math.floor((double)this.shift_ * Y / distance));
            double dy = (int)Math.floor((double)this.shift_ * X / distance);
            double controlPointX = (double)startPointX + dx * 2.0 + (double)Math.round(X / 2.0);
            double controlPointY = (double)startPointY + dy * 2.0 + (double)Math.round(Y / 2.0);
            output.println(String.valueOf(startPointX) + " " + startPointY + " " + (int)controlPointX + " " + (int)controlPointY + " " + endPointX + " " + endPointY);
            output.println(" 0.0 -1.0 0.0");
            if (this.edgesLabels_ == null) continue;
            this.writeText(this.edgesLabels_, (endPointX + 3 * startPointX) / 4, (endPointY + 3 * startPointY) / 4, current, this.edgesLabelsMap_, this.edgesLabelsContext_, output);
        }
    }

    private void writeVertexSet(MascoptVertexSet vertexSet, PrintStream output) {
        for (MascoptVertex current : vertexSet) {
            output.print("1 3 ");
            output.print(String.valueOf(this.verticesLineStyle_) + " ");
            output.print(String.valueOf(this.verticesLineThickness_) + " ");
            if (this.verticesColorMode_ == 0) {
                output.print(String.valueOf(this.createOrGetColor(current.getColor())) + " ");
                output.print(String.valueOf(this.createOrGetColor(current.getColor())) + " ");
            } else {
                output.print(String.valueOf(this.verticesUnifiedColor_) + " ");
                output.print(String.valueOf(this.verticesUnifiedColor_) + " ");
            }
            output.print("50 -1 ");
            output.print(String.valueOf(this.verticesFillType_) + " ");
            output.print("0.000 1 0.0000 ");
            output.println(String.valueOf((int)current.getX() * 10) + " " + (int)current.getY() * 10 + " " + " " + this.verticesRadiusLength_ + " " + this.verticesRadiusLength_ + " " + (int)current.getX() * 10 + " " + (int)current.getY() * 10 + " " + ((int)current.getX() * 10 + this.verticesRadiusLength_) + " " + (int)current.getY() * 10);
            if (this.verticesLabels_ == null) continue;
            this.writeText(this.verticesLabels_, (int)current.getX() * 10, (int)current.getY() * 10 - (this.verticesRadiusLength_ + 10), current, this.verticesLabelsMap_, this.verticesLabelsContext_, output);
        }
    }

    private void writeUserColors(TreeMap<Integer, Integer> colors, PrintStream output) {
        for (Integer rgbValue : colors.keySet()) {
            Integer colorNumber = colors.get(rgbValue);
            output.print("0 ");
            output.print(String.valueOf(colorNumber) + " #");
            String hexColor = "000000" + Integer.toHexString(rgbValue & 0xFFFFFF);
            output.println(hexColor.substring(hexColor.length() - 6, hexColor.length()));
        }
    }

    private int createOrGetColor(int color) {
        Integer colorNumber = this.userColorMap_.get(new Integer(color));
        if (colorNumber != null) {
            return colorNumber;
        }
        colorNumber = new Integer(this.userColorNumber_++);
        this.userColorMap_.put(new Integer(color), colorNumber);
        return colorNumber;
    }

    private void createSetColor(MascoptSet<? extends MascoptObject> set) {
        for (MascoptObject mascoptObject : set) {
            this.createOrGetColor(mascoptObject.getColor());
        }
    }

    private void fillUserColorMap() {
        for (MascoptAbstractGraph<?> currentGraph : this.graphsToGenerate_) {
            if (this.edgesColorMode_ == 0) {
                this.createSetColor((MascoptSet<? extends MascoptObject>)currentGraph.edgeSet());
            }
            if (this.verticesColorMode_ != 0) continue;
            this.createSetColor(currentGraph.vertexSet());
        }
    }

    public void write() throws FileNotFoundException, SecurityException {
        PrintStream ps = null;
        ps = new PrintStream(new FileOutputStream(this.fileName_));
        ps.println("#FIG 3.2");
        ps.println(this.orientation_);
        ps.println(this.justification_);
        ps.println("Metric");
        ps.println("A4");
        ps.println(this.magnification_);
        ps.println("Single");
        ps.println(-1);
        ps.println("1200 2");
        this.fillUserColorMap();
        this.writeUserColors(this.userColorMap_, ps);
        for (MascoptAbstractGraph<?> currentGraph : this.graphsToGenerate_) {
            this.writeVertexSet(currentGraph.vertexSet(), ps);
            this.writeEdgeSet((MascoptAbstractLinkSet<?>)currentGraph.edgeSet(), ps);
        }
    }
}

