/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.io.writer.mgl.dom;

import com.sun.org.apache.xerces.internal.dom.DOMImplementationImpl;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import mascoptLib.core.MascoptObject;
import mascoptLib.io.interfaces.Writer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class MGLWriter
implements Writer {
    private Document document;
    protected OutputStream os;
    public static String rootElementForXMLFile = "OBJECTS";
    public String SYSTEM = "SYSTEM";
    public static final String DTD = "ftp://ftp-sop.inria.fr/mascotte/mascopt/dtd/mgl_v2.0.dtd";
    public static final String W3CSchemaAttr = "xmlns:xsi";
    public static final String W3CSchema = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String MGLSchemaAttr = "xsi:noNamespaceSchemaLocation";
    public static final String MGLSchema = "ftp://ftp-sop.inria.fr/mascotte/mascopt/dtd/mgl_v2.0.xsd";
    public static String relaxNGVersionAttribute = "version";

    public MGLWriter(String file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public MGLWriter(OutputStream os) {
        this.os = os;
        DOMImplementation dom_impl = DOMImplementationImpl.getDOMImplementation();
        DocumentType docType = dom_impl.createDocumentType(rootElementForXMLFile, this.SYSTEM, DTD);
        this.document = dom_impl.createDocument(null, rootElementForXMLFile, docType);
        Element node = (Element)this.document.getElementsByTagName(rootElementForXMLFile).item(0);
        node.setAttribute(W3CSchemaAttr, W3CSchema);
        node.setAttribute(MGLSchemaAttr, MGLSchema);
    }

    @Override
    public void add(MascoptObject object) {
        object.toDOMTree(this.document.getDocumentElement());
    }

    @Override
    public void write() {
        OutputFormat format = new OutputFormat(this.document);
        format.setLineWidth(80);
        format.setIndenting(true);
        format.setIndent(2);
        format.setEncoding("ISO-8859-1");
        XMLSerializer serializer = new XMLSerializer(this.os, format);
        try {
            serializer.serialize(this.document);
        }
        catch (IOException e) {
            System.out.println("Error when serializing into the file." + e);
        }
    }
}

