/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.lpSolver.Impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mascoptLib.lpSolver.Impl.LpExprImpl;
import mascoptLib.lpSolver.Impl.LpLinearExprImpl;
import mascoptLib.lpSolver.exception.LpException;
import mascoptLib.lpSolver.interfaces.LpContinuousVariable;

public class LpContinuousVariableImpl
extends LpLinearExprImpl
implements LpContinuousVariable {
    private static final String NAME_PREFIX = "ContVar";
    private static long nameGenerator_ = 0L;
    private HashMap<LpExprImpl, LpExprImpl.LpTermImpl> belongTo_ = new HashMap();
    private double lowerBound_;
    private double upperBound_;
    private int index_ = -1;
    private final String name_;

    public LpContinuousVariableImpl(double lowerBound, double upperBound) {
        this(lowerBound, upperBound, NAME_PREFIX + nameGenerator_++);
    }

    public LpContinuousVariableImpl(double lowerBound, double upperBound, String name) {
        this.lowerBound_ = lowerBound;
        this.upperBound_ = upperBound;
        this.name_ = name;
    }

    public LpExprImpl.LpTermImpl getRef(LpExprImpl expr) {
        return this.belongTo_.get(expr);
    }

    public void addRef(LpExprImpl expr, LpExprImpl.LpTermImpl term) {
        if (this.belongTo_.containsKey(expr)) {
            throw new RuntimeException("This variable already belong to the given expr");
        }
        this.belongTo_.put(expr, term);
    }

    public LpExprImpl.LpTermImpl removeRef(LpExprImpl expr) {
        LpExprImpl.LpTermImpl result = this.belongTo_.get(expr);
        this.belongTo_.remove(expr);
        return result;
    }

    public final void setVariableIndex(int index) throws LpException {
        if (this.index_ != -1) {
            throw new LpException("Can't modify variable index after solve");
        }
        this.index_ = index;
    }

    public final int getVariableIndex() {
        return this.index_;
    }

    public final String getName() {
        return this.name_;
    }

    public String toString() {
        return this.getName();
    }

    public double getLowerBound() {
        return this.lowerBound_;
    }

    public double getUpperBound() {
        return this.upperBound_;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Iterator<? extends LpExprImpl.LpTermImpl> termIterator() {
        Vector<LpExprImpl.LpTermImpl> tmp = new Vector<LpExprImpl.LpTermImpl>();
        tmp.add(new LpExprImpl.LpTermImpl(this, 1.0, this));
        return tmp.iterator();
    }
}

