/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.lpSolver.Impl;

import java.util.Iterator;
import java.util.Vector;
import mascoptLib.lpSolver.Impl.LpContinuousVariableImpl;
import mascoptLib.lpSolver.Impl.LpExprImpl;
import mascoptLib.lpSolver.Impl.LpIntegerVariableImpl;
import mascoptLib.lpSolver.Impl.LpLinearExprImpl;
import mascoptLib.lpSolver.interfaces.LpContinuousVariable;
import mascoptLib.lpSolver.interfaces.LpLinearContinuousExpr;
import mascoptLib.lpSolver.interfaces.LpLinearExpr;

public class LpLinearContinuousExprImpl
extends LpLinearExprImpl
implements LpLinearContinuousExpr {
    private Vector<LpExprImpl.LpTermImpl> sumOfTerm = new Vector();
    private double constant = 0.0;

    public Iterator<LpExprImpl.LpTermImpl> termIterator() {
        return this.sumOfTerm.iterator();
    }

    @Override
    public int size() {
        return this.sumOfTerm.size();
    }

    @Override
    public void addExpr(LpLinearExpr expr) {
        Iterator<LpExprImpl.LpTermImpl> termIt = ((LpLinearContinuousExprImpl)expr).termIterator();
        while (termIt.hasNext()) {
            LpExprImpl.LpTermImpl currentTerm = termIt.next();
            this.addTerm(currentTerm.getCoef(), currentTerm.getVar());
        }
    }

    @Override
    public void addTerm(double coef, LpContinuousVariable var) {
        if (coef == 0.0) {
            return;
        }
        LpExprImpl.LpTermImpl currentTerm = ((LpContinuousVariableImpl)var).getRef(this);
        if (currentTerm != null) {
            currentTerm.addToCoef(coef);
            return;
        }
        currentTerm = var instanceof LpIntegerVariableImpl ? new LpExprImpl.LpTermImpl(this, coef, (LpIntegerVariableImpl)var) : new LpExprImpl.LpTermImpl(this, coef, (LpContinuousVariableImpl)var);
        this.sumOfTerm.add(currentTerm);
        ((LpContinuousVariableImpl)var).addRef(this, currentTerm);
    }

    public boolean constains(LpExprImpl.LpTermImpl term) {
        return this.sumOfTerm.contains(term);
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.sumOfTerm.size()) {
            this.sumOfTerm.get(i).getVar().removeRef(this);
            ++i;
        }
        this.sumOfTerm.clear();
    }

    @Override
    public Iterator<LpContinuousVariable> iterator() {
        return new VarIterator(this.sumOfTerm.iterator());
    }

    @Override
    public void remove(LpContinuousVariable var) {
        LpExprImpl.LpTermImpl term = ((LpContinuousVariableImpl)var).removeRef(this);
        if (term != null) {
            this.sumOfTerm.remove(term);
        }
    }

    @Override
    public void setConstant(double constant) {
        this.constant = constant;
    }

    @Override
    public double getConstant() {
        return this.constant;
    }

    public String toString() {
        String str = new String();
        for (LpExprImpl.LpTermImpl current : this.sumOfTerm) {
            str = str.concat(" + " + current);
        }
        return str;
    }

    private class VarIterator
    implements Iterator<LpContinuousVariable> {
        private Iterator<LpExprImpl.LpTermImpl> realIt;

        public VarIterator(Iterator<LpExprImpl.LpTermImpl> realIt) {
            this.realIt = realIt;
        }

        @Override
        public boolean hasNext() {
            return this.realIt.hasNext();
        }

        @Override
        public LpContinuousVariableImpl next() {
            return this.realIt.next().getVar();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

