/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.lpSolver.glpkImpl;

import mascoptLib.lpSolver.Impl.AbstractLinearProgram;
import mascoptLib.lpSolver.exception.LpException;
import mascoptLib.lpSolver.interfaces.LinearProgram;
import org.gnu.glpk.GlpkSolver;

public class GlpkLinearProgram
extends AbstractLinearProgram {
    private GlpkSolver realSolver_ = new GlpkSolver();

    @Override
    protected boolean callingSolve() {
        boolean result;
        this.realSolver_.setIntParm(327, 1);
        System.out.println("Solving...");
        if (this.isMIP()) {
            this.realSolver_.setIntParm(329, 3);
            this.realSolver_.simplex();
            result = this.realSolver_.integer() == 200;
        } else {
            result = this.realSolver_.simplex() == 200;
        }
        this.setSolved(result);
        return result;
    }

    @Override
    protected double getVariableValue(int variableIndex) {
        return this.realSolver_.getColPrim(variableIndex);
    }

    @Override
    protected void addConstraint(int constraintIndex, int nTerm, int[] varIndex, double[] varCoef) {
        this.realSolver_.setMatRow(constraintIndex, nTerm, varIndex, varCoef);
    }

    @Override
    protected void setConstraintBounds(int constraintIndex, double bound, AbstractLinearProgram.ConstraintsType type) throws LpException {
        int constraintType;
        switch (type) {
            case EQUAL_CONSTRAINT: {
                constraintType = 114;
                break;
            }
            case LESSER_CONSTRAINT: {
                constraintType = 112;
                break;
            }
            case UPPER_CONSTRAINT: {
                constraintType = 111;
                break;
            }
            default: {
                throw new LpException("The constraint type is unknow");
            }
        }
        this.realSolver_.setRowBnds(constraintIndex, constraintType, bound, bound);
    }

    @Override
    protected void setConstraintName(int constraintIndex, String name) {
        this.realSolver_.setRowName(constraintIndex, name);
    }

    @Override
    protected void setConstraintNumber(int nbConstraints) {
        this.realSolver_.addRows(nbConstraints);
    }

    @Override
    protected void setVariableBounds(int variableIndex, double lowerBound, double upperBound) {
        this.realSolver_.setColBnds(variableIndex, 113, lowerBound, upperBound);
    }

    @Override
    protected void setVariableName(int variableIndex, String name) {
        this.realSolver_.setColName(variableIndex, name);
    }

    @Override
    protected void setVariableNumber(int nbVariables) {
        this.realSolver_.addCols(nbVariables);
    }

    @Override
    protected void setObjectiveExpr(int nbTerm, double[] coefs, int[] variablesIndex) {
        int i = 1;
        while (i <= nbTerm) {
            this.realSolver_.setObjCoef(variablesIndex[i], coefs[i]);
            ++i;
        }
    }

    @Override
    protected void setProblemClass(AbstractLinearProgram.ProblemClass problemClass) {
        switch (problemClass) {
            case FRACTIONNAL_PROBLEM: {
                this.realSolver_.setClss(100);
                break;
            }
            case MIXED_INTEGER_PROBLEM: {
                this.realSolver_.setClss(101);
            }
        }
    }

    @Override
    protected void setVariableType(int variableIndex, AbstractLinearProgram.VariableType type) {
        switch (type) {
            case CONTINUOUS_VARIABLE: {
                this.realSolver_.setColKind(variableIndex, 160);
                break;
            }
            case INTEGER_VARIABLE: {
                this.realSolver_.setColKind(variableIndex, 161);
            }
        }
    }

    @Override
    protected void writeCplexFile(String filename) {
        this.realSolver_.writeCpxlp(String.valueOf(filename) + ".lp");
    }

    @Override
    protected void writeMpsFile(String filename) {
        this.realSolver_.setIntParm(322, 1);
        this.realSolver_.writeMps(String.valueOf(filename) + ".mps");
    }

    @Override
    protected void setObjectiveSense(AbstractLinearProgram.ObjectiveSense sense) {
        switch (sense) {
            case MAXIMIZE: {
                this.realSolver_.setObjDir(121);
                break;
            }
            case MINIMIZE: {
                this.realSolver_.setObjDir(120);
                break;
            }
            default: {
                throw new InternalError("Unknow objective sense");
            }
        }
    }

    @Override
    public void setDoubleOption(LinearProgram.DoubleOption option, double value) throws LpException {
        switch (option) {
            case SOLUTION_GAP: {
                throw new LpException("Unsupported operation");
            }
            case TIME_LIMIT: {
                throw new LpException("Unsupported operation");
            }
        }
        throw new LpException("Unknowed option");
    }

    @Override
    public void setIntegerOption(LinearProgram.IntegerOption option, int value) throws LpException {
        switch (option) {
            case SOLVER_ALGO: {
                throw new LpException("Not yet implemented");
            }
        }
        throw new LpException("Unknowed option");
    }

    @Override
    public void clearModel() throws LpException {
        throw new LpException("Not yet implemented");
    }
}

