/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.numeric;

import junit.framework.Assert;
import junit.framework.TestCase;
import mascoptLib.numeric.MascoptDouble;
import mascoptLib.numeric.MascoptInteger;

public class MascoptDoubleTest
extends TestCase {
    private static double EPSILON = 5.0E-16;
    private MascoptDouble d1;
    private MascoptDouble d2;
    private MascoptDouble d3;
    private MascoptDouble d4;
    private MascoptInteger i1;
    private MascoptInteger i2;

    protected void setUp() throws Exception {
        super.setUp();
        this.d1 = new MascoptDouble(1.2);
        this.d2 = new MascoptDouble(0.8);
        this.d3 = new MascoptDouble(-1.5);
        this.d4 = new MascoptDouble(16.0);
        this.i1 = new MascoptInteger(1);
        this.i2 = new MascoptInteger(-1);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.d1 = null;
        this.d2 = null;
        this.d3 = null;
        this.i1 = null;
        this.i2 = null;
    }

    boolean epsilonEqual(double v1, double v2) {
        return Math.abs(v1 - v2) < EPSILON;
    }

    public void testAdd() {
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.add(this.i2).doubleValue(), 0.2));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.add(this.d2).doubleValue(), 1.0));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.add(this.i1).doubleValue(), 2.0));
    }

    public void testSubtract() {
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.subtract(this.i2).doubleValue(), 2.2));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.subtract(this.d2).doubleValue(), 1.4));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.subtract(this.i1).doubleValue(), 0.4));
    }

    public void testMultiply() {
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.multiply(this.i2).doubleValue(), -1.2));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.multiply(this.d2).doubleValue(), -0.96));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.multiply(this.i1).doubleValue(), -0.96));
    }

    public void testDivide() {
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.divide(this.i2).doubleValue(), -1.2));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.divide(this.d2).doubleValue(), -1.5));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.divide(this.i1).doubleValue(), -1.5));
    }

    public void testCompareTo() {
        Assert.assertTrue((this.d1.compareTo(this.d1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.d1.compareTo(this.i1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.d2.compareTo(this.i1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.d1.compareTo(this.d2) > 0 ? 1 : 0) != 0);
    }

    public void testExp() {
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.exp().doubleValue(), Math.exp(1.2)));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d2.exp().doubleValue(), Math.exp(0.8)));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d3.exp().doubleValue(), Math.exp(-1.5)));
    }

    public void testAbs() {
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.abs().doubleValue(), 1.2));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d2.abs().doubleValue(), 0.8));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d3.abs().doubleValue(), 1.5));
    }

    public void testLog() {
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.log().doubleValue(), Math.log(1.2)));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d2.log().doubleValue(), Math.log(0.8)));
    }

    public void testLog10() {
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.log10().doubleValue(), Math.log10(1.2)));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d2.log10().doubleValue(), Math.log10(0.8)));
    }

    public void testPow() {
        Assert.assertTrue((boolean)this.epsilonEqual(this.d1.pow(this.d2).doubleValue(), Math.pow(1.2, 0.8)));
        Assert.assertTrue((boolean)this.epsilonEqual(this.d2.pow(this.d3).doubleValue(), Math.pow(0.8, -1.5)));
    }

    public void testSqrt() {
        Assert.assertTrue((this.d4.sqrt().doubleValue() == 4.0 ? 1 : 0) != 0);
    }
}

