/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.numeric;

import bridge.abstractClasses.AbstractScalar;
import mascoptLib.numeric.MascoptAbstractMP;
import mascoptLib.numeric.MascoptAbstractScalar;
import mascoptLib.numeric.MascoptMPInteger;
import mpfun.MP;
import mpfun.MPPrecision;
import mpfun.MPReal;

public class MascoptMPDecimal
extends MascoptAbstractMP {
    private static final long serialVersionUID = -663609036246660115L;
    private MPReal value;

    public MascoptMPDecimal(String value) {
        this.value = new MPReal(value, new MPPrecision(MascoptAbstractMP.defaultPrecision));
    }

    public MascoptMPDecimal(double value) {
        this.value = new MPReal(value, new MPPrecision(MascoptAbstractMP.defaultPrecision));
    }

    public MascoptMPDecimal(AbstractScalar c) {
        this.value = c instanceof MascoptMPDecimal ? ((MascoptMPDecimal)c).getMPReal() : (c instanceof MascoptMPInteger ? new MPReal(((MascoptMPInteger)c).getMPInt()) : new MPReal(c.doubleValue(), new MPPrecision(MascoptAbstractMP.defaultPrecision)));
    }

    @Override
    public void setPrecision(int precision) {
        this.updateGlobalPrecision(precision);
        this.value = new MPReal(new MPPrecision(precision)).assign((MP)this.value);
    }

    MPReal getMPReal() {
        return this.value;
    }

    @Override
    public AbstractScalar zero() {
        return new MascoptMPDecimal(0.0);
    }

    @Override
    public AbstractScalar add(AbstractScalar c) {
        if (c instanceof MascoptMPDecimal) {
            this.value = this.value.add(((MascoptMPDecimal)c).getMPReal());
        } else if (c instanceof MascoptMPInteger) {
            this.value = this.value.add(new MPReal(((MascoptMPInteger)c).getMPInt()));
        } else {
            MPReal tmp = new MPReal(c.doubleValue());
            this.value = this.value.add(tmp);
        }
        return this;
    }

    @Override
    public AbstractScalar subtract(AbstractScalar c) {
        if (c instanceof MascoptMPDecimal) {
            this.value = this.value.subtract(((MascoptMPDecimal)c).getMPReal());
        } else if (c instanceof MascoptMPInteger) {
            this.value = this.value.subtract(new MPReal(((MascoptMPInteger)c).getMPInt()));
        } else {
            MPReal tmp = new MPReal(c.doubleValue());
            this.value = this.value.subtract(tmp);
        }
        return this;
    }

    @Override
    public AbstractScalar multiply(AbstractScalar c) {
        if (c instanceof MascoptMPDecimal) {
            this.value = this.value.multiply(((MascoptMPDecimal)c).getMPReal());
        } else if (c instanceof MascoptMPInteger) {
            this.value = this.value.multiply(new MPReal(((MascoptMPInteger)c).getMPInt()));
        } else {
            MPReal tmp = new MPReal(c.doubleValue());
            this.value = this.value.multiply(tmp);
        }
        return this;
    }

    @Override
    public AbstractScalar divide(AbstractScalar c) {
        if (c instanceof MascoptAbstractMP) {
            this.value = this.value.divide(((MascoptMPDecimal)c).getMPReal());
        } else if (c instanceof MascoptMPInteger) {
            this.value = this.value.divide(new MPReal(((MascoptMPInteger)c).getMPInt()));
        } else {
            MPReal tmp = new MPReal(c.doubleValue());
            this.value = this.value.divide(tmp);
        }
        return this;
    }

    @Override
    public AbstractScalar negate() {
        this.value = this.value.negate();
        return this;
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public int compareTo(AbstractScalar c) {
        if (c instanceof MascoptMPDecimal) {
            return this.value.compareTo((Object)((MascoptMPDecimal)c).getMPReal());
        }
        if (c instanceof MascoptMPInteger) {
            return this.value.compareTo((Object)((MascoptMPInteger)c).getMPInt());
        }
        return this.value.compareTo((Object)new MPReal(c.doubleValue()));
    }

    @Override
    public AbstractScalar abs() {
        this.value = this.value.abs();
        return this;
    }

    @Override
    public AbstractScalar exp() {
        this.value = this.value.exp();
        return this;
    }

    @Override
    public AbstractScalar log() {
        this.value = this.value.log();
        return this;
    }

    @Override
    public AbstractScalar log10() {
        this.value = this.value.log10();
        return this;
    }

    @Override
    public AbstractScalar pow(AbstractScalar c) {
        if (c instanceof MascoptAbstractMP) {
            this.value = this.value.pow((MP)((MascoptMPDecimal)c).getMPReal());
        } else if (c instanceof MascoptMPInteger) {
            this.value = this.value.pow((MP)new MPReal(((MascoptMPInteger)c).getMPInt()));
        } else {
            MPReal tmp = new MPReal(c.doubleValue());
            this.value = this.value.pow((MP)tmp);
        }
        return this;
    }

    @Override
    public AbstractScalar sqrt() {
        this.value = this.value.sqrt();
        return this;
    }

    @Override
    public MascoptMPDecimal clone() {
        MascoptMPDecimal copy = (MascoptMPDecimal)super.clone();
        copy.value = (MPReal)this.value.clone();
        return copy;
    }

    public boolean equals(Object o) {
        return ((MascoptAbstractScalar)o).doubleValue() == this.value.doubleValue();
    }

    public int hashCode() {
        return this.value.intValue();
    }
}

