/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.numeric;

import bridge.abstractClasses.AbstractScalar;
import mascoptLib.numeric.MascoptAbstractMP;
import mascoptLib.numeric.MascoptAbstractScalar;
import mascoptLib.numeric.MascoptDouble;
import mascoptLib.numeric.MascoptInteger;
import mascoptLib.numeric.MascoptMPDecimal;
import mpfun.MP;
import mpfun.MPInt;
import mpfun.MPPrecision;
import mpfun.MPReal;

public class MascoptMPInteger
extends MascoptAbstractMP {
    private static final long serialVersionUID = 433492698745540112L;
    private MPInt value;

    public MascoptMPInteger(String value) {
        this.value = new MPInt(value, new MPPrecision(MascoptAbstractMP.defaultPrecision));
    }

    public MascoptMPInteger(long value) {
        this.value = new MPInt((double)value, new MPPrecision(MascoptAbstractMP.defaultPrecision));
    }

    public MascoptMPInteger(MascoptMPInteger scalar) {
        this.value = new MPInt(scalar.getMPInt());
    }

    @Override
    public AbstractScalar zero() {
        return new MascoptMPInteger(0L);
    }

    @Override
    public void setPrecision(int precision) {
        this.updateGlobalPrecision(precision);
        this.value = new MPInt(new MPPrecision(precision)).assign((MP)this.value);
    }

    MPInt getMPInt() {
        return this.value;
    }

    @Override
    public AbstractScalar add(AbstractScalar c) {
        if (c instanceof MascoptMPInteger) {
            this.value = this.value.add(((MascoptMPInteger)c).getMPInt());
        } else if (c instanceof MascoptInteger) {
            MPInt tmp = new MPInt((double)c.longValue());
            this.value = this.value.add(tmp);
        } else {
            throw new IllegalArgumentException("Cannot add a" + c.getClass() + " to a MascoptMPInteger");
        }
        return this;
    }

    @Override
    public AbstractScalar subtract(AbstractScalar c) {
        if (c instanceof MascoptMPInteger) {
            this.value = this.value.subtract(((MascoptMPInteger)c).getMPInt());
        } else if (c instanceof MascoptInteger) {
            MPInt tmp = new MPInt((double)c.longValue());
            this.value = this.value.subtract(tmp);
        } else {
            throw new IllegalArgumentException("Cannot subtract a" + c.getClass() + " to a MascoptMPInteger");
        }
        return this;
    }

    @Override
    public AbstractScalar multiply(AbstractScalar c) {
        if (c instanceof MascoptMPInteger) {
            this.value = this.value.multiply(((MascoptMPInteger)c).getMPInt());
        } else if (c instanceof MascoptInteger) {
            MPInt tmp = new MPInt((double)c.longValue());
            this.value = this.value.multiply(tmp);
        } else {
            throw new IllegalArgumentException("Cannot multiply a MascoptMPInteger by a " + c.getClass());
        }
        return this;
    }

    @Override
    public AbstractScalar divide(AbstractScalar c) {
        if (c instanceof MascoptMPInteger) {
            this.value = this.value.divide(((MascoptMPInteger)c).getMPInt());
        } else if (c instanceof MascoptInteger) {
            MPInt tmp = new MPInt((double)c.longValue());
            this.value = this.value.divide(tmp);
        } else {
            throw new IllegalArgumentException("Cannot multiply a MascoptMPInteger by a " + c.getClass());
        }
        return this;
    }

    @Override
    public AbstractScalar negate() {
        this.value = this.value.negate();
        return this;
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public int compareTo(AbstractScalar c) {
        if (c instanceof MascoptInteger) {
            return this.value.compareTo((Object)new MPInt((double)c.longValue()));
        }
        if (c instanceof MascoptDouble) {
            this.value.compareTo((Object)new MPReal(c.doubleValue()));
        } else {
            if (c instanceof MascoptMPInteger) {
                return this.value.compareTo((Object)((MascoptMPInteger)c).getMPInt());
            }
            if (c instanceof MascoptMPDecimal) {
                return this.value.compareTo((Object)((MascoptMPDecimal)c).getMPReal());
            }
        }
        return 0;
    }

    @Override
    public AbstractScalar abs() {
        this.value = this.value.abs();
        return this;
    }

    @Override
    public AbstractScalar exp() throws Exception {
        throw new RuntimeException("Can't call exp on an MascoptMPInteger");
    }

    @Override
    public AbstractScalar log() throws Exception {
        throw new RuntimeException("Can't call exp on an MascoptMPInteger");
    }

    @Override
    public AbstractScalar log10() throws Exception {
        throw new RuntimeException("Can't call exp on an MascoptMPInteger");
    }

    @Override
    public AbstractScalar pow(AbstractScalar c) {
        if (c instanceof MascoptMPInteger) {
            this.value = this.value.pow(((MascoptMPInteger)c).getMPInt());
        } else if (c instanceof MascoptInteger) {
            this.value = this.value.pow(c.intValue());
        } else {
            throw new IllegalArgumentException("exponent must be integer");
        }
        return this;
    }

    @Override
    public AbstractScalar sqrt() throws Exception {
        throw new RuntimeException("Can't call exp on an MascoptMPInteger");
    }

    @Override
    public MascoptMPInteger clone() {
        MascoptMPInteger copy = (MascoptMPInteger)super.clone();
        copy.value = (MPInt)this.value.clone();
        return copy;
    }

    public boolean equals(Object o) {
        return ((MascoptAbstractScalar)o).doubleValue() == this.value.doubleValue();
    }

    public int hashCode() {
        return this.value.intValue();
    }
}

