/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class CommandLineParse {
    private String[] args_;
    private String[] noProceedArgs_;
    private Vector<CommandLineParameter> parameters_;
    private int nbObjectInNoProceedArgs_ = 0;
    private CommandLineParameter helpOption_ = null;

    public CommandLineParse(String[] args) {
        this.args_ = args;
        this.noProceedArgs_ = new String[args.length];
        this.parameters_ = new Vector();
    }

    public void parse() {
        int i = 0;
        while (i < this.args_.length) {
            if (this.args_[i].equals("--")) {
                ++i;
                break;
            }
            Iterator<CommandLineParameter> optionIt = this.parameters_.iterator();
            int add = 0;
            while (optionIt.hasNext()) {
                add = optionIt.next().readValue(this.args_, i);
                if (add == 0) continue;
                i += add;
                break;
            }
            if (add != 0) continue;
            this.noProceedArgs_[this.nbObjectInNoProceedArgs_++] = this.args_[i++];
        }
        while (i < this.args_.length) {
            this.noProceedArgs_[this.nbObjectInNoProceedArgs_++] = this.args_[i++];
        }
        if (this.helpOption_ == null || !this.helpOption_.isFound()) {
            for (CommandLineParameter current : this.parameters_) {
                if (current.isFound() && current.haveSuperOption() && !current.getSuperParameter().isFound()) {
                    throw new CommandLineParserException(current + " is found but his super parameter " + current.getSuperParameter() + " is missing");
                }
                if (!current.mustBePresent() || current.isFound() || current.getSuperParameter() != null && !current.getSuperParameter().isFound() || current.testExclusivity() != null) continue;
                throw new CommandLineParserException("The parameter --" + current.getLongName() + " must be present");
            }
        }
    }

    public BooleanParameter declareHelpParameter() {
        BooleanParameter current = new BooleanParameter(null, "h", "help");
        current.setDefaultValue(new Boolean(false));
        this.parameters_.add(current);
        this.helpOption_ = current;
        return current;
    }

    public BooleanParameter declareBooleanParameter(String shortParameter, String longParameter) {
        BooleanParameter current = new BooleanParameter(null, shortParameter, longParameter);
        current.setDefaultValue(new Boolean(false));
        this.parameters_.add(current);
        return current;
    }

    public BooleanParameter declareBooleanParameter(CommandLineParameter superParameter, String shortParameter, String longParameter) {
        BooleanParameter current = new BooleanParameter(superParameter, shortParameter, longParameter);
        current.setDefaultValue(new Boolean(false));
        this.parameters_.add(current);
        return current;
    }

    public IntegerParameter declareIntegerParameter(String shortParameter, String longParameter, boolean mustBePresent) {
        IntegerParameter current = new IntegerParameter(null, shortParameter, longParameter, mustBePresent);
        this.parameters_.add(current);
        return current;
    }

    public IntegerParameter declareIntegerParameterWithDefaultValue(String shortParameter, String longParameter, int defaultValue) {
        IntegerParameter current = new IntegerParameter(null, shortParameter, longParameter, false);
        current.setDefaultValue(new Integer(defaultValue));
        this.parameters_.add(current);
        return current;
    }

    public IntegerParameter declareIntegerParameter(CommandLineParameter superParameter, String shortParameter, String longParameter, boolean mustBePresent) {
        IntegerParameter current = new IntegerParameter(superParameter, shortParameter, longParameter, mustBePresent);
        this.parameters_.add(current);
        return current;
    }

    public IntegerParameter declareIntegerParameterWithDefaultValue(CommandLineParameter superParameter, String shortParameter, String longParameter, int defaultValue) {
        IntegerParameter current = new IntegerParameter(superParameter, shortParameter, longParameter, false);
        current.setDefaultValue(new Integer(defaultValue));
        this.parameters_.add(current);
        return current;
    }

    public LongParameter declareLongParameter(String shortParameter, String longParameter, boolean mustBePresent) {
        LongParameter current = new LongParameter(null, shortParameter, longParameter, mustBePresent);
        this.parameters_.add(current);
        return current;
    }

    public LongParameter declareLongParameterWithDefaultValue(String shortParameter, String longParameter, long defaultValue) {
        LongParameter current = new LongParameter(null, shortParameter, longParameter, false);
        current.setDefaultValue(new Long(defaultValue));
        this.parameters_.add(current);
        return current;
    }

    public LongParameter declareLongParameter(CommandLineParameter superParameter, String shortParameter, String longParameter, boolean mustBePresent) {
        LongParameter current = new LongParameter(superParameter, shortParameter, longParameter, mustBePresent);
        this.parameters_.add(current);
        return current;
    }

    public LongParameter declareLongParameterWithDefaultValue(CommandLineParameter superOption, String shortOption, String longOption, long defaultValue) {
        LongParameter current = new LongParameter(superOption, shortOption, longOption, false);
        current.setDefaultValue(new Long(defaultValue));
        this.parameters_.add(current);
        return current;
    }

    public DoubleParameter declareDoubleParameter(String shortParameter, String longParameter, boolean mustBePresent) {
        DoubleParameter current = new DoubleParameter(null, shortParameter, longParameter, mustBePresent);
        this.parameters_.add(current);
        return current;
    }

    public DoubleParameter declareDoubleParameterWithDefaultValue(String shortParameter, String longParameter, double defaultValue) {
        DoubleParameter current = new DoubleParameter(null, shortParameter, longParameter, false);
        current.setDefaultValue(new Double(defaultValue));
        this.parameters_.add(current);
        return current;
    }

    public DoubleParameter declareDoubleParameter(CommandLineParameter superParameter, String shortParameter, String longParameter, boolean mustBePresent) {
        DoubleParameter current = new DoubleParameter(superParameter, shortParameter, longParameter, mustBePresent);
        this.parameters_.add(current);
        return current;
    }

    public DoubleParameter declareDoubleParameterWithDefaultValue(CommandLineParameter superParameter, String shortParameter, String longParameter, double defaultValue) {
        DoubleParameter current = new DoubleParameter(superParameter, shortParameter, longParameter, false);
        current.setDefaultValue(new Double(defaultValue));
        this.parameters_.add(current);
        return current;
    }

    public StringParameter declareStringParameter(String shortParameter, String longParameter, boolean mustBePresent) {
        StringParameter current = new StringParameter(null, shortParameter, longParameter, mustBePresent);
        this.parameters_.add(current);
        return current;
    }

    public StringParameter declareStringParameterWithDefaultValue(String shortParameter, String longParameter, String defaultValue) {
        StringParameter current = new StringParameter(null, shortParameter, longParameter, false);
        current.setDefaultValue(defaultValue);
        this.parameters_.add(current);
        return current;
    }

    public StringParameter declareStringParameter(CommandLineParameter superParameter, String shortParameter, String longParameter) {
        StringParameter current = new StringParameter(superParameter, shortParameter, longParameter, false);
        this.parameters_.add(current);
        return current;
    }

    public StringParameter declareStringParameterWithDefaultValue(CommandLineParameter superParameter, String shortParameter, String longParameter, String defaultValue) {
        StringParameter current = new StringParameter(superParameter, shortParameter, longParameter, false);
        current.setDefaultValue(defaultValue);
        this.parameters_.add(current);
        return current;
    }

    public String usage() {
        String result = "";
        for (CommandLineParameter current : this.parameters_) {
            result = String.valueOf(result) + "-" + current.getShortName() + " --" + current.getLongName() + " : " + (current.getExplanation() != null ? current.getExplanation() : "") + System.getProperty("line.separator");
        }
        return result;
    }

    public String[] getNotProceedArgs() {
        String[] result = new String[this.nbObjectInNoProceedArgs_];
        int i = 0;
        while (i < this.nbObjectInNoProceedArgs_) {
            result[i] = this.noProceedArgs_[i];
            ++i;
        }
        return result;
    }

    public class BooleanParameter
    extends CommandLineParameter {
        BooleanParameter(CommandLineParameter superOption, String shortName, String longName) {
            super(superOption, OptionType.BOOLEAN_OPTION, shortName, longName, false);
        }

        public Boolean getBooleanValue() {
            return (Boolean)this.getValue();
        }
    }

    class CommandLineParameter {
        private CommandLineParameter superParameter_;
        private HashSet<CommandLineParameter> exclusive_;
        private OptionType type_;
        private String shortName_;
        private String longName_;
        private String explanation_;
        private boolean mustBePresent_;
        private Object value_;
        private boolean found_;

        CommandLineParameter(CommandLineParameter superOption, OptionType type, String shortName, String longName, boolean mustBePresent) {
            this.superParameter_ = superOption;
            this.exclusive_ = new HashSet();
            this.type_ = type;
            this.shortName_ = shortName;
            this.longName_ = longName;
            this.mustBePresent_ = mustBePresent;
            this.found_ = false;
            for (CommandLineParameter current : CommandLineParse.this.parameters_) {
                if (!current.getShortName().equals(shortName) && !current.getLongName().equals(longName)) continue;
                System.err.println("Warning : Two parameter have the same short or/and long name");
            }
        }

        Object getValue() {
            return this.value_;
        }

        public boolean isFound() {
            return this.found_;
        }

        boolean mustBePresent() {
            return this.mustBePresent_;
        }

        public void setExplanation(String explanation) {
            this.explanation_ = explanation;
        }

        String getExplanation() {
            return this.explanation_;
        }

        String getLongName() {
            return this.longName_;
        }

        String getShortName() {
            return this.shortName_;
        }

        public String toString() {
            return this.longName_;
        }

        CommandLineParameter getSuperParameter() {
            return this.superParameter_;
        }

        boolean haveSuperOption() {
            return this.superParameter_ != null;
        }

        public void addExclusiveParameter(CommandLineParameter exclusiveParameter) {
            this.exclusive_.add(this);
            this.exclusive_.add(exclusiveParameter);
            exclusiveParameter.exclusive_.addAll(this.exclusive_);
        }

        public CommandLineParameter testExclusivity() {
            for (CommandLineParameter current : CommandLineParse.this.parameters_) {
                if (!current.isFound() || !this.exclusive_.contains(current)) continue;
                return current;
            }
            return null;
        }

        private int internalSetValue(String valueString) {
            CommandLineParameter exclusive = this.testExclusivity();
            if (exclusive != null) {
                throw new CommandLineParserException("The parameter (" + this + ") is exclusive with (" + exclusive + ")");
            }
            if (this.found_ && this.type_ != OptionType.BOOLEAN_OPTION) {
                throw new CommandLineParserException("This option is already set");
            }
            this.found_ = true;
            switch (this.type_) {
                case BOOLEAN_OPTION: {
                    this.value_ = new Boolean("true");
                    return 1;
                }
                case INTEGER_OPTION: {
                    this.value_ = new Integer(Integer.parseInt(valueString));
                    return 2;
                }
                case LONG_OPTION: {
                    this.value_ = new Long(Long.parseLong(valueString));
                    return 2;
                }
                case DOUBLE_OPTION: {
                    this.value_ = new Double(Double.parseDouble(valueString));
                    return 2;
                }
                case STRING_OPTION: {
                    this.value_ = valueString;
                    return 2;
                }
            }
            throw new IllegalStateException("The type of option is incorrect");
        }

        int readValue(String[] args, int index) {
            if (args[index].equals("-" + this.shortName_) || args[index].equals("--" + this.longName_)) {
                if (index + 1 < args.length) {
                    return this.internalSetValue(args[index + 1]);
                }
                if (this.type_ == OptionType.BOOLEAN_OPTION) {
                    return this.internalSetValue(args[index]);
                }
                throw new CommandLineParserException("The option " + args[index] + " need argument");
            }
            return 0;
        }

        void setDefaultValue(Object value) {
            this.value_ = value;
        }
    }

    public class CommandLineParserException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        CommandLineParserException(String message) {
            super(message);
        }
    }

    public class DoubleParameter
    extends CommandLineParameter {
        DoubleParameter(CommandLineParameter superOption, String shortName, String longName, boolean mustBePresent) {
            super(superOption, OptionType.DOUBLE_OPTION, shortName, longName, mustBePresent);
        }

        public Double getDoubleValue() {
            return (Double)this.getValue();
        }
    }

    public class IntegerParameter
    extends CommandLineParameter {
        IntegerParameter(CommandLineParameter superOption, String shortName, String longName, boolean mustBePresent) {
            super(superOption, OptionType.INTEGER_OPTION, shortName, longName, mustBePresent);
        }

        public Integer getIntegerValue() {
            return (Integer)this.getValue();
        }
    }

    public class LongParameter
    extends CommandLineParameter {
        LongParameter(CommandLineParameter superOption, String shortName, String longName, boolean mustBePresent) {
            super(superOption, OptionType.LONG_OPTION, shortName, longName, mustBePresent);
        }

        public Long getLongValue() {
            return (Long)this.getValue();
        }
    }

    public static enum OptionType {
        BOOLEAN_OPTION,
        INTEGER_OPTION,
        LONG_OPTION,
        DOUBLE_OPTION,
        STRING_OPTION;

    }

    public class StringParameter
    extends CommandLineParameter {
        StringParameter(CommandLineParameter superOption, String shortName, String longName, boolean mustBePresent) {
            super(superOption, OptionType.STRING_OPTION, shortName, longName, mustBePresent);
        }

        public String getStringValue() {
            return (String)this.getValue();
        }
    }
}

