/*
 * Decompiled with CFR 0.152.
 */
package AssemblyGraph;

import JungAGAPE.Algos;
import JungAGAPE.Tools;
import edu.uci.ics.jung.algorithms.layout.FRLayout2;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.io.PajekNetReader;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import java.awt.Color;
import java.io.IOException;
import javax.swing.JFrame;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.FactoryUtils;

public class GraphDraw {
    public static void main(String[] args) throws IOException {
        Graph<String, Integer> g = Tools.readDNet("GenGraphs/dER/dERgraph_n40p0.02.net");
        JFrame jf = new JFrame();
        int ei = g.getEdgeCount();
        int vi = g.getVertexCount();
        Algos<String, Integer> alg = new Algos<String, Integer>();
        Factory<Integer> edgeFactory = new Factory<Integer>(ei){
            int c;
            {
                this.c = n;
            }

            @Override
            public Integer create() {
                ++this.c;
                return this.c;
            }
        };
        Factory<String> vertexFactory = new Factory<String>(vi){
            int c;
            {
                this.c = n;
            }

            @Override
            public String create() {
                ++this.c;
                return "v" + this.c;
            }
        };
        Factory<Graph<String, Integer>> graphFactory = new Factory<Graph<String, Integer>>(){

            @Override
            public Graph<String, Integer> create() {
                return new UndirectedSparseGraph<String, Integer>();
            }
        };
        Factory<Graph<String, Integer>> DgraphFactory = new Factory<Graph<String, Integer>>(){

            @Override
            public Graph<String, Integer> create() {
                return new DirectedSparseGraph<String, Integer>();
            }
        };
        alg.setEdgeFactoy(edgeFactory);
        alg.setVertexFactoy(vertexFactory);
        alg.setGraphFactoy(DgraphFactory);
        VisualizationViewer<String, Integer> vv = new VisualizationViewer<String, Integer>(new FRLayout2<String, Integer>(g));
        vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        vv.setGraphMouse(graphMouse);
        vv.addKeyListener(graphMouse.getModeKeyListener());
        vv.setBackground(Color.white);
        jf.getContentPane().add(vv);
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.setVisible(true);
        System.out.println("V size: " + g.getVertexCount());
        System.out.println("E size: " + g.getEdgeCount());
        System.out.println();
    }

    public static Graph getGraph() throws IOException {
        PajekNetReader pnr = new PajekNetReader(FactoryUtils.instantiateFactory(Object.class));
        UndirectedSparseGraph g = new UndirectedSparseGraph();
        pnr.load("test.net", g);
        return g;
    }
}

