/*
 * Decompiled with CFR 0.152.
 */
package JungAGAPE;

import JungAGAPE.MarkMap;
import JungAGAPE.Tools;
import agape.test.Tracker;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections15.Factory;

public class Algos<V, E> {
    private Factory<V> vertexFactory;
    private Factory<E> edgeFactory;
    private Factory<Graph<V, E>> graphFactory;
    private Set<V> VCbuf = new HashSet<V>();
    private Tracker tracker;
    final int UM = 10;
    final int LM = 11;
    final int RM = 12;
    final int WLM = 13;
    final int WRM = 14;
    final int LMD = 15;
    final int RMD = 16;
    private Set<V> Tmarked = new HashSet<V>();
    private Stack<V> Mstack = new Stack();
    private Stack<V> Pstack = new Stack();
    private HashMap<V, Integer> Tnodes = new HashMap();
    final double alpha = 0.19903;

    public void setVertexFactoy(Factory<V> vf) {
        this.vertexFactory = vf;
    }

    public void setEdgeFactoy(Factory<E> ef) {
        this.edgeFactory = ef;
    }

    public void setGraphFactoy(Factory<Graph<V, E>> gf) {
        this.graphFactory = gf;
    }

    public Factory<V> getVertexFactory() {
        return this.vertexFactory;
    }

    public Factory<E> getEdgeFactory() {
        return this.edgeFactory;
    }

    public Factory<Graph<V, E>> getGraphFactory() {
        return this.graphFactory;
    }

    public void initTracker() {
        this.tracker = new Tracker();
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    public Set<ArrayList<V>> EnumAllCircuitsTarjan(Graph<V, E> G) {
        HashSet<ArrayList<V>> cycles = new HashSet<ArrayList<V>>();
        this.Tmarked = new HashSet<V>();
        this.Mstack = new Stack();
        this.Pstack = new Stack();
        this.Tnodes = new HashMap();
        Iterator itr = G.getVertices().iterator();
        int i = 1;
        while (i <= G.getVertexCount()) {
            this.Tnodes.put((Integer)itr.next(), i);
            ++i;
        }
        for (Object v : G.getVertices()) {
            this.BackTrack(v, v, G, cycles);
            while (!this.Mstack.isEmpty()) {
                V u = this.Mstack.pop();
                this.Tmarked.remove(u);
            }
        }
        return cycles;
    }

    private boolean BackTrack(V v, V source, Graph<V, E> G, Set<ArrayList<V>> cycles) {
        boolean f = false;
        this.Pstack.push(v);
        this.Tmarked.add(v);
        this.Mstack.push(v);
        for (V w : G.getSuccessors(v)) {
            if (this.Tnodes.get(w) < this.Tnodes.get(source)) continue;
            if (w == source) {
                ArrayList<V> path = new ArrayList<V>(this.Pstack);
                cycles.add(path);
                f = true;
                continue;
            }
            if (this.Tmarked.contains(w)) continue;
            boolean bl = f = this.BackTrack(w, source, G, cycles) || f;
        }
        if (f) {
            while (this.Mstack.peek() != v) {
                V u = this.Mstack.pop();
                this.Tmarked.remove(u);
            }
            this.Mstack.remove(v);
            this.Tmarked.remove(v);
        }
        this.Pstack.remove(v);
        return f;
    }

    private MarkMap<V> initMarkedMap() {
        MarkMap map = new MarkMap();
        map.initRole(10);
        map.initRole(11);
        map.initRole(12);
        map.initRole(13);
        map.initRole(14);
        map.initRole(15);
        map.initRole(16);
        return map;
    }

    public Set<V> findGreedyFVS(Graph<V, E> G) {
        HashSet aset = new HashSet();
        Graph Gp = Tools.copyDGraph(G);
        while (!Tools.isAcyclic(Gp)) {
            int degmax = 0;
            Object toremove = null;
            for (Object v : Gp.getVertices()) {
                if (Gp.getNeighborCount(v) <= degmax) continue;
                degmax = Gp.getNeighborCount(v);
                toremove = v;
            }
            aset.add(toremove);
            Gp.removeVertex(toremove);
        }
        return aset;
    }

    public Set<V> MaximumDirectedAcyclicSubset(Graph<V, E> G) {
        MarkMap R = this.initMarkedMap();
        for (Object v : G.getVertices()) {
            R.addV(v, 10);
        }
        HashSet<V> MAS = new HashSet<V>();
        HashSet MAStemp = new HashSet();
        boolean first = true;
        while (!MAS.equals(MAStemp) && !first || first) {
            MAS = new HashSet(MAStemp);
            this.KernelizationMAS(G, MAStemp);
            first = false;
        }
        System.out.println("after kern:" + G.getVertexCount());
        System.out.println("MAS:" + MAS.size());
        MAS.addAll(this.MAS(G, R));
        return MAS;
    }

    private void CompressGraph(Graph<V, E> G, V v) {
        HashSet<V> loopvertices = new HashSet<V>();
        for (V u : G.getPredecessors(v)) {
            for (V w : G.getSuccessors(v)) {
                if (u == w) {
                    loopvertices.add(u);
                    continue;
                }
                if (G.isSuccessor(u, w)) continue;
                G.addEdge(this.edgeFactory.create(), u, w);
            }
        }
        Tools.removeAllVertices(G, loopvertices);
        G.removeVertex(v);
    }

    private void KernelizationMAS(Graph<V, E> G, Set<V> S) {
        HashSet toRemove = new HashSet();
        for (Object v : G.getVertices()) {
            if (G.findEdge(v, v) == null) continue;
            toRemove.add(v);
        }
        Tools.removeAllVertices(G, toRemove);
        toRemove.clear();
        for (Object v : G.getVertices()) {
            if (G.getPredecessorCount(v) != 0 && G.getSuccessorCount(v) != 0) continue;
            toRemove.add(v);
            S.add(v);
        }
        Tools.removeAllVertices(G, toRemove);
        boolean cfound = false;
        do {
            Pair<V> p = null;
            Object r = null;
            cfound = false;
            Iterator itr = G.getVertices().iterator();
            while (itr.hasNext() && !cfound) {
                V z;
                V y;
                Object v = itr.next();
                if (G.getPredecessorCount(v) != 1 || G.getSuccessorCount(v) != 1 || (y = G.getPredecessors(v).iterator().next()) == (z = G.getSuccessors(v).iterator().next())) continue;
                p = new Pair<V>(y, z);
                r = v;
                S.add(v);
                cfound = true;
            }
            if (!cfound) continue;
            G.removeVertex(r);
            if (G.findEdge(p.getFirst(), p.getSecond()) != null) continue;
            G.addEdge(this.edgeFactory.create(), p.getFirst(), p.getSecond());
        } while (cfound);
    }

    /*
     * WARNING - void declaration
     */
    private Set<V> MAS(Graph<V, E> G, MarkMap<V> R) {
        void var14_45;
        Object v;
        int i;
        int nToChangeRole;
        if (G.getEdgeCount() == 0) {
            return new HashSet(G.getVertices());
        }
        Set<Object> MAS = new HashSet<Object>();
        Set<Object> VL = R.getVertices(11, 15);
        Set<Object> VR = R.getVertices(12, 16);
        if (VR.size() - VL.size() > 3) {
            nToChangeRole = VR.size() - (VL.size() + 3);
            Set<Object> sRM = R.getVertices(12);
            Set<Object> sRMD = R.getVertices(16);
            Set<Object> sWRM = R.getVertices(14);
            i = 0;
            while (i < nToChangeRole) {
                if (!sRM.isEmpty() && !sRMD.isEmpty()) {
                    v = null;
                    if (Math.random() < 0.5) {
                        v = sRM.iterator().next();
                        sRM.remove(v);
                    } else {
                        v = sRMD.iterator().next();
                        sRMD.remove(v);
                    }
                    sWRM.add(v);
                    ++i;
                    continue;
                }
                if (sRM.isEmpty() && sRMD.isEmpty()) {
                    i = nToChangeRole;
                    continue;
                }
                if (sRM.isEmpty()) {
                    v = sRMD.iterator().next();
                    sWRM.add(v);
                    sRMD.remove(v);
                    ++i;
                    continue;
                }
                if (!sRMD.isEmpty()) continue;
                v = sRM.iterator().next();
                sWRM.add(v);
                sRM.remove(v);
                ++i;
            }
            R.changeRole(sRM, 12);
            R.changeRole(sRMD, 16);
            R.changeRole(sWRM, 14);
        }
        if (VL.size() - VR.size() > 3) {
            nToChangeRole = VL.size() - (VR.size() + 3);
            Set<Object> sLM = R.getVertices(11);
            Set<Object> sLMD = R.getVertices(15);
            Set<Object> sWLM = R.getVertices(13);
            i = 0;
            while (i < nToChangeRole) {
                if (!sLM.isEmpty() && !sLMD.isEmpty()) {
                    v = null;
                    if (Math.random() < 0.5) {
                        v = sLM.iterator().next();
                        sLM.remove(v);
                    } else {
                        v = sLMD.iterator().next();
                        sLMD.remove(v);
                    }
                    sWLM.add(v);
                    ++i;
                    continue;
                }
                if (sLM.isEmpty() && sLMD.isEmpty()) {
                    i = nToChangeRole;
                    continue;
                }
                if (sLM.isEmpty()) {
                    v = sLMD.iterator().next();
                    sWLM.add(v);
                    sLMD.remove(v);
                    ++i;
                    continue;
                }
                if (!sLMD.isEmpty()) continue;
                v = sLM.iterator().next();
                sWLM.add(v);
                sLM.remove(v);
                ++i;
            }
            R.changeRole(sLM, 11);
            R.changeRole(sLMD, 15);
            R.changeRole(sWLM, 13);
        }
        if (G.getVertexCount() <= 3) {
            if (G.getVertexCount() == 2) {
                Object v2;
                Iterator itrv = G.getVertices().iterator();
                Object u = itrv.next();
                if (G.isPredecessor(u, v2 = itrv.next()) && G.isSuccessor(u, v2)) {
                    MAS.add(u);
                } else {
                    MAS.addAll(G.getVertices());
                }
            }
            if (G.getVertexCount() == 3) {
                ArrayList<Set<Object>> SCC = Tools.getAllStronglyConnectedComponent(G);
                if (SCC.size() == 1 && SCC.get(0).equals(G.getVertices())) {
                    Iterator itrv = G.getVertices().iterator();
                    MAS.add(itrv.next());
                    MAS.add(itrv.next());
                }
                if (SCC.size() == 1 && SCC.get(0).size() == 1) {
                    MAS.addAll(G.getVertices());
                }
                if (SCC.size() == 2) {
                    if (SCC.get(0).size() == 1) {
                        MAS.addAll((Collection)SCC.get(0));
                        MAS.add(SCC.get(1).iterator().next());
                    } else {
                        MAS.addAll((Collection)SCC.get(1));
                        MAS.add(SCC.get(0).iterator().next());
                    }
                }
                if (SCC.size() == 3) {
                    MAS.addAll(G.getVertices());
                }
            }
            return MAS;
        }
        boolean cycle2 = false;
        Iterator itre = G.getEdges().iterator();
        Object x = null;
        Object y = null;
        while (!cycle2 && itre.hasNext()) {
            Object edge = itre.next();
            x = G.getEndpoints(edge).getFirst();
            y = G.getEndpoints(edge).getSecond();
            if (!G.getSuccessors(x).contains(y) || !G.getSuccessors(y).contains(x)) continue;
            cycle2 = true;
        }
        if (cycle2) {
            Object v3 = x;
            HashSet<Object> MAS1 = new HashSet<Object>();
            MAS1.add(v3);
            Graph Gcv = Tools.copyDGraph(G);
            this.CompressGraph(Gcv, v3);
            MarkMap<Object> Rp = new MarkMap<Object>(R);
            if (!R.getVertices(10).contains(v3)) {
                if (R.getVertices(11).contains(v3) || R.getVertices(15).contains(v3) || R.getVertices(13).contains(v3)) {
                    for (Object object : G.getPredecessors(v3)) {
                        if (!R.getVertices(10).contains(object)) continue;
                        Rp.changeRole(object, 13);
                    }
                }
                if (R.getVertices(12).contains(v3) || R.getVertices(16).contains(v3) || R.getVertices(14).contains(v3)) {
                    for (Object object : G.getSuccessors(v3)) {
                        if (!R.getVertices(10).contains(object)) continue;
                        Rp.changeRole(object, 14);
                    }
                }
            }
            MAS1.addAll(this.MAS(Gcv, Rp));
            Graph<V, E> graph = this.graphFactory.create();
            Tools.subGraph(G, graph, v3);
            G.removeVertex(v3);
            Set<Object> MAS2 = this.MAS(G, R);
            Tools.mergeGraph(G, graph);
            if (MAS1.size() > MAS2.size()) {
                return MAS1;
            }
            return MAS2;
        }
        ArrayList<Set<Object>> CC = Tools.getAllStronglyConnectedComponent(G);
        if (CC.size() > 1) {
            void var14_38;
            void var16_49;
            Set<Object> C;
            void var16_47;
            HashSet<Object> VLMDRMD = new HashSet<Object>();
            VLMDRMD.addAll(R.getVertices(15));
            VLMDRMD.addAll(R.getVertices(16));
            Iterator<Set<Object>> itr = CC.iterator();
            Set<Object> C1 = null;
            Object var14_35 = null;
            Object v1 = null;
            Object var16_46 = null;
            block5: while (itr.hasNext() && v1 == null && var16_47 == null) {
                Set<Object> S = itr.next();
                if (Sets.intersection(S, VLMDRMD).isEmpty()) continue;
                if (v1 == null) {
                    for (Object v4 : S) {
                        if (!VLMDRMD.contains(v4)) continue;
                        v1 = v4;
                        C1 = S;
                        continue block5;
                    }
                    continue;
                }
                for (Object v2 : S) {
                    if (!VLMDRMD.contains(v2)) continue;
                    Object object = v2;
                    Set<Object> set = S;
                    continue block5;
                }
            }
            if (v1 == null) {
                itr = CC.iterator();
                while (itr.hasNext() && v1 == null) {
                    C = itr.next();
                    if (C.contains(var16_47)) continue;
                    v1 = C.iterator().next();
                    C1 = C;
                }
            }
            if (var16_47 == null) {
                itr = CC.iterator();
                while (itr.hasNext() && var16_49 == null) {
                    C = itr.next();
                    if (C.contains(v1)) continue;
                    Object object = C.iterator().next();
                    Set<Object> set = C;
                }
            }
            HashSet<Object> T1 = new HashSet<Object>();
            Graph Gcv1v2 = Tools.copyDGraph(G);
            Graph<V, E> Gv1v2 = this.graphFactory.create();
            HashSet<Object> v1v2 = new HashSet<Object>();
            v1v2.add(v1);
            v1v2.add(var16_49);
            for (Object v5 : v1v2) {
                this.CompressGraph(Gcv1v2, v5);
            }
            T1.addAll(v1v2);
            T1.addAll(this.MAS(Gcv1v2, R));
            Tools.subGraph(G, Gv1v2, v1v2);
            G.removeVertex(v1);
            G.removeVertex(var16_49);
            Set<Object> T2 = this.MAS(G, R);
            Tools.mergeGraph(G, Gv1v2);
            HashSet A = new HashSet();
            HashSet B = new HashSet();
            HashSet C3 = new HashSet();
            HashSet D = new HashSet();
            Sets.intersection(T1, C1).copyInto(A);
            Sets.intersection(T2, C1).copyInto(B);
            Sets.intersection(T1, var14_38).copyInto(C3);
            Sets.intersection(T2, var14_38).copyInto(D);
            HashSet<Object> toReturn = new HashSet<Object>();
            if (A.size() > B.size()) {
                toReturn.addAll(A);
            } else {
                toReturn.addAll(B);
            }
            if (C3.size() > D.size()) {
                toReturn.addAll(C3);
            } else {
                toReturn.addAll(D);
            }
            C1.addAll((Collection<Object>)var14_38);
            T1.removeAll(C1);
            toReturn.addAll(T1);
            return toReturn;
        }
        if (VL.isEmpty() || VR.isEmpty()) {
            v = null;
            Iterator itr = G.getVertices().iterator();
            while (itr.hasNext() && v == null) {
                Object w = itr.next();
                if (G.getPredecessors(w).size() > 3 && G.getSuccessors(w).size() > 3 || !R.getVertices(10).contains(w) && !R.getVertices(13).contains(w) && !R.getVertices(14).contains(w)) continue;
                v = w;
            }
            if (v != null) {
                void var16_52;
                ArrayList<Object> l = new ArrayList();
                l = G.getPredecessors(v).size() <= 3 ? new ArrayList<Object>(G.getPredecessors(v)) : new ArrayList<Object>(G.getSuccessors(v));
                ArrayList arrayList = new ArrayList();
                Graph Gp = Tools.copyDGraph(G);
                this.CompressGraph(Gp, v);
                MAS.add(v);
                MAS.addAll(this.MAS(Gp, R));
                arrayList.add(new HashSet(MAS));
                boolean bl = false;
                while (var16_52 < l.size()) {
                    MAS = new HashSet();
                    Gp = Tools.copyDGraph(G);
                    Gp.removeVertex(v);
                    MAS.add(l.get((int)var16_52));
                    int j = 0;
                    while (j < var16_52) {
                        Gp.removeVertex(l.get(j));
                        ++j;
                    }
                    this.CompressGraph(Gp, l.get((int)var16_52));
                    MAS.addAll(this.MAS(Gp, R));
                    arrayList.add(new HashSet(MAS));
                    ++var16_52;
                }
                MAS.clear();
                for (Set set : arrayList) {
                    if (set.size() <= MAS.size()) continue;
                    MAS = set;
                }
                return MAS;
            }
            v = null;
            if (!R.getVertices(10).isEmpty()) {
                v = R.getVertices(10).iterator().next();
            }
            if (v == null && !R.getVertices(13).isEmpty()) {
                v = R.getVertices(13).iterator().next();
            }
            if (v == null && !R.getVertices(14).isEmpty()) {
                v = R.getVertices(14).iterator().next();
            }
            if (v == null) {
                v = G.getVertices().iterator().next();
            }
            HashSet<Object> MAS1 = new HashSet<Object>();
            MAS1.add(v);
            Graph graph = Tools.copyDGraph(G);
            this.CompressGraph(graph, v);
            MarkMap<Object> Rp = new MarkMap<Object>(R);
            if (!VL.contains(v) && !VR.contains(v)) {
                for (Object v3 : graph.getVertices()) {
                    Rp.changeRole(v3, 10);
                }
                HashSet<Object> hashSet = new HashSet<Object>();
                Iterator<Object> itru = graph.getPredecessors(v).iterator();
                int i3 = 0;
                while (i3 < 4) {
                    hashSet.add(itru.next());
                    ++i3;
                }
                HashSet<Object> W = new HashSet<Object>();
                Iterator<Object> itrw = graph.getSuccessors(v).iterator();
                int i4 = 0;
                while (i4 < 4) {
                    W.add(itrw.next());
                    ++i4;
                }
                Rp.changeRole(hashSet, 11);
                Rp.changeRole(W, 12);
                HashSet UU = new HashSet();
                Sets.difference(new HashSet<Object>(graph.getPredecessors(v)), hashSet).copyInto(UU);
                HashSet WW = new HashSet();
                Sets.difference(new HashSet<Object>(graph.getSuccessors(v)), W).copyInto(WW);
                if (!UU.isEmpty()) {
                    Rp.changeRole(UU, 13);
                }
                if (!WW.isEmpty()) {
                    Rp.changeRole(WW, 14);
                }
            }
            MAS1.addAll(this.MAS(graph, Rp));
            Graph<V, E> graph2 = this.graphFactory.create();
            Tools.subGraph(G, graph2, v);
            G.removeVertex(v);
            Set<Object> MAS2 = this.MAS(G, R);
            Tools.mergeGraph(G, graph2);
            if (MAS1.size() > MAS2.size()) {
                return MAS1;
            }
            return MAS2;
        }
        int xM = 0;
        int xMD = 0;
        int WxM = 0;
        Object var14_42 = null;
        if (VL.size() <= VR.size()) {
            xM = 11;
            xMD = 15;
            WxM = 13;
            Set<Object> set = VL;
        } else {
            xM = 12;
            xMD = 16;
            WxM = 14;
            Set<Object> set = VR;
        }
        HashSet<Object> U = new HashSet<Object>();
        for (Object e : var14_45) {
            if (xM == 11) {
                for (Object p : G.getPredecessors(e)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                    break;
                }
            } else {
                for (Object p : G.getSuccessors(e)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                    break;
                }
            }
            if (!U.isEmpty()) break;
        }
        if (R.getVertices(xMD).containsAll((Collection<?>)var14_45) || U.isEmpty()) {
            Object e = var14_45.iterator().next();
            HashSet<Object> MAS1 = new HashSet<Object>();
            MAS1.add(e);
            Graph Gcv = Tools.copyDGraph(G);
            this.CompressGraph(Gcv, e);
            MAS1.addAll(this.MAS(Gcv, R));
            Graph<V, E> Gv = this.graphFactory.create();
            Tools.subGraph(G, Gv, e);
            G.removeVertex(e);
            Set<Object> MAS2 = this.MAS(G, R);
            Tools.mergeGraph(G, Gv);
            if (MAS1.size() > MAS2.size()) {
                return MAS1;
            }
            return MAS2;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll((Collection<Object>)var14_45);
        hashSet.addAll(R.getVertices(WxM));
        hashSet.removeAll(R.getVertices(xMD));
        U = new HashSet();
        Object v7 = null;
        for (Object h : hashSet) {
            U.clear();
            if (xM == 11) {
                for (Object p : G.getPredecessors(h)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                }
            } else {
                for (Object p : G.getSuccessors(h)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                }
            }
            if (U.size() < 4) continue;
            v7 = h;
            break;
        }
        if (v7 != null) {
            HashSet Uv = new HashSet();
            Iterator itru = U.iterator();
            int i5 = 0;
            while (i5 < 4) {
                Uv.add(itru.next());
                ++i5;
            }
            HashSet<Object> MAS1 = new HashSet<Object>();
            MAS1.add(v7);
            Graph Gcv = Tools.copyDGraph(G);
            this.CompressGraph(Gcv, v7);
            MarkMap<Object> Rp = new MarkMap<Object>(R);
            Rp.changeRole(Uv, xM);
            U.removeAll(Uv);
            Rp.changeRole(U, WxM);
            MAS1.addAll(this.MAS(Gcv, Rp));
            Graph<V, E> Gv = this.graphFactory.create();
            Tools.subGraph(G, Gv, v7);
            G.removeVertex(v7);
            Set<Object> MAS2 = this.MAS(G, R);
            Tools.mergeGraph(G, Gv);
            if (MAS1.size() > MAS2.size()) {
                return MAS1;
            }
            return MAS2;
        }
        v7 = null;
        int max = 0;
        HashSet X = null;
        for (Object h : hashSet) {
            U.clear();
            if (xM == 11) {
                for (Object p : G.getPredecessors(h)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                }
            } else {
                for (Object p : G.getSuccessors(h)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                }
            }
            if (U.size() <= max) continue;
            v7 = h;
            max = U.size();
            X = new HashSet(U);
        }
        long ncomb = (long)Math.pow(2.0, X.size());
        Object[] tabX = X.toArray();
        HashSet TYfinal = new HashSet();
        long i6 = 0L;
        while (i6 < ncomb) {
            HashSet<Object> Y = new HashSet<Object>();
            String comb = Long.toBinaryString(i6);
            int k = 0;
            while (k < comb.length()) {
                if (comb.charAt(k) == '1') {
                    Y.add(tabX[k]);
                }
                ++k;
            }
            HashSet X_Y = new HashSet(X);
            X_Y.removeAll(Y);
            Graph GY = Tools.copyDGraph(G);
            Tools.removeAllVertices(GY, X_Y);
            for (Object e : Y) {
                this.CompressGraph(GY, e);
            }
            MarkMap<Object> markMap = new MarkMap<Object>(R);
            if (Y.isEmpty()) {
                markMap.changeRole(v7, xMD);
            }
            HashSet<Object> TY = new HashSet<Object>();
            TY.addAll(this.MAS(GY, markMap));
            TY.addAll(Y);
            if (TY.size() > TYfinal.size()) {
                TYfinal = new HashSet(TY);
            }
            ++i6;
        }
        return TYfinal;
    }

    public Set<Set<V>> getABSeparators(Graph<V, E> G, V a, V b) {
        HashSet<Set<V>> SS = new HashSet<Set<V>>();
        if (!G.getNeighbors(a).contains(b)) {
            HashSet<V> Na = new HashSet<V>();
            Na.addAll(G.getNeighbors(a));
            Na.add(a);
            ArrayList<Set<V>> CC = Tools.getAllConnectedComponent(G, Na);
            for (Set<V> C : CC) {
                Set<V> Nc;
                if (!C.contains(b) || (Nc = Tools.getNeighbors(G, C)).isEmpty()) continue;
                SS.add(Nc);
            }
            HashSet<Set> T = new HashSet<Set>();
            HashSet<Set<V>> SdT = new HashSet<Set<V>>(SS);
            while (!SdT.isEmpty()) {
                Set S = (Set)SdT.iterator().next();
                for (Object x : S) {
                    HashSet SNx = new HashSet(S);
                    SNx.addAll(G.getNeighbors(x));
                    CC = Tools.getAllConnectedComponent(G, SNx);
                    for (Set<V> C : CC) {
                        Set<V> Nc = Tools.getNeighbors(G, C);
                        if (Nc.isEmpty() || !C.contains(b)) continue;
                        SS.add(Nc);
                    }
                }
                T.add(S);
                SdT = new HashSet<Set<V>>(SS);
                SdT.removeAll(T);
            }
        }
        return SS;
    }

    public Set<Set<V>> getAllMinimalSeparators(Graph<V, E> G) {
        HashSet<Set<V>> SS = new HashSet<Set<V>>();
        for (Object v : G.getVertices()) {
            HashSet Nv = new HashSet();
            Nv.addAll(G.getNeighbors(v));
            Nv.add(v);
            ArrayList<Set<V>> CC = Tools.getAllConnectedComponent(G, Nv);
            for (Set<V> C : CC) {
                Set<V> Nc = Tools.getNeighbors(G, C);
                if (Nc.isEmpty()) continue;
                SS.add(Nc);
            }
        }
        HashSet<Set> T = new HashSet<Set>();
        HashSet<Object> SdT = new HashSet(SS);
        while (!SdT.isEmpty()) {
            Set S = (Set)SdT.iterator().next();
            for (Object x : S) {
                HashSet SNx = new HashSet(S);
                SNx.addAll(G.getNeighbors(x));
                ArrayList<Set<V>> CC = Tools.getAllConnectedComponent(G, SNx);
                for (Set<V> C : CC) {
                    Set<V> Nc = Tools.getNeighbors(G, C);
                    if (Nc.isEmpty()) continue;
                    SS.add(Nc);
                }
            }
            T.add(S);
            SdT = new HashSet<Set<V>>(SS);
            SdT.removeAll(T);
        }
        return SS;
    }

    public Set<V> find2ApproximationCover(Graph<V, E> G) {
        HashSet<V> cover = new HashSet<V>();
        Graph Gp = Tools.copyGraph(G);
        while (Gp.getEdgeCount() > 0) {
            Object e = Gp.getEdges().iterator().next();
            V u = Gp.getEndpoints(e).getFirst();
            V v = Gp.getEndpoints(e).getSecond();
            cover.add(u);
            cover.add(v);
            Gp.removeVertex(u);
            Gp.removeVertex(v);
        }
        return cover;
    }

    public Set<V> findGreedyCover(Graph<V, E> G) {
        HashSet<V> cover = new HashSet<V>();
        Graph<V, E> Gp = Tools.copyGraph(G);
        while (Gp.getEdgeCount() > 0) {
            V v = Tools.getMaxDegVertex(Gp);
            cover.add(v);
            Gp.removeVertex(v);
        }
        return cover;
    }

    public boolean kVertexCoverBruteForce(Graph<V, E> G, int k, Set<V> VCfinal) {
        int nbe = G.getEdgeCount();
        if (nbe == 0) {
            if (this.VCbuf.size() < VCfinal.size() || VCfinal.isEmpty()) {
                VCfinal.clear();
                VCfinal.addAll(this.VCbuf);
            }
            return true;
        }
        if (nbe >= k * G.getVertexCount()) {
            return false;
        }
        Object e = G.getEdges().iterator().next();
        V x = G.getEndpoints(e).getFirst();
        V y = G.getEndpoints(e).getSecond();
        HashSet<V> oldVCbuf = new HashSet<V>(this.VCbuf);
        this.VCbuf.add(x);
        Graph<V, E> Gx = this.graphFactory.create();
        Tools.subGraph(G, Gx, x);
        G.removeVertex(x);
        boolean a = this.kVertexCoverBruteForce(G, k - 1, VCfinal);
        Tools.mergeGraph(G, Gx);
        this.VCbuf = new HashSet<V>(oldVCbuf);
        this.VCbuf.add(y);
        Graph<V, E> Gy = this.graphFactory.create();
        Tools.subGraph(G, Gy, y);
        G.removeVertex(y);
        boolean b = this.kVertexCoverBruteForce(G, k - 1, VCfinal);
        Tools.mergeGraph(G, Gy);
        return a || b;
    }

    public boolean kVertexCoverDBS(Graph<V, E> G, int k, Set<V> VCfinal) {
        int nbe;
        if (this.tracker != null) {
            this.tracker.increase("VC");
        }
        if ((nbe = G.getEdgeCount()) == 0) {
            if (this.VCbuf.size() < VCfinal.size() || VCfinal.isEmpty()) {
                VCfinal.clear();
                VCfinal.addAll(this.VCbuf);
            }
            return true;
        }
        if (nbe >= k * G.getVertexCount()) {
            return false;
        }
        V vone = Tools.getDegVertex(G, 1);
        if (vone != null) {
            HashSet<V> Nvone = new HashSet<V>(G.getNeighbors(vone));
            Graph<V, E> Gp = this.graphFactory.create();
            for (Object v : Nvone) {
                Tools.subGraph(G, Gp, v);
            }
            this.VCbuf.addAll(Nvone);
            Tools.removeAllVertices(G, Nvone);
            boolean b = this.kVertexCoverDBS(G, k - Nvone.size(), VCfinal);
            Tools.mergeGraph(G, Gp);
            this.VCbuf.removeAll(Nvone);
            return b;
        }
        V vtwo = Tools.getDegVertex(G, 2);
        if (vtwo != null) {
            Set<V> Nvtwo2 = Tools.getNeighbors(G, vtwo, 2);
            HashSet<V> Nvtwo = new HashSet<V>(G.getNeighbors(vtwo));
            Graph<V, E> GNv2 = this.graphFactory.create();
            Graph<V, E> GNv = this.graphFactory.create();
            Tools.subGraph(G, GNv2, vtwo);
            for (V v : Nvtwo2) {
                Tools.subGraph(G, GNv2, v);
            }
            this.VCbuf.add(vtwo);
            this.VCbuf.addAll(Nvtwo2);
            G.removeVertex(vtwo);
            Tools.removeAllVertices(G, Nvtwo2);
            boolean a = this.kVertexCoverDBS(G, k - Nvtwo2.size() - 1, VCfinal);
            Tools.mergeGraph(G, GNv2);
            this.VCbuf.remove(vtwo);
            this.VCbuf.removeAll(Nvtwo2);
            for (Object v : Nvtwo) {
                Tools.subGraph(G, GNv, v);
            }
            this.VCbuf.addAll(Nvtwo);
            Tools.removeAllVertices(G, Nvtwo);
            boolean b = this.kVertexCoverDBS(G, k - Nvtwo.size(), VCfinal);
            Tools.mergeGraph(G, GNv);
            this.VCbuf.removeAll(Nvtwo);
            return a || b;
        }
        V vmax = Tools.getMaxDegVertex(G);
        if (vmax != null && G.degree(vmax) >= 3) {
            HashSet<V> Nvmax = new HashSet<V>(G.getNeighbors(vmax));
            Graph<V, E> Gvmax = this.graphFactory.create();
            Graph<V, E> GNvmax = this.graphFactory.create();
            Tools.subGraph(G, Gvmax, vmax);
            this.VCbuf.add(vmax);
            G.removeVertex(vmax);
            boolean a = this.kVertexCoverDBS(G, k - 1, VCfinal);
            Tools.mergeGraph(G, Gvmax);
            this.VCbuf.remove(vmax);
            for (Object v : Nvmax) {
                Tools.subGraph(G, GNvmax, v);
            }
            this.VCbuf.addAll(Nvmax);
            Tools.removeAllVertices(G, Nvmax);
            boolean b = this.kVertexCoverDBS(G, k - Nvmax.size(), VCfinal);
            Tools.mergeGraph(G, GNvmax);
            this.VCbuf.removeAll(Nvmax);
            return a || b;
        }
        return this.kVertexCoverDBS(G, k, VCfinal);
    }

    public boolean kVertexCoverKernel(Graph<V, E> G, int k, Set<V> VCfinal) {
        V vmax;
        int nbe;
        if (this.tracker != null) {
            this.tracker.increase("VC");
        }
        if ((nbe = G.getEdgeCount()) == 0) {
            if (this.VCbuf.size() < VCfinal.size() || VCfinal.isEmpty()) {
                VCfinal.clear();
                VCfinal.addAll(this.VCbuf);
            }
            return true;
        }
        if (nbe >= k * G.getVertexCount()) {
            return false;
        }
        Set<Object> K = new HashSet();
        V vmin = Tools.getMinDegVertex(G);
        int degmin = G.degree(vmin);
        int degmax = Tools.getMaxDeg(G);
        Graph<V, E> Gp = G;
        if (degmin == 0 || degmin == 1 || degmax > k) {
            Gp = Tools.copyGraph(G);
            K = this.KernelizationBussVC(Gp, k);
            k -= K.size();
            this.VCbuf.addAll(K);
        }
        if ((vmax = Tools.getMaxDegVertex(Gp)) == null) {
            return this.kVertexCoverKernel(Gp, k, VCfinal);
        }
        HashSet<V> oldVCbuf = new HashSet<V>(this.VCbuf);
        int degvmax = Gp.degree(vmax);
        this.VCbuf.add(vmax);
        Graph<V, E> Gvmax = this.graphFactory.create();
        Tools.subGraph(Gp, Gvmax, vmax);
        Gp.removeVertex(vmax);
        boolean a = this.kVertexCoverKernel(Gp, k - 1, VCfinal);
        Tools.mergeGraph(Gp, Gvmax);
        this.VCbuf = new HashSet<V>(oldVCbuf);
        Graph<V, E> GNvmax = this.graphFactory.create();
        if (degvmax > 0) {
            HashSet<V> Nvmax = new HashSet<V>(Gp.getNeighbors(vmax));
            for (Object nv : Nvmax) {
                Tools.subGraph(Gp, GNvmax, nv);
            }
            this.VCbuf.addAll(Nvmax);
            Tools.removeAllVertices(Gp, Nvmax);
        }
        boolean b = this.kVertexCoverKernel(Gp, k - degvmax, VCfinal);
        Tools.mergeGraph(Gp, GNvmax);
        return a || b;
    }

    public boolean kVertexCoverNiedermeier(Graph<V, E> G, int k, Set<V> VCfinal) {
        int nbe;
        if (this.tracker != null) {
            this.tracker.increase("VC");
        }
        if ((nbe = G.getEdgeCount()) == 0) {
            if (this.VCbuf.size() < VCfinal.size() || VCfinal.isEmpty()) {
                VCfinal.clear();
                VCfinal.addAll(this.VCbuf);
            }
            return true;
        }
        if (nbe >= k * G.getVertexCount()) {
            return false;
        }
        if (Tools.getMinDeg(G) == 0) {
            Graph<V, E> Gp = this.graphFactory.create();
            Set<Object> vZeros = Tools.getAllMinDegVertex(G);
            for (Object v : vZeros) {
                Tools.subGraph(G, Gp, v);
            }
            Tools.removeAllVertices(G, vZeros);
            boolean b = this.kVertexCoverNiedermeier(G, k, VCfinal);
            Tools.mergeGraph(G, Gp);
            return b;
        }
        Object vone = Tools.getDegVertex(G, 1);
        if (vone != null) {
            Graph<V, E> Gp = this.graphFactory.create();
            Object Nvone = G.getNeighbors(vone).iterator().next();
            this.VCbuf.add(Nvone);
            Tools.subGraph(G, Gp, Nvone);
            G.removeVertex(Nvone);
            boolean b = this.kVertexCoverNiedermeier(G, k - 1, VCfinal);
            Tools.mergeGraph(G, Gp);
            this.VCbuf.remove(Nvone);
            return b;
        }
        Object vfivemore = Tools.getMaxDegVertex(G);
        if (G.degree(vfivemore) >= 5) {
            HashSet<Object> Nvfivemore = new HashSet<Object>(G.getNeighbors(vfivemore));
            Graph<V, E> Gf = this.graphFactory.create();
            Graph<V, E> GNf = this.graphFactory.create();
            Tools.subGraph(G, Gf, vfivemore);
            this.VCbuf.add(vfivemore);
            G.removeVertex(vfivemore);
            boolean bx = this.kVertexCoverNiedermeier(G, k - 1, VCfinal);
            Tools.mergeGraph(G, Gf);
            this.VCbuf.remove(vfivemore);
            this.VCbuf.addAll(Nvfivemore);
            for (Object v : Nvfivemore) {
                Tools.subGraph(G, GNf, v);
            }
            Tools.removeAllVertices(G, Nvfivemore);
            boolean bnx = this.kVertexCoverNiedermeier(G, k - Nvfivemore.size(), VCfinal);
            Tools.mergeGraph(G, GNf);
            this.VCbuf.removeAll(Nvfivemore);
            return bx || bnx;
        }
        if (Tools.isRegular(G)) {
            Object v = G.getVertices().iterator().next();
            HashSet Nv = new HashSet(G.getNeighbors(v));
            Graph<V, E> Gv = this.graphFactory.create();
            Graph<V, E> GNv = this.graphFactory.create();
            Tools.subGraph(G, Gv, v);
            this.VCbuf.add(v);
            G.removeVertex(v);
            boolean bx = this.kVertexCoverNiedermeier(G, k - 1, VCfinal);
            Tools.mergeGraph(G, Gv);
            this.VCbuf.remove(v);
            this.VCbuf.addAll(Nv);
            for (Object x : Nv) {
                Tools.subGraph(G, GNv, x);
            }
            Tools.removeAllVertices(G, Nv);
            boolean bnx = this.kVertexCoverNiedermeier(G, k - Nv.size(), VCfinal);
            Tools.mergeGraph(G, GNv);
            this.VCbuf.removeAll(Nv);
            return bx || bnx;
        }
        Object vtwo = null;
        vtwo = Tools.getDegVertex(G, 2);
        if (vtwo != null) {
            Object vb;
            Iterator<Object> itrvtwo = G.getNeighbors(vtwo).iterator();
            Object va = itrvtwo.next();
            if (Tools.isEdge(G, va, vb = itrvtwo.next())) {
                Graph<V, E> Gp = this.graphFactory.create();
                this.VCbuf.add(va);
                this.VCbuf.add(vb);
                Tools.subGraph(G, Gp, va);
                Tools.subGraph(G, Gp, vb);
                G.removeVertex(va);
                G.removeVertex(vb);
                boolean b = this.kVertexCoverNiedermeier(G, k - 2, VCfinal);
                Tools.mergeGraph(G, Gp);
                this.VCbuf.remove(va);
                this.VCbuf.remove(vb);
                return b;
            }
            if (!Tools.isEdge(G, va, vb) && G.degree(va) == 2 && G.degree(vb) == 2) {
                HashSet<Object> Nva = new HashSet<Object>(G.getNeighbors(va));
                HashSet<Object> Nvb = new HashSet<Object>(G.getNeighbors(vb));
                Nva.remove(vtwo);
                Nvb.remove(vtwo);
                if (Nva.equals(Nvb)) {
                    Graph<V, E> Gp = this.graphFactory.create();
                    this.VCbuf.add(vtwo);
                    this.VCbuf.add(Nva.iterator().next());
                    Tools.subGraph(G, Gp, vtwo);
                    Tools.subGraph(G, Gp, Nva.iterator().next());
                    G.removeVertex(vtwo);
                    G.removeVertex(Nva.iterator().next());
                    boolean b = this.kVertexCoverNiedermeier(G, k - 2, VCfinal);
                    Tools.mergeGraph(G, Gp);
                    this.VCbuf.remove(vtwo);
                    this.VCbuf.remove(Nva.iterator().next());
                    return b;
                }
            }
            HashSet<Object> Nx = new HashSet<Object>(G.getNeighbors(vtwo));
            HashSet<Object> Na = new HashSet<Object>(G.getNeighbors(va));
            HashSet<Object> Nb = new HashSet<Object>(G.getNeighbors(vb));
            HashSet NaNb = new HashSet();
            Sets.union(Na, Nb).copyInto(NaNb);
            Graph<V, E> GNx = this.graphFactory.create();
            Graph<V, E> GNaNb = this.graphFactory.create();
            this.VCbuf.addAll(Nx);
            for (Object e : Nx) {
                Tools.subGraph(G, GNx, e);
            }
            Tools.removeAllVertices(G, Nx);
            boolean bl = this.kVertexCoverNiedermeier(G, k - Nx.size(), VCfinal);
            this.VCbuf.removeAll(Nx);
            Tools.mergeGraph(G, GNx);
            this.VCbuf.addAll(NaNb);
            for (Object e : NaNb) {
                Tools.subGraph(G, GNaNb, e);
            }
            Tools.removeAllVertices(G, NaNb);
            boolean bl2 = this.kVertexCoverNiedermeier(G, k - NaNb.size(), VCfinal);
            Tools.mergeGraph(G, GNaNb);
            this.VCbuf.removeAll(NaNb);
            return bl || bl2;
        }
        Object vthree = null;
        vthree = Tools.getDegVertex(G, 3);
        if (vthree != null) {
            Iterator<Object> itrvthree = G.getNeighbors(vthree).iterator();
            Object va = itrvthree.next();
            Object vb = itrvthree.next();
            Object vc = itrvthree.next();
            Object t = null;
            if (Tools.isEdge(G, va, vb)) {
                t = vc;
            } else if (Tools.isEdge(G, va, vc)) {
                t = vb;
            } else if (Tools.isEdge(G, vb, vc)) {
                t = va;
            }
            if (t != null) {
                HashSet<Object> Nx = new HashSet<Object>(G.getNeighbors(vthree));
                HashSet<Object> Nt = new HashSet<Object>(G.getNeighbors(t));
                Graph<V, E> GNx = this.graphFactory.create();
                Graph<V, E> graph = this.graphFactory.create();
                this.VCbuf.addAll(Nx);
                for (Object e : Nx) {
                    Tools.subGraph(G, GNx, e);
                }
                Tools.removeAllVertices(G, Nx);
                boolean bl = this.kVertexCoverNiedermeier(G, k - Nx.size(), VCfinal);
                this.VCbuf.removeAll(Nx);
                Tools.mergeGraph(G, GNx);
                this.VCbuf.addAll(Nt);
                for (Object e : Nt) {
                    Tools.subGraph(G, graph, e);
                }
                Tools.removeAllVertices(G, Nt);
                boolean bl3 = this.kVertexCoverNiedermeier(G, k - Nt.size(), VCfinal);
                Tools.mergeGraph(G, graph);
                this.VCbuf.removeAll(Nt);
                return bl || bl3;
            }
            HashSet<Object> Na = new HashSet<Object>(G.getNeighbors(va));
            HashSet<Object> Nb = new HashSet<Object>(G.getNeighbors(vb));
            HashSet<Object> Nc = new HashSet<Object>(G.getNeighbors(vc));
            HashSet hashSet = new HashSet();
            if (!Sets.intersection(Na, Nb).isEmpty()) {
                Sets.intersection(Na, Nb).copyInto(hashSet);
            } else if (!Sets.intersection(Na, Nc).isEmpty()) {
                Sets.intersection(Na, Nc).copyInto(hashSet);
            } else if (!Sets.intersection(Nb, Nc).isEmpty()) {
                Sets.intersection(Nb, Nc).copyInto(hashSet);
            }
            if (!hashSet.isEmpty()) {
                Object e = hashSet.iterator().next();
                HashSet<Object> hashSet2 = new HashSet<Object>(G.getNeighbors(vthree));
                HashSet<Object> xd = new HashSet<Object>();
                xd.add(vthree);
                xd.add(e);
                Graph<V, E> GNx = this.graphFactory.create();
                Graph<V, E> graph = this.graphFactory.create();
                this.VCbuf.addAll(hashSet2);
                for (Object e2 : hashSet2) {
                    Tools.subGraph(G, GNx, e2);
                }
                Tools.removeAllVertices(G, hashSet2);
                boolean bl = this.kVertexCoverNiedermeier(G, k - hashSet2.size(), VCfinal);
                this.VCbuf.removeAll(hashSet2);
                Tools.mergeGraph(G, GNx);
                this.VCbuf.addAll(xd);
                for (Object v : xd) {
                    Tools.subGraph(G, graph, v);
                }
                Tools.removeAllVertices(G, xd);
                boolean bxd = this.kVertexCoverNiedermeier(G, k - xd.size(), VCfinal);
                Tools.mergeGraph(G, graph);
                this.VCbuf.removeAll(xd);
                return bl || bxd;
            }
            HashSet<Object> hashSet3 = new HashSet<Object>(G.getNeighbors(vthree));
            Graph<V, E> graph = this.graphFactory.create();
            Graph<V, E> GNa = this.graphFactory.create();
            Graph<V, E> GaNbNc = this.graphFactory.create();
            this.VCbuf.addAll(hashSet3);
            for (Object e : hashSet3) {
                Tools.subGraph(G, graph, e);
            }
            Tools.removeAllVertices(G, hashSet3);
            boolean bl = this.kVertexCoverNiedermeier(G, k - hashSet3.size(), VCfinal);
            this.VCbuf.removeAll(hashSet3);
            Tools.mergeGraph(G, graph);
            this.VCbuf.addAll(Na);
            for (Object e : Na) {
                Tools.subGraph(G, GNa, e);
            }
            Tools.removeAllVertices(G, Na);
            boolean bl4 = this.kVertexCoverNiedermeier(G, k - Na.size(), VCfinal);
            Tools.mergeGraph(G, GNa);
            this.VCbuf.removeAll(Na);
            HashSet<Object> aNbNc = new HashSet<Object>();
            aNbNc.add(va);
            aNbNc.addAll(Nb);
            aNbNc.addAll(Nc);
            this.VCbuf.addAll(aNbNc);
            for (Object e : aNbNc) {
                Tools.subGraph(G, GaNbNc, e);
            }
            Tools.removeAllVertices(G, aNbNc);
            boolean bl5 = this.kVertexCoverNiedermeier(G, k - aNbNc.size(), VCfinal);
            Tools.mergeGraph(G, GaNbNc);
            this.VCbuf.removeAll(aNbNc);
            return bl || bl4 || bl5;
        }
        return this.kVertexCoverNiedermeier(G, k, VCfinal);
    }

    public Set<V> KernelizationBussVC(Graph<V, E> G, int k) {
        Set<Object> VC = new HashSet();
        if (G.getVertexCount() == 0) {
            return VC;
        }
        V x = Tools.getMinDegVertex(G);
        int degx = G.degree(x);
        if (degx == 0) {
            G.removeVertex(x);
            return this.KernelizationBussVC(G, k);
        }
        if (degx == 1) {
            V y = G.getNeighbors(x).iterator().next();
            G.removeVertex(x);
            G.removeVertex(y);
            VC = this.KernelizationBussVC(G, k - 1);
            VC.add(y);
        }
        x = Tools.getMaxDegVertex(G);
        degx = -1;
        if (x != null) {
            degx = G.degree(x);
        }
        if (degx > k) {
            G.removeVertex(x);
            VC = this.KernelizationBussVC(G, k - 1);
            VC.add(x);
        }
        return VC;
    }

    public Set<V> MaximalIndependentSetGreedy(Graph<V, E> G_) {
        Graph<Object, E> G = Tools.copyGraph(G_);
        HashSet<V> S = new HashSet<V>();
        HashSet<Object> M = new HashSet<Object>();
        while (!G.getVertices().isEmpty()) {
            for (Object e : M) {
                G.removeVertex(e);
            }
            V v = Tools.getMinDegVertex(G);
            if (v == null) continue;
            S.add(v);
            M.add(v);
            HashSet<V> N = new HashSet<V>();
            if (G.getNeighbors(v) == null) continue;
            N.addAll(G.getNeighbors(v));
            for (Object y : N) {
                M.add(y);
            }
        }
        return S;
    }

    public Set MaximumIndependentSetBruteForce(Graph<V, E> G) {
        HashSet S = new HashSet();
        long ncomb = (long)Math.pow(2.0, G.getVertexCount());
        Object[] nodes = G.getVertices().toArray();
        long i = 0L;
        while (i < ncomb) {
            HashSet<Object> Sp = new HashSet<Object>();
            String comb = Long.toBinaryString(i);
            int k = 0;
            while (k < comb.length()) {
                if (comb.charAt(k) == '1') {
                    Sp.add(nodes[k]);
                }
                ++k;
            }
            if (Tools.isIndependentSet(G, Sp) && Sp.size() > S.size()) {
                S = Sp;
            }
            ++i;
        }
        return S;
    }

    public Set<V> MaximumIndependentSetMM(Graph<V, E> G, Set<V> S) {
        if (!G.getVertices().isEmpty()) {
            V v = Tools.getMinDegVertex(G);
            HashSet<V> Nv = new HashSet<V>();
            Nv.addAll(G.getNeighbors(v));
            Nv.add(v);
            Set<Object> Smax = new HashSet();
            for (Object u : Nv) {
                Graph Gp = Tools.copyGraph(G);
                HashSet Nu = new HashSet();
                Nu.addAll(G.getNeighbors(u));
                Nu.add(u);
                Set<Object> Stemp = new HashSet();
                HashSet<Object> Su = new HashSet<Object>();
                Su.addAll(S);
                Su.add(u);
                for (Object nu : Nu) {
                    Gp.removeVertex(nu);
                }
                Stemp = this.MaximumIndependentSetMM(Gp, Su);
                if (Stemp.size() <= Smax.size()) continue;
                Smax = Stemp;
            }
            return Smax;
        }
        return S;
    }

    public Set<V> MaximumIndependentSetMM_NR(Graph<V, E> G_) {
        Stack<Graph<V, E>> stackG = new Stack<Graph<V, E>>();
        Stack stackS = new Stack();
        Set Smax = new HashSet();
        stackG.push(G_);
        stackS.push(new HashSet());
        while (!stackG.empty()) {
            Graph G = (Graph)stackG.pop();
            Set S = (Set)stackS.pop();
            if (!G.getVertices().isEmpty()) {
                Object v = Tools.getMinDegVertex(G);
                HashSet Nv = new HashSet();
                Nv.addAll(G.getNeighbors(v));
                Nv.add(v);
                for (Object u : Nv) {
                    Graph Gp = Tools.copyGraph(G);
                    HashSet Nu = new HashSet();
                    Nu.addAll(G.getNeighbors(u));
                    Nu.add(u);
                    HashSet Su = new HashSet();
                    Su.addAll(S);
                    Su.add(u);
                    for (Object nu : Nu) {
                        Gp.removeVertex(nu);
                    }
                    stackG.push(Gp);
                    stackS.push(Su);
                }
                continue;
            }
            if (S.size() <= Smax.size()) continue;
            Smax = S;
        }
        return Smax;
    }

    public Set<V> MaximumIndependentSetDegMaX(Graph<V, E> G) {
        int degmax = Tools.getMaxDeg(G);
        Set<Object> S = new HashSet();
        if (degmax >= 3) {
            V x = Tools.getMaxDegVertex(G);
            HashSet<V> Nx = new HashSet<V>();
            Nx.addAll(G.getNeighbors(x));
            Nx.add(x);
            Graph<V, E> Gp = this.graphFactory.create();
            for (Object nx : Nx) {
                Tools.subGraph(G, Gp, nx);
            }
            for (Object nx : Nx) {
                G.removeVertex(nx);
            }
            S = this.MaximumIndependentSetDegMaX(G);
            Tools.mergeGraph(G, Gp);
            S.add(x);
            Set<Object> S_ = new HashSet();
            Graph<V, E> Gpp = this.graphFactory.create();
            Tools.subGraph(G, Gpp, x);
            G.removeVertex(x);
            S_ = this.MaximumIndependentSetDegMaX(G);
            Tools.mergeGraph(G, Gpp);
            if (S_.size() > S.size()) {
                S = S_;
            }
        } else {
            S = this.MaximalIndependentSetGreedy(G);
        }
        return S;
    }

    public Set<V> MaximumIndependentSetFGK(Graph<V, E> G) {
        int Vsize;
        if (this.tracker != null) {
            this.tracker.increase("FGK");
        }
        if ((Vsize = G.getVertices().size()) <= 1) {
            return new HashSet(G.getVertices());
        }
        Set C = Tools.getConnectedComponent(G);
        if (!C.isEmpty() && C.size() < Vsize) {
            Graph<Object, Object> GC = Tools.copyGraph(G);
            Graph<Object, Object> G_C = Tools.copyGraph(G);
            HashSet toKeep = new HashSet(G.getVertices());
            for (Object c : toKeep) {
                if (C.contains(c)) continue;
                GC.removeVertex(c);
            }
            for (Object c : C) {
                G_C.removeVertex(c);
            }
            HashSet<Object> U = new HashSet<Object>();
            U.addAll(this.MaximumIndependentSetFGK(GC));
            U.addAll(this.MaximumIndependentSetFGK(G_C));
            return U;
        }
        Object v = Tools.getDominatedVertex(G);
        if (v != null) {
            if (this.tracker != null) {
                this.tracker.increase("DomV");
            }
            Graph<Object, Object> G_v = Tools.copyGraph(G);
            G_v.removeVertex(v);
            return this.MaximumIndependentSetFGK(G_v);
        }
        boolean deg2 = false;
        Object x = null;
        Iterator itr = G.getVertices().iterator();
        while (!deg2 && itr.hasNext()) {
            x = itr.next();
            if (G.getNeighbors(x).size() != 2) continue;
            deg2 = true;
        }
        if (deg2) {
            if (this.tracker != null) {
                this.tracker.increase("Fold");
            }
            HashSet<Object> uF = new HashSet<Object>();
            HashMap vftable = new HashMap();
            Set<Object> F = this.MaximumIndependentSetFGK(Tools.getFoldingGraph(G, x, vftable, this.vertexFactory, this.edgeFactory));
            boolean fold = false;
            for (Object object : F) {
                if (vftable.containsKey(object)) {
                    uF.addAll((Collection)vftable.get(object));
                    fold = true;
                    continue;
                }
                uF.add(object);
            }
            if (!fold) {
                uF.add(x);
            }
            return uF;
        }
        Set<Object> Mdeg = Tools.getAllMaxDegVertex(G);
        Object d = null;
        int ENv = Integer.MAX_VALUE;
        for (Object y : Mdeg) {
            int ENy = Tools.getNbEdges(G, new HashSet<Object>(G.getNeighbors(y)));
            if (ENy >= ENv) continue;
            ENv = ENy;
            d = y;
        }
        Graph<Object, Object> G_v_Mv = Tools.copyGraph(G);
        Graph<Object, Object> graph = Tools.copyGraph(G);
        G_v_Mv.removeVertex(d);
        Set<Object> M = Tools.getMirrors(G, d);
        for (Object object : M) {
            G_v_Mv.removeVertex(object);
        }
        HashSet<Object> hashSet = new HashSet<Object>(G.getNeighbors(d));
        for (Object e : hashSet) {
            graph.removeVertex(e);
        }
        graph.removeVertex(d);
        Set<Object> set = this.MaximumIndependentSetFGK(G_v_Mv);
        Set<Object> S2 = this.MaximumIndependentSetFGK(graph);
        S2.add(d);
        if (set.size() > S2.size()) {
            if (this.tracker != null) {
                this.tracker.increase("M branch(" + M.size() + ")");
            }
            return set;
        }
        if (this.tracker != null) {
            this.tracker.increase("Nv branch");
        }
        return S2;
    }

    public int ChromaticNumber(Graph<V, E> G) {
        double n = G.getVertexCount();
        int best = (int)n;
        long ncomb = (long)Math.pow(2.0, best);
        Object[] nodes = G.getVertices().toArray();
        long i = 1L;
        while (i < ncomb) {
            HashSet<Object> S = new HashSet<Object>();
            String comb = Long.toBinaryString(i);
            int k = 0;
            while (k < comb.length()) {
                if (comb.charAt(k) == '1') {
                    S.add(nodes[k]);
                }
                ++k;
            }
            if (Tools.isMaximalIndependentSet(G, S) && (double)S.size() >= 0.19903 * n) {
                Graph<V, E> GS = this.graphFactory.create();
                Tools.subGraph(G, GS, S);
                Tools.removeAllVertices(G, S);
                int cnG_S = this.ChromaticNumber(G);
                Tools.mergeGraph(G, GS);
                best = Math.min(best, 1 + cnG_S);
            }
            if ((n - 0.19903 * n) / 2.0 <= (double)S.size() && (double)S.size() <= (n + 0.19903 * n) / 2.0) {
                Graph<V, E> GS = this.graphFactory.create();
                Tools.subGraph(G, GS, S);
                HashSet V_S = new HashSet();
                Sets.difference(new HashSet(G.getVertices()), S).copyInto(V_S);
                Tools.removeAllVertices(G, V_S);
                int cnGS = this.ChromaticNumber(G);
                Tools.mergeGraph(G, GS);
                Graph<V, E> G_S = this.graphFactory.create();
                Tools.subGraph(G, G_S, S);
                Tools.removeAllVertices(G, S);
                int cnG_S = this.ChromaticNumber(G);
                Tools.mergeGraph(G, G_S);
                best = Math.min(best, cnGS + cnG_S);
            }
            ++i;
        }
        return best;
    }
}

