/*
 * Decompiled with CFR 0.152.
 */
package JungAGAPE;

import JungAGAPE.Algos;
import JungAGAPE.Tools;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import org.apache.commons.collections15.Factory;

public class Bench {
    public static void main(String[] args) throws IOException, InterruptedException, InstantiationException, IllegalAccessException {
        String folder = "./GenGraphs/ER/";
        PrintWriter pfile = new PrintWriter(new BufferedWriter(new FileWriter("AllMinSep.csv")));
        PrintWriter kfile = new PrintWriter(new BufferedWriter(new FileWriter("VC_k.csv")));
        int n = 5;
        while (n <= 50) {
            int ip = 10;
            double p = 0.5;
            String Sp = "0.01";
            Graph<String, Integer> G = Tools.readNet(String.valueOf(folder) + "ERgraph_n" + n + "p" + p + ".net");
            int ei = G.getEdgeCount();
            int vi = G.getVertexCount();
            Algos<String, Integer> alg = new Algos<String, Integer>();
            Factory<Integer> edgeFactory = new Factory<Integer>(ei){
                int c;
                {
                    this.c = n;
                }

                @Override
                public Integer create() {
                    ++this.c;
                    return this.c;
                }
            };
            Factory<String> vertexFactory = new Factory<String>(vi){
                int c;
                {
                    this.c = n;
                }

                @Override
                public String create() {
                    ++this.c;
                    return "v" + this.c;
                }
            };
            Factory<Graph<String, Integer>> graphFactory = new Factory<Graph<String, Integer>>(){

                @Override
                public Graph<String, Integer> create() {
                    return new UndirectedSparseGraph<String, Integer>();
                }
            };
            alg.setEdgeFactoy(edgeFactory);
            alg.setVertexFactoy(vertexFactory);
            alg.setGraphFactoy(graphFactory);
            alg.initTracker();
            double t = 0.0;
            HashSet S = new HashSet();
            HashSet A = new HashSet();
            int k = alg.findGreedyCover(G).size();
            t = System.currentTimeMillis();
            System.out.println(alg.getAllMinimalSeparators(G).size());
            t = (double)System.currentTimeMillis() - t;
            k = S.size();
            pfile.print(String.valueOf(t) + ";");
            kfile.print(String.valueOf(k) + ";");
            pfile.flush();
            kfile.flush();
            System.out.println(t / 1000.0);
            System.out.println("n:" + G.getVertexCount() + " " + ip + " k:" + k);
            System.out.println(alg.getTracker());
            pfile.println();
            kfile.println();
            pfile.flush();
            kfile.flush();
            System.out.println();
            n += 5;
        }
        pfile.close();
        kfile.close();
    }
}

