/*
 * Decompiled with CFR 0.152.
 */
package JungAGAPE;

import JungAGAPE.Algos;
import JungAGAPE.Tools;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections15.Factory;

public class BenchStandAlone {
    static boolean directed = false;
    static Set S = new HashSet();
    static final int MISBF = 100;
    static final int MISMM = 101;
    static final int MISDegMax = 102;
    static final int MISFGK = 103;
    static final int MVCBF = 104;
    static final int MVCKern = 105;
    static final int MVCN = 106;
    static final int MVCDBS = 107;
    static final int DFVS = 108;

    public static ArrayList<File> listFiles(String directoryPath) {
        ArrayList<File> files = new ArrayList();
        File directoryToScan = new File(directoryPath);
        files = new ArrayList<File>(Arrays.asList(directoryToScan.listFiles()));
        return files;
    }

    public static double launchAlgorithm(Graph<String, Integer> G, int algo) {
        System.out.println("V:" + G.getVertexCount() + " E:" + G.getEdgeCount());
        int ei = G.getEdgeCount();
        int vi = G.getVertexCount();
        Factory<Integer> edgeFactory = new Factory<Integer>(ei){
            int c;
            {
                this.c = n;
            }

            @Override
            public Integer create() {
                ++this.c;
                return this.c;
            }
        };
        Factory<String> vertexFactory = new Factory<String>(vi){
            int c;
            {
                this.c = n;
            }

            @Override
            public String create() {
                ++this.c;
                return "v" + this.c;
            }
        };
        Factory<Graph<String, Integer>> graphFactory = new Factory<Graph<String, Integer>>(){

            @Override
            public Graph<String, Integer> create() {
                return new UndirectedSparseGraph<String, Integer>();
            }
        };
        Factory<Graph<String, Integer>> DgraphFactory = new Factory<Graph<String, Integer>>(){

            @Override
            public Graph<String, Integer> create() {
                return new DirectedSparseGraph<String, Integer>();
            }
        };
        Algos<String, Integer> alg = new Algos<String, Integer>();
        alg.setEdgeFactoy(edgeFactory);
        alg.setVertexFactoy(vertexFactory);
        if (!directed) {
            alg.setGraphFactoy(graphFactory);
        } else {
            alg.setGraphFactoy(DgraphFactory);
        }
        double t = 0.0;
        HashSet A = new HashSet();
        int k = 0;
        switch (algo) {
            case 100: {
                t = System.currentTimeMillis();
                S = alg.MaximumIndependentSetBruteForce(G);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 101: {
                t = System.currentTimeMillis();
                S = alg.MaximumIndependentSetMM(G, A);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 102: {
                t = System.currentTimeMillis();
                S = alg.MaximumIndependentSetDegMaX(G);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 103: {
                t = System.currentTimeMillis();
                S = alg.MaximumIndependentSetFGK(G);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 104: {
                k = alg.findGreedyCover(G).size();
                t = System.currentTimeMillis();
                alg.kVertexCoverBruteForce(G, k, S);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 105: {
                k = alg.findGreedyCover(G).size();
                t = System.currentTimeMillis();
                alg.kVertexCoverKernel(G, k, S);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 107: {
                k = alg.findGreedyCover(G).size();
                t = System.currentTimeMillis();
                alg.kVertexCoverDBS(G, k, S);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 106: {
                k = alg.findGreedyCover(G).size();
                t = System.currentTimeMillis();
                alg.kVertexCoverNiedermeier(G, k, S);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 108: {
                Graph<String, Integer> Gp = null;
                Gp = Tools.copyDGraph(G);
                System.out.println("isAcyclic:" + Tools.isAcyclic(Gp));
                Set<String> approx = alg.findGreedyFVS(Gp);
                System.out.println("Greedy approx:" + approx.size());
                t = System.currentTimeMillis();
                S = alg.MaximumDirectedAcyclicSubset(Gp);
                t = (double)System.currentTimeMillis() - t;
                HashSet FVS = new HashSet(G.getVertices());
                FVS.removeAll(S);
                S = FVS;
            }
        }
        return t;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.print("Usage: \njava -jar AGAPE.jar graphfilepath|graphdirectorypath algorithm [D] \n\ngraphfilepath|graphdirectorypath:    use mygraph.net to apply an algorithm on a simple graph, use mydirectory/ to apply algorithm on a series of graph.\nalgorithm:   specify algorithm (MISBF, MISMM, MISDegMax, MISFGK, MVCBF, MVCKern, MVCDBS, MVCN, DFVS).\n[D] (optional):  use if graph is directed.\n");
            return;
        }
        String folder = args[0];
        int algo = 0;
        if (args[1].equals("MISBF")) {
            algo = 100;
        }
        if (args[1].equals("MISMM")) {
            algo = 101;
        }
        if (args[1].equals("MISDegMax")) {
            algo = 102;
        }
        if (args[1].equals("MISFGK")) {
            algo = 103;
        }
        if (args[1].equals("MVCBF")) {
            algo = 104;
        }
        if (args[1].equals("MVCKern")) {
            algo = 105;
        }
        if (args[1].equals("MVCDBS")) {
            algo = 107;
        }
        if (args[1].equals("MVCN")) {
            algo = 106;
        }
        if (args[1].equals("DFVS")) {
            algo = 108;
        }
        if (args.length > 2 && args[2].equals("D")) {
            directed = true;
        }
        if (folder.contains(".net")) {
            Graph<String, Integer> G = null;
            G = !directed ? Tools.readNet(folder) : Tools.readDNet(folder);
            Graph<String, Integer> Gp = null;
            Gp = !directed ? Tools.copyGraph(G) : Tools.copyDGraph(G);
            double t = BenchStandAlone.launchAlgorithm(Gp, algo);
            System.out.println(S);
            System.out.println(BenchStandAlone.printTime(t));
            if (algo == 108) {
                System.out.println("Size: " + S.size());
                Tools.removeAllVertices(G, S);
                System.out.println("isAcyclic:" + Tools.isAcyclic(G));
            }
        }
    }

    public static String printTime(double t) {
        String r = String.valueOf(t) + " ms\n";
        double tt = t / 1000.0;
        r = String.valueOf(r) + tt + " s";
        r = String.valueOf(r) + "\n" + (tt /= 60.0) + " mins";
        r = String.valueOf(r) + "\n" + (tt /= 60.0) + " h";
        r = String.valueOf(r) + "\n" + (tt /= 24.0) + " d";
        return r;
    }
}

