/*
 * Decompiled with CFR 0.152.
 */
package JungAGAPE;

import JungAGAPE.Tools;
import edu.uci.ics.jung.graph.Graph;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExportGV {
    public static void main(String[] args) {
        Graph<String, Integer> G = Tools.readDNet("GenGraphs/AlbertBPowerLawtest/AlbertBPLgraph_n10000e2.net");
        try {
            ExportGV.writeGV("test", G);
        }
        catch (IOException ex) {
            Logger.getLogger(ExportGV.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void writeGV(String fname, Graph<String, Integer> G) throws IOException {
        PrintWriter pfile = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(fname) + ".gv")));
        pfile.println("digraph G {");
        pfile.println("size=\"100,20\"; ratio = auto;");
        pfile.println("node [style=filled];");
        for (Integer e : G.getEdges()) {
            pfile.println("\"" + G.getSource(e) + "\" -> \"" + G.getDest(e) + "\" [color=\"0.649 0.701 0.701\"];");
        }
        for (String x : G.getVertices()) {
            pfile.print("\"" + x + "\" ");
            pfile.print("[color=grey];\n");
        }
        pfile.println("}");
        pfile.flush();
        pfile.close();
    }
}

