/*
 * Decompiled with CFR 0.152.
 */
package JungAGAPE;

import JungAGAPE.Algos;
import JungAGAPE.Tools;
import agape.tools.Pair;
import edu.uci.ics.jung.algorithms.generators.Lattice2DGenerator;
import edu.uci.ics.jung.algorithms.generators.random.BarabasiAlbertGenerator;
import edu.uci.ics.jung.algorithms.generators.random.EppsteinPowerLawGenerator;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections15.Factory;

public class GenerateGraph {
    public static final int FGK = 1;
    public static final int MINSEP = 2;
    public static final int ER = 100;
    public static final int dER = 1001;
    public static final int EPL = 101;
    public static final int ABPL = 102;
    public static final int LAT = 103;
    public static final int KSW = 104;
    public static final int WSSW = 105;
    public static final int REG = 106;
    public static final int REGR = 107;
    public static final int HARD = 108;
    public static final int SEP = 109;

    public static void main(String[] args) {
        int nl;
        String folder = "./GenGraphs/";
        String gname = "";
        String ext = "";
        int ch = 106;
        int d = 3;
        int k = 4;
        int n = 1000;
        int ne = 2;
        int nhard = 200;
        double p = 0.04;
        String Sp = Double.toString(p).substring(0, 3);
        Factory<Integer> edgeFactory = new Factory<Integer>(){
            int c = 0;

            @Override
            public Integer create() {
                ++this.c;
                return this.c;
            }
        };
        Factory<String> vertexFactory = new Factory<String>(){
            int c = 0;

            @Override
            public String create() {
                ++this.c;
                return "v" + this.c;
            }
        };
        Factory<Graph<String, Integer>> graphFactory = new Factory<Graph<String, Integer>>(){

            @Override
            public Graph<String, Integer> create() {
                return new UndirectedSparseGraph<String, Integer>();
            }
        };
        Factory<Graph<String, Integer>> DgraphFactory = new Factory<Graph<String, Integer>>(){

            @Override
            public Graph<String, Integer> create() {
                return new DirectedSparseGraph<String, Integer>();
            }
        };
        Graph<String, Integer> G = null;
        String curfolder = folder;
        if (ch == 100) {
            curfolder = String.valueOf(curfolder) + "ER/";
            gname = "ERgraph";
            G = GenerateGraph.generateERGraph(DgraphFactory, vertexFactory, edgeFactory, n, p);
            ext = "p" + p;
        }
        if (ch == 1001) {
            curfolder = String.valueOf(curfolder) + "dER/";
            gname = "dERgraph";
            G = GenerateGraph.generateERdGraph(DgraphFactory, vertexFactory, edgeFactory, n, p);
            ext = "p" + p;
        }
        if (ch == 101) {
            curfolder = String.valueOf(curfolder) + "EppsteinPowerLaw/";
            gname = "EppsteinPLgraph";
            int nbe = (int)Math.round((double)(n * n) * p);
            G = new EppsteinPowerLawGenerator<String, Integer>(graphFactory, vertexFactory, edgeFactory, n, nbe, 100 * nbe).create();
            ext = "d8-2";
        }
        if (ch == 102) {
            curfolder = String.valueOf(curfolder) + "AlbertBPowerLawtest/";
            gname = "AlbertBPLgraph";
            int eadded = ne;
            int nseed = Math.round((float)n / 10.0f);
            if (nseed < 3) {
                nseed = 3;
            }
            Iterator vset = new HashSet();
            double time = System.currentTimeMillis();
            BarabasiAlbertGenerator<String, Integer> BAgen = new BarabasiAlbertGenerator<String, Integer>(graphFactory, vertexFactory, edgeFactory, nseed, eadded, (Set<String>)((Object)vset));
            BAgen.evolveGraph(n - nseed);
            G = BAgen.create();
            time = (double)System.currentTimeMillis() - time;
            System.out.println(time);
            ext = "e" + eadded;
        }
        if (ch == 103) {
            curfolder = String.valueOf(curfolder) + "Lattice2D/";
            gname = "Lattice2Dgraph";
            ext = "tor";
            nl = (int)Math.sqrt(n);
            G = new Lattice2DGenerator<String, Integer>(graphFactory, vertexFactory, edgeFactory, nl, true).create();
        }
        if (ch == 104) {
            curfolder = String.valueOf(curfolder) + "KleinbergSW/";
            gname = "KleinbergSWgraph";
            ext = "p" + p;
            nl = (int)Math.round(Math.sqrt(n));
            G = new Lattice2DGenerator<String, Integer>(graphFactory, vertexFactory, edgeFactory, nl, true).create();
            for (String x : G.getVertices()) {
                for (String y : G.getVertices()) {
                    if (!(Math.random() <= p)) continue;
                    G.addEdge((Integer)edgeFactory.create(), x, y);
                }
            }
        }
        if (ch == 105) {
            curfolder = String.valueOf(curfolder) + "WattsSW/";
            gname = "WattsSWgraph";
            ext = "k" + k + "p" + p;
            G = GenerateGraph.generateRegularRing(graphFactory, vertexFactory, edgeFactory, n, k);
            HashSet vertices = new HashSet(G.getVertices());
            for (String v : vertices) {
                HashSet<String> Nv = new HashSet<String>(G.getNeighbors(v));
                for (String nv : Nv) {
                    if (!(Math.random() < p)) continue;
                    G.removeEdge((Integer)G.findEdge(v, nv));
                    int j = 0;
                    int choose = (int)(Math.random() * (double)n);
                    String new_nv = "";
                    Iterator itr = G.getVertices().iterator();
                    while (itr.hasNext() && j < choose) {
                        new_nv = (String)itr.next();
                        ++j;
                    }
                    if (Tools.isEdge(G, v, new_nv) || new_nv.equals("")) continue;
                    G.addEdge((Integer)edgeFactory.create(), v, new_nv);
                }
            }
        }
        if (ch == 106) {
            curfolder = String.valueOf(curfolder) + "Regular/";
            gname = "Regular" + d + "-graph";
            G = GenerateGraph.generateRegularGraph(graphFactory, vertexFactory, edgeFactory, n, d);
        }
        if (ch == 107) {
            curfolder = String.valueOf(curfolder) + "RegularRing/";
            gname = "RRgraph";
            ext = "k" + k;
            G = GenerateGraph.generateRegularRing(graphFactory, vertexFactory, edgeFactory, n, k);
        }
        if (ch == 108) {
            curfolder = String.valueOf(curfolder) + "HardG/";
            gname = "Hgraph";
            ext = "minsep";
            G = GenerateGraph.generateERGraph(graphFactory, vertexFactory, edgeFactory, n, p);
            Graph<String, Integer> Gp = G;
            System.out.println(Gp);
            Algos<String, Integer> alg = new Algos<String, Integer>();
            alg.setGraphFactoy(graphFactory);
            alg.setEdgeFactoy(edgeFactory);
            alg.setVertexFactoy(vertexFactory);
            int i = 0;
            while (i < nhard) {
                G = GenerateGraph.generateHarderGraph(Gp, graphFactory, vertexFactory, edgeFactory, 2);
                ++i;
            }
        }
        System.out.println("Graph created " + G.getVertexCount() + " " + G.getEdgeCount());
        HashSet<Integer> eloops = new HashSet<Integer>();
        for (Integer e : G.getEdges()) {
            if (!((String)G.getEndpoints(e).getFirst()).equals(G.getEndpoints(e).getSecond())) continue;
            eloops.add(e);
        }
        for (Integer e : eloops) {
            G.removeEdge(e);
        }
        Tools.writeNet(G, String.valueOf(curfolder) + gname + "_n" + n + ext + ".net");
        System.out.println();
    }

    public static <V, E> Graph<V, E> generateERdGraph(Factory<Graph<V, E>> gf, Factory<V> vf, Factory<E> ef, int n, double p) {
        Graph<Object, E> G = gf.create();
        int i = 0;
        while (i < n) {
            G.addVertex(vf.create());
            ++i;
        }
        Object[] varray = G.getVertices().toArray();
        int i2 = 0;
        while (i2 < varray.length) {
            int j = 0;
            while (j < varray.length) {
                if (Math.random() <= p && varray[i2] != varray[j] && G.findEdge(varray[i2], varray[j]) == null) {
                    G.addEdge(ef.create(), varray[i2], varray[j]);
                }
                ++j;
            }
            ++i2;
        }
        return G;
    }

    public static <V, E> Graph<V, E> generateERGraph(Factory<Graph<V, E>> gf, Factory<V> vf, Factory<E> ef, int n, double p) {
        Graph<Object, E> G = gf.create();
        int i = 0;
        while (i < n) {
            G.addVertex(vf.create());
            ++i;
        }
        Object[] varray = G.getVertices().toArray();
        int i2 = 0;
        while (i2 < varray.length) {
            int j = i2;
            while (j < varray.length) {
                if (Math.random() <= p && varray[i2] != varray[j]) {
                    G.addEdge(ef.create(), varray[i2], varray[j]);
                }
                ++j;
            }
            ++i2;
        }
        return G;
    }

    public static <V, E> Graph<V, E> generateRegularRing(Factory<Graph<V, E>> gf, Factory<V> vf, Factory<E> ef, int n, int k) {
        Graph G = gf.create();
        ArrayList<V> vertices = new ArrayList<V>();
        int i = 0;
        while (i < n) {
            vertices.add(vf.create());
            ++i;
        }
        i = 0;
        while (i < n - 1) {
            G.addEdge(ef.create(), vertices.get(i), vertices.get(i + 1));
            ++i;
        }
        G.addEdge(ef.create(), vertices.get(n - 1), vertices.get(0));
        Graph Gp = Tools.copyGraph(G);
        int i2 = 1;
        while (i2 < k / 2) {
            for (Object v : vertices) {
                Set<V> Nv2 = Tools.getNeighbors(G, v, 2);
                for (V nv : Nv2) {
                    if (Tools.isEdge(Gp, v, nv)) continue;
                    Gp.addEdge(ef.create(), v, nv);
                }
            }
            ++i2;
        }
        return Gp;
    }

    public static <V, E> Graph<V, E> generateRegularGraph(Factory<Graph<V, E>> gf, Factory<V> vf, Factory<E> ef, int n, int d) {
        Graph<Object, E> G = gf.create();
        int step = 0;
        do {
            G = gf.create();
            int i = 0;
            while (i < n) {
                G.addVertex(vf.create());
                ++i;
            }
            HashSet S = new HashSet();
            for (Object u : G.getVertices()) {
                for (Object v : G.getVertices()) {
                    if (u == v) continue;
                    Pair pair = new Pair(u, v);
                    Pair p2 = new Pair(v, u);
                    if (S.contains(pair) || S.contains(p2)) continue;
                    S.add(pair);
                }
            }
            while (!S.isEmpty()) {
                boolean stop = false;
                Pair pchoosen = null;
                Iterator itr = S.iterator();
                while (!stop) {
                    if (!itr.hasNext()) {
                        itr = S.iterator();
                        continue;
                    }
                    Pair p = (Pair)itr.next();
                    double d2 = (double)(d - G.degree(p.fst)) * (double)(d - G.degree(p.snd)) / (double)S.size();
                    if (!(Math.random() < d2)) continue;
                    pchoosen = p;
                    stop = true;
                }
                S.remove(pchoosen);
                G.addEdge(ef.create(), pchoosen.fst, pchoosen.snd);
                HashSet<Pair> toRemove = new HashSet<Pair>();
                for (Pair pair : S) {
                    int deg1 = G.degree(pair.fst);
                    int deg2 = G.degree(pair.snd);
                    if (deg1 <= d - 1 && deg2 <= d - 1) continue;
                    toRemove.add(pair);
                }
                S.removeAll(toRemove);
            }
            ++step;
        } while (!Tools.isRegular(G, d));
        System.out.println("Graph " + d + "-regular :) " + step);
        return G;
    }

    public static <V, E> Graph<V, E> generateHarderGraph(Graph<V, E> G, Factory<Graph<V, E>> gf, Factory<V> vf, Factory<E> ef, int method) {
        Algos<Object, E> alg = new Algos<Object, E>();
        alg.initTracker();
        alg.setGraphFactoy(gf);
        alg.setEdgeFactoy(ef);
        alg.setVertexFactoy(vf);
        ArrayList<Pair<Object, Object>> edges = new ArrayList<Pair<Object, Object>>();
        ArrayList<Pair<Object, Object>> antiedges = new ArrayList<Pair<Object, Object>>();
        Object[] varray = G.getVertices().toArray();
        int i = 0;
        while (i < varray.length) {
            int j = i;
            while (j < varray.length) {
                if (varray[i] != varray[j]) {
                    if (Tools.isEdge(G, varray[i], varray[j])) {
                        edges.add(new Pair<Object, Object>(varray[i], varray[j]));
                    } else {
                        antiedges.add(new Pair<Object, Object>(varray[i], varray[j]));
                    }
                }
                ++j;
            }
            ++i;
        }
        int maxcall = 0;
        Graph Gp = gf.create();
        Graph Gpp = gf.create();
        Graph<V, E> Gmax = Tools.copyGraph(G);
        String v = "v1";
        String w = "v20";
        if (method == 2) {
            int n = alg.getABSeparators(G, v, w).size();
            if (n > maxcall) {
                maxcall = n;
            }
            System.out.println(n);
            int k = 0;
            Gpp = Tools.copyGraph(G);
            for (Pair pair : edges) {
                Gp = Tools.copyGraph(G);
                Object edge = Gp.findEdge(pair.fst, pair.snd);
                Gp.removeEdge(edge);
                for (Pair pair2 : antiedges) {
                    Gpp = Tools.copyGraph(Gp);
                    Gpp.addEdge(ef.create(), pair2.fst, pair2.snd);
                    int nsep = 0;
                    int n2 = alg.getABSeparators(Gpp, v, w).size();
                    if (n2 > nsep) {
                        nsep = n2;
                    }
                    if (n2 > 749) {
                        System.out.println("win:" + v + " " + w);
                        Tools.writeNet(Gpp, "win.net");
                    }
                    System.out.println(n2);
                    if (nsep <= maxcall) continue;
                    maxcall = nsep;
                    Gmax = Tools.copyGraph(Gpp);
                    System.out.println(maxcall);
                }
                System.out.println(String.valueOf(k) + " step");
                ++k;
            }
        }
        if (method == 1) {
            alg.initTracker();
            alg.MaximumIndependentSetFGK(G);
            maxcall = alg.getTracker().get("FGK");
            for (Pair pair : edges) {
                Gp = Tools.copyGraph(G);
                Object e = Gp.findEdge(pair.fst, pair.snd);
                Gp.removeEdge(e);
                for (Pair pair3 : antiedges) {
                    Gpp = Tools.copyGraph(Gp);
                    Gpp.addEdge(ef.create(), pair3.fst, pair3.snd);
                    alg.initTracker();
                    alg.MaximumIndependentSetFGK(Gpp);
                    if (alg.getTracker().get("FGK") <= maxcall) continue;
                    maxcall = alg.getTracker().get("FGK");
                    Gmax = Tools.copyGraph(Gpp);
                    System.out.println(maxcall);
                }
            }
        }
        return Gmax;
    }
}

