/*
 * Decompiled with CFR 0.152.
 */
package JungAGAPE;

import JungAGAPE.Algos;
import JungAGAPE.Tools;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections15.Factory;

public class JungMain {
    public static void main(String[] args) throws InstantiationException, IllegalAccessException {
        int k;
        long t = 0L;
        Graph<String, Integer> g = Tools.readDNet("GenGraphs/temp/LF1000.net");
        int ei = g.getEdgeCount();
        int vi = g.getVertexCount();
        int ch = 12;
        Algos<Object, Integer> alg = new Algos<Object, Integer>();
        Factory<Integer> edgeFactory = new Factory<Integer>(ei){
            int c;
            {
                this.c = n;
            }

            @Override
            public Integer create() {
                ++this.c;
                return this.c;
            }
        };
        Factory<String> vertexFactory = new Factory<String>(vi){
            int c;
            {
                this.c = n;
            }

            @Override
            public String create() {
                ++this.c;
                return "v" + this.c;
            }
        };
        Factory<Graph<String, Integer>> graphFactory = new Factory<Graph<String, Integer>>(){

            @Override
            public Graph<String, Integer> create() {
                return new UndirectedSparseGraph<String, Integer>();
            }
        };
        Factory<Graph<String, Integer>> DgraphFactory = new Factory<Graph<String, Integer>>(){

            @Override
            public Graph<String, Integer> create() {
                return new DirectedSparseGraph<String, Integer>();
            }
        };
        alg.setEdgeFactoy(edgeFactory);
        alg.setVertexFactoy(vertexFactory);
        alg.setGraphFactoy(graphFactory);
        Set<Object> S = new HashSet();
        System.out.println("V:" + g.getVertexCount());
        System.out.println("E:" + g.getEdgeCount());
        if (ch == 1) {
            HashSet A = new HashSet();
            System.out.println("Stable Maximum (V1 (min vertex))");
            t = System.currentTimeMillis();
            S = alg.MaximumIndependentSetMM(g, A);
            t = System.currentTimeMillis() - t;
            System.out.println(JungMain.printTime(t));
            System.out.println(String.valueOf(S.size()) + " : " + S);
        }
        if (ch == 2) {
            System.out.println("Stable Maximum ( V2 (max vertex))");
            t = System.currentTimeMillis();
            S = alg.MaximumIndependentSetDegMaX(g);
            t = System.currentTimeMillis() - t;
            System.out.println(JungMain.printTime(t));
            System.out.println(String.valueOf(S.size()) + " : " + S);
            System.out.println(Tools.isIndependentSet(g, S));
        }
        if (ch == 3) {
            System.out.println("Stable Maximum ( V3 (FGK 09))");
            t = System.currentTimeMillis();
            S = alg.MaximumIndependentSetFGK(g);
            t = System.currentTimeMillis() - t;
            System.out.println(JungMain.printTime(t));
            System.out.println(String.valueOf(S.size()) + " : " + S);
        }
        if (ch == 4) {
            int a2 = alg.find2ApproximationCover(g).size();
            System.out.println("2-approx cover: " + a2);
            k = alg.findGreedyCover(g).size();
            System.out.println("greedy cover: " + k);
            HashSet A = new HashSet();
            System.out.println("Vertex Cover (brute force) with k=" + k);
            t = System.currentTimeMillis();
            boolean b = alg.kVertexCoverBruteForce(g, k, S);
            t = System.currentTimeMillis() - t;
            System.out.println(JungMain.printTime(t));
            if (b) {
                System.out.println(String.valueOf(S.size()) + " : " + S);
                System.out.println(b);
            } else {
                System.out.println("No vertex cover of size " + k);
            }
            if (Tools.isVertexCoverSet(g, S)) {
                System.out.println("OK");
            } else {
                System.out.println("False Algo !!");
            }
        }
        if (ch == 5) {
            int a2 = alg.find2ApproximationCover(g).size();
            System.out.println("2-approx cover: " + a2);
            k = alg.findGreedyCover(g).size();
            System.out.println("greedy cover: " + k);
            System.out.println("Vertex Cover (V2) with k=" + k);
            t = System.currentTimeMillis();
            boolean b = alg.kVertexCoverKernel(g, k, S);
            t = System.currentTimeMillis() - t;
            System.out.println(JungMain.printTime(t));
            if (b) {
                System.out.println(String.valueOf(S.size()) + " : " + S);
                System.out.println(b);
            } else {
                System.out.println("No vertex cover of size " + k);
            }
            if (Tools.isVertexCoverSet(g, S)) {
                System.out.println("OK");
            } else {
                System.out.println("False Algo !!");
            }
        }
        if (ch == 6) {
            int a2 = alg.find2ApproximationCover(g).size();
            System.out.println("2-approx cover: " + a2);
            k = alg.findGreedyCover(g).size();
            System.out.println("greedy cover: " + k);
            System.out.println("Vertex Cover (Niedermeier) with k=" + k);
            t = System.currentTimeMillis();
            boolean b = alg.kVertexCoverNiedermeier(g, k, S);
            t = System.currentTimeMillis() - t;
            System.out.println(JungMain.printTime(t));
            if (b) {
                System.out.println(String.valueOf(S.size()) + " : " + S);
                System.out.println(b);
            } else {
                System.out.println("No vertex cover of size " + k);
            }
            if (Tools.isVertexCoverSet(g, S)) {
                System.out.println("OK");
            } else {
                System.out.println("False Algo !!");
            }
        }
        if (ch == 7) {
            int a2 = alg.find2ApproximationCover(g).size();
            System.out.println("2-approx cover: " + a2);
            k = alg.findGreedyCover(g).size();
            System.out.println("greedy cover: " + k);
            System.out.println("Vertex Cover (DBS) with k=" + k);
            t = System.currentTimeMillis();
            boolean b = alg.kVertexCoverDBS(g, k, S);
            t = System.currentTimeMillis() - t;
            System.out.println(JungMain.printTime(t));
            if (b) {
                System.out.println(String.valueOf(S.size()) + " : " + S);
                System.out.println(b);
            } else {
                System.out.println("No vertex cover of size " + k);
            }
            if (Tools.isVertexCoverSet(g, S)) {
                System.out.println("OK");
            } else {
                System.out.println("False Algo !!");
            }
        }
        if (ch == 8) {
            System.out.println("AllMinSep");
            Set<Set<String>> minSep = alg.getAllMinimalSeparators(g);
            System.out.println("Number of MinSep:" + minSep.size());
            System.out.println(minSep);
        }
        if (ch == 9) {
            String a = "0";
            String b = "19";
            System.out.println("Min ab-Sep");
            Set<Set<String>> minSep = alg.getABSeparators(g, a, b);
            System.out.println("Number of Min ab-Sep:" + minSep.size());
            System.out.println(minSep);
        }
        if (ch == 10) {
            System.out.println("Chromatic Number:");
            t = System.currentTimeMillis();
            int nc = alg.ChromaticNumber(g);
            t = System.currentTimeMillis() - t;
            System.out.println(nc);
            System.out.println(JungMain.printTime(t));
        }
        if (ch == 11) {
            alg.setGraphFactoy(DgraphFactory);
            Set<String> approx = alg.findGreedyFVS(g);
            System.out.println("Greedy approx (FVS):" + approx);
            System.out.println("Size:" + approx.size());
            System.out.println(Tools.isAcyclic(g));
            Graph<String, Integer> g_orig = Tools.copyDGraph(g);
            t = System.currentTimeMillis();
            S = alg.MaximumDirectedAcyclicSubset(g);
            System.out.println("MAS size:" + S.size());
            t = System.currentTimeMillis() - t;
            HashSet FVS = new HashSet(g_orig.getVertices());
            FVS.removeAll(S);
            System.out.println("Size: " + S.size());
            System.out.println(S);
            System.out.println("Size: " + FVS.size());
            System.out.println(FVS);
            Tools.removeAllVertices(g_orig, FVS);
            System.out.println(String.valueOf(Tools.isAcyclic(g_orig)) + "\n");
            System.out.println(JungMain.printTime(t));
        }
        if (ch == 12) {
            alg.setGraphFactoy(DgraphFactory);
            Set<String> approx = alg.findGreedyFVS(g);
            System.out.println("Greedy approx (FVS):" + approx.size());
            Set<ArrayList<String>> circuits = alg.EnumAllCircuitsTarjan(g);
            int max = 0;
            for (ArrayList<String> l : circuits) {
                if (l.size() <= max) continue;
                max = l.size();
            }
            System.out.println("Nb of cycles:" + circuits.size());
            System.out.println("Max size:" + max);
            System.out.println();
            HashSet<String> approxFVS = new HashSet<String>();
            for (ArrayList<String> l : circuits) {
                int i = 0;
                ArrayList<HashSet<String>> inter = new ArrayList<HashSet<String>>();
                for (ArrayList<String> h : circuits) {
                    if (l == h || Sets.intersection(new HashSet<String>(l), new HashSet<String>(h)).isEmpty()) continue;
                    ++i;
                    inter.add(new HashSet<String>(h));
                }
                HashSet<String> s = new HashSet<String>(l);
                HashSet r = new HashSet();
                for (Set set : inter) {
                    if (!Sets.intersection(s, set).isEmpty()) {
                        Sets.intersection(s, set).copyInto(r);
                        s = new HashSet(r);
                        r.clear();
                        continue;
                    }
                    approxFVS.addAll(s);
                    s = new HashSet<String>(l);
                    Sets.intersection(s, set).copyInto(r);
                    s = new HashSet(r);
                    r.clear();
                }
                approxFVS.add((String)s.iterator().next());
            }
            System.out.println("Approx: " + approxFVS.size());
            Tools.removeAllVertices(g, approxFVS);
            System.out.println(Tools.isAcyclic(g));
        }
    }

    public static String printTime(long t) {
        String r = "";
        int div = 0;
        double tt = t;
        while (tt > 1000.0) {
            tt /= 1000.0;
            ++div;
        }
        r = Double.toString(tt);
        switch (div) {
            case 0: {
                r = String.valueOf(r) + " ms";
                break;
            }
            case 1: {
                r = String.valueOf(r) + " s";
            }
        }
        if (div >= 1 && tt >= 60.0) {
            r = String.valueOf(r) + " s (" + (tt /= 60.0) + " mins)";
        }
        return r;
    }

    public static String MtoString(int[][] M) {
        String str = "";
        int i = 0;
        while (i < M.length) {
            int j = 0;
            while (j < M[0].length) {
                str = String.valueOf(str) + M[i][j] + " ";
                ++j;
            }
            str = String.valueOf(str) + "\n";
            ++i;
        }
        return str;
    }
}

