/*
 * Decompiled with CFR 0.152.
 */
package JungAGAPE;

import JungAGAPE.Tools;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class TGFconvert {
    public static void main(String[] args) {
        String folder_s = "./GenGraphs/temp/";
        String folder_t = "./GenGraphs/Prism/";
        String fname = "Prism_n";
        int n = 5;
        while (n <= 20) {
            Graph<String, Integer> G = TGFconvert.readTGF(String.valueOf(folder_s) + fname + n + ".tgf");
            Tools.writeNet(G, String.valueOf(folder_t) + fname + n + ".net");
            n += 5;
        }
    }

    public static Graph<String, Integer> readTGF(String fname) {
        File f = new File(fname);
        BufferedReader lecteurAvecBuffer = null;
        UndirectedSparseGraph<String, Integer> G = new UndirectedSparseGraph<String, Integer>();
        try {
            lecteurAvecBuffer = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException exc) {
            System.err.println("Error opening file\n");
        }
        ArrayList<String> V = new ArrayList<String>();
        try {
            String ligne = lecteurAvecBuffer.readLine();
            while (!ligne.equals("#")) {
                String v = ligne;
                V.add(v);
                G.addVertex(v);
                ligne = lecteurAvecBuffer.readLine();
            }
            int ne = 0;
            ligne = lecteurAvecBuffer.readLine();
            while (ligne != null) {
                StringTokenizer tok = new StringTokenizer(ligne, " ");
                int s = Integer.valueOf(tok.nextToken());
                int t = Integer.valueOf(tok.nextToken());
                if (!V.isEmpty()) {
                    G.addEdge((Integer)ne, (String)V.get(s - 1), (String)V.get(t - 1));
                } else {
                    G.addEdge((Integer)ne, Integer.toString(s), Integer.toString(t));
                }
                ++ne;
                ligne = lecteurAvecBuffer.readLine();
            }
            lecteurAvecBuffer.close();
        }
        catch (Exception e) {
            System.err.println("Error reading: " + e + "\n");
        }
        return G;
    }
}

