/*
 * Decompiled with CFR 0.152.
 */
package JungAGAPE;

import JungAGAPE.JungMain;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptGraph;
import mascoptLib.core.MascoptVertex;
import mascoptLib.io.reader.mgl.dom.MGLDOMReader;
import org.apache.commons.collections15.Factory;

public class Tools<V, E> {
    private static HashMap indexmap;
    private static HashMap lowlinkmap;
    private static int index;
    private static ArrayList stackSC;
    private static ArrayList SCC;

    public static <V, E> void subGraph(Graph<V, E> G, Graph<V, E> subG, V x) {
        subG.addVertex(x);
        Collection edges = G.getIncidentEdges(x);
        if (edges != null) {
            for (Object e : edges) {
                if (G.getEdgeType(e) == EdgeType.UNDIRECTED) {
                    subG.addEdge(e, G.getEndpoints(e).getFirst(), G.getEndpoints(e).getSecond());
                    continue;
                }
                subG.addEdge(e, G.getSource(e), G.getDest(e));
            }
        }
    }

    public static <V, E> void subGraph(Graph<V, E> G, Graph<V, E> subG, Set<V> S) {
        for (V x : S) {
            subG.addVertex(x);
            Collection edges = G.getIncidentEdges(x);
            if (edges == null) continue;
            for (Object e : edges) {
                if (subG.containsEdge(e)) continue;
                subG.addEdge(e, G.getEndpoints(e).getFirst(), G.getEndpoints(e).getSecond());
            }
        }
    }

    public static <V, E> void mergeGraph(Graph<V, E> G, Graph<V, E> subG) {
        for (Object v : subG.getVertices()) {
            G.addVertex(v);
        }
        for (Object e : subG.getEdges()) {
            if (subG.getEdgeType(e) == EdgeType.UNDIRECTED) {
                G.addEdge(e, subG.getEndpoints(e).getFirst(), subG.getEndpoints(e).getSecond());
                continue;
            }
            G.addEdge(e, subG.getSource(e), subG.getDest(e));
        }
    }

    public static <V, E> Graph<V, E> copyGraph(Graph<V, E> G) {
        UndirectedSparseGraph<V, Object> newG = new UndirectedSparseGraph<V, Object>();
        for (Object x : G.getVertices()) {
            newG.addVertex(x);
        }
        for (Object e : G.getEdges()) {
            newG.addEdge(e, G.getEndpoints(e).getFirst(), G.getEndpoints(e).getSecond());
        }
        return newG;
    }

    public static <V, E> Graph<V, E> copyDGraph(Graph<V, E> G) {
        DirectedSparseGraph<V, Object> newG = new DirectedSparseGraph<V, Object>();
        for (Object x : G.getVertices()) {
            newG.addVertex(x);
        }
        for (Object e : G.getEdges()) {
            newG.addEdge(e, G.getEndpoints(e).getFirst(), G.getEndpoints(e).getSecond());
        }
        return newG;
    }

    public static <V, E> int getDiameter(Graph<V, E> G) {
        int diameter = 0;
        DijkstraDistance d = new DijkstraDistance(G);
        for (Object s : G.getVertices()) {
            for (Object t : G.getVertices()) {
                if (s == t || d.getDistance(s, t) == null || d.getDistance(s, t).intValue() <= diameter) continue;
                diameter = d.getDistance(s, t).intValue();
            }
        }
        return diameter;
    }

    public static <V, E> V getMinDegVertex(Graph<V, E> G) {
        int deg = Integer.MAX_VALUE;
        V v = null;
        for (Object x : G.getVertices()) {
            if (G.degree(x) >= deg) continue;
            v = x;
            deg = G.degree(x);
        }
        return v;
    }

    public static <V, E> Set<V> getAllMinDegVertex(Graph<V, E> G) {
        HashSet allDM = new HashSet();
        int degmin = Tools.getMinDeg(G);
        for (Object x : G.getVertices()) {
            if (G.degree(x) != degmin) continue;
            allDM.add(x);
        }
        return allDM;
    }

    public static <V, E> V getMaxDegVertex(Graph<V, E> G) {
        int deg = 0;
        V v = null;
        for (Object x : G.getVertices()) {
            if (G.degree(x) <= deg) continue;
            v = x;
            deg = G.degree(x);
        }
        return v;
    }

    public static <V, E> Set<V> getAllMaxDegVertex(Graph<V, E> G) {
        HashSet allDM = new HashSet();
        int degmax = Tools.getMaxDeg(G);
        for (Object x : G.getVertices()) {
            if (G.degree(x) != degmax) continue;
            allDM.add(x);
        }
        return allDM;
    }

    public static <V, E> int getMaxDeg(Graph<V, E> G) {
        int deg = 0;
        for (Object x : G.getVertices()) {
            if (G.degree(x) <= deg) continue;
            deg = G.degree(x);
        }
        return deg;
    }

    public static <V, E> int getMinDeg(Graph<V, E> G) {
        int deg = Integer.MAX_VALUE;
        for (Object x : G.getVertices()) {
            if (G.degree(x) >= deg) continue;
            deg = G.degree(x);
        }
        return deg;
    }

    public static <V, E> V getDegVertex(Graph<V, E> G, int deg) {
        V v = null;
        for (Object x : G.getVertices()) {
            if (G.degree(x) != deg) continue;
            v = x;
            break;
        }
        return v;
    }

    public static <V, E> Set<V> getAllDegVertex(Graph<V, E> G, int deg) {
        HashSet Sdeg = new HashSet();
        for (Object x : G.getVertices()) {
            if (G.getNeighborCount(x) != deg) continue;
            Sdeg.add(x);
        }
        return Sdeg;
    }

    public static <V, E> int getNbEdges(Graph<V, E> G, Set<V> A) {
        int nbe = 0;
        for (Object e : G.getEdges()) {
            if (!A.contains(G.getEndpoints(e).getFirst()) || !A.contains(G.getEndpoints(e).getSecond())) continue;
            ++nbe;
        }
        return nbe;
    }

    public static <V, E> Set<V> getNeighbors(Graph<V, E> G, Set<V> S) {
        HashSet<V> N = new HashSet<V>();
        for (V v : S) {
            N.addAll(G.getNeighbors(v));
        }
        N.removeAll(S);
        return N;
    }

    public static <V, E> Set<V> getNeighbors(Graph<V, E> G, V v, int dist) {
        HashSet<V> N = new HashSet<V>();
        HashSet<Object> done = new HashSet<Object>();
        N.addAll(G.getNeighbors(v));
        done.addAll(N);
        done.add(v);
        int i = 1;
        while (i < dist) {
            HashSet Nn = new HashSet();
            for (Object x : N) {
                Sets.difference(new HashSet(G.getNeighbors(x)), done).copyInto(Nn);
            }
            done.addAll(Nn);
            N = Nn;
            ++i;
        }
        return N;
    }

    public static <V, E> Set<V> getConnectedComponent(Graph<V, E> G, Set<V> restrictNodes) {
        HashSet<Object> C = new HashSet<Object>();
        Stack<Object> stack = new Stack<Object>();
        if (!G.getVertices().isEmpty()) {
            Iterator itr = G.getVertices().iterator();
            Object v = itr.next();
            while (restrictNodes.contains(v) && itr.hasNext()) {
                v = itr.next();
            }
            if (!restrictNodes.contains(v)) {
                C.add(v);
                stack.add(v);
            }
            while (!stack.isEmpty()) {
                Object x = stack.pop();
                HashSet nT = new HashSet();
                HashSet Nx = new HashSet(G.getNeighbors(x));
                Nx.removeAll(restrictNodes);
                Sets.difference(Nx, C).copyInto(nT);
                stack.addAll(nT);
                C.addAll(nT);
            }
        }
        return C;
    }

    public static <V, E> Set<V> getConnectedComponent(Graph<V, E> G) {
        HashSet<Object> C = new HashSet<Object>();
        Stack<Object> stack = new Stack<Object>();
        if (!G.getVertices().isEmpty()) {
            Object v = G.getVertices().iterator().next();
            C.add(v);
            stack.add(v);
            while (!stack.isEmpty()) {
                Object x = stack.pop();
                HashSet nT = new HashSet();
                HashSet Nx = new HashSet(G.getNeighbors(x));
                Sets.difference(Nx, C).copyInto(nT);
                stack.addAll(nT);
                C.addAll(nT);
            }
        }
        return C;
    }

    public static <V, E> ArrayList<Set<V>> getAllConnectedComponent(Graph<V, E> G, Set restrictNodes) {
        ArrayList<Set<V>> CC = new ArrayList<Set<V>>();
        HashSet nodes = new HashSet(G.getVertices());
        nodes.removeAll(restrictNodes);
        while (!nodes.isEmpty()) {
            Object vinit = null;
            Iterator itr = nodes.iterator();
            boolean b = false;
            while (itr.hasNext() && !b) {
                Object vtemp = itr.next();
                if (restrictNodes.contains(vtemp)) continue;
                vinit = vtemp;
                b = true;
            }
            if (vinit == null) continue;
            HashSet<V> C = new HashSet<V>();
            HashSet Ci = new HashSet();
            C.add(vinit);
            while (!Ci.equals(C)) {
                Ci = new HashSet(C);
                C.addAll(Tools.getNeighbors(G, Ci));
                C.removeAll(restrictNodes);
            }
            CC.add(C);
            nodes.removeAll(C);
        }
        return CC;
    }

    public static <V, E> ArrayList<Set<V>> getAllConnectedComponent(Graph<V, E> G) {
        ArrayList<Set<V>> CC = new ArrayList<Set<V>>();
        ArrayList<Graph> memG = new ArrayList<Graph>();
        while (!G.getVertices().isEmpty()) {
            try {
                Graph Gp = (Graph)G.getClass().newInstance();
                Set<V> C = Tools.getConnectedComponent(G);
                CC.add(C);
                Tools.subGraph(G, Gp, C);
                memG.add(Gp);
                Tools.removeAllVertices(G, C);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(Tools.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Tools.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (Graph GC : memG) {
            Tools.mergeGraph(G, GC);
        }
        return CC;
    }

    public static <V, E> ArrayList<Set<V>> getAllStronglyConnectedComponent(Graph<V, E> G) {
        indexmap = new HashMap();
        lowlinkmap = new HashMap();
        index = 0;
        stackSC = new ArrayList();
        SCC = new ArrayList();
        for (Object v : G.getVertices()) {
            if (indexmap.get(v) != null) continue;
            Tools.tarjan(v, G);
        }
        return SCC;
    }

    private static <V, E> void tarjan(V v, Graph<V, E> G) {
        indexmap.put(v, index);
        lowlinkmap.put(v, index);
        ++index;
        stackSC.add(0, v);
        for (E e : G.getOutEdges(v)) {
            V n = G.getDest(e);
            if (indexmap.get(n) == null) {
                Tools.tarjan(n, G);
                lowlinkmap.put(v, Math.min((Integer)lowlinkmap.get(v), (Integer)lowlinkmap.get(n)));
                continue;
            }
            if (!stackSC.contains(n)) continue;
            lowlinkmap.put(v, Math.min((Integer)lowlinkmap.get(v), (Integer)indexmap.get(n)));
        }
        if ((Integer)lowlinkmap.get(v) == (Integer)indexmap.get(v)) {
            Object n;
            HashSet component = new HashSet();
            do {
                n = stackSC.remove(0);
                component.add(n);
            } while (n != v);
            SCC.add(component);
        }
    }

    public static <V, E> Graph<V, E> getComplementGraph(Graph<V, E> G, Factory<E> eFactory) {
        UndirectedSparseGraph Gc = new UndirectedSparseGraph();
        for (Object v1 : G.getVertices()) {
            for (Object v2 : G.getVertices()) {
                if (v1 == v2 || G.findEdge(v1, v2) != null) continue;
                Gc.addEdge(eFactory.create(), v1, v2);
            }
        }
        return Gc;
    }

    public static <V, E> Graph<V, E> getFoldingGraph(Graph<V, E> G, V v, HashMap<V, Set<V>> fold, Factory<V> vertexFactory, Factory<E> edgeFactory) {
        int j;
        Graph<Object, E> Gv = Tools.copyGraph(G);
        ArrayList<V> newv = new ArrayList<V>();
        HashSet<V> Nv = new HashSet<V>();
        Nv.addAll(G.getNeighbors(v));
        ArrayList Nvlist = new ArrayList(Nv);
        int i = 0;
        while (i < Nvlist.size() - 1) {
            j = i + 1;
            while (j < Nvlist.size()) {
                Object uj;
                Object ui = Nvlist.get(i);
                if (!Tools.isEdge(G, ui, uj = Nvlist.get(j))) {
                    E ei;
                    V uij = vertexFactory.create();
                    Gv.addVertex(uij);
                    HashSet vfolded = new HashSet();
                    vfolded.add(ui);
                    vfolded.add(uj);
                    fold.put(uij, vfolded);
                    for (Object nui : G.getNeighbors(ui)) {
                        if (Tools.isEdge(G, uij, nui)) continue;
                        ei = edgeFactory.create();
                        while (Gv.getEdges().contains(ei)) {
                            ei = edgeFactory.create();
                        }
                        Gv.addEdge(ei, uij, nui);
                    }
                    for (Object nuj : G.getNeighbors(uj)) {
                        if (Tools.isEdge(G, uij, nuj)) continue;
                        ei = edgeFactory.create();
                        while (Gv.getEdges().contains(ei)) {
                            ei = edgeFactory.create();
                        }
                        Gv.addEdge(ei, uij, nuj);
                    }
                    newv.add(uij);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < newv.size() - 1) {
            j = i + 1;
            while (j < newv.size()) {
                if (!Tools.isEdge(G, newv.get(i), newv.get(j))) {
                    E ei = edgeFactory.create();
                    Gv.addEdge(ei, newv.get(i), newv.get(j));
                }
                ++j;
            }
            ++i;
        }
        for (Object x : Nv) {
            Gv.removeVertex(x);
        }
        Gv.removeVertex(v);
        return Gv;
    }

    public static <V, E> Set<V> getMirrors(Graph<V, E> G, V v) {
        HashSet<Object> Mv = new HashSet<Object>();
        Set<Object> U = new HashSet();
        HashSet<V> Nv = new HashSet<V>();
        Nv.addAll(G.getNeighbors(v));
        U = Tools.getNeighbors(G, v, 2);
        for (Object u : U) {
            HashSet C = new HashSet();
            Sets.difference(Nv, new HashSet<Object>(G.getNeighbors(u))).copyInto(C);
            if (!Tools.isClique(G, C)) continue;
            Mv.add(u);
        }
        return Mv;
    }

    public static <V, E> V getDominatedVertex(Graph<V, E> G) {
        V v = null;
        HashMap dom = new HashMap();
        ArrayList<Set<V>> N = new ArrayList<Set<V>>();
        for (Object x : G.getVertices()) {
            HashSet Nx = new HashSet();
            Nx.addAll(new HashSet(G.getNeighbors(x)));
            Nx.add(x);
            dom.put(Nx, x);
            N.add(Nx);
        }
        Tools.quickSortSet(N, 0, N.size() - 1);
        boolean vfound = false;
        int i = N.size() - 1;
        while (i > 0 && !vfound) {
            Set<V> Nv = N.get(i);
            int j = 0;
            while (j < i && !vfound) {
                Set<V> Nw = N.get(j);
                if (Nv.containsAll(Nw)) {
                    v = dom.get(Nv);
                    vfound = true;
                }
                ++j;
            }
            --i;
        }
        return v;
    }

    public static <V, E> boolean isRegular(Graph<V, E> G) {
        int deg = G.degree(G.getVertices().iterator().next());
        for (Object v : G.getVertices()) {
            if (G.degree(v) == deg) continue;
            return false;
        }
        return true;
    }

    public static <V, E> boolean isRegular(Graph<V, E> G, int deg) {
        for (Object v : G.getVertices()) {
            if (G.degree(v) == deg) continue;
            return false;
        }
        return true;
    }

    public static <V, E> boolean isAcyclic(Graph<V, E> G) {
        boolean b = false;
        Graph<Object, E> Gp = Tools.copyDGraph(G);
        ArrayList L = new ArrayList();
        ArrayList<Object> Q = new ArrayList<Object>();
        for (Object v : Gp.getVertices()) {
            if (Gp.getPredecessorCount(v) != 0) continue;
            Q.add(v);
        }
        while (!Q.isEmpty()) {
            Object n = Q.remove(0);
            L.add(n);
            HashSet<V> succ = new HashSet<V>(Gp.getSuccessors(n));
            Gp.removeVertex(n);
            for (Object m : succ) {
                if (Gp.getPredecessorCount(m) != 0) continue;
                Q.add(m);
            }
        }
        if (Gp.getEdgeCount() == 0) {
            b = true;
        }
        return b;
    }

    public static <V, E> boolean isCycle(Graph<V, E> G, Set<V> C) {
        ArrayList<V> visited = new ArrayList<V>();
        V vstart = C.iterator().next();
        visited.add(vstart);
        boolean b = true;
        Object v = vstart;
        while (b && visited.size() < C.size()) {
            HashSet neigh = new HashSet();
            if (!G.getNeighbors(v).isEmpty()) {
                Sets.intersection(C, new HashSet<V>(G.getNeighbors(v))).copyInto(neigh);
            }
            neigh.removeAll(visited);
            if (!neigh.isEmpty()) {
                v = neigh.iterator().next();
                visited.add(v);
                continue;
            }
            b = false;
        }
        if (b && !G.getNeighbors(visited.get(visited.size() - 1)).contains(vstart)) {
            b = false;
        }
        return b;
    }

    public static <V, E> boolean isIndependentSet(Graph<V, E> G, Set<V> S) {
        boolean b = true;
        Iterator<V> itr = S.iterator();
        while (b && itr.hasNext()) {
            HashSet<V> Nv;
            V v = itr.next();
            Collection<V> N = G.getNeighbors(v);
            if (N == null || Sets.intersection(S, Nv = new HashSet<V>(N)).isEmpty()) continue;
            b = false;
        }
        return b;
    }

    public static <V, E> boolean isMaximalIndependentSet(Graph<V, E> G, Set<V> S) {
        boolean b = true;
        if (Tools.isIndependentSet(G, S)) {
            HashSet NS = new HashSet(G.getVertices());
            NS.removeAll(S);
            Iterator itr = NS.iterator();
            while (b && itr.hasNext()) {
                Object v = itr.next();
                if (!Sets.intersection(new HashSet(G.getNeighbors(v)), S).isEmpty()) continue;
                b = false;
            }
        } else {
            b = false;
        }
        return b;
    }

    public static <V, E> boolean isVertexCoverSet(Graph<V, E> G, Set<V> VC) {
        boolean b = true;
        Graph<V, E> Gp = Tools.copyGraph(G);
        for (V v : VC) {
            Gp.removeVertex(v);
        }
        if (Gp.getEdgeCount() > 0) {
            b = false;
        }
        return b;
    }

    public static <V, E> boolean isEdge(Graph<V, E> G, V v1, V v2) {
        return G.findEdge(v1, v2) != null;
    }

    public static <V, E> boolean isClique(Graph<V, E> G, Set<V> K) {
        boolean b = true;
        if (K.isEmpty() || K.size() == 1) {
            return true;
        }
        ArrayList N = new ArrayList();
        for (V v : K) {
            HashSet<V> Nv = new HashSet<V>();
            Nv.addAll(G.getNeighbors(v));
            Nv.add(v);
            N.add(Nv);
        }
        HashSet Ni = (HashSet)N.get(0);
        int i = 1;
        while (b && i < N.size()) {
            HashSet temp = new HashSet();
            Sets.intersection(Ni, (Set)N.get(i)).copyInto(temp);
            Ni = temp;
            if (!Ni.containsAll(K)) {
                b = false;
            }
            ++i;
        }
        return b;
    }

    public static <V, E> void addAllVertices(Graph<V, E> G, Set<V> A) {
        for (V v : A) {
            G.addVertex(v);
        }
    }

    public static <V, E> void removeAllVertices(Graph<V, E> G, Set<V> R) {
        for (V v : R) {
            G.removeVertex(v);
        }
    }

    public static <V, E> void removeAllEdges(Graph<V, E> G, Set<E> R) {
        for (E e : R) {
            G.removeEdge(e);
        }
    }

    public static <V> void quickSortSet(ArrayList<Set<V>> tab, int p, int r) {
        if (p < r) {
            int q = Tools.partitionSet(tab, p, r);
            Tools.quickSortSet(tab, p, q);
            Tools.quickSortSet(tab, q + 1, r);
        }
    }

    private static <V> int partitionSet(ArrayList<Set<V>> tab, int p, int r) {
        int pivot = tab.get(p).size();
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (tab.get(--j).size() > pivot) {
                continue;
            }
            while (tab.get(++i).size() < pivot) {
            }
            if (i >= j) break;
            HashSet temp = new HashSet();
            temp.addAll(tab.get(i));
            tab.set(i, tab.get(j));
            tab.set(j, temp);
        }
        return j;
    }

    public static Graph<String, Integer> MGLtoJungGraph(String fname) {
        UndirectedSparseGraph<String, Integer> g = new UndirectedSparseGraph<String, Integer>();
        MGLDOMReader mglR = null;
        try {
            mglR = new MGLDOMReader(fname);
            mglR.parse();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(JungMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(JungMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        MascoptGraph G = (MascoptGraph)mglR.getGraphs().next();
        for (MascoptVertex v : G.vertexSet()) {
            g.addVertex(v.toString());
        }
        int k = 0;
        for (MascoptEdge e : G.edgeSet()) {
            g.addEdge((Integer)k, e.toArray()[0].toString(), e.toArray()[1].toString());
            ++k;
        }
        return g;
    }

    public static Graph<String, Integer> readNet(String fname) {
        File f = new File(fname);
        BufferedReader lecteurAvecBuffer = null;
        UndirectedSparseGraph<String, Integer> G = new UndirectedSparseGraph<String, Integer>();
        try {
            lecteurAvecBuffer = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException exc) {
            System.err.println("Error opening file .net\n");
        }
        ArrayList<String> V = new ArrayList<String>();
        try {
            String ligne = lecteurAvecBuffer.readLine();
            ligne = lecteurAvecBuffer.readLine();
            while (!ligne.equals("*edgeslist")) {
                StringTokenizer tok = new StringTokenizer(ligne, "\"");
                tok.nextToken();
                String v = tok.nextToken();
                V.add(v);
                G.addVertex(v);
                ligne = lecteurAvecBuffer.readLine();
            }
            int ne = 0;
            ligne = lecteurAvecBuffer.readLine();
            while (ligne != null) {
                StringTokenizer tok = new StringTokenizer(ligne, " ");
                int s = Integer.valueOf(tok.nextToken()) - 1;
                while (tok.hasMoreTokens()) {
                    int t = Integer.valueOf(tok.nextToken()) - 1;
                    if (!V.isEmpty()) {
                        G.addEdge((Integer)ne, (String)V.get(s), (String)V.get(t));
                    } else {
                        G.addEdge((Integer)ne, Integer.toString(s), Integer.toString(t));
                    }
                    ++ne;
                }
                ligne = lecteurAvecBuffer.readLine();
            }
            lecteurAvecBuffer.close();
        }
        catch (Exception e) {
            System.err.println("Error reading: " + e + "\n");
        }
        return G;
    }

    public static Graph<String, Integer> readDNet(String fname) {
        File f = new File(fname);
        BufferedReader lecteurAvecBuffer = null;
        DirectedSparseGraph<String, Integer> G = new DirectedSparseGraph<String, Integer>();
        try {
            lecteurAvecBuffer = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException exc) {
            System.err.println("Error opening file .net\n");
        }
        ArrayList<String> V = new ArrayList<String>();
        try {
            String ligne = lecteurAvecBuffer.readLine();
            ligne = lecteurAvecBuffer.readLine();
            while (!ligne.equals("*edgeslist")) {
                StringTokenizer tok = new StringTokenizer(ligne, "\"");
                tok.nextToken();
                String v = tok.nextToken();
                V.add(v);
                G.addVertex(v);
                ligne = lecteurAvecBuffer.readLine();
            }
            int ne = 0;
            ligne = lecteurAvecBuffer.readLine();
            while (ligne != null) {
                StringTokenizer tok = new StringTokenizer(ligne, " ");
                int s = Integer.valueOf(tok.nextToken()) - 1;
                while (tok.hasMoreTokens()) {
                    int t = Integer.valueOf(tok.nextToken()) - 1;
                    if (!V.isEmpty()) {
                        G.addEdge((Integer)ne, (String)V.get(s), (String)V.get(t));
                    } else {
                        G.addEdge((Integer)ne, Integer.toString(s), Integer.toString(t));
                    }
                    ++ne;
                }
                ligne = lecteurAvecBuffer.readLine();
            }
            lecteurAvecBuffer.close();
        }
        catch (Exception e) {
            System.err.println("Error reading: " + e + "\n");
        }
        return G;
    }

    public static <V, E> void writeNet(Graph<V, E> G, String fname) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(fname, false);
        }
        catch (Exception e) {
            System.err.println("Error writing: " + e);
        }
        BufferedWriter bfw = new BufferedWriter(fw);
        PrintWriter output = new PrintWriter(bfw);
        HashMap posv = new HashMap();
        HashSet done = new HashSet();
        output.println("*Vertices " + G.getVertexCount());
        int i = 1;
        for (Object v : G.getVertices()) {
            output.println(String.valueOf(i) + " \"" + v.toString() + "\"");
            posv.put(v, i);
            ++i;
        }
        output.println("*edgeslist");
        for (Object v : G.getVertices()) {
            boolean first = true;
            for (Object nv : G.getNeighbors(v)) {
                Pair p1 = new Pair(v, nv);
                Pair p2 = new Pair(nv, v);
                if (done.contains(p1) || done.contains(p2)) continue;
                if (first) {
                    output.print(posv.get(v) + " ");
                    output.print(posv.get(nv) + " ");
                    done.add(p1);
                    done.add(p2);
                    first = false;
                    continue;
                }
                output.print(posv.get(nv) + " ");
                done.add(p1);
                done.add(p2);
            }
            if (first) continue;
            output.println();
        }
        output.flush();
        output.close();
    }

    public static <V, E> void writeDNet(Graph<V, E> G, String fname) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(fname, false);
        }
        catch (Exception e) {
            System.err.println("Error writing: " + e);
        }
        BufferedWriter bfw = new BufferedWriter(fw);
        PrintWriter output = new PrintWriter(bfw);
        HashMap posv = new HashMap();
        HashSet done = new HashSet();
        output.println("*Vertices " + G.getVertexCount());
        int i = 1;
        for (Object v : G.getVertices()) {
            output.println(String.valueOf(i) + " \"" + v.toString() + "\"");
            posv.put(v, i);
            ++i;
        }
        output.println("*edgeslist");
        for (Object v : G.getVertices()) {
            boolean first = true;
            for (V nv : G.getSuccessors(v)) {
                Pair p = new Pair(v, nv);
                if (done.contains(p)) continue;
                if (first) {
                    output.print(posv.get(v) + " ");
                    output.print(posv.get(nv) + " ");
                    done.add(p);
                    first = false;
                    continue;
                }
                output.print(posv.get(nv) + " ");
                done.add(p);
            }
            if (first) continue;
            output.println();
        }
        output.flush();
        output.close();
    }

    public static <V, E> int[][] getBMatrix(Graph<V, E> G, int d) {
        int[][] Bmatrix = new int[d][G.getVertexCount()];
        int i = 0;
        while (i < d) {
            for (Object x : G.getVertices()) {
                Set<V> N = Tools.getNeighbors(G, x, i + 1);
                N.remove(x);
                Bmatrix[i][N.size()] = Bmatrix[i][N.size()] + 1;
            }
            ++i;
        }
        return Bmatrix;
    }

    public static <V, E> V chooseRandVertex(Graph<V, E> G) {
        V vertex = null;
        while (vertex == null) {
            for (Object v : G.getVertices()) {
                if (!(Math.random() < 0.3)) continue;
                vertex = v;
            }
        }
        return vertex;
    }

    public static <V, E> double getDensity(Graph<V, E> G) {
        return (double)(2 * G.getEdgeCount()) / (double)(G.getVertexCount() * (G.getVertexCount() - 1));
    }

    public static <V, E> void showGraph(Graph<V, E> G, Set<V> selectedNodes) {
        JFrame jf = new JFrame();
        VisualizationViewer<V, E> vv = new VisualizationViewer<V, E>(new FRLayout<V, E>(G));
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        vv.setGraphMouse(graphMouse);
        vv.addKeyListener(graphMouse.getModeKeyListener());
        vv.setBackground(Color.white);
        vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        jf.getContentPane().add(vv);
        jf.pack();
        jf.setVisible(true);
        for (V v : selectedNodes) {
            vv.getPickedVertexState().pick(v, true);
        }
    }

    public static <V, E> void rewireEdgesRand(Graph<V, E> G, int amount, Factory<E> edgeFactory) {
        ArrayList edgesR = new ArrayList();
        while (edgesR.size() < amount) {
            for (Object e : G.getEdges()) {
                if (!(Math.random() < 0.3)) continue;
                edgesR.add(e);
            }
        }
        for (Object e : edgesR) {
            Object v1 = null;
            v1 = Math.random() < 0.5 ? (Object)G.getEndpoints(e).getFirst() : (Object)G.getEndpoints(e).getSecond();
            Object v2 = null;
            Iterator itr = G.getVertices().iterator();
            while (v2 == null || v2.equals(G.getEndpoints(e).getFirst()) || v2.equals(G.getEndpoints(e).getSecond()) || G.findEdge(v1, v2) != null) {
                v2 = itr.next();
            }
            G.removeEdge(e);
            G.addEdge(edgeFactory.create(), v1, v2);
        }
    }

    public static <V, E> void rewireEdge(Graph<V, E> G, E edge, Factory<E> edgeFactory) {
        Object v1 = null;
        v1 = Math.random() < 0.5 ? (Object)G.getEndpoints(edge).getFirst() : (Object)G.getEndpoints(edge).getSecond();
        Object v2 = null;
        Iterator itr = G.getVertices().iterator();
        while (v2 == null || v2.equals(G.getEndpoints(edge).getFirst()) || v2.equals(G.getEndpoints(edge).getSecond()) || G.findEdge(v1, v2) != null) {
            v2 = itr.next();
        }
        G.removeEdge(edge);
        G.addEdge(edgeFactory.create(), v1, v2);
    }
}

