/*
 * Decompiled with CFR 0.152.
 */
package agape.algos;

import agape.algos.Algorithms;
import agape.algos.MIS;
import agape.tools.Operations;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Factory;

public class Coloring<V, E>
extends Algorithms<V, E> {
    final double alpha = 0.19903;
    private Map<String, Integer> S_0x;

    public Coloring(Factory<Graph<V, E>> factory) {
        this.graphFactory = factory;
    }

    public Set<Set<V>> greedyGraphColoring(Graph<V, E> Ginit) {
        Graph<V, E> G = Operations.copyGraph(Ginit, this.graphFactory);
        HashSet<Set<V>> sol = new HashSet<Set<V>>();
        MIS<V, E> mis = new MIS<V, E>(this.graphFactory, this.vertexFactory, this.edgeFactory);
        while (G.getVertexCount() != 0) {
            Set misSet = mis.maximalIndependentSetGreedy(G);
            sol.add(misSet);
            Operations.removeAllVertices(G, misSet);
        }
        return sol;
    }

    public Set<Set<V>> graphColoring(Graph<V, E> Ginit) {
        Graph<V, E> G = Operations.copyGraph(Ginit, this.graphFactory);
        return this.graphColoringInternal(G);
    }

    protected Set<Set<V>> graphColoringInternal(Graph<V, E> G) {
        double n = G.getVertexCount();
        int best = (int)n;
        Set<Set<V>> bestSol = new HashSet<Set<V>>();
        long ncomb = (long)Math.pow(2.0, best);
        ArrayList nodesArray = new ArrayList();
        nodesArray.addAll(G.getVertices());
        long i = 1L;
        while (i < ncomb) {
            HashSet S = new HashSet();
            String comb = Long.toBinaryString(i);
            int k = 0;
            while (k < comb.length()) {
                if (comb.charAt(k) == '1') {
                    S.add(nodesArray.get(comb.length() - k - 1));
                }
                ++k;
            }
            if (MIS.isMaximalIndependentSet(G, S) && (double)S.size() >= 0.19903 * n) {
                Graph GS = (Graph)this.graphFactory.create();
                Operations.subGraph(G, GS, S);
                Operations.removeAllVertices(G, S);
                Set<Set<V>> sol = this.graphColoringInternal(G);
                Operations.mergeGraph(G, GS);
                best = Math.min(best, sol.size() + 1);
                if (best == sol.size() + 1) {
                    bestSol = sol;
                    bestSol.add(S);
                }
            }
            if ((n - 0.19903 * n) / 2.0 <= (double)S.size() && (double)S.size() <= (n + 0.19903 * n) / 2.0) {
                Graph GS = (Graph)this.graphFactory.create();
                HashSet V_S = new HashSet();
                Sets.difference(new HashSet(G.getVertices()), S).copyInto(V_S);
                Operations.subGraph(G, GS, V_S);
                Operations.removeAllVertices(G, V_S);
                Set<Set<V>> sol = this.graphColoringInternal(G);
                int cnGS = sol.size();
                Operations.mergeGraph(G, GS);
                Graph G_S = (Graph)this.graphFactory.create();
                Operations.subGraph(G, G_S, S);
                Operations.removeAllVertices(G, S);
                Set<Set<V>> sol2 = this.graphColoringInternal(G);
                int cnG_S = sol2.size();
                Operations.mergeGraph(G, G_S);
                best = Math.min(best, cnGS + cnG_S);
                if (best == cnG_S + cnGS) {
                    bestSol = sol;
                    sol.addAll(sol2);
                }
            }
            ++i;
        }
        if ((double)best == n) {
            for (Object v : G.getVertices()) {
                HashSet toAdd = new HashSet();
                toAdd.add(v);
                bestSol.add(toAdd);
            }
        }
        return bestSol;
    }

    public int chromaticNumberBodlaenderKratsch(Graph<V, E> Ginit) {
        Graph<V, E> G = Operations.copyGraph(Ginit, this.graphFactory);
        return this.chromaticNumberInternal(G);
    }

    protected int chromaticNumberInternal(Graph<V, E> G) {
        int n;
        int best = n = G.getVertexCount();
        long ncomb = (long)Math.pow(2.0, best);
        ArrayList nodesArray = new ArrayList();
        nodesArray.addAll(G.getVertices());
        long i = 1L;
        while (i < ncomb) {
            HashSet S = new HashSet();
            String comb = Long.toBinaryString(i);
            int k = 0;
            while (k < comb.length()) {
                if (comb.charAt(k) == '1') {
                    S.add(nodesArray.get(comb.length() - k - 1));
                }
                ++k;
            }
            if (MIS.isMaximalIndependentSet(G, S) && (double)S.size() >= 0.19903 * (double)n) {
                Graph GS = (Graph)this.graphFactory.create();
                Operations.subGraph(G, GS, S);
                Operations.removeAllVertices(G, S);
                int cnG_S = this.chromaticNumberInternal(G);
                Operations.mergeGraph(G, GS);
                best = Math.min(best, 1 + cnG_S);
            }
            if (((double)n - 0.19903 * (double)n) / 2.0 <= (double)S.size() && (double)S.size() <= ((double)n + 0.19903 * (double)n) / 2.0) {
                Graph GS = (Graph)this.graphFactory.create();
                HashSet V_S = new HashSet();
                Sets.difference(new HashSet(G.getVertices()), S).copyInto(V_S);
                Operations.subGraph(G, GS, V_S);
                Operations.removeAllVertices(G, V_S);
                int cnGS = this.chromaticNumberInternal(G);
                Operations.mergeGraph(G, GS);
                Graph G_S = (Graph)this.graphFactory.create();
                Operations.subGraph(G, G_S, S);
                Operations.removeAllVertices(G, S);
                int cnG_S = this.chromaticNumberInternal(G);
                Operations.mergeGraph(G, G_S);
                best = Math.min(best, cnGS + cnG_S);
            }
            ++i;
        }
        return best;
    }

    protected void computeAi(Graph<V, E> g) {
        this.S_0x = new HashMap<String, Integer>();
        int n = g.getVertexCount();
        Collection Vset = g.getVertices();
        ArrayList Varray = new ArrayList(Vset);
        long N = (long)Math.pow(2.0, n);
        String s = Coloring.longToString(N - 1L, n);
        this.S_0x.put(s, 0);
        long i = N - 2L;
        while (i >= 0L) {
            s = Coloring.longToString(i, n);
            if (!this.S_0x.containsKey(s)) {
                this.computeSx(g, s, Varray);
            }
            --i;
        }
    }

    protected int computeSx(Graph<V, E> g, String X, ArrayList<V> Varray) {
        StringBuffer sbW = new StringBuffer(X.length());
        int i = 0;
        while (i < X.length()) {
            sbW.replace(i, i + 1, "0");
            ++i;
        }
        return this.computeSWx(g, X, new String(sbW), Varray);
    }

    protected int computeSWx(Graph<V, E> g, String X, String W, ArrayList<V> Varray) {
        Integer res;
        boolean W_full_0 = true;
        int i = 0;
        while (i < W.length()) {
            W_full_0 = W_full_0 && W.charAt(i) == '0';
            ++i;
        }
        if (W_full_0 && (res = this.S_0x.get(X)) != null) {
            return res;
        }
        HashSet<V> setW = new HashSet<V>();
        boolean full_1 = true;
        int i2 = 0;
        while (i2 < W.length()) {
            boolean bl = full_1 = full_1 && (W.charAt(i2) == '1' || X.charAt(i2) == '1');
            if (W.charAt(i2) == '1') {
                setW.add(Varray.get(i2));
            }
            ++i2;
        }
        if (full_1) {
            if (MIS.isIndependentSet(g, setW)) {
                return 1;
            }
            return 0;
        }
        int missing_vertex = 0;
        while (W.charAt(missing_vertex) != '0' || X.charAt(missing_vertex) != '0') {
            ++missing_vertex;
        }
        StringBuffer SBX2 = new StringBuffer(X);
        SBX2.replace(missing_vertex, missing_vertex + 1, "1");
        String X2 = new String(SBX2);
        int SwXv = this.computeSWx(g, X2, W, Varray);
        StringBuffer SBW2 = new StringBuffer(W);
        SBW2.replace(missing_vertex, missing_vertex + 1, "1");
        String W2 = new String(SBW2);
        int SwvX = this.computeSWx(g, X, W2, Varray);
        if (W_full_0) {
            this.S_0x.put(X, new Integer(SwXv + SwvX));
        }
        return SwXv + SwvX;
    }

    protected boolean isKColorable(int k) {
        long c_k_S = 0L;
        for (String s : this.S_0x.keySet()) {
            int ai = this.S_0x.get(s);
            long ai_pow_k = (long)Math.pow(ai, k);
            int t = 0;
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i) == '1') {
                    ++t;
                }
                ++i;
            }
            if (t % 2 == 0) {
                c_k_S += ai_pow_k;
                continue;
            }
            c_k_S -= ai_pow_k;
        }
        return c_k_S > 0L;
    }

    public int chromaticNumberBjorklundHusfeldt(Graph<V, E> g) {
        this.computeAi(g);
        int k = 1;
        while (!this.isKColorable(k)) {
            ++k;
        }
        return k;
    }

    private static String longToString(long N, int k) {
        StringBuffer sb = new StringBuffer();
        long R = N;
        int i = 0;
        while (i < k) {
            if (R % 2L == 0L) {
                sb.append('0');
            } else {
                sb.append('1');
            }
            R /= 2L;
            ++i;
        }
        return sb.toString();
    }
}

