/*
 * Decompiled with CFR 0.152.
 */
package agape.algos;

import agape.algos.Algorithms;
import agape.tools.Components;
import agape.tools.Operations;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections15.Factory;

public class MIS<V, E>
extends Algorithms<V, E> {
    public MIS(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory) {
        this.graphFactory = graphFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
    }

    public Set<V> maximalIndependentSetGreedy(Graph<V, E> g) {
        Graph<Object, E> Gp = Operations.copyGraph(g, this.graphFactory);
        HashSet<V> S = new HashSet<V>();
        HashSet<V> M = new HashSet<V>();
        while (!Gp.getVertices().isEmpty()) {
            for (Object v : M) {
                Gp.removeVertex(v);
            }
            V x = Operations.getMinDegVertex(Gp);
            if (x == null) continue;
            S.add(x);
            M.add(x);
            if (Gp.getNeighbors(x) == null) continue;
            M.addAll(Gp.getNeighbors(x));
        }
        return S;
    }

    public Set<V> maximumIndependentSetBruteForce(Graph<V, E> g) {
        HashSet S = new HashSet();
        long ncomb = (long)Math.pow(2.0, g.getVertexCount());
        Object[] nodes = g.getVertices().toArray();
        long i = 0L;
        while (i < ncomb) {
            HashSet<Object> Sp = new HashSet<Object>();
            String comb = Long.toBinaryString(i);
            int k = 0;
            while (k < comb.length()) {
                if (comb.charAt(k) == '1') {
                    Sp.add(nodes[k]);
                }
                ++k;
            }
            if (MIS.isIndependentSet(g, Sp) && Sp.size() > S.size()) {
                S = Sp;
            }
            ++i;
        }
        return S;
    }

    public Set<V> maximumIndependentSetMoonMoser(Graph<V, E> g) {
        HashSet S = new HashSet();
        return this.maximumIndependentSetMoonMoser(g, S);
    }

    protected Set<V> maximumIndependentSetMoonMoser(Graph<V, E> G, Set<V> S) {
        if (!G.getVertices().isEmpty()) {
            V v = Operations.getMinDegVertex(G);
            HashSet<V> Nv = new HashSet<V>();
            Nv.addAll(G.getNeighbors(v));
            Nv.add(v);
            Set<Object> Smax = new HashSet();
            for (Object u : Nv) {
                Graph Gp = Operations.copyUndirectedSparseGraph(G);
                HashSet Nu = new HashSet();
                Nu.addAll(G.getNeighbors(u));
                Nu.add(u);
                Set<Object> Stemp = new HashSet();
                HashSet<Object> Su = new HashSet<Object>();
                Su.addAll(S);
                Su.add(u);
                for (Object nu : Nu) {
                    Gp.removeVertex(nu);
                }
                Stemp = this.maximumIndependentSetMoonMoser(Gp, Su);
                if (Stemp.size() <= Smax.size()) continue;
                Smax = Stemp;
            }
            return Smax;
        }
        return S;
    }

    public Set<V> maximumIndependentSetMoonMoserNonRecursive(Graph<V, E> g) {
        Stack<Graph<V, E>> stackG = new Stack<Graph<V, E>>();
        Stack stackS = new Stack();
        Set Smax = new HashSet();
        stackG.push(g);
        stackS.push(new HashSet());
        while (!stackG.empty()) {
            Graph G = (Graph)stackG.pop();
            Set S = (Set)stackS.pop();
            if (!G.getVertices().isEmpty()) {
                Object v = Operations.getMinDegVertex(G);
                HashSet Nv = new HashSet();
                Nv.addAll(G.getNeighbors(v));
                Nv.add(v);
                for (Object u : Nv) {
                    Graph Gp = Operations.copyUndirectedSparseGraph(G);
                    HashSet Nu = new HashSet();
                    Nu.addAll(G.getNeighbors(u));
                    Nu.add(u);
                    HashSet Su = new HashSet();
                    Su.addAll(S);
                    Su.add(u);
                    for (Object nu : Nu) {
                        Gp.removeVertex(nu);
                    }
                    stackG.push(Gp);
                    stackS.push(Su);
                }
                continue;
            }
            if (S.size() <= Smax.size()) continue;
            Smax = S;
        }
        return Smax;
    }

    public Set<V> maximumIndependentSetMaximumDegree(Graph<V, E> g) {
        Graph<Object, E> G3 = Operations.copyGraph(g, this.graphFactory);
        int degmax = Operations.getMaxDeg(G3);
        Set<Object> S = new HashSet();
        if (degmax >= 3) {
            V x = Operations.getMaxDegVertex(G3);
            HashSet<V> Nx = new HashSet<V>();
            Nx.addAll(G3.getNeighbors(x));
            Nx.add(x);
            Graph Gp = (Graph)this.graphFactory.create();
            for (Object nx : Nx) {
                Operations.subGraph(G3, Gp, nx);
            }
            for (Object nx : Nx) {
                G3.removeVertex(nx);
            }
            S = this.maximumIndependentSetMaximumDegree(G3);
            Operations.mergeGraph(G3, Gp);
            S.add(x);
            Set<Object> S_ = new HashSet();
            Graph Gpp = (Graph)this.graphFactory.create();
            Operations.subGraph(G3, Gpp, x);
            G3.removeVertex(x);
            S_ = this.maximumIndependentSetMaximumDegree(G3);
            Operations.mergeGraph(G3, Gpp);
            if (S_.size() > S.size()) {
                S = S_;
            }
        } else {
            S = this.maximalIndependentSetGreedy(G3);
        }
        return S;
    }

    public Set<V> maximuRmIndependentSetFominGrandoniKratsch(Graph<V, E> g) {
        int Vsize = g.getVertices().size();
        if (Vsize <= 1) {
            return new HashSet(g.getVertices());
        }
        Set C = Components.getConnectedComponent(g);
        if (!C.isEmpty() && C.size() < Vsize) {
            Graph<Object, Object> GC = Operations.copyUndirectedSparseGraph(g);
            Graph<Object, Object> G_C = Operations.copyUndirectedSparseGraph(g);
            HashSet toKeep = new HashSet(g.getVertices());
            for (Object c : toKeep) {
                if (C.contains(c)) continue;
                GC.removeVertex(c);
            }
            for (Object c : C) {
                G_C.removeVertex(c);
            }
            HashSet<Object> U = new HashSet<Object>();
            U.addAll(this.maximuRmIndependentSetFominGrandoniKratsch(GC));
            U.addAll(this.maximuRmIndependentSetFominGrandoniKratsch(G_C));
            return U;
        }
        Object v = MIS.getDominatedVertex(g);
        if (v != null) {
            Graph<Object, Object> G_v = Operations.copyUndirectedSparseGraph(g);
            G_v.removeVertex(v);
            return this.maximuRmIndependentSetFominGrandoniKratsch(G_v);
        }
        boolean deg2 = false;
        Object x = null;
        Iterator itr = g.getVertices().iterator();
        while (!deg2 && itr.hasNext()) {
            x = itr.next();
            if (g.getNeighbors(x).size() != 2) continue;
            deg2 = true;
        }
        if (deg2) {
            HashSet<Object> uF = new HashSet<Object>();
            HashMap vftable = new HashMap();
            Set<Object> F = this.maximuRmIndependentSetFominGrandoniKratsch(MIS.getFoldingGraph(g, x, vftable, this.vertexFactory, this.edgeFactory));
            boolean fold = false;
            for (Object object : F) {
                if (vftable.containsKey(object)) {
                    uF.addAll((Collection)vftable.get(object));
                    fold = true;
                    continue;
                }
                uF.add(object);
            }
            if (!fold) {
                uF.add(x);
            }
            return uF;
        }
        Set<Object> Mdeg = Operations.getAllMaxDegVertex(g);
        Object d = null;
        int ENv = Integer.MAX_VALUE;
        for (Object y : Mdeg) {
            int ENy = Operations.getNbEdges(g, new HashSet<Object>(g.getNeighbors(y)));
            if (ENy >= ENv) continue;
            ENv = ENy;
            d = y;
        }
        Graph<Object, Object> G_v_Mv = Operations.copyUndirectedSparseGraph(g);
        Graph<Object, Object> graph = Operations.copyUndirectedSparseGraph(g);
        G_v_Mv.removeVertex(d);
        Set<Object> M = MIS.getMirrors(g, d);
        for (Object object : M) {
            G_v_Mv.removeVertex(object);
        }
        HashSet<Object> hashSet = new HashSet<Object>(g.getNeighbors(d));
        for (Object e : hashSet) {
            graph.removeVertex(e);
        }
        graph.removeVertex(d);
        Set<Object> set = this.maximuRmIndependentSetFominGrandoniKratsch(G_v_Mv);
        Set<Object> S2 = this.maximuRmIndependentSetFominGrandoniKratsch(graph);
        S2.add(d);
        if (set.size() > S2.size()) {
            return set;
        }
        return S2;
    }

    public static <V, E> boolean isIndependentSet(Graph<V, E> g, Set<V> S) {
        boolean b = true;
        Iterator<V> itr = S.iterator();
        while (b && itr.hasNext()) {
            HashSet<V> Nv;
            V v = itr.next();
            Collection<V> N = g.getNeighbors(v);
            if (N == null || Sets.intersection(S, Nv = new HashSet<V>(N)).isEmpty()) continue;
            b = false;
        }
        return b;
    }

    public static <V, E> boolean isMaximalIndependentSet(Graph<V, E> g, Set<V> S) {
        boolean b = true;
        if (MIS.isIndependentSet(g, S)) {
            HashSet NS = new HashSet(g.getVertices());
            NS.removeAll(S);
            Iterator itr = NS.iterator();
            while (b && itr.hasNext()) {
                Object v = itr.next();
                if (!Sets.intersection(new HashSet(g.getNeighbors(v)), S).isEmpty()) continue;
                b = false;
            }
        } else {
            b = false;
        }
        return b;
    }

    protected static <V, E> Graph<V, E> getFoldingGraph(Graph<V, E> G, V v, HashMap<V, Set<V>> fold, Factory<V> vertexFactory, Factory<E> edgeFactory) {
        int j;
        Graph<Object, E> Gv = Operations.copyUndirectedSparseGraph(G);
        ArrayList<V> newv = new ArrayList<V>();
        HashSet<V> Nv = new HashSet<V>();
        Nv.addAll(G.getNeighbors(v));
        ArrayList Nvlist = new ArrayList(Nv);
        int i = 0;
        while (i < Nvlist.size() - 1) {
            j = i + 1;
            while (j < Nvlist.size()) {
                Object uj;
                Object ui = Nvlist.get(i);
                if (!Operations.isEdge(G, ui, uj = Nvlist.get(j))) {
                    E ei;
                    V uij = vertexFactory.create();
                    Gv.addVertex(uij);
                    HashSet vfolded = new HashSet();
                    vfolded.add(ui);
                    vfolded.add(uj);
                    fold.put(uij, vfolded);
                    for (Object nui : G.getNeighbors(ui)) {
                        if (Operations.isEdge(G, uij, nui)) continue;
                        ei = edgeFactory.create();
                        while (Gv.getEdges().contains(ei)) {
                            ei = edgeFactory.create();
                        }
                        Gv.addEdge(ei, uij, nui);
                    }
                    for (Object nuj : G.getNeighbors(uj)) {
                        if (Operations.isEdge(G, uij, nuj)) continue;
                        ei = edgeFactory.create();
                        while (Gv.getEdges().contains(ei)) {
                            ei = edgeFactory.create();
                        }
                        Gv.addEdge(ei, uij, nuj);
                    }
                    newv.add(uij);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < newv.size() - 1) {
            j = i + 1;
            while (j < newv.size()) {
                if (!Operations.isEdge(G, newv.get(i), newv.get(j))) {
                    E ei = edgeFactory.create();
                    Gv.addEdge(ei, newv.get(i), newv.get(j));
                }
                ++j;
            }
            ++i;
        }
        for (Object x : Nv) {
            Gv.removeVertex(x);
        }
        Gv.removeVertex(v);
        return Gv;
    }

    protected static <V, E> Set<V> getMirrors(Graph<V, E> G, V v) {
        HashSet<Object> Mv = new HashSet<Object>();
        Set<Object> U = new HashSet();
        HashSet<V> Nv = new HashSet<V>();
        Nv.addAll(G.getNeighbors(v));
        U = Operations.getNeighbors(G, v, 2);
        for (Object u : U) {
            HashSet C = new HashSet();
            Sets.difference(Nv, new HashSet<Object>(G.getNeighbors(u))).copyInto(C);
            if (!Operations.isClique(G, C)) continue;
            Mv.add(u);
        }
        return Mv;
    }

    protected static <V, E> V getDominatedVertex(Graph<V, E> G) {
        V v = null;
        HashMap dom = new HashMap();
        ArrayList N = new ArrayList();
        for (Object x : G.getVertices()) {
            HashSet Nx = new HashSet();
            Nx.addAll(new HashSet(G.getNeighbors(x)));
            Nx.add(x);
            dom.put(Nx, x);
            N.add(Nx);
        }
        Operations.quickSortSet(N, 0, N.size() - 1);
        boolean vfound = false;
        int i = N.size() - 1;
        while (i > 0 && !vfound) {
            Set Nv = N.get(i);
            int j = 0;
            while (j < i && !vfound) {
                Set Nw = N.get(j);
                if (Nv.containsAll(Nw)) {
                    v = dom.get(Nv);
                    vfound = true;
                }
                ++j;
            }
            --i;
        }
        return v;
    }
}

