/*
 * Decompiled with CFR 0.152.
 */
package agape.algos;

import agape.algos.Algorithms;
import agape.tools.Operations;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.Graph;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections15.Factory;

public class MVC<V, E>
extends Algorithms<V, E> {
    private Set<V> VCbuf = null;
    private Set<V> VCFinal;

    public MVC(Factory<Graph<V, E>> graphFactory) {
        this.graphFactory = graphFactory;
    }

    public Set<V> getVertexCoverSolution() {
        if (this.VCFinal.size() == 0) {
            return null;
        }
        return this.VCFinal;
    }

    private void initSolution() {
        this.VCFinal = new HashSet<V>();
        this.VCbuf = new HashSet<V>();
    }

    public Set<V> twoApproximationCover(Graph<V, E> g) {
        this.initSolution();
        Graph Gp = Operations.copyGraph(g, this.graphFactory);
        while (Gp.getEdgeCount() > 0) {
            Object e = Gp.getEdges().iterator().next();
            V u = Gp.getEndpoints(e).getFirst();
            V v = Gp.getEndpoints(e).getSecond();
            this.VCFinal.add(u);
            this.VCFinal.add(v);
            Gp.removeVertex(u);
            Gp.removeVertex(v);
        }
        return this.VCFinal;
    }

    public Set<V> greedyCoverMaxDegree(Graph<V, E> g) {
        this.initSolution();
        Graph<V, E> Gp = Operations.copyGraph(g, this.graphFactory);
        while (Gp.getEdgeCount() > 0) {
            V v = Operations.getMaxDegVertex(Gp);
            this.VCFinal.add(v);
            Gp.removeVertex(v);
        }
        return this.VCFinal;
    }

    public boolean kVertexCoverBruteForce(Graph<V, E> g, int k) {
        this.initSolution();
        Graph<V, E> g2 = Operations.copyGraph(g, this.graphFactory);
        return this.kVertexCoverBruteForce(g2, k, this.VCFinal, new HashSet(), new HashSet(g2.getVertices()));
    }

    protected boolean kVertexCoverBruteForce(Graph<V, E> G, int k, Set<V> VCcurrent, Set<E> viewed, Set<V> remaining) {
        if (k <= 0 && remaining.size() > 0) {
            return false;
        }
        if (viewed.size() == G.getEdgeCount()) {
            if (this.VCbuf.size() < VCcurrent.size() || VCcurrent.isEmpty()) {
                VCcurrent.clear();
                VCcurrent.addAll(this.VCbuf);
            }
            return true;
        }
        boolean res = false;
        for (V v_considered_in_the_solution1 : remaining) {
            this.VCbuf.add(v_considered_in_the_solution1);
            HashSet viewed2 = new HashSet(viewed);
            HashSet<V> remaining2 = new HashSet<V>(remaining);
            remaining2.remove(v_considered_in_the_solution1);
            viewed2.addAll(G.getIncidentEdges(v_considered_in_the_solution1));
            HashSet<V> oldVCbuf = new HashSet<V>(this.VCbuf);
            res = this.kVertexCoverBruteForce(G, k - 1, VCcurrent, viewed2, remaining2) || res;
            this.VCbuf = oldVCbuf;
            this.VCbuf.remove(v_considered_in_the_solution1);
        }
        return res;
    }

    public boolean kVertexCoverDegreeBranchingStrategy(Graph<V, E> g, int k) {
        this.initSolution();
        Graph<V, E> g2 = Operations.copyGraph(g, this.graphFactory);
        return this.kVertexCoverDegreeBranchingStrategy(g2, k, this.VCFinal);
    }

    protected boolean kVertexCoverDegreeBranchingStrategy(Graph<V, E> G, int k, Set<V> VCcurrent) {
        int nbe = G.getEdgeCount();
        if (nbe == 0) {
            if (this.VCbuf.size() < VCcurrent.size() || VCcurrent.isEmpty()) {
                VCcurrent.clear();
                VCcurrent.addAll(this.VCbuf);
            }
            return true;
        }
        if (nbe >= k * G.getVertexCount()) {
            return false;
        }
        V vone = Operations.getDegVertex(G, 1);
        if (vone != null) {
            HashSet<V> Nvone = new HashSet<V>(G.getNeighbors(vone));
            Graph Gp = (Graph)this.graphFactory.create();
            for (Object v : Nvone) {
                Operations.subGraph(G, Gp, v);
            }
            this.VCbuf.addAll(Nvone);
            Operations.removeAllVertices(G, Nvone);
            boolean b = this.kVertexCoverDegreeBranchingStrategy(G, k - Nvone.size(), VCcurrent);
            Operations.mergeGraph(G, Gp);
            this.VCbuf.removeAll(Nvone);
            return b;
        }
        V vtwo = Operations.getDegVertex(G, 2);
        if (vtwo != null) {
            Set<V> Nvtwo2 = Operations.getNeighbors(G, vtwo, 2);
            HashSet<V> Nvtwo = new HashSet<V>(G.getNeighbors(vtwo));
            Graph GNv2 = (Graph)this.graphFactory.create();
            Graph GNv = (Graph)this.graphFactory.create();
            Operations.subGraph(G, GNv2, vtwo);
            for (V v : Nvtwo2) {
                Operations.subGraph(G, GNv2, v);
            }
            this.VCbuf.add(vtwo);
            this.VCbuf.addAll(Nvtwo2);
            G.removeVertex(vtwo);
            Operations.removeAllVertices(G, Nvtwo2);
            boolean a = this.kVertexCoverDegreeBranchingStrategy(G, k - Nvtwo2.size() - 1, VCcurrent);
            Operations.mergeGraph(G, GNv2);
            this.VCbuf.remove(vtwo);
            this.VCbuf.removeAll(Nvtwo2);
            for (Object v : Nvtwo) {
                Operations.subGraph(G, GNv, v);
            }
            this.VCbuf.addAll(Nvtwo);
            Operations.removeAllVertices(G, Nvtwo);
            boolean b = this.kVertexCoverDegreeBranchingStrategy(G, k - Nvtwo.size(), VCcurrent);
            Operations.mergeGraph(G, GNv);
            this.VCbuf.removeAll(Nvtwo);
            return a || b;
        }
        V vmax = Operations.getMaxDegVertex(G);
        if (vmax != null && G.degree(vmax) >= 3) {
            HashSet<V> Nvmax = new HashSet<V>(G.getNeighbors(vmax));
            Graph Gvmax = (Graph)this.graphFactory.create();
            Graph GNvmax = (Graph)this.graphFactory.create();
            Operations.subGraph(G, Gvmax, vmax);
            this.VCbuf.add(vmax);
            G.removeVertex(vmax);
            boolean a = this.kVertexCoverDegreeBranchingStrategy(G, k - 1, VCcurrent);
            Operations.mergeGraph(G, Gvmax);
            this.VCbuf.remove(vmax);
            for (Object v : Nvmax) {
                Operations.subGraph(G, GNvmax, v);
            }
            this.VCbuf.addAll(Nvmax);
            Operations.removeAllVertices(G, Nvmax);
            boolean b = this.kVertexCoverDegreeBranchingStrategy(G, k - Nvmax.size(), VCcurrent);
            Operations.mergeGraph(G, GNvmax);
            this.VCbuf.removeAll(Nvmax);
            return a || b;
        }
        return this.kVertexCoverDegreeBranchingStrategy(G, k, VCcurrent);
    }

    public boolean kVertexCoverBussGoldsmith(Graph<V, E> g, int k) {
        this.initSolution();
        Graph<V, E> g2 = Operations.copyGraph(g, this.graphFactory);
        return this.kVertexCoverKernel(g2, k, this.VCFinal);
    }

    protected boolean kVertexCoverKernel(Graph<V, E> G, int k, Set<V> VCfinal) {
        V vmax;
        int nbe = G.getEdgeCount();
        if (nbe == 0) {
            if (this.VCbuf.size() < VCfinal.size() || VCfinal.isEmpty()) {
                VCfinal.clear();
                VCfinal.addAll(this.VCbuf);
            }
            return true;
        }
        if (nbe >= k * G.getVertexCount()) {
            return false;
        }
        Set<Object> K = new HashSet();
        V vmin = Operations.getMinDegVertex(G);
        int degmin = G.degree(vmin);
        int degmax = Operations.getMaxDeg(G);
        Graph<V, E> Gp = G;
        if (degmin == 0 || degmin == 1 || degmax > k) {
            Gp = Operations.copyUndirectedSparseGraph(G);
            K = this.kVertexCoverKernelizationBussInternal(Gp, k);
            k -= K.size();
            this.VCbuf.addAll(K);
        }
        if ((vmax = Operations.getMaxDegVertex(Gp)) == null) {
            return this.kVertexCoverKernel(Gp, k, VCfinal);
        }
        HashSet<V> oldVCbuf = new HashSet<V>(this.VCbuf);
        int degvmax = Gp.degree(vmax);
        this.VCbuf.add(vmax);
        Graph Gvmax = (Graph)this.graphFactory.create();
        Operations.subGraph(Gp, Gvmax, vmax);
        Gp.removeVertex(vmax);
        boolean a = this.kVertexCoverKernel(Gp, k - 1, VCfinal);
        Operations.mergeGraph(Gp, Gvmax);
        this.VCbuf = new HashSet<V>(oldVCbuf);
        Graph GNvmax = (Graph)this.graphFactory.create();
        if (degvmax > 0) {
            HashSet<V> Nvmax = new HashSet<V>(Gp.getNeighbors(vmax));
            for (Object nv : Nvmax) {
                Operations.subGraph(Gp, GNvmax, nv);
            }
            this.VCbuf.addAll(Nvmax);
            Operations.removeAllVertices(Gp, Nvmax);
        }
        boolean b = this.kVertexCoverKernel(Gp, k - degvmax, VCfinal);
        Operations.mergeGraph(Gp, GNvmax);
        return a || b;
    }

    public boolean kVertexCoverNiedermeier(Graph<V, E> g, int k) {
        this.initSolution();
        Graph<V, E> g2 = Operations.copyGraph(g, this.graphFactory);
        return this.kVertexCoverNiedermeier(g2, k, this.VCFinal);
    }

    protected boolean kVertexCoverNiedermeier(Graph<V, E> g, int k, Set<V> VCfinal) {
        int nbe = g.getEdgeCount();
        if (nbe == 0) {
            if (this.VCbuf.size() < VCfinal.size() || VCfinal.isEmpty()) {
                VCfinal.clear();
                VCfinal.addAll(this.VCbuf);
            }
            return true;
        }
        if (nbe >= k * g.getVertexCount()) {
            return false;
        }
        if (Operations.getMinDeg(g) == 0) {
            Graph Gp = (Graph)this.graphFactory.create();
            Set<Object> vZeros = Operations.getAllMinDegVertex(g);
            for (Object v : vZeros) {
                Operations.subGraph(g, Gp, v);
            }
            Operations.removeAllVertices(g, vZeros);
            boolean b = this.kVertexCoverNiedermeier(g, k, VCfinal);
            Operations.mergeGraph(g, Gp);
            return b;
        }
        Object vone = Operations.getDegVertex(g, 1);
        if (vone != null) {
            Graph Gp = (Graph)this.graphFactory.create();
            Object Nvone = g.getNeighbors(vone).iterator().next();
            this.VCbuf.add(Nvone);
            Operations.subGraph(g, Gp, Nvone);
            g.removeVertex(Nvone);
            boolean b = this.kVertexCoverNiedermeier(g, k - 1, VCfinal);
            Operations.mergeGraph(g, Gp);
            this.VCbuf.remove(Nvone);
            return b;
        }
        Object vfivemore = Operations.getMaxDegVertex(g);
        if (g.degree(vfivemore) >= 5) {
            HashSet<Object> Nvfivemore = new HashSet<Object>(g.getNeighbors(vfivemore));
            Graph Gf = (Graph)this.graphFactory.create();
            Graph GNf = (Graph)this.graphFactory.create();
            Operations.subGraph(g, Gf, vfivemore);
            this.VCbuf.add(vfivemore);
            g.removeVertex(vfivemore);
            boolean bx = this.kVertexCoverNiedermeier(g, k - 1, VCfinal);
            Operations.mergeGraph(g, Gf);
            this.VCbuf.remove(vfivemore);
            this.VCbuf.addAll(Nvfivemore);
            for (Object v : Nvfivemore) {
                Operations.subGraph(g, GNf, v);
            }
            Operations.removeAllVertices(g, Nvfivemore);
            boolean bnx = this.kVertexCoverNiedermeier(g, k - Nvfivemore.size(), VCfinal);
            Operations.mergeGraph(g, GNf);
            this.VCbuf.removeAll(Nvfivemore);
            return bx || bnx;
        }
        if (Operations.isRegular(g)) {
            Object v = g.getVertices().iterator().next();
            HashSet Nv = new HashSet(g.getNeighbors(v));
            Graph Gv = (Graph)this.graphFactory.create();
            Graph GNv = (Graph)this.graphFactory.create();
            Operations.subGraph(g, Gv, v);
            this.VCbuf.add(v);
            g.removeVertex(v);
            boolean bx = this.kVertexCoverNiedermeier(g, k - 1, VCfinal);
            Operations.mergeGraph(g, Gv);
            this.VCbuf.remove(v);
            this.VCbuf.addAll(Nv);
            for (Object x : Nv) {
                Operations.subGraph(g, GNv, x);
            }
            Operations.removeAllVertices(g, Nv);
            boolean bnx = this.kVertexCoverNiedermeier(g, k - Nv.size(), VCfinal);
            Operations.mergeGraph(g, GNv);
            this.VCbuf.removeAll(Nv);
            return bx || bnx;
        }
        Object vtwo = null;
        vtwo = Operations.getDegVertex(g, 2);
        if (vtwo != null) {
            Object vb;
            Iterator<Object> itrvtwo = g.getNeighbors(vtwo).iterator();
            Object va = itrvtwo.next();
            if (Operations.isEdge(g, va, vb = itrvtwo.next())) {
                Graph Gp = (Graph)this.graphFactory.create();
                this.VCbuf.add(va);
                this.VCbuf.add(vb);
                Operations.subGraph(g, Gp, va);
                Operations.subGraph(g, Gp, vb);
                g.removeVertex(va);
                g.removeVertex(vb);
                boolean b = this.kVertexCoverNiedermeier(g, k - 2, VCfinal);
                Operations.mergeGraph(g, Gp);
                this.VCbuf.remove(va);
                this.VCbuf.remove(vb);
                return b;
            }
            if (!Operations.isEdge(g, va, vb) && g.degree(va) == 2 && g.degree(vb) == 2) {
                HashSet<Object> Nva = new HashSet<Object>(g.getNeighbors(va));
                HashSet<Object> Nvb = new HashSet<Object>(g.getNeighbors(vb));
                Nva.remove(vtwo);
                Nvb.remove(vtwo);
                if (Nva.equals(Nvb)) {
                    Graph Gp = (Graph)this.graphFactory.create();
                    this.VCbuf.add(vtwo);
                    this.VCbuf.add(Nva.iterator().next());
                    Operations.subGraph(g, Gp, vtwo);
                    Operations.subGraph(g, Gp, Nva.iterator().next());
                    g.removeVertex(vtwo);
                    g.removeVertex(Nva.iterator().next());
                    boolean b = this.kVertexCoverNiedermeier(g, k - 2, VCfinal);
                    Operations.mergeGraph(g, Gp);
                    this.VCbuf.remove(vtwo);
                    this.VCbuf.remove(Nva.iterator().next());
                    return b;
                }
            }
            HashSet<Object> Nx = new HashSet<Object>(g.getNeighbors(vtwo));
            HashSet<Object> Na = new HashSet<Object>(g.getNeighbors(va));
            HashSet<Object> Nb = new HashSet<Object>(g.getNeighbors(vb));
            HashSet NaNb = new HashSet();
            Sets.union(Na, Nb).copyInto(NaNb);
            Graph GNx = (Graph)this.graphFactory.create();
            Graph GNaNb = (Graph)this.graphFactory.create();
            this.VCbuf.addAll(Nx);
            for (Object e : Nx) {
                Operations.subGraph(g, GNx, e);
            }
            Operations.removeAllVertices(g, Nx);
            boolean bl = this.kVertexCoverNiedermeier(g, k - Nx.size(), VCfinal);
            this.VCbuf.removeAll(Nx);
            Operations.mergeGraph(g, GNx);
            this.VCbuf.addAll(NaNb);
            for (Object e : NaNb) {
                Operations.subGraph(g, GNaNb, e);
            }
            Operations.removeAllVertices(g, NaNb);
            boolean bl2 = this.kVertexCoverNiedermeier(g, k - NaNb.size(), VCfinal);
            Operations.mergeGraph(g, GNaNb);
            this.VCbuf.removeAll(NaNb);
            return bl || bl2;
        }
        Object vthree = null;
        vthree = Operations.getDegVertex(g, 3);
        if (vthree != null) {
            Iterator<Object> itrvthree = g.getNeighbors(vthree).iterator();
            Object va = itrvthree.next();
            Object vb = itrvthree.next();
            Object vc = itrvthree.next();
            Object t = null;
            if (Operations.isEdge(g, va, vb)) {
                t = vc;
            } else if (Operations.isEdge(g, va, vc)) {
                t = vb;
            } else if (Operations.isEdge(g, vb, vc)) {
                t = va;
            }
            if (t != null) {
                HashSet<Object> Nx = new HashSet<Object>(g.getNeighbors(vthree));
                HashSet<Object> Nt = new HashSet<Object>(g.getNeighbors(t));
                Graph GNx = (Graph)this.graphFactory.create();
                Graph graph = (Graph)this.graphFactory.create();
                this.VCbuf.addAll(Nx);
                for (Object e : Nx) {
                    Operations.subGraph(g, GNx, e);
                }
                Operations.removeAllVertices(g, Nx);
                boolean bl = this.kVertexCoverNiedermeier(g, k - Nx.size(), VCfinal);
                this.VCbuf.removeAll(Nx);
                Operations.mergeGraph(g, GNx);
                this.VCbuf.addAll(Nt);
                for (Object e : Nt) {
                    Operations.subGraph(g, graph, e);
                }
                Operations.removeAllVertices(g, Nt);
                boolean bl3 = this.kVertexCoverNiedermeier(g, k - Nt.size(), VCfinal);
                Operations.mergeGraph(g, graph);
                this.VCbuf.removeAll(Nt);
                return bl || bl3;
            }
            HashSet<Object> Na = new HashSet<Object>(g.getNeighbors(va));
            HashSet<Object> Nb = new HashSet<Object>(g.getNeighbors(vb));
            HashSet<Object> Nc = new HashSet<Object>(g.getNeighbors(vc));
            HashSet hashSet = new HashSet();
            if (!Sets.intersection(Na, Nb).isEmpty()) {
                Sets.intersection(Na, Nb).copyInto(hashSet);
            } else if (!Sets.intersection(Na, Nc).isEmpty()) {
                Sets.intersection(Na, Nc).copyInto(hashSet);
            } else if (!Sets.intersection(Nb, Nc).isEmpty()) {
                Sets.intersection(Nb, Nc).copyInto(hashSet);
            }
            if (!hashSet.isEmpty()) {
                Object e = hashSet.iterator().next();
                HashSet<Object> hashSet2 = new HashSet<Object>(g.getNeighbors(vthree));
                HashSet<Object> xd = new HashSet<Object>();
                xd.add(vthree);
                xd.add(e);
                Graph GNx = (Graph)this.graphFactory.create();
                Graph graph = (Graph)this.graphFactory.create();
                this.VCbuf.addAll(hashSet2);
                for (Object e2 : hashSet2) {
                    Operations.subGraph(g, GNx, e2);
                }
                Operations.removeAllVertices(g, hashSet2);
                boolean bl = this.kVertexCoverNiedermeier(g, k - hashSet2.size(), VCfinal);
                this.VCbuf.removeAll(hashSet2);
                Operations.mergeGraph(g, GNx);
                this.VCbuf.addAll(xd);
                for (Object v : xd) {
                    Operations.subGraph(g, graph, v);
                }
                Operations.removeAllVertices(g, xd);
                boolean bxd = this.kVertexCoverNiedermeier(g, k - xd.size(), VCfinal);
                Operations.mergeGraph(g, graph);
                this.VCbuf.removeAll(xd);
                return bl || bxd;
            }
            HashSet<Object> hashSet3 = new HashSet<Object>(g.getNeighbors(vthree));
            Graph graph = (Graph)this.graphFactory.create();
            Graph GNa = (Graph)this.graphFactory.create();
            Graph GaNbNc = (Graph)this.graphFactory.create();
            this.VCbuf.addAll(hashSet3);
            for (Object e : hashSet3) {
                Operations.subGraph(g, graph, e);
            }
            Operations.removeAllVertices(g, hashSet3);
            boolean bl = this.kVertexCoverNiedermeier(g, k - hashSet3.size(), VCfinal);
            this.VCbuf.removeAll(hashSet3);
            Operations.mergeGraph(g, graph);
            this.VCbuf.addAll(Na);
            for (Object e : Na) {
                Operations.subGraph(g, GNa, e);
            }
            Operations.removeAllVertices(g, Na);
            boolean bl4 = this.kVertexCoverNiedermeier(g, k - Na.size(), VCfinal);
            Operations.mergeGraph(g, GNa);
            this.VCbuf.removeAll(Na);
            HashSet<Object> aNbNc = new HashSet<Object>();
            aNbNc.add(va);
            aNbNc.addAll(Nb);
            aNbNc.addAll(Nc);
            this.VCbuf.addAll(aNbNc);
            for (Object e : aNbNc) {
                Operations.subGraph(g, GaNbNc, e);
            }
            Operations.removeAllVertices(g, aNbNc);
            boolean bl5 = this.kVertexCoverNiedermeier(g, k - aNbNc.size(), VCfinal);
            Operations.mergeGraph(g, GaNbNc);
            this.VCbuf.removeAll(aNbNc);
            return bl || bl4 || bl5;
        }
        return this.kVertexCoverNiedermeier(g, k, VCfinal);
    }

    protected Set<V> kVertexCoverKernelizationBussInternal(Graph<V, E> g, int k) {
        Set<Object> VC = new HashSet();
        if (g.getVertexCount() == 0) {
            return VC;
        }
        V x = Operations.getMinDegVertex(g);
        int degx = g.degree(x);
        if (degx == 0) {
            g.removeVertex(x);
            return this.kVertexCoverKernelizationBussInternal(g, k);
        }
        if (degx == 1) {
            V y = g.getNeighbors(x).iterator().next();
            g.removeVertex(x);
            g.removeVertex(y);
            VC = this.kVertexCoverKernelizationBussInternal(g, k - 1);
            VC.add(y);
        }
        x = Operations.getMaxDegVertex(g);
        degx = -1;
        if (x != null) {
            degx = g.degree(x);
        }
        if (degx > k) {
            g.removeVertex(x);
            VC = this.kVertexCoverKernelizationBussInternal(g, k - 1);
            VC.add(x);
        }
        return VC;
    }
}

