/*
 * Decompiled with CFR 0.152.
 */
package agape.algos;

import agape.algos.Algorithms;
import agape.algos.MarkMap;
import agape.tools.Components;
import agape.tools.Operations;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections15.Factory;

public class MinDFVS<V, E>
extends Algorithms<V, E> {
    final int UM = 10;
    final int LM = 11;
    final int RM = 12;
    final int WLM = 13;
    final int WRM = 14;
    final int LMD = 15;
    final int RMD = 16;
    private Set<V> Tmarked = new HashSet<V>();
    private Stack<V> Mstack = new Stack();
    private Stack<V> Pstack = new Stack();
    private HashMap<V, Integer> Tnodes = new HashMap();

    public MinDFVS(Factory<Graph<V, E>> graphFactory, Factory<E> edgeFactory) {
        this.graphFactory = graphFactory;
        this.edgeFactory = edgeFactory;
    }

    public Set<ArrayList<V>> enumAllCircuitsTarjan(Graph<V, E> G) {
        HashSet<ArrayList<V>> cycles = new HashSet<ArrayList<V>>();
        this.Tmarked = new HashSet<V>();
        this.Mstack = new Stack();
        this.Pstack = new Stack();
        this.Tnodes = new HashMap();
        Iterator itr = G.getVertices().iterator();
        int i = 1;
        while (i <= G.getVertexCount()) {
            this.Tnodes.put((Integer)itr.next(), i);
            ++i;
        }
        for (Object v : G.getVertices()) {
            this.BackTrack(v, v, G, cycles);
            while (!this.Mstack.isEmpty()) {
                V u = this.Mstack.pop();
                this.Tmarked.remove(u);
            }
        }
        return cycles;
    }

    private boolean BackTrack(V v, V source, Graph<V, E> G, Set<ArrayList<V>> cycles) {
        boolean f = false;
        this.Pstack.push(v);
        this.Tmarked.add(v);
        this.Mstack.push(v);
        for (V w : G.getSuccessors(v)) {
            if (this.Tnodes.get(w) < this.Tnodes.get(source)) continue;
            if (w == source) {
                ArrayList<V> path = new ArrayList<V>(this.Pstack);
                cycles.add(path);
                f = true;
                continue;
            }
            if (this.Tmarked.contains(w)) continue;
            boolean bl = f = this.BackTrack(w, source, G, cycles) || f;
        }
        if (f) {
            while (this.Mstack.peek() != v) {
                V u = this.Mstack.pop();
                this.Tmarked.remove(u);
            }
            this.Mstack.remove(v);
            this.Tmarked.remove(v);
        }
        this.Pstack.remove(v);
        return f;
    }

    private MarkMap<V> initMarkedMap() {
        MarkMap map = new MarkMap();
        map.initRole(10);
        map.initRole(11);
        map.initRole(12);
        map.initRole(13);
        map.initRole(14);
        map.initRole(15);
        map.initRole(16);
        return map;
    }

    public Set<V> greedyMinFVS(Graph<V, E> G) {
        HashSet aset = new HashSet();
        Graph Gp = Operations.copyGraph(G, this.graphFactory);
        while (!Operations.isAcyclic(Gp)) {
            int degmax = 0;
            Object toremove = null;
            for (Object v : Gp.getVertices()) {
                if (Gp.getNeighborCount(v) <= degmax) continue;
                degmax = Gp.getNeighborCount(v);
                toremove = v;
            }
            aset.add(toremove);
            Gp.removeVertex(toremove);
        }
        return aset;
    }

    public Set<V> maximumDirectedAcyclicSubset(Graph<V, E> Ginit) {
        Graph<V, E> G = Operations.copyGraph(Ginit, this.graphFactory);
        MarkMap R = this.initMarkedMap();
        for (Object v : G.getVertices()) {
            R.addV(v, 10);
        }
        HashSet<Object> MAS = new HashSet(G.getVertices());
        HashSet MAStemp = new HashSet();
        while (!MAS.equals(MAStemp)) {
            MAS = new HashSet(MAStemp);
            this.KernelizationMAS(G, MAStemp);
        }
        MAS.addAll(this.MASAlgorithm(G, R));
        return MAS;
    }

    public Set<V> minimumFeedbackVertexSet(Graph<V, E> G) {
        HashSet res = new HashSet();
        res.addAll(G.getVertices());
        res.removeAll(this.maximumDirectedAcyclicSubset(G));
        return res;
    }

    private void CompressGraph(Graph<V, E> G, V v) {
        HashSet<V> loopvertices = new HashSet<V>();
        for (V u : G.getPredecessors(v)) {
            for (V w : G.getSuccessors(v)) {
                if (u == w) {
                    loopvertices.add(u);
                    continue;
                }
                if (G.isSuccessor(u, w)) continue;
                G.addEdge(this.edgeFactory.create(), u, w);
            }
        }
        Operations.removeAllVertices(G, loopvertices);
        G.removeVertex(v);
    }

    private void KernelizationMAS(Graph<V, E> G, Set<V> S) {
        HashSet toRemove = new HashSet();
        for (Object v : G.getVertices()) {
            if (G.findEdge(v, v) == null) continue;
            toRemove.add(v);
        }
        Operations.removeAllVertices(G, toRemove);
        toRemove.clear();
        for (Object v : G.getVertices()) {
            if (G.getPredecessorCount(v) != 0 && G.getSuccessorCount(v) != 0) continue;
            toRemove.add(v);
            S.add(v);
        }
        Operations.removeAllVertices(G, toRemove);
        boolean cfound = false;
        do {
            Pair<V> p = null;
            Object r = null;
            cfound = false;
            Iterator itr = G.getVertices().iterator();
            while (itr.hasNext() && !cfound) {
                V z;
                V y;
                Object v = itr.next();
                if (G.getPredecessorCount(v) != 1 || G.getSuccessorCount(v) != 1 || (y = G.getPredecessors(v).iterator().next()) == (z = G.getSuccessors(v).iterator().next())) continue;
                p = new Pair<V>(y, z);
                r = v;
                S.add(v);
                cfound = true;
            }
            if (!cfound) continue;
            G.removeVertex(r);
            if (G.findEdge(p.getFirst(), p.getSecond()) != null) continue;
            G.addEdge(this.edgeFactory.create(), p.getFirst(), p.getSecond());
        } while (cfound);
    }

    /*
     * WARNING - void declaration
     */
    private Set<V> MASAlgorithm(Graph<V, E> G, MarkMap<V> R) {
        void var14_46;
        Object v;
        int i;
        int nToChangeRole;
        if (G.getEdgeCount() == 0) {
            return new HashSet(G.getVertices());
        }
        Set<Object> MAS = new HashSet<Object>();
        Set<Object> VL = R.getVertices(11, 15);
        Set<Object> VR = R.getVertices(12, 16);
        if (VR.size() - VL.size() > 3) {
            nToChangeRole = VR.size() - (VL.size() + 3);
            Set<Object> sRM = R.getVertices(12);
            Set<Object> sRMD = R.getVertices(16);
            Set<Object> sWRM = R.getVertices(14);
            i = 0;
            while (i < nToChangeRole) {
                if (!sRM.isEmpty() && !sRMD.isEmpty()) {
                    v = null;
                    if (Math.random() < 0.5) {
                        v = sRM.iterator().next();
                        sRM.remove(v);
                    } else {
                        v = sRMD.iterator().next();
                        sRMD.remove(v);
                    }
                    sWRM.add(v);
                    ++i;
                    continue;
                }
                if (sRM.isEmpty() && sRMD.isEmpty()) {
                    i = nToChangeRole;
                    continue;
                }
                if (sRM.isEmpty()) {
                    v = sRMD.iterator().next();
                    sWRM.add(v);
                    sRMD.remove(v);
                    ++i;
                    continue;
                }
                if (!sRMD.isEmpty()) continue;
                v = sRM.iterator().next();
                sWRM.add(v);
                sRM.remove(v);
                ++i;
            }
            R.changeRole(sRM, 12);
            R.changeRole(sRMD, 16);
            R.changeRole(sWRM, 14);
        }
        if (VL.size() - VR.size() > 3) {
            nToChangeRole = VL.size() - (VR.size() + 3);
            Set<Object> sLM = R.getVertices(11);
            Set<Object> sLMD = R.getVertices(15);
            Set<Object> sWLM = R.getVertices(13);
            i = 0;
            while (i < nToChangeRole) {
                if (!sLM.isEmpty() && !sLMD.isEmpty()) {
                    v = null;
                    if (Math.random() < 0.5) {
                        v = sLM.iterator().next();
                        sLM.remove(v);
                    } else {
                        v = sLMD.iterator().next();
                        sLMD.remove(v);
                    }
                    sWLM.add(v);
                    ++i;
                    continue;
                }
                if (sLM.isEmpty() && sLMD.isEmpty()) {
                    i = nToChangeRole;
                    continue;
                }
                if (sLM.isEmpty()) {
                    v = sLMD.iterator().next();
                    sWLM.add(v);
                    sLMD.remove(v);
                    ++i;
                    continue;
                }
                if (!sLMD.isEmpty()) continue;
                v = sLM.iterator().next();
                sWLM.add(v);
                sLM.remove(v);
                ++i;
            }
            R.changeRole(sLM, 11);
            R.changeRole(sLMD, 15);
            R.changeRole(sWLM, 13);
        }
        if (G.getVertexCount() <= 3) {
            if (G.getVertexCount() == 2) {
                Object v2;
                Iterator itrv = G.getVertices().iterator();
                Object u = itrv.next();
                if (G.isPredecessor(u, v2 = itrv.next()) && G.isSuccessor(u, v2)) {
                    MAS.add(u);
                } else {
                    MAS.addAll(G.getVertices());
                }
            }
            if (G.getVertexCount() == 3) {
                ArrayList<Set<Object>> SCC = Components.getAllStronglyConnectedComponent(G);
                if (SCC.size() == 1) {
                    if (G.getEdgeCount() == 6) {
                        MAS.add(SCC.get(0).iterator().next());
                    } else {
                        Iterator it = G.getVertices().iterator();
                        Object v1 = it.next();
                        Object v2 = it.next();
                        Object v3 = it.next();
                        if (G.degree(v1) <= G.degree(v2) && G.degree(v3) <= G.degree(v2)) {
                            MAS.add(v1);
                            MAS.add(v3);
                        } else if (G.degree(v2) <= G.degree(v1) && G.degree(v3) <= G.degree(v1)) {
                            MAS.add(v2);
                            MAS.add(v3);
                        } else {
                            MAS.add(v1);
                            MAS.add(v2);
                        }
                    }
                }
                if (SCC.size() == 2) {
                    if (SCC.get(0).size() == 1) {
                        MAS.addAll((Collection)SCC.get(0));
                        MAS.add(SCC.get(1).iterator().next());
                    } else {
                        MAS.addAll((Collection)SCC.get(1));
                        MAS.add(SCC.get(0).iterator().next());
                    }
                }
                if (SCC.size() == 3) {
                    MAS.addAll(G.getVertices());
                }
            }
            return MAS;
        }
        boolean cycle2 = false;
        Iterator itre = G.getEdges().iterator();
        Object x = null;
        Object y = null;
        while (!cycle2 && itre.hasNext()) {
            Object edge = itre.next();
            x = G.getEndpoints(edge).getFirst();
            y = G.getEndpoints(edge).getSecond();
            if (!G.getSuccessors(x).contains(y) || !G.getSuccessors(y).contains(x)) continue;
            cycle2 = true;
        }
        if (cycle2) {
            Object v3 = x;
            HashSet<Object> MAS1 = new HashSet<Object>();
            MAS1.add(v3);
            Graph Gcv = Operations.copyDirectedSparseGraph(G);
            this.CompressGraph(Gcv, v3);
            MarkMap<Object> Rp = new MarkMap<Object>(R);
            if (!R.getVertices(10).contains(v3)) {
                if (R.getVertices(11).contains(v3) || R.getVertices(15).contains(v3) || R.getVertices(13).contains(v3)) {
                    for (Object object : G.getPredecessors(v3)) {
                        if (!R.getVertices(10).contains(object)) continue;
                        Rp.changeRole(object, 13);
                    }
                }
                if (R.getVertices(12).contains(v3) || R.getVertices(16).contains(v3) || R.getVertices(14).contains(v3)) {
                    for (Object object : G.getSuccessors(v3)) {
                        if (!R.getVertices(10).contains(object)) continue;
                        Rp.changeRole(object, 14);
                    }
                }
            }
            MAS1.addAll(this.MASAlgorithm(Gcv, Rp));
            Graph graph = (Graph)this.graphFactory.create();
            Operations.subGraph(G, graph, v3);
            G.removeVertex(v3);
            Set<Object> MAS2 = this.MASAlgorithm(G, R);
            Operations.mergeGraph(G, graph);
            if (MAS1.size() > MAS2.size()) {
                return MAS1;
            }
            return MAS2;
        }
        ArrayList<Set<Object>> CC = Components.getAllStronglyConnectedComponent(G);
        if (CC.size() > 1) {
            void var14_39;
            void var16_50;
            Set<Object> C;
            void var16_48;
            HashSet<Object> VLMDRMD = new HashSet<Object>();
            VLMDRMD.addAll(R.getVertices(15));
            VLMDRMD.addAll(R.getVertices(16));
            Iterator<Set<Object>> itr = CC.iterator();
            Set<Object> C1 = null;
            Object var14_36 = null;
            Object v1 = null;
            Object var16_47 = null;
            block5: while (itr.hasNext() && v1 == null && var16_48 == null) {
                Set<Object> S = itr.next();
                if (Sets.intersection(S, VLMDRMD).isEmpty()) continue;
                if (v1 == null) {
                    for (Object v4 : S) {
                        if (!VLMDRMD.contains(v4)) continue;
                        v1 = v4;
                        C1 = S;
                        continue block5;
                    }
                    continue;
                }
                for (Object v2 : S) {
                    if (!VLMDRMD.contains(v2)) continue;
                    Object object = v2;
                    Set<Object> set = S;
                    continue block5;
                }
            }
            if (v1 == null) {
                itr = CC.iterator();
                while (itr.hasNext() && v1 == null) {
                    C = itr.next();
                    if (C.contains(var16_48)) continue;
                    v1 = C.iterator().next();
                    C1 = C;
                }
            }
            if (var16_48 == null) {
                itr = CC.iterator();
                while (itr.hasNext() && var16_50 == null) {
                    C = itr.next();
                    if (C.contains(v1)) continue;
                    Object object = C.iterator().next();
                    Set<Object> set = C;
                }
            }
            HashSet<Object> T1 = new HashSet<Object>();
            Graph Gcv1v2 = Operations.copyDirectedSparseGraph(G);
            Graph Gv1v2 = (Graph)this.graphFactory.create();
            HashSet<Object> v1v2 = new HashSet<Object>();
            v1v2.add(v1);
            v1v2.add(var16_50);
            for (Object v5 : v1v2) {
                this.CompressGraph(Gcv1v2, v5);
            }
            T1.addAll(v1v2);
            T1.addAll(this.MASAlgorithm(Gcv1v2, R));
            Operations.subGraph(G, Gv1v2, v1v2);
            G.removeVertex(v1);
            G.removeVertex(var16_50);
            Set<Object> T2 = this.MASAlgorithm(G, R);
            Operations.mergeGraph(G, Gv1v2);
            HashSet A = new HashSet();
            HashSet B = new HashSet();
            HashSet C3 = new HashSet();
            HashSet D = new HashSet();
            Sets.intersection(T1, C1).copyInto(A);
            Sets.intersection(T2, C1).copyInto(B);
            Sets.intersection(T1, var14_39).copyInto(C3);
            Sets.intersection(T2, var14_39).copyInto(D);
            HashSet<Object> toReturn = new HashSet<Object>();
            if (A.size() > B.size()) {
                toReturn.addAll(A);
            } else {
                toReturn.addAll(B);
            }
            if (C3.size() > D.size()) {
                toReturn.addAll(C3);
            } else {
                toReturn.addAll(D);
            }
            C1.addAll((Collection<Object>)var14_39);
            T1.removeAll(C1);
            toReturn.addAll(T1);
            return toReturn;
        }
        if (VL.isEmpty() || VR.isEmpty()) {
            v = null;
            Iterator itr = G.getVertices().iterator();
            while (itr.hasNext() && v == null) {
                Object w = itr.next();
                if (G.getPredecessors(w).size() > 3 && G.getSuccessors(w).size() > 3 || !R.getVertices(10).contains(w) && !R.getVertices(13).contains(w) && !R.getVertices(14).contains(w)) continue;
                v = w;
            }
            if (v != null) {
                void var16_53;
                ArrayList<Object> l = new ArrayList();
                l = G.getPredecessors(v).size() <= 3 ? new ArrayList<Object>(G.getPredecessors(v)) : new ArrayList<Object>(G.getSuccessors(v));
                ArrayList arrayList = new ArrayList();
                Graph Gp = Operations.copyDirectedSparseGraph(G);
                this.CompressGraph(Gp, v);
                MAS.add(v);
                MAS.addAll(this.MASAlgorithm(Gp, R));
                arrayList.add(new HashSet(MAS));
                boolean bl = false;
                while (var16_53 < l.size()) {
                    MAS = new HashSet();
                    Gp = Operations.copyDirectedSparseGraph(G);
                    Gp.removeVertex(v);
                    MAS.add(l.get((int)var16_53));
                    int j = 0;
                    while (j < var16_53) {
                        Gp.removeVertex(l.get(j));
                        ++j;
                    }
                    this.CompressGraph(Gp, l.get((int)var16_53));
                    MAS.addAll(this.MASAlgorithm(Gp, R));
                    arrayList.add(new HashSet(MAS));
                    ++var16_53;
                }
                MAS.clear();
                for (Set set : arrayList) {
                    if (set.size() <= MAS.size()) continue;
                    MAS = set;
                }
                return MAS;
            }
            v = null;
            if (!R.getVertices(10).isEmpty()) {
                v = R.getVertices(10).iterator().next();
            }
            if (v == null && !R.getVertices(13).isEmpty()) {
                v = R.getVertices(13).iterator().next();
            }
            if (v == null && !R.getVertices(14).isEmpty()) {
                v = R.getVertices(14).iterator().next();
            }
            if (v == null) {
                v = G.getVertices().iterator().next();
            }
            HashSet<Object> MAS1 = new HashSet<Object>();
            MAS1.add(v);
            Graph graph = Operations.copyDirectedSparseGraph(G);
            this.CompressGraph(graph, v);
            MarkMap<Object> Rp = new MarkMap<Object>(R);
            if (!VL.contains(v) && !VR.contains(v)) {
                for (Object v3 : graph.getVertices()) {
                    Rp.changeRole(v3, 10);
                }
                HashSet<Object> hashSet = new HashSet<Object>();
                Iterator<Object> itru = graph.getPredecessors(v).iterator();
                int i3 = 0;
                while (i3 < 4) {
                    hashSet.add(itru.next());
                    ++i3;
                }
                HashSet<Object> W = new HashSet<Object>();
                Iterator<Object> itrw = graph.getSuccessors(v).iterator();
                int i4 = 0;
                while (i4 < 4) {
                    W.add(itrw.next());
                    ++i4;
                }
                Rp.changeRole(hashSet, 11);
                Rp.changeRole(W, 12);
                HashSet UU = new HashSet();
                Sets.difference(new HashSet<Object>(graph.getPredecessors(v)), hashSet).copyInto(UU);
                HashSet WW = new HashSet();
                Sets.difference(new HashSet<Object>(graph.getSuccessors(v)), W).copyInto(WW);
                if (!UU.isEmpty()) {
                    Rp.changeRole(UU, 13);
                }
                if (!WW.isEmpty()) {
                    Rp.changeRole(WW, 14);
                }
            }
            MAS1.addAll(this.MASAlgorithm(graph, Rp));
            Graph graph2 = (Graph)this.graphFactory.create();
            Operations.subGraph(G, graph2, v);
            G.removeVertex(v);
            Set<Object> MAS2 = this.MASAlgorithm(G, R);
            Operations.mergeGraph(G, graph2);
            if (MAS1.size() > MAS2.size()) {
                return MAS1;
            }
            return MAS2;
        }
        int xM = 0;
        int xMD = 0;
        int WxM = 0;
        Object var14_43 = null;
        if (VL.size() <= VR.size()) {
            xM = 11;
            xMD = 15;
            WxM = 13;
            Set<Object> set = VL;
        } else {
            xM = 12;
            xMD = 16;
            WxM = 14;
            Set<Object> set = VR;
        }
        HashSet<Object> U = new HashSet<Object>();
        for (Object e : var14_46) {
            if (xM == 11) {
                for (Object p : G.getPredecessors(e)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                    break;
                }
            } else {
                for (Object p : G.getSuccessors(e)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                    break;
                }
            }
            if (!U.isEmpty()) break;
        }
        if (R.getVertices(xMD).containsAll((Collection<?>)var14_46) || U.isEmpty()) {
            Object e = var14_46.iterator().next();
            HashSet<Object> MAS1 = new HashSet<Object>();
            MAS1.add(e);
            Graph Gcv = Operations.copyDirectedSparseGraph(G);
            this.CompressGraph(Gcv, e);
            MAS1.addAll(this.MASAlgorithm(Gcv, R));
            Graph Gv = (Graph)this.graphFactory.create();
            Operations.subGraph(G, Gv, e);
            G.removeVertex(e);
            Set<Object> MAS2 = this.MASAlgorithm(G, R);
            Operations.mergeGraph(G, Gv);
            if (MAS1.size() > MAS2.size()) {
                return MAS1;
            }
            return MAS2;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll((Collection<Object>)var14_46);
        hashSet.addAll(R.getVertices(WxM));
        hashSet.removeAll(R.getVertices(xMD));
        U = new HashSet();
        Object v7 = null;
        for (Object h : hashSet) {
            U.clear();
            if (xM == 11) {
                for (Object p : G.getPredecessors(h)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                }
            } else {
                for (Object p : G.getSuccessors(h)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                }
            }
            if (U.size() < 4) continue;
            v7 = h;
            break;
        }
        if (v7 != null) {
            HashSet Uv = new HashSet();
            Iterator itru = U.iterator();
            int i5 = 0;
            while (i5 < 4) {
                Uv.add(itru.next());
                ++i5;
            }
            HashSet<Object> MAS1 = new HashSet<Object>();
            MAS1.add(v7);
            Graph Gcv = Operations.copyDirectedSparseGraph(G);
            this.CompressGraph(Gcv, v7);
            MarkMap<Object> Rp = new MarkMap<Object>(R);
            Rp.changeRole(Uv, xM);
            U.removeAll(Uv);
            Rp.changeRole(U, WxM);
            MAS1.addAll(this.MASAlgorithm(Gcv, Rp));
            Graph Gv = (Graph)this.graphFactory.create();
            Operations.subGraph(G, Gv, v7);
            G.removeVertex(v7);
            Set<Object> MAS2 = this.MASAlgorithm(G, R);
            Operations.mergeGraph(G, Gv);
            if (MAS1.size() > MAS2.size()) {
                return MAS1;
            }
            return MAS2;
        }
        v7 = null;
        int max = 0;
        HashSet X = null;
        for (Object h : hashSet) {
            U.clear();
            if (xM == 11) {
                for (Object p : G.getPredecessors(h)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                }
            } else {
                for (Object p : G.getSuccessors(h)) {
                    if (!R.getVertices(10).contains(p)) continue;
                    U.add(p);
                }
            }
            if (U.size() <= max) continue;
            v7 = h;
            max = U.size();
            X = new HashSet(U);
        }
        long ncomb = (long)Math.pow(2.0, X.size());
        Object[] tabX = X.toArray();
        HashSet TYfinal = new HashSet();
        long i6 = 0L;
        while (i6 < ncomb) {
            HashSet<Object> Y = new HashSet<Object>();
            String comb = Long.toBinaryString(i6);
            int k = 0;
            while (k < comb.length()) {
                if (comb.charAt(k) == '1') {
                    Y.add(tabX[k]);
                }
                ++k;
            }
            HashSet X_Y = new HashSet(X);
            X_Y.removeAll(Y);
            Graph GY = Operations.copyDirectedSparseGraph(G);
            Operations.removeAllVertices(GY, X_Y);
            for (Object e : Y) {
                this.CompressGraph(GY, e);
            }
            MarkMap<Object> markMap = new MarkMap<Object>(R);
            if (Y.isEmpty()) {
                markMap.changeRole(v7, xMD);
            }
            HashSet<Object> TY = new HashSet<Object>();
            TY.addAll(this.MASAlgorithm(GY, markMap));
            TY.addAll(Y);
            if (TY.size() > TYfinal.size()) {
                TYfinal = new HashSet(TY);
            }
            ++i6;
        }
        return TYfinal;
    }
}

