/*
 * Decompiled with CFR 0.152.
 */
package agape.algos;

import agape.algos.Algorithms;
import agape.tools.Components;
import agape.tools.Operations;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Separators<V, E>
extends Algorithms<V, E> {
    public Set<Set<V>> getABSeparators(Graph<V, E> g, V a, V b) {
        HashSet<Set<V>> SS = new HashSet<Set<V>>();
        if (!g.getNeighbors(a).contains(b)) {
            HashSet<V> Na = new HashSet<V>();
            Na.addAll(g.getNeighbors(a));
            Na.add(a);
            ArrayList<Set<V>> CC = Components.getAllConnectedComponent(g, Na);
            for (Set<V> C : CC) {
                Set<V> Nc;
                if (!C.contains(b) || (Nc = Operations.getNeighbors(g, C)).isEmpty()) continue;
                SS.add(Nc);
            }
            HashSet<Set> T = new HashSet<Set>();
            HashSet<Set<V>> SdT = new HashSet<Set<V>>(SS);
            while (!SdT.isEmpty()) {
                Set S = (Set)SdT.iterator().next();
                for (Object x : S) {
                    HashSet SNx = new HashSet(S);
                    SNx.addAll(g.getNeighbors(x));
                    CC = Components.getAllConnectedComponent(g, SNx);
                    for (Set<V> C : CC) {
                        Set<V> Nc = Operations.getNeighbors(g, C);
                        if (Nc.isEmpty() || !C.contains(b)) continue;
                        SS.add(Nc);
                    }
                }
                T.add(S);
                SdT = new HashSet<Set<V>>(SS);
                SdT.removeAll(T);
            }
        }
        return SS;
    }

    public Set<Set<V>> getAllMinimalSeparators(Graph<V, E> g) {
        HashSet<Set<V>> SS = new HashSet<Set<V>>();
        for (Object v : g.getVertices()) {
            HashSet Nv = new HashSet();
            Nv.addAll(g.getNeighbors(v));
            Nv.add(v);
            ArrayList<Set<V>> CC = Components.getAllConnectedComponent(g, Nv);
            for (Set<V> C : CC) {
                Set<V> Nc = Operations.getNeighbors(g, C);
                if (Nc.isEmpty()) continue;
                SS.add(Nc);
            }
        }
        HashSet<Set> T = new HashSet<Set>();
        HashSet<Object> SdT = new HashSet(SS);
        while (!SdT.isEmpty()) {
            Set S = (Set)SdT.iterator().next();
            for (Object x : S) {
                HashSet SNx = new HashSet(S);
                SNx.addAll(g.getNeighbors(x));
                ArrayList<Set<V>> CC = Components.getAllConnectedComponent(g, SNx);
                for (Set<V> C : CC) {
                    Set<V> Nc = Operations.getNeighbors(g, C);
                    if (Nc.isEmpty()) continue;
                    SS.add(Nc);
                }
            }
            T.add(S);
            SdT = new HashSet<Set<V>>(SS);
            SdT.removeAll(T);
        }
        return SS;
    }
}

