/*
 * Decompiled with CFR 0.152.
 */
package agape.applications;

import agape.algos.Algorithms;
import agape.algos.Coloring;
import agape.algos.MIS;
import agape.algos.MVC;
import agape.algos.MinDFVS;
import agape.algos.Separators;
import agape.io.Import;
import agape.tools.Operations;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections15.Factory;

public class AgapeCL {
    static Set S = new HashSet();
    static final int MISBF = 100;
    static final int MISMM = 101;
    static final int MISDegMax = 102;
    static final int MISFGK = 103;
    static final int MVCBF = 104;
    static final int MVCBG = 105;
    static final int MVCN = 106;
    static final int MVCDBS = 107;
    static final int DFVS = 108;
    static final int CN = 109;
    static final int SEP = 110;

    public static ArrayList<File> listFiles(String directoryPath) {
        ArrayList<File> files = new ArrayList();
        File directoryToScan = new File(directoryPath);
        files = new ArrayList<File>(Arrays.asList(directoryToScan.listFiles()));
        return files;
    }

    public static double launchAlgorithm(Graph<String, Integer> G, int algo, boolean directed) {
        int ei = G.getEdgeCount();
        int vi = G.getVertexCount();
        Factory<Integer> edgeFactory = new Factory<Integer>(ei){
            int c;
            {
                this.c = n;
            }

            @Override
            public Integer create() {
                ++this.c;
                return this.c;
            }
        };
        Factory<String> vertexFactory = new Factory<String>(vi){
            int c;
            {
                this.c = n;
            }

            @Override
            public String create() {
                ++this.c;
                return "v" + this.c;
            }
        };
        Factory<Graph<String, Integer>> graphFactory = new Factory<Graph<String, Integer>>(){

            @Override
            public Graph<String, Integer> create() {
                return new UndirectedSparseGraph<String, Integer>();
            }
        };
        Factory<Graph<String, Integer>> DgraphFactory = new Factory<Graph<String, Integer>>(){

            @Override
            public Graph<String, Integer> create() {
                return new DirectedSparseGraph<String, Integer>();
            }
        };
        double t = 0.0;
        int k = 0;
        switch (algo) {
            case 100: {
                MIS<String, Integer> alg = new MIS<String, Integer>(graphFactory, vertexFactory, edgeFactory);
                t = System.currentTimeMillis();
                S = alg.maximumIndependentSetBruteForce(G);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 101: {
                MIS<String, Integer> alg = new MIS<String, Integer>(graphFactory, vertexFactory, edgeFactory);
                t = System.currentTimeMillis();
                S = alg.maximumIndependentSetMoonMoser(G);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 102: {
                MIS<String, Integer> alg = new MIS<String, Integer>(graphFactory, vertexFactory, edgeFactory);
                t = System.currentTimeMillis();
                S = alg.maximumIndependentSetMaximumDegree(G);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 103: {
                MIS<String, Integer> alg = new MIS<String, Integer>(graphFactory, vertexFactory, edgeFactory);
                t = System.currentTimeMillis();
                S = alg.maximuRmIndependentSetFominGrandoniKratsch(G);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 104: {
                MVC<String, Integer> alg = new MVC<String, Integer>(graphFactory);
                k = alg.greedyCoverMaxDegree(G).size();
                t = System.currentTimeMillis();
                alg.kVertexCoverBruteForce(G, k);
                S = alg.getVertexCoverSolution();
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 105: {
                MVC<String, Integer> alg = new MVC<String, Integer>(graphFactory);
                k = alg.greedyCoverMaxDegree(G).size();
                t = System.currentTimeMillis();
                alg.kVertexCoverBussGoldsmith(G, k);
                S = alg.getVertexCoverSolution();
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 107: {
                MVC<String, Integer> alg = new MVC<String, Integer>(graphFactory);
                k = alg.greedyCoverMaxDegree(G).size();
                t = System.currentTimeMillis();
                alg.kVertexCoverDegreeBranchingStrategy(G, k);
                S = alg.getVertexCoverSolution();
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 106: {
                MVC<String, Integer> alg = new MVC<String, Integer>(graphFactory);
                k = alg.greedyCoverMaxDegree(G).size();
                t = System.currentTimeMillis();
                alg.kVertexCoverNiedermeier(G, k);
                S = alg.getVertexCoverSolution();
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 108: {
                MinDFVS<String, Integer> alg = new MinDFVS<String, Integer>(DgraphFactory, edgeFactory);
                Graph<String, Integer> Gp = null;
                Gp = Operations.copyDirectedSparseGraph(G);
                t = System.currentTimeMillis();
                S = alg.maximumDirectedAcyclicSubset(Gp);
                t = (double)System.currentTimeMillis() - t;
                HashSet FVS = new HashSet(G.getVertices());
                FVS.removeAll(S);
                S = FVS;
                break;
            }
            case 109: {
                Coloring<String, Integer> alg = new Coloring<String, Integer>(graphFactory);
                t = System.currentTimeMillis();
                S = alg.graphColoring(G);
                t = (double)System.currentTimeMillis() - t;
                break;
            }
            case 110: {
                Separators<String, Integer> alg = new Separators<String, Integer>();
                t = System.currentTimeMillis();
                S = alg.getAllMinimalSeparators(G);
                t = (double)System.currentTimeMillis() - t;
            }
        }
        return t;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.print("Usage: \njava -jar AGAPE.jar graphfilepath|graphdirectorypath algorithm \n\ngraphfilepath|graphdirectorypath:    use mygraph.net to apply an algorithm on a simple graph, use mydirectory/ to apply algorithm on a series of graph.\nalgorithm:   specify algorithm (CN, MISBF, MISMM, MISDegMax, MISFGK, MVCBF, MVCBG, MVCDBS, MVCN, DFVS, SEP).\n");
            return;
        }
        String folder = args[0];
        int algo = 0;
        if (args[1].equals("CN")) {
            algo = 109;
        }
        if (args[1].equals("SEP")) {
            algo = 110;
        }
        if (args[1].equals("MISBF")) {
            algo = 100;
        }
        if (args[1].equals("MISMM")) {
            algo = 101;
        }
        if (args[1].equals("MISDegMax")) {
            algo = 102;
        }
        if (args[1].equals("MISFGK")) {
            algo = 103;
        }
        if (args[1].equals("MVCBF")) {
            algo = 104;
        }
        if (args[1].equals("MVCBG")) {
            algo = 105;
        }
        if (args[1].equals("MVCDBS")) {
            algo = 107;
        }
        if (args[1].equals("MVCN")) {
            algo = 106;
        }
        if (args[1].equals("DFVS")) {
            algo = 108;
        }
        if (folder.contains(".net")) {
            Graph<String, Integer> G = null;
            if (algo == 108) {
                System.out.println("Reading a directed graph...");
                G = Import.readDNet(folder);
            } else {
                System.out.println("Reading an undirected graph...");
                G = Import.readNet(folder);
            }
            System.out.println("Read from " + folder + ": ");
            System.out.println("V:" + G.getVertexCount() + " E:" + G.getEdgeCount());
            AgapeCL.Bench(G, algo);
            System.out.println();
        } else {
            ArrayList<File> graphs = AgapeCL.listFiles(folder);
            for (File f : graphs) {
                if (!f.getName().contains(".net")) continue;
                Graph<String, Integer> G = null;
                G = algo == 108 ? Import.readDNet(f.getPath()) : Import.readNet(f.getPath());
                System.out.println(f.getName());
                System.out.println("V:" + G.getVertexCount() + " E:" + G.getEdgeCount());
                AgapeCL.Bench(G, algo);
                System.out.println();
            }
        }
    }

    public static void Bench(Graph<String, Integer> G, int algo) {
        double t = 0.0;
        t = algo == 108 ? AgapeCL.launchAlgorithm(G, algo, true) : AgapeCL.launchAlgorithm(G, algo, false);
        System.out.println(AgapeCL.printTime(t));
        System.out.println("Size: " + S.size());
        System.out.println(S);
    }

    public static void initFactories(Algorithms<String, Integer> alg, Factory<Graph<String, Integer>> gf, Factory<String> vf, Factory<Integer> ef) {
        alg.setEdgeFactoy(ef);
        alg.setVertexFactoy(vf);
        alg.setGraphFactoy(gf);
    }

    public static String printTime(double t) {
        double tt;
        String r = "";
        r = t < 1000.0 ? String.valueOf(t) + " ms" : ((tt = t / 1000.0) < 60.0 ? String.valueOf(r) + tt + " s" : ((tt /= 60.0) < 60.0 ? String.valueOf(r) + tt + " mins" : ((tt /= 60.0) < 24.0 ? String.valueOf(r) + tt + " h" : String.valueOf(r) + (tt /= 24.0) + " days")));
        return r;
    }
}

