/*
 * Decompiled with CFR 0.152.
 */
package agape.generators;

import agape.generators.NRandGenerator;
import agape.tools.Operations;
import edu.uci.ics.jung.algorithms.generators.random.BarabasiAlbertGenerator;
import edu.uci.ics.jung.algorithms.generators.random.EppsteinPowerLawGenerator;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections15.Factory;
import tools.dataStructures.Pair;

public class RandGenerator<V, E> {
    public static <V, E> Graph<V, E> generateErdosRenyiGraph(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int n, double p) {
        Graph<Object, E> G = graphFactory.create();
        int i = 0;
        while (i < n) {
            G.addVertex(vertexFactory.create());
            ++i;
        }
        Object[] varray = G.getVertices().toArray();
        int i2 = 0;
        while (i2 < varray.length) {
            int j = i2;
            while (j < varray.length) {
                if (Math.random() <= p && varray[i2] != varray[j]) {
                    G.addEdge(edgeFactory.create(), varray[i2], varray[j]);
                }
                ++j;
            }
            ++i2;
        }
        return G;
    }

    public static <V, E> Graph<V, E> generateEppsteinGraph(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int n, int e, int i) {
        return new EppsteinPowerLawGenerator<V, E>(graphFactory, vertexFactory, edgeFactory, n, e, i).create();
    }

    public static <V, E> Graph<V, E> generateBarabasiAlbertGraph(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int n, int e, int steps) throws Exception {
        if (e > n) {
            throw new Exception("Impossible to attach the " + e + " new edges to " + n + " vertices.");
        }
        HashSet<V> vset = new HashSet<V>();
        int i = 0;
        while (i < n) {
            vset.add(vertexFactory.create());
            ++i;
        }
        BarabasiAlbertGenerator<V, E> BAgen = new BarabasiAlbertGenerator<V, E>(graphFactory, vertexFactory, edgeFactory, n, e, vset);
        BAgen.evolveGraph(steps);
        return BAgen.create();
    }

    public static <V, E> Graph<V, E> generateKleinbergSWGraph(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int width, int height, int p, int q, double r) {
        Object v;
        int j;
        Graph<V, E> g = graphFactory.create();
        ArrayList map = new ArrayList(width);
        int i = 0;
        while (i < width) {
            map.add(new ArrayList(height));
            ++i;
        }
        i = 0;
        while (i < width) {
            j = 0;
            while (j < height) {
                v = vertexFactory.create();
                ((ArrayList)map.get(i)).add(j, v);
                g.addVertex(v);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < width) {
            j = 0;
            while (j < height) {
                v = ((ArrayList)map.get(i)).get(j);
                double sum_proba = 0.0;
                int k = 0;
                while (k < width) {
                    int l = 0;
                    while (l < height) {
                        int manhattan_distance = Math.abs(i - k) + Math.abs(j - l);
                        if (i != k || j != l) {
                            if (manhattan_distance <= p) {
                                Object v2 = ((ArrayList)map.get(k)).get(l);
                                E e = edgeFactory.create();
                                g.addEdge(e, v, v2);
                            } else {
                                sum_proba += Math.pow(manhattan_distance, -r);
                            }
                        }
                        ++l;
                    }
                    ++k;
                }
                int q2 = 0;
                while (q2 < q) {
                    double tirage = Math.random() * sum_proba;
                    double sum_search = 0.0;
                    boolean generated = false;
                    int k2 = 0;
                    while (k2 < width && !generated) {
                        int l = 0;
                        while (l < height && !generated) {
                            Object v2;
                            int manhattan_distance = Math.abs(i - k2) + Math.abs(j - l);
                            if (manhattan_distance > p && (sum_search += Math.pow(manhattan_distance, -r)) >= tirage && !Operations.isEdge(g, v, v2 = ((ArrayList)map.get(k2)).get(l))) {
                                E e = edgeFactory.create();
                                g.addEdge(e, v, v2);
                                generated = true;
                            }
                            ++l;
                        }
                        ++k2;
                    }
                    ++q2;
                }
                ++j;
            }
            ++i;
        }
        return g;
    }

    public static <V, E> Graph<V, E> generateWattsStrogatzSWGraph(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int n, int k, double p) throws Exception {
        if (p < 0.0 || p > 1.0) {
            throw new Exception("Probabilities must be between 0 and 1");
        }
        Graph G = NRandGenerator.generateRegularRing(graphFactory, vertexFactory, edgeFactory, n, k);
        HashSet vertices = new HashSet(G.getVertices());
        for (Object v : vertices) {
            HashSet Nv = new HashSet(G.getNeighbors(v));
            for (Object nv : Nv) {
                if (!(Math.random() < p)) continue;
                G.removeEdge(G.findEdge(v, nv));
                int j = 0;
                int choose = (int)(Math.random() * (double)n);
                Object new_nv = null;
                Iterator itr = G.getVertices().iterator();
                while (itr.hasNext() && j < choose) {
                    new_nv = itr.next();
                    ++j;
                }
                if (Operations.isEdge(G, v, new_nv) || new_nv == null) continue;
                G.addEdge(edgeFactory.create(), v, new_nv);
            }
        }
        return G;
    }

    public static <V, E> Graph<V, E> generateRandomRegularGraph(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int n, int d) {
        Graph<Object, E> G;
        do {
            G = graphFactory.create();
            int i = 0;
            while (i < n) {
                G.addVertex(vertexFactory.create());
                ++i;
            }
            HashSet S = new HashSet();
            for (Object u : G.getVertices()) {
                for (Object v : G.getVertices()) {
                    if (u == v) continue;
                    Pair pair = new Pair(u, v);
                    Pair p2 = new Pair(v, u);
                    if (S.contains(pair) || S.contains(p2)) continue;
                    S.add(pair);
                }
            }
            while (!S.isEmpty()) {
                boolean stop = false;
                Pair pchoosen = null;
                Iterator itr = S.iterator();
                while (!stop) {
                    if (!itr.hasNext()) {
                        itr = S.iterator();
                        continue;
                    }
                    Pair p = (Pair)itr.next();
                    double d2 = (double)(d - G.degree(p.getKey())) * (double)(d - G.degree(p.getValue())) / (double)S.size();
                    if (!(Math.random() < d2)) continue;
                    pchoosen = p;
                    stop = true;
                }
                S.remove(pchoosen);
                G.addEdge(edgeFactory.create(), pchoosen.getKey(), pchoosen.getValue());
                HashSet<Pair> toRemove = new HashSet<Pair>();
                for (Pair pair : S) {
                    int deg1 = G.degree(pair.getKey());
                    int deg2 = G.degree(pair.getValue());
                    if (deg1 <= d - 1 && deg2 <= d - 1) continue;
                    toRemove.add(pair);
                }
                S.removeAll(toRemove);
            }
        } while (!Operations.isRegular(G, d));
        return G;
    }
}

