/*
 * Decompiled with CFR 0.152.
 */
package agape.io;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;

public class Export {
    public static <V, E> void writeNet(Graph<V, E> G, String fname) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(fname, false);
        }
        catch (Exception e) {
            System.err.println("Error writing: " + e);
        }
        BufferedWriter bfw = new BufferedWriter(fw);
        PrintWriter output = new PrintWriter(bfw);
        HashMap posv = new HashMap();
        HashSet done = new HashSet();
        output.println("*Vertices " + G.getVertexCount());
        int i = 1;
        for (Object v : G.getVertices()) {
            output.println(String.valueOf(i) + " \"" + v.toString() + "\"");
            posv.put(v, i);
            ++i;
        }
        output.println("*edgeslist");
        for (Object v : G.getVertices()) {
            boolean first = true;
            for (Object nv : G.getNeighbors(v)) {
                Pair p1 = new Pair(v, nv);
                Pair p2 = new Pair(nv, v);
                if (done.contains(p1) || done.contains(p2)) continue;
                if (first) {
                    output.print(posv.get(v) + " ");
                    output.print(posv.get(nv) + " ");
                    done.add(p1);
                    done.add(p2);
                    first = false;
                    continue;
                }
                output.print(posv.get(nv) + " ");
                done.add(p1);
                done.add(p2);
            }
            if (first) continue;
            output.println();
        }
        output.flush();
        output.close();
    }

    public static <V, E> void writeDNet(Graph<V, E> G, String fname) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(fname, false);
        }
        catch (Exception e) {
            System.err.println("Error writing: " + e);
        }
        BufferedWriter bfw = new BufferedWriter(fw);
        PrintWriter output = new PrintWriter(bfw);
        HashMap posv = new HashMap();
        HashSet done = new HashSet();
        output.println("*Vertices " + G.getVertexCount());
        int i = 1;
        for (Object v : G.getVertices()) {
            output.println(String.valueOf(i) + " \"" + v.toString() + "\"");
            posv.put(v, i);
            ++i;
        }
        output.println("*edgeslist");
        for (Object v : G.getVertices()) {
            boolean first = true;
            for (V nv : G.getSuccessors(v)) {
                Pair p = new Pair(v, nv);
                if (done.contains(p)) continue;
                if (first) {
                    output.print(posv.get(v) + " ");
                    output.print(posv.get(nv) + " ");
                    done.add(p);
                    first = false;
                    continue;
                }
                output.print(posv.get(nv) + " ");
                done.add(p);
            }
            if (first) continue;
            output.println();
        }
        output.flush();
        output.close();
    }

    public static <V, E> void writeGV(String fname, Graph<V, E> G) throws IOException {
        PrintWriter pfile = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(fname) + ".gv")));
        pfile.println("digraph G {");
        pfile.println("size=\"100,20\"; ratio = auto;");
        pfile.println("node [style=filled];");
        for (Object e : G.getEdges()) {
            pfile.println("\"" + G.getSource(e) + "\" -> \"" + G.getDest(e) + "\" [color=\"0.649 0.701 0.701\"];");
        }
        for (Object x : G.getVertices()) {
            pfile.print("\"" + x + "\" ");
            pfile.print("[color=grey];\n");
        }
        pfile.println("}");
        pfile.flush();
        pfile.close();
    }
}

