/*
 * Decompiled with CFR 0.152.
 */
package agape.io;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import mascoptLib.core.MascoptEdge;
import mascoptLib.core.MascoptGraph;
import mascoptLib.core.MascoptVertex;
import mascoptLib.io.reader.mgl.dom.MGLDOMReader;

public class Import {
    public static Graph<String, Integer> MGLtoJungGraph(String fname) {
        UndirectedSparseGraph<String, Integer> g = new UndirectedSparseGraph<String, Integer>();
        MGLDOMReader mglR = null;
        try {
            mglR = new MGLDOMReader(fname);
            mglR.parse();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Import.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(Import.class.getName()).log(Level.SEVERE, null, ex);
        }
        MascoptGraph G = (MascoptGraph)mglR.getGraphs().next();
        for (MascoptVertex v : G.vertexSet()) {
            g.addVertex(v.toString());
        }
        int k = 0;
        for (MascoptEdge e : G.edgeSet()) {
            g.addEdge((Integer)k, e.toArray()[0].toString(), e.toArray()[1].toString());
            ++k;
        }
        return g;
    }

    public static Graph<String, Integer> readNet(String fname) {
        File f = new File(fname);
        BufferedReader lecteurAvecBuffer = null;
        UndirectedSparseGraph<String, Integer> G = new UndirectedSparseGraph<String, Integer>();
        try {
            lecteurAvecBuffer = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException exc) {
            System.err.println("Error opening file .net\n");
        }
        ArrayList<String> V = new ArrayList<String>();
        try {
            String ligne = lecteurAvecBuffer.readLine();
            ligne = lecteurAvecBuffer.readLine();
            while (!ligne.equals("*edgeslist")) {
                StringTokenizer tok = new StringTokenizer(ligne, "\"");
                tok.nextToken();
                String v = tok.nextToken();
                V.add(v);
                G.addVertex(v);
                ligne = lecteurAvecBuffer.readLine();
            }
            int ne = 0;
            ligne = lecteurAvecBuffer.readLine();
            while (ligne != null) {
                StringTokenizer tok = new StringTokenizer(ligne, " ");
                int s = Integer.valueOf(tok.nextToken()) - 1;
                while (tok.hasMoreTokens()) {
                    int t = Integer.valueOf(tok.nextToken()) - 1;
                    if (!V.isEmpty()) {
                        G.addEdge((Integer)ne, (String)V.get(s), (String)V.get(t));
                    } else {
                        G.addEdge((Integer)ne, Integer.toString(s), Integer.toString(t));
                    }
                    ++ne;
                }
                ligne = lecteurAvecBuffer.readLine();
            }
            lecteurAvecBuffer.close();
        }
        catch (Exception e) {
            System.err.println("Error parsing file: " + e + "\n");
        }
        return G;
    }

    public static Graph<String, Integer> readTRG(String fname) {
        File f = new File(fname);
        BufferedReader lecteurAvecBuffer = null;
        UndirectedSparseGraph<String, Integer> G = new UndirectedSparseGraph<String, Integer>();
        try {
            lecteurAvecBuffer = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException exc) {
            System.err.println("Error opening file .net\n");
        }
        try {
            String ligneV = lecteurAvecBuffer.readLine();
            StringTokenizer tokenV = new StringTokenizer(ligneV, ":,");
            tokenV.nextToken();
            while (tokenV.hasMoreTokens()) {
                G.addVertex(new String(tokenV.nextToken()));
            }
            String ligneE = lecteurAvecBuffer.readLine();
            StringTokenizer tokenE = new StringTokenizer(ligneE, ": ");
            tokenE.nextToken();
            while (tokenE.hasMoreTokens()) {
                String edge = tokenE.nextToken();
                StringTokenizer EdgeT = new StringTokenizer(edge, ",\\[\\]");
                G.addEdge((Integer)Integer.parseInt(EdgeT.nextToken()), EdgeT.nextToken(), EdgeT.nextToken());
            }
            lecteurAvecBuffer.close();
        }
        catch (Exception e) {
            System.err.println("Error parsing file: " + e + "\n");
        }
        return G;
    }

    public static Graph<String, Integer> readDNet(String fname) {
        File f = new File(fname);
        BufferedReader lecteurAvecBuffer = null;
        DirectedSparseGraph<String, Integer> G = new DirectedSparseGraph<String, Integer>();
        try {
            lecteurAvecBuffer = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException exc) {
            System.err.println("Error opening file .net\n");
        }
        ArrayList<String> V = new ArrayList<String>();
        try {
            String ligne = lecteurAvecBuffer.readLine();
            ligne = lecteurAvecBuffer.readLine();
            while (!ligne.equals("*edgeslist")) {
                StringTokenizer tok = new StringTokenizer(ligne, "\"");
                tok.nextToken();
                String v = tok.nextToken();
                V.add(v);
                G.addVertex(v);
                ligne = lecteurAvecBuffer.readLine();
            }
            int ne = 0;
            ligne = lecteurAvecBuffer.readLine();
            while (ligne != null) {
                StringTokenizer tok = new StringTokenizer(ligne, " ");
                int s = Integer.valueOf(tok.nextToken()) - 1;
                while (tok.hasMoreTokens()) {
                    int t = Integer.valueOf(tok.nextToken()) - 1;
                    if (!V.isEmpty()) {
                        G.addEdge((Integer)ne, (String)V.get(s), (String)V.get(t));
                    } else {
                        G.addEdge((Integer)ne, Integer.toString(s), Integer.toString(t));
                    }
                    ++ne;
                }
                ligne = lecteurAvecBuffer.readLine();
            }
            lecteurAvecBuffer.close();
        }
        catch (Exception e) {
            System.err.println("Error parsing file: " + e + "\n");
            e.printStackTrace();
        }
        return G;
    }

    public static Graph<String, Integer> readTGF(String fname) {
        File f = new File(fname);
        BufferedReader lecteurAvecBuffer = null;
        UndirectedSparseGraph<String, Integer> G = new UndirectedSparseGraph<String, Integer>();
        try {
            lecteurAvecBuffer = new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException exc) {
            System.err.println("Error opening file\n");
        }
        ArrayList<String> V = new ArrayList<String>();
        try {
            String ligne = lecteurAvecBuffer.readLine();
            while (!ligne.equals("#")) {
                String v = ligne;
                V.add(v);
                G.addVertex(v);
                ligne = lecteurAvecBuffer.readLine();
            }
            int ne = 0;
            ligne = lecteurAvecBuffer.readLine();
            while (ligne != null) {
                StringTokenizer tok = new StringTokenizer(ligne, " ");
                int s = Integer.valueOf(tok.nextToken());
                int t = Integer.valueOf(tok.nextToken());
                if (!V.isEmpty()) {
                    G.addEdge((Integer)ne, (String)V.get(s - 1), (String)V.get(t - 1));
                } else {
                    G.addEdge((Integer)ne, Integer.toString(s), Integer.toString(t));
                }
                ++ne;
                ligne = lecteurAvecBuffer.readLine();
            }
            lecteurAvecBuffer.close();
        }
        catch (Exception e) {
            System.err.println("Error reading: " + e + "\n");
        }
        return G;
    }
}

