/*
 * Decompiled with CFR 0.152.
 */
package agape.test;

import agape.algos.Coloring;
import agape.generators.RandGenerator;
import agape.tutorials.UndirectedGraphFactoryForStringInteger;
import agape.visu.Visualization;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import edu.uci.ics.jung.graph.util.Pair;

public class AlgoColoringTests {
    public static void main(String[] args) {
        UndirectedGraphFactoryForStringInteger undfactory = new UndirectedGraphFactoryForStringInteger();
        SparseGraph<String, Integer> gu = new SparseGraph<String, Integer>();
        gu.addVertex("v1");
        gu.addVertex("v2");
        gu.addVertex("v3");
        gu.addVertex("v4");
        gu.addEdge(Integer.valueOf(1), new Pair<String>("v1", "v2"));
        gu.addEdge(Integer.valueOf(2), new Pair<String>("v1", "v3"));
        gu.addEdge(Integer.valueOf(3), new Pair<String>("v1", "v4"));
        gu.addEdge(Integer.valueOf(4), new Pair<String>("v3", "v4"));
        Coloring<String, Integer> coloring = new Coloring<String, Integer>(undfactory);
        int col = coloring.chromaticNumberBjorklundHusfeldt(gu);
        System.out.println(gu);
        System.out.println("Chromatic number Simple graph: " + col);
        UndirectedGraphFactoryForStringInteger factory = new UndirectedGraphFactoryForStringInteger();
        Graph<String, Integer> g4 = RandGenerator.generateErdosRenyiGraph(factory, factory.vertexFactory, factory.edgeFactory, 17, 0.9);
        Visualization.showGraph(g4);
        int col4 = coloring.chromaticNumberBjorklundHusfeldt(g4);
        System.out.println("Chromatic number ER: " + col4);
        int col4check = coloring.chromaticNumberBodlaenderKratsch(g4);
        System.out.println("Chromatic number ER (check): " + col4check);
    }
}

