/*
 * Decompiled with CFR 0.152.
 */
package agape.test;

import agape.algos.Coloring;
import agape.generators.RandGenerator;
import agape.io.Import;
import agape.tutorials.UndirectedGraphFactoryForStringInteger;
import agape.visu.Visualization;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Set;

public class DemoAgape {
    public static void main(String[] args) {
        UndirectedGraphFactoryForStringInteger undfactory = new UndirectedGraphFactoryForStringInteger();
        SparseGraph<String, Integer> gu = new SparseGraph<String, Integer>();
        gu.addVertex("v1");
        gu.addVertex("v2");
        gu.addVertex("v3");
        gu.addVertex("v4");
        gu.addEdge(Integer.valueOf(1), new Pair<String>("v1", "v2"));
        gu.addEdge(Integer.valueOf(2), new Pair<String>("v1", "v3"));
        gu.addEdge(Integer.valueOf(3), new Pair<String>("v1", "v4"));
        gu.addEdge(Integer.valueOf(4), new Pair<String>("v3", "v4"));
        UndirectedGraphFactoryForStringInteger factory = new UndirectedGraphFactoryForStringInteger();
        Graph<String, Integer> g4 = RandGenerator.generateErdosRenyiGraph(factory, factory.vertexFactory, factory.edgeFactory, 10, 0.6);
        Coloring<String, Integer> coloring = new Coloring<String, Integer>(undfactory);
        Set couleurs = coloring.graphColoring(g4);
        System.out.println("Chromatic number Simple graph: " + couleurs.size());
        Visualization.showGraphSets(g4, couleurs);
        Graph<String, Integer> g = Import.readNet("test/Simone/graph.net");
        Visualization.showGraph(g);
    }
}

