/*
 * Decompiled with CFR 0.152.
 */
package agape.test;

import agape.algos.MIS;
import agape.io.Import;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.util.Set;
import org.apache.commons.collections15.Factory;

public class Test {
    public static void main(String[] args) {
        Graph<String, Integer> g = Import.readNet("test.net");
        int ei = g.getEdgeCount();
        int vi = g.getVertexCount();
        Factory<Integer> edgeFactory = new Factory<Integer>(ei){
            int c;
            {
                this.c = n;
            }

            @Override
            public Integer create() {
                ++this.c;
                return this.c;
            }
        };
        Factory<String> vertexFactory = new Factory<String>(vi){
            int c;
            {
                this.c = n;
            }

            @Override
            public String create() {
                ++this.c;
                return "v" + this.c;
            }
        };
        Factory<Graph<String, Integer>> graphFactory = new Factory<Graph<String, Integer>>(){

            @Override
            public Graph<String, Integer> create() {
                return new UndirectedSparseGraph<String, Integer>();
            }
        };
        MIS<String, Integer> alg = new MIS<String, Integer>(graphFactory, vertexFactory, edgeFactory);
        System.out.println("Stable Maximum (V1 (min vertex))");
        double t = System.currentTimeMillis();
        Set<String> S = alg.maximumIndependentSetMoonMoser(g);
        t = (double)System.currentTimeMillis() - t;
        System.out.println(t);
        System.out.println(String.valueOf(S.size()) + " : " + S);
    }
}

