/*
 * Decompiled with CFR 0.152.
 */
package agape.tools;

import agape.tools.Operations;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections15.Factory;

public class Components {
    private static HashMap indexmap;
    private static HashMap lowlinkmap;
    private static int index;
    private static ArrayList stackSC;
    private static ArrayList SCC;

    public static <V, E> Set<V> getConnectedComponent(Graph<V, E> G, Set<V> restrictNodes) {
        HashSet<Object> C = new HashSet<Object>();
        Stack<Object> stack = new Stack<Object>();
        if (!G.getVertices().isEmpty()) {
            Iterator itr = G.getVertices().iterator();
            Object v = itr.next();
            while (restrictNodes.contains(v) && itr.hasNext()) {
                v = itr.next();
            }
            if (!restrictNodes.contains(v)) {
                C.add(v);
                stack.add(v);
            }
            while (!stack.isEmpty()) {
                Object x = stack.pop();
                HashSet nT = new HashSet();
                HashSet Nx = new HashSet(G.getNeighbors(x));
                Nx.removeAll(restrictNodes);
                Sets.difference(Nx, C).copyInto(nT);
                stack.addAll(nT);
                C.addAll(nT);
            }
        }
        return C;
    }

    public static <V, E> Set<V> getConnectedComponent(Graph<V, E> G) {
        HashSet<Object> C = new HashSet<Object>();
        Stack<Object> stack = new Stack<Object>();
        if (!G.getVertices().isEmpty()) {
            Object v = G.getVertices().iterator().next();
            C.add(v);
            stack.add(v);
            while (!stack.isEmpty()) {
                Object x = stack.pop();
                HashSet nT = new HashSet();
                HashSet Nx = new HashSet(G.getNeighbors(x));
                Sets.difference(Nx, C).copyInto(nT);
                stack.addAll(nT);
                C.addAll(nT);
            }
        }
        return C;
    }

    public static <V, E> ArrayList<Set<V>> getAllConnectedComponent(Graph<V, E> G, Set restrictNodes) {
        ArrayList<Set<V>> CC = new ArrayList<Set<V>>();
        HashSet nodes = new HashSet(G.getVertices());
        nodes.removeAll(restrictNodes);
        while (!nodes.isEmpty()) {
            Object vinit = null;
            Iterator itr = nodes.iterator();
            boolean b = false;
            while (itr.hasNext() && !b) {
                Object vtemp = itr.next();
                if (restrictNodes.contains(vtemp)) continue;
                vinit = vtemp;
                b = true;
            }
            if (vinit == null) continue;
            HashSet<V> C = new HashSet<V>();
            HashSet Ci = new HashSet();
            C.add(vinit);
            while (!Ci.equals(C)) {
                Ci = new HashSet(C);
                C.addAll(Operations.getNeighbors(G, Ci));
                C.removeAll(restrictNodes);
            }
            CC.add(C);
            nodes.removeAll(C);
        }
        return CC;
    }

    public static <V, E> ArrayList<Set<V>> getAllConnectedComponent(Graph<V, E> G) {
        ArrayList<Set<V>> CC = new ArrayList<Set<V>>();
        ArrayList<Graph> memG = new ArrayList<Graph>();
        while (!G.getVertices().isEmpty()) {
            try {
                Graph Gp = (Graph)G.getClass().newInstance();
                Set<V> C = Components.getConnectedComponent(G);
                CC.add(C);
                Operations.subGraph(G, Gp, C);
                memG.add(Gp);
                Operations.removeAllVertices(G, C);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(Components.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Components.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (Graph GC : memG) {
            Operations.mergeGraph(G, GC);
        }
        return CC;
    }

    public static <V, E> ArrayList<Set<V>> getAllStronglyConnectedComponent(Graph<V, E> G) {
        indexmap = new HashMap();
        lowlinkmap = new HashMap();
        index = 0;
        stackSC = new ArrayList();
        SCC = new ArrayList();
        for (Object v : G.getVertices()) {
            if (indexmap.get(v) != null) continue;
            Components.tarjan(v, G);
        }
        return SCC;
    }

    private static <V, E> void tarjan(V v, Graph<V, E> G) {
        indexmap.put(v, index);
        lowlinkmap.put(v, index);
        ++index;
        stackSC.add(0, v);
        for (E e : G.getOutEdges(v)) {
            V n = G.getDest(e);
            if (indexmap.get(n) == null) {
                Components.tarjan(n, G);
                lowlinkmap.put(v, Math.min((Integer)lowlinkmap.get(v), (Integer)lowlinkmap.get(n)));
                continue;
            }
            if (!stackSC.contains(n)) continue;
            lowlinkmap.put(v, Math.min((Integer)lowlinkmap.get(v), (Integer)indexmap.get(n)));
        }
        if ((Integer)lowlinkmap.get(v) == (Integer)indexmap.get(v)) {
            Object n;
            HashSet component = new HashSet();
            do {
                n = stackSC.remove(0);
                component.add(n);
            } while (n != v);
            SCC.add(component);
        }
    }

    public static <V, E> Graph<V, E> getComplementGraph(Graph<V, E> G, Factory<E> eFactory) {
        UndirectedSparseGraph Gc = new UndirectedSparseGraph();
        for (Object v1 : G.getVertices()) {
            for (Object v2 : G.getVertices()) {
                if (v1 == v2 || G.findEdge(v1, v2) != null) continue;
                Gc.addEdge(eFactory.create(), v1, v2);
            }
        }
        return Gc;
    }
}

