/*
 * Decompiled with CFR 0.152.
 */
package agape.tools;

import com.google.common.collect.Sets;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections15.Factory;

public class Operations {
    public static <V, E> void subGraph(Graph<V, E> G, Graph<V, E> subG, V x) {
        subG.addVertex(x);
        Collection edges = G.getIncidentEdges(x);
        if (edges != null) {
            for (Object e : edges) {
                if (G.getEdgeType(e) == EdgeType.UNDIRECTED) {
                    subG.addEdge(e, G.getEndpoints(e).getFirst(), G.getEndpoints(e).getSecond());
                    continue;
                }
                subG.addEdge(e, G.getSource(e), G.getDest(e));
            }
        }
    }

    public static <V, E> void subGraph(Graph<V, E> G, Graph<V, E> subG, Set<V> S) {
        for (V x : S) {
            subG.addVertex(x);
            Collection edges = G.getIncidentEdges(x);
            if (edges == null) continue;
            for (Object e : edges) {
                if (subG.containsEdge(e)) continue;
                subG.addEdge(e, G.getEndpoints(e).getFirst(), G.getEndpoints(e).getSecond());
            }
        }
    }

    public static <V, E> void mergeGraph(Graph<V, E> G, Graph<V, E> subG) {
        for (Object v : subG.getVertices()) {
            G.addVertex(v);
        }
        for (Object e : subG.getEdges()) {
            if (subG.getEdgeType(e) == EdgeType.UNDIRECTED) {
                G.addEdge(e, subG.getEndpoints(e).getFirst(), subG.getEndpoints(e).getSecond());
                continue;
            }
            G.addEdge(e, subG.getSource(e), subG.getDest(e));
        }
    }

    public static <V, E> Graph<V, E> copyUndirectedSparseGraph(Graph<V, E> G) {
        UndirectedSparseGraph<V, Object> newG = new UndirectedSparseGraph<V, Object>();
        for (Object x : G.getVertices()) {
            newG.addVertex(x);
        }
        for (Object e : G.getEdges()) {
            newG.addEdge(e, G.getEndpoints(e).getFirst(), G.getEndpoints(e).getSecond());
        }
        return newG;
    }

    public static <V, E> Graph<V, E> copyDirectedSparseGraph(Graph<V, E> G) {
        DirectedSparseGraph<V, Object> newG = new DirectedSparseGraph<V, Object>();
        for (Object x : G.getVertices()) {
            newG.addVertex(x);
        }
        for (Object e : G.getEdges()) {
            newG.addEdge(e, G.getEndpoints(e).getFirst(), G.getEndpoints(e).getSecond());
        }
        return newG;
    }

    public static <V, E> Graph<V, E> copyGraph(Graph<V, E> G, Factory<Graph<V, E>> f) {
        Graph<V, Object> newG = f.create();
        for (Object x : G.getVertices()) {
            newG.addVertex(x);
        }
        for (Object e : G.getEdges()) {
            newG.addEdge(e, G.getEndpoints(e).getFirst(), G.getEndpoints(e).getSecond());
        }
        return newG;
    }

    public static <V, E> int getDiameter(Graph<V, E> G) {
        int diameter = 0;
        DijkstraDistance d = new DijkstraDistance(G);
        for (Object s : G.getVertices()) {
            for (Object t : G.getVertices()) {
                if (s == t || d.getDistance(s, t) == null || d.getDistance(s, t).intValue() <= diameter) continue;
                diameter = d.getDistance(s, t).intValue();
            }
        }
        return diameter;
    }

    public static <V, E> V getMinDegVertex(Graph<V, E> G) {
        int deg = Integer.MAX_VALUE;
        V v = null;
        for (Object x : G.getVertices()) {
            if (G.degree(x) >= deg) continue;
            v = x;
            deg = G.degree(x);
        }
        return v;
    }

    public static <V, E> Set<V> getAllMinDegVertex(Graph<V, E> G) {
        HashSet allDM = new HashSet();
        int degmin = Operations.getMinDeg(G);
        for (Object x : G.getVertices()) {
            if (G.degree(x) != degmin) continue;
            allDM.add(x);
        }
        return allDM;
    }

    public static <V, E> V getMaxDegVertex(Graph<V, E> G) {
        int deg = 0;
        V v = null;
        for (Object x : G.getVertices()) {
            if (G.degree(x) <= deg) continue;
            v = x;
            deg = G.degree(x);
        }
        return v;
    }

    public static <V, E> Set<V> getAllMaxDegVertex(Graph<V, E> G) {
        HashSet allDM = new HashSet();
        int degmax = Operations.getMaxDeg(G);
        for (Object x : G.getVertices()) {
            if (G.degree(x) != degmax) continue;
            allDM.add(x);
        }
        return allDM;
    }

    public static <V, E> int getMaxDeg(Graph<V, E> G) {
        int deg = 0;
        for (Object x : G.getVertices()) {
            if (G.degree(x) <= deg) continue;
            deg = G.degree(x);
        }
        return deg;
    }

    public static <V, E> int getMinDeg(Graph<V, E> G) {
        int deg = Integer.MAX_VALUE;
        for (Object x : G.getVertices()) {
            if (G.degree(x) >= deg) continue;
            deg = G.degree(x);
        }
        return deg;
    }

    public static <V, E> V getDegVertex(Graph<V, E> G, int deg) {
        V v = null;
        for (Object x : G.getVertices()) {
            if (G.degree(x) != deg) continue;
            v = x;
            break;
        }
        return v;
    }

    public static <V, E> Set<V> getAllDegVertex(Graph<V, E> G, int deg) {
        HashSet Sdeg = new HashSet();
        for (Object x : G.getVertices()) {
            if (G.getNeighborCount(x) != deg) continue;
            Sdeg.add(x);
        }
        return Sdeg;
    }

    public static <V, E> int getNbEdges(Graph<V, E> G, Set<V> A) {
        int nbe = 0;
        for (Object e : G.getEdges()) {
            if (!A.contains(G.getEndpoints(e).getFirst()) || !A.contains(G.getEndpoints(e).getSecond())) continue;
            ++nbe;
        }
        return nbe;
    }

    public static <V, E> Set<V> getNeighbors(Graph<V, E> G, Set<V> S) {
        HashSet<V> N = new HashSet<V>();
        for (V v : S) {
            N.addAll(G.getNeighbors(v));
        }
        N.removeAll(S);
        return N;
    }

    public static <V, E> Set<V> getNeighbors(Graph<V, E> G, V v, int dist) {
        HashSet<V> N = new HashSet<V>();
        HashSet<Object> done = new HashSet<Object>();
        N.addAll(G.getNeighbors(v));
        done.addAll(N);
        done.add(v);
        int i = 1;
        while (i < dist) {
            HashSet Nn = new HashSet();
            for (Object x : N) {
                Sets.difference(new HashSet(G.getNeighbors(x)), done).copyInto(Nn);
            }
            done.addAll(Nn);
            N = Nn;
            ++i;
        }
        return N;
    }

    public static <V, E> boolean isRegular(Graph<V, E> G) {
        int deg = G.degree(G.getVertices().iterator().next());
        for (Object v : G.getVertices()) {
            if (G.degree(v) == deg) continue;
            return false;
        }
        return true;
    }

    public static <V, E> boolean isRegular(Graph<V, E> G, int deg) {
        for (Object v : G.getVertices()) {
            if (G.degree(v) == deg) continue;
            return false;
        }
        return true;
    }

    public static <V, E> boolean isAcyclic(Graph<V, E> G) {
        boolean b = false;
        Graph<Object, E> Gp = Operations.copyDirectedSparseGraph(G);
        ArrayList L = new ArrayList();
        ArrayList<Object> Q = new ArrayList<Object>();
        for (Object v : Gp.getVertices()) {
            if (Gp.getPredecessorCount(v) != 0) continue;
            Q.add(v);
        }
        while (!Q.isEmpty()) {
            Object n = Q.remove(0);
            L.add(n);
            HashSet<V> succ = new HashSet<V>(Gp.getSuccessors(n));
            Gp.removeVertex(n);
            for (Object m : succ) {
                if (Gp.getPredecessorCount(m) != 0) continue;
                Q.add(m);
            }
        }
        if (Gp.getEdgeCount() == 0) {
            b = true;
        }
        return b;
    }

    public static <V, E> boolean isCycle(Graph<V, E> G, Set<V> C) {
        ArrayList<V> visited = new ArrayList<V>();
        V vstart = C.iterator().next();
        visited.add(vstart);
        boolean b = true;
        Object v = vstart;
        while (b && visited.size() < C.size()) {
            HashSet neigh = new HashSet();
            if (!G.getNeighbors(v).isEmpty()) {
                Sets.intersection(C, new HashSet<V>(G.getNeighbors(v))).copyInto(neigh);
            }
            neigh.removeAll(visited);
            if (!neigh.isEmpty()) {
                v = neigh.iterator().next();
                visited.add(v);
                continue;
            }
            b = false;
        }
        if (b && !G.getNeighbors(visited.get(visited.size() - 1)).contains(vstart)) {
            b = false;
        }
        return b;
    }

    public static <V, E> boolean isEdge(Graph<V, E> G, V v1, V v2) {
        return G.findEdge(v1, v2) != null;
    }

    public static <V, E> boolean isClique(Graph<V, E> G, Set<V> K) {
        boolean b = true;
        if (K.isEmpty() || K.size() == 1) {
            return true;
        }
        ArrayList N = new ArrayList();
        for (V v : K) {
            HashSet<V> Nv = new HashSet<V>();
            Nv.addAll(G.getNeighbors(v));
            Nv.add(v);
            N.add(Nv);
        }
        HashSet Ni = (HashSet)N.get(0);
        int i = 1;
        while (b && i < N.size()) {
            HashSet temp = new HashSet();
            Sets.intersection(Ni, (Set)N.get(i)).copyInto(temp);
            Ni = temp;
            if (!Ni.containsAll(K)) {
                b = false;
            }
            ++i;
        }
        return b;
    }

    public static <V, E> void addAllVertices(Graph<V, E> G, Set<V> A) {
        for (V v : A) {
            G.addVertex(v);
        }
    }

    public static <V, E> void removeAllVertices(Graph<V, E> G, Set<V> R) {
        for (V v : R) {
            G.removeVertex(v);
        }
    }

    public static <V, E> void removeAllEdges(Graph<V, E> G, Set<E> R) {
        for (E e : R) {
            G.removeEdge(e);
        }
    }

    public static <V> void quickSortSet(ArrayList<Set<V>> tab, int p, int r) {
        if (p < r) {
            int q = Operations.partitionSet(tab, p, r);
            Operations.quickSortSet(tab, p, q);
            Operations.quickSortSet(tab, q + 1, r);
        }
    }

    private static <V> int partitionSet(ArrayList<Set<V>> tab, int p, int r) {
        int pivot = tab.get(p).size();
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (tab.get(--j).size() > pivot) {
                continue;
            }
            while (tab.get(++i).size() < pivot) {
            }
            if (i >= j) break;
            HashSet temp = new HashSet();
            temp.addAll(tab.get(i));
            tab.set(i, tab.get(j));
            tab.set(j, temp);
        }
        return j;
    }

    public static <V, E> V chooseRandVertex(Graph<V, E> G) {
        V vertex = null;
        while (vertex == null) {
            for (Object v : G.getVertices()) {
                if (!(Math.random() < 0.3)) continue;
                vertex = v;
            }
        }
        return vertex;
    }

    public static <V, E> double getDensity(Graph<V, E> G) {
        return (double)(2 * G.getEdgeCount()) / (double)(G.getVertexCount() * (G.getVertexCount() - 1));
    }

    public static <V, E> void rewireEdgesRand(Graph<V, E> G, int amount, Factory<E> edgeFactory) {
        ArrayList edgesR = new ArrayList();
        while (edgesR.size() < amount) {
            for (Object e : G.getEdges()) {
                if (!(Math.random() < 0.3)) continue;
                edgesR.add(e);
            }
        }
        for (Object e : edgesR) {
            Object v1 = null;
            v1 = Math.random() < 0.5 ? (Object)G.getEndpoints(e).getFirst() : (Object)G.getEndpoints(e).getSecond();
            Object v2 = null;
            Iterator itr = G.getVertices().iterator();
            while (v2 == null || v2.equals(G.getEndpoints(e).getFirst()) || v2.equals(G.getEndpoints(e).getSecond()) || G.findEdge(v1, v2) != null) {
                v2 = itr.next();
            }
            G.removeEdge(e);
            G.addEdge(edgeFactory.create(), v1, v2);
        }
    }

    public static <V, E> void rewireEdge(Graph<V, E> G, E edge, Factory<E> edgeFactory) {
        Object v1 = null;
        v1 = Math.random() < 0.5 ? (Object)G.getEndpoints(edge).getFirst() : (Object)G.getEndpoints(edge).getSecond();
        Object v2 = null;
        Iterator itr = G.getVertices().iterator();
        while (v2 == null || v2.equals(G.getEndpoints(edge).getFirst()) || v2.equals(G.getEndpoints(edge).getSecond()) || G.findEdge(v1, v2) != null) {
            v2 = itr.next();
        }
        G.removeEdge(edge);
        G.addEdge(edgeFactory.create(), v1, v2);
    }
}

