/*
 * Decompiled with CFR 0.152.
 */
package agape.tutorials;

import agape.tutorials.UndirectedGraphFactoryForStringInteger;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Iterator;
import org.apache.commons.collections15.Factory;

public class FactoryProblem<V, E> {
    public static void main(String[] args) {
        UndirectedGraphFactoryForStringInteger undfactory = new UndirectedGraphFactoryForStringInteger();
        SparseGraph<String, Integer> gu = new SparseGraph<String, Integer>();
        gu.addVertex("v1");
        gu.addVertex("v2");
        gu.addVertex("v3");
        gu.addVertex("v4");
        gu.addVertex("v5");
        gu.addEdge(Integer.valueOf(1), new Pair<String>("v1", "v2"));
        gu.addEdge(Integer.valueOf(2), new Pair<String>("v1", "v4"));
        gu.addEdge(Integer.valueOf(3), new Pair<String>("v2", "v3"));
        gu.addEdge(Integer.valueOf(4), new Pair<String>("v3", "v5"));
        gu.addEdge(Integer.valueOf(5), new Pair<String>("v5", "v2"));
        gu.addEdge(Integer.valueOf(6), new Pair<String>("v5", "v3"));
        FactoryProblem<String, Integer> problem = new FactoryProblem<String, Integer>();
        try {
            problem.addRandomEdge(gu, undfactory.edgeFactory);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e);
            System.out.println("Our factory is badly used because it tries to instantiate the edge number 1 which already exists in the graph.");
        }
        SparseGraph<String, Integer> gu2 = new SparseGraph<String, Integer>();
        String[] v = new String[5];
        int i = 0;
        while (i < 5) {
            v[i] = undfactory.vertexFactory.create();
            gu2.addVertex(v[i]);
            ++i;
        }
        Integer[] e = new Integer[6];
        int i2 = 0;
        while (i2 < 6) {
            e[i2] = undfactory.edgeFactory.create();
            ++i2;
        }
        gu2.addEdge(e[0], v[0], v[1]);
        gu2.addEdge(e[1], v[0], v[3]);
        gu2.addEdge(e[2], v[1], v[2]);
        gu2.addEdge(e[3], v[2], v[4]);
        gu2.addEdge(e[4], v[4], v[2]);
        gu2.addEdge(e[5], v[4], v[3]);
        System.out.println("gu2 before : " + gu2);
        problem.addRandomEdge(gu2, undfactory.edgeFactory);
        System.out.println("gu2 after  : " + gu2);
    }

    public void addRandomEdge(Graph<V, E> g, Factory<E> f) {
        int choice = (int)(Math.random() * (double)g.getVertexCount());
        Iterator it = g.getVertices().iterator();
        Object v1 = null;
        int i = 0;
        while (i <= choice) {
            v1 = it.next();
            ++i;
        }
        choice = (int)(Math.random() * (double)g.getVertexCount());
        it = g.getVertices().iterator();
        Object v2 = null;
        int i2 = 0;
        while (i2 <= choice) {
            v2 = it.next();
            ++i2;
        }
        E edge = f.create();
        System.out.println("Trying to add Edge " + edge + " between " + v1 + " " + v2);
        g.addEdge(edge, v1, v2);
    }
}

