/*
 * Decompiled with CFR 0.152.
 */
package agape.visu;

import agape.tools.Operations;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JFrame;
import org.apache.commons.collections15.Transformer;

public class Visualization {
    public static <V, E> void showGraph(Graph<V, E> G) {
        Visualization.showGraph(G, new HashSet());
    }

    public static <V, E> void showGraph(Graph<V, E> G, Layout<V, E> l) {
        Visualization.showGraph(G, new HashSet(), null, l);
    }

    public static <V, E> void showGraph(Graph<V, E> G, Set<V> selectedNodes) {
        Visualization.showGraph(G, selectedNodes, null, new FRLayout<V, E>(G));
    }

    public static <V, E> void showGraph(Graph<V, E> G, Set<V> selectedNodes, Set<V> selectedNodes2) {
        Visualization.showGraph(G, selectedNodes, selectedNodes2, new FRLayout<V, E>(G));
    }

    public static <V, E> void showGraph(Graph<V, E> G, Set<V> selectedNodes, Set<V> selectedNodes2, Layout<V, E> l) {
        JFrame jf = new JFrame();
        VisualizationViewer<V, E> vv = new VisualizationViewer<V, E>(l);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        vv.setGraphMouse(graphMouse);
        vv.addKeyListener(graphMouse.getModeKeyListener());
        vv.setBackground(Color.white);
        vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        jf.getContentPane().add(vv);
        jf.pack();
        jf.setDefaultCloseOperation(3);
        jf.setVisible(true);
        ColoredSetsTransformer<V> vertexPaint = new ColoredSetsTransformer<V>(selectedNodes, selectedNodes2);
        vv.getRenderContext().setVertexFillPaintTransformer(vertexPaint);
    }

    public static <V, E> void showGraphSets(Graph<V, E> G, Set<Set<V>> verticesGroups) {
        JFrame jf = new JFrame();
        VisualizationViewer<V, E> vv = new VisualizationViewer<V, E>(new FRLayout<V, E>(G));
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        vv.setGraphMouse(graphMouse);
        vv.addKeyListener(graphMouse.getModeKeyListener());
        vv.setBackground(Color.white);
        vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        jf.getContentPane().add(vv);
        jf.pack();
        jf.setDefaultCloseOperation(3);
        jf.setVisible(true);
        ColoredSetsTransformerSet<V> vertexPaint = new ColoredSetsTransformerSet<V>(verticesGroups);
        vv.getRenderContext().setVertexFillPaintTransformer(vertexPaint);
    }

    public static <V, E> int[][] getBMatrix(Graph<V, E> G, int d) {
        int[][] Bmatrix = new int[d][G.getVertexCount()];
        int i = 0;
        while (i < d) {
            for (Object x : G.getVertices()) {
                Set<V> N = Operations.getNeighbors(G, x, i + 1);
                N.remove(x);
                Bmatrix[i][N.size()] = Bmatrix[i][N.size()] + 1;
            }
            ++i;
        }
        return Bmatrix;
    }

    protected static final class ColoredSetsTransformer<V>
    implements Transformer<V, Paint> {
        Set<V> selectedNodes_ = null;
        Set<V> selectedNodes2_ = null;

        public ColoredSetsTransformer(Set<V> selectedNodes_) {
            this.selectedNodes_ = selectedNodes_;
        }

        public ColoredSetsTransformer(Set<V> selectedNodes_, Set<V> selectedNodes2_) {
            this(selectedNodes_);
            this.selectedNodes2_ = selectedNodes2_;
        }

        @Override
        public Paint transform(V n) {
            if (this.selectedNodes_.contains(n)) {
                return Color.YELLOW;
            }
            if (this.selectedNodes2_ != null && this.selectedNodes2_.contains(n)) {
                return Color.GREEN;
            }
            return Color.red;
        }
    }

    protected static final class ColoredSetsTransformerSet<V>
    implements Transformer<V, Paint> {
        Set<Set<V>> verticesGroups_ = null;
        Color[] table = null;

        public ColoredSetsTransformerSet(Set<Set<V>> verticesGroups) {
            this.verticesGroups_ = verticesGroups;
            this.table = new Color[verticesGroups.size()];
            int i = 0;
            while (i < verticesGroups.size()) {
                this.table[i] = Color.getHSBColor((float)Math.random(), (float)Math.random(), (float)Math.random());
                ++i;
            }
        }

        @Override
        public Paint transform(V n) {
            Iterator<Set<V>> it_set = this.verticesGroups_.iterator();
            int i = 0;
            while (it_set.hasNext()) {
                Set<V> group = it_set.next();
                if (group.contains(n)) {
                    return this.table[i];
                }
                ++i;
            }
            return Color.black;
        }
    }
}

