/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms;

import bridge.interfaces.Arc;
import bridge.interfaces.Edge;
import bridge.interfaces.Graph;
import bridge.interfaces.HierarchicalSet;
import bridge.interfaces.Link;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class GraphUtility {
    private GraphUtility() {
    }

    public static <V, L extends Link<V>> boolean checkProprieties(Graph<V, L> graph, Propriety ... propieties) {
        Propriety[] proprietyArray = propieties;
        int n = propieties.length;
        int n2 = 0;
        while (n2 < n) {
            Propriety propriety = proprietyArray[n2];
            if (!propriety.verify(graph)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static <V, L extends Link<V>> HierarchicalSet<V> rechabilityVertices(V startingVertex, Graph<V, L> graph, boolean includeStatingPoint) {
        HashSet<Object> visitedVertices = new HashSet<Object>(graph.vertexSet().size() * 2);
        Vector<Object> toDeal = new Vector<Object>(graph.vertexSet().size());
        toDeal.add(startingVertex);
        while (!toDeal.isEmpty()) {
            Object currentVertex = toDeal.remove(0);
            for (Object outVertex : graph.outNeighborhood(currentVertex)) {
                if (!visitedVertices.add(outVertex)) continue;
                toDeal.add(outVertex);
            }
        }
        if (includeStatingPoint) {
            visitedVertices.add(startingVertex);
        }
        return graph.vertexSet().newSubSet(visitedVertices.iterator());
    }

    public static <V, L extends Link<V>> HierarchicalSet<L> rechabilityLinks(V startingVertex, Graph<V, L> graph) {
        HashSet<Link> visitedLinks = new HashSet<Link>(graph.edgeSet().size() * 2);
        HashSet<Object> visitedVertices = new HashSet<Object>(graph.vertexSet().size() * 2);
        Vector<Object> toDeal = new Vector<Object>(graph.vertexSet().size());
        toDeal.add(startingVertex);
        visitedVertices.add(startingVertex);
        while (!toDeal.isEmpty()) {
            Object currentVertex = toDeal.remove(0);
            for (Link outEdge : graph.outEdges(currentVertex)) {
                Object currentOppositeVertex = outEdge.getOpposite(currentVertex);
                visitedLinks.add(outEdge);
                if (visitedVertices.contains(currentOppositeVertex)) continue;
                visitedVertices.add(currentOppositeVertex);
                toDeal.add(currentOppositeVertex);
            }
        }
        return graph.edgeSet().newSubSet(visitedLinks.iterator());
    }

    public static <V, L extends Link<V>> void copyGraphInGraph(Graph<V, L> graph, Graph<V, L> emptyGraph) {
        for (Object vertex : graph.vertexSet()) {
            emptyGraph.addVertex(vertex);
        }
        for (Link link : graph.edgeSet()) {
            emptyGraph.addEdge(link);
        }
    }

    public static <V, L extends Link<V>> boolean isMultiGraph(Graph<V, L> graph) {
        for (Link link : graph.edgeSet()) {
            V[] v1v2 = link.toArray();
            if (graph.getEdgesConnected(v1v2[0], v1v2[1]).size() == 1) continue;
            return true;
        }
        return false;
    }

    public static <V, L extends Link<V>> boolean isConnectedGraph(Graph<V, L> graph, boolean stronglyConnectedRequired) {
        if (graph.vertexSet().size() < 2) {
            return true;
        }
        if (graph.edgeSet().size() < graph.vertexSet().size() - 1) {
            return false;
        }
        assert (!graph.edgeSet().isEmpty());
        if (graph.edgeSet().iterator().next() instanceof Edge) {
            return graph.vertexSet().size() == GraphUtility.rechabilityVertices(graph.vertexSet().iterator().next(), graph, true).size();
        }
        if (graph.edgeSet().iterator().next() instanceof Arc) {
            Iterator iterator = graph.vertexSet().iterator();
            int candidate = GraphUtility.rechabilityVertices(iterator.next(), graph, true).size();
            while (iterator.hasNext()) {
                if (stronglyConnectedRequired) {
                    if ((candidate = Math.max(candidate, GraphUtility.rechabilityVertices(iterator.next(), graph, true).size())) == graph.vertexSet().size()) continue;
                    return false;
                }
                candidate = Math.max(candidate, GraphUtility.rechabilityVertices(iterator.next(), graph, true).size());
                if (graph.vertexSet().size() != candidate) continue;
                return true;
            }
            return graph.vertexSet().size() == candidate;
        }
        throw new IllegalStateException("graph links are not Edges or Arcs");
    }

    public static <V, L extends Link<V>> boolean haveLoopLinks(Graph<V, L> graph) {
        for (Link link : graph.edgeSet()) {
            if (!link.isLoop()) continue;
            return true;
        }
        return false;
    }

    public static enum Propriety {
        EMPTY_GRAPH{

            @Override
            protected <V, L extends Link<V>> boolean verify(Graph<V, L> graph) {
                return graph.vertexSet().size() == 0;
            }
        }
        ,
        MULTI_GRAPH{

            @Override
            protected <V, L extends Link<V>> boolean verify(Graph<V, L> graph) {
                return GraphUtility.isMultiGraph(graph);
            }
        }
        ,
        CONNECTED_GRAPH{

            @Override
            protected <V, L extends Link<V>> boolean verify(Graph<V, L> graph) {
                return GraphUtility.isConnectedGraph(graph, false);
            }
        }
        ,
        STRONGLY_CONNECTED_GRAPH{

            @Override
            protected <V, L extends Link<V>> boolean verify(Graph<V, L> graph) {
                return GraphUtility.isConnectedGraph(graph, true);
            }
        }
        ,
        HAVE_LOOP_LINKS{

            @Override
            protected <V, L extends Link<V>> boolean verify(Graph<V, L> graph) {
                return GraphUtility.haveLoopLinks(graph);
            }
        };


        protected abstract <V, L extends Link<V>> boolean verify(Graph<V, L> var1);
    }
}

