/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.common;

import bridge.abstractClasses.AbstractScalar;
import bridge.interfaces.Cycle;
import bridge.interfaces.Graph;
import bridge.interfaces.HierarchicalSet;
import bridge.interfaces.Link;
import bridge.interfaces.Map;
import bridge.interfaces.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public abstract class FindElementaryCyclesFrom<V, E extends Link<V>, G extends Graph<V, E>> {
    private G g_;
    private V root_;
    private Map edgeCost_;
    private AbstractScalar maxCost_;
    private HashSet<Cycle<V, E>> solutions;
    private String edgeCostName = "EDGE_COST_NAME";
    private Object edgeCostContext;
    private HashMap<V, HashSet<V>> predecessor;

    protected abstract Path<V, E> createPath();

    protected abstract Cycle<V, E> createCycle(Path<V, E> var1, E var2);

    protected abstract AbstractScalar createIntegerScalar(int var1);

    public FindElementaryCyclesFrom(G g, V root, Map edgeCost, AbstractScalar maxCost) {
        this.g_ = g;
        this.root_ = root;
        this.edgeCost_ = edgeCost;
        this.maxCost_ = maxCost;
        this.solutions = new HashSet();
        this.predecessor = new HashMap();
        this.edgeCostContext = g;
    }

    public FindElementaryCyclesFrom(G g, V root, AbstractScalar maxLength) {
        this(g, root, null, maxLength);
    }

    public void run() {
        Path<V, Link<Object>> currentPath = this.createPath();
        HashSet visited = new HashSet();
        for (Object currentNeighbor : this.g_.outNeighborhood(this.root_)) {
            HierarchicalSet connectingEdge = this.g_.getEdgesConnected(this.root_, currentNeighbor);
            connectingEdge.disconnect();
            for (Link newEdge : connectingEdge) {
                if (newEdge.isLoop()) {
                    this.solutions.add(this.createCycle(currentPath, newEdge));
                    continue;
                }
                currentPath.concat(newEdge);
                this.g_.removeEdge(newEdge);
                this.cycle(currentNeighbor, currentPath, visited);
                currentPath.remove((Link<Object>)currentNeighbor);
            }
        }
    }

    public HashSet<Cycle<V, E>> getCycles() {
        return this.solutions;
    }

    public void setEdgeCostName(String name) {
        this.edgeCostName = name;
    }

    public void setEdgeCostContext(Object context) {
        this.edgeCostContext = context;
    }

    private boolean cycle(V v, Path<V, E> currentPath, HashSet<V> visited) {
        boolean flag = false;
        visited.add(v);
        for (Object current : this.g_.outNeighborhood(v)) {
            if (current == this.root_) {
                for (Link lastEdge : this.g_.getEdgesConnected(v, current)) {
                    Cycle<V, Link> newCycle = this.createCycle(currentPath, lastEdge);
                    this.solutions.add(newCycle);
                    flag = true;
                }
                continue;
            }
            if (this.computePathCost(currentPath).compareTo(this.maxCost_) > 0) {
                flag = true;
                continue;
            }
            if (visited.contains(current)) continue;
            for (Link newEdge : this.g_.getEdgesConnected(v, current)) {
                currentPath.concat(newEdge);
                flag = this.cycle(current, currentPath, visited) || flag;
                currentPath.remove((Link)current);
            }
        }
        if (flag) {
            this.unmarkNode(visited, v);
        } else {
            Iterator neighborIt = this.g_.outNeighborhood(v).iterator();
            while (neighborIt.hasNext()) {
                this.addPredecessor(neighborIt.next(), v);
            }
        }
        assert (currentPath.getEnds()[0] == v || currentPath.getEnds()[1] == v);
        return flag;
    }

    private void addPredecessor(V w, V newPred) {
        if (this.predecessor.keySet().contains(w)) {
            this.predecessor.get(w).add(newPred);
        } else {
            HashSet<V> predSet = new HashSet<V>();
            predSet.add(newPred);
            this.predecessor.put(w, predSet);
        }
    }

    private void unmarkNode(HashSet<V> visited, V v) {
        if (visited.remove(v) && this.predecessor.keySet().contains(v)) {
            Iterator<V> predIt = this.predecessor.get(v).iterator();
            while (predIt.hasNext()) {
                this.unmarkNode(visited, predIt.next());
                predIt.remove();
            }
        }
    }

    private AbstractScalar computePathCost(Path<V, E> p) {
        if (this.edgeCost_ == null) {
            return this.createIntegerScalar(p.length());
        }
        Iterator<E> edgeIt = p.edgeIterator(p.isDirected() ? p.getFirstVertex() : p.getEnds()[0]);
        AbstractScalar cost = null;
        while (edgeIt.hasNext()) {
            Link currentEdge = (Link)edgeIt.next();
            if (cost == null) {
                cost = this.edgeCostContext != null ? this.edgeCost_.getValue(currentEdge, this.edgeCostName, this.edgeCostContext).clone() : this.edgeCost_.getValue(edgeIt.next(), this.edgeCostName, currentEdge).clone();
                continue;
            }
            cost.add(this.edgeCostContext != null ? this.edgeCost_.getValue(currentEdge, this.edgeCostName, this.edgeCostContext).clone() : this.edgeCost_.getValue(edgeIt.next(), this.edgeCostName, currentEdge).clone());
        }
        return cost;
    }
}

