/*
 * Decompiled with CFR 0.152.
 */
package bridge.algorithms.common;

import bridge.interfaces.Graph;
import bridge.interfaces.Link;
import bridge.interfaces.Path;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

public abstract class RandomWalk<V, E extends Link<V>, G extends Graph<V, E>> {
    private G graph_;
    private Random rand_;
    private long seed_;

    public abstract Path<V, E> createPath();

    public RandomWalk(G g) {
        this(g, System.currentTimeMillis());
    }

    public RandomWalk(G g, long seed) {
        this.graph_ = g;
        this.seed_ = seed;
        this.rand_ = new Random(seed);
    }

    public Path<V, E> getNextPath(V source, V destination) {
        Path<V, Object> result = this.createPath();
        V current = source;
        Link previousEdge = null;
        while (current != destination) {
            Vector outEdgeArray = new Vector();
            outEdgeArray.addAll(this.graph_.outEdges(current));
            Link edge = this.chooseNextEdge(previousEdge, outEdgeArray, this.rand_);
            V next = edge.getOpposite(current);
            if (result.contains((Object)next)) {
                Iterator<E> edgeIterator = result.edgeIterator(source);
                result = this.createPath();
                while (edgeIterator.hasNext()) {
                    Link currentEdge = (Link)edgeIterator.next();
                    if (currentEdge.contains(next)) {
                        if (next == source) break;
                        result.concat(currentEdge);
                        break;
                    }
                    result.concat(currentEdge);
                }
                previousEdge = null;
            } else {
                result.concat(edge);
                previousEdge = edge;
            }
            current = next;
        }
        return result;
    }

    protected double[] computeProbability(E previousEdge, Vector<E> edgeVector) {
        double[] result = new double[edgeVector.size()];
        double singleEdgeProbability = 1 / edgeVector.size();
        int i = 0;
        while (i < edgeVector.size()) {
            result[i] = (double)(i + 1) * singleEdgeProbability;
            ++i;
        }
        result[edgeVector.size() - 1] = 1.0;
        return result;
    }

    private E chooseNextEdge(E previousEdge, Vector<E> edgeArray, Random randomGenerator) {
        double[] probability = this.computeProbability(previousEdge, edgeArray);
        double randValue = randomGenerator.nextDouble();
        int i = 0;
        while (i < probability.length) {
            if (randValue <= probability[i]) {
                return (E)((Link)edgeArray.get(i));
            }
            ++i;
        }
        return null;
    }

    public long getInitialSeed() {
        return this.seed_;
    }
}

